#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2025 Christian Stalp
set -o errexit

###
# Baldur's Gate 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250616.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='baldurs-gate-3'
GAME_NAME='Baldurʼs Gate Ⅲ'

ARCHIVE_BASE_PATCH8_2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168).exe'
ARCHIVE_BASE_PATCH8_2_MD5='11560af8d52ef9e14691005ab22bb514'
ARCHIVE_BASE_PATCH8_2_TYPE='innosetup'
ARCHIVE_BASE_PATCH8_2_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-1.bin'
ARCHIVE_BASE_PATCH8_2_PART1_MD5='886a70664272c85185b71275dd22534f'
ARCHIVE_BASE_PATCH8_2_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-2.bin'
ARCHIVE_BASE_PATCH8_2_PART2_MD5='b0fa66b07e73df1ae2fe4852fb0d7a52'
ARCHIVE_BASE_PATCH8_2_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-3.bin'
ARCHIVE_BASE_PATCH8_2_PART3_MD5='d78d9ce3e9dd8085b85ccefd3af9cc16'
ARCHIVE_BASE_PATCH8_2_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-4.bin'
ARCHIVE_BASE_PATCH8_2_PART4_MD5='6f66ea775bdf984bec07e53bd2ef7134'
ARCHIVE_BASE_PATCH8_2_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-5.bin'
ARCHIVE_BASE_PATCH8_2_PART5_MD5='b9129de228d0afbcd4e56420b0de4bfe'
ARCHIVE_BASE_PATCH8_2_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-6.bin'
ARCHIVE_BASE_PATCH8_2_PART6_MD5='2151a76c67865e67b70fb922f8365186'
ARCHIVE_BASE_PATCH8_2_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-7.bin'
ARCHIVE_BASE_PATCH8_2_PART7_MD5='39bfc492c1feb3dfeeb72ae0b772ff38'
ARCHIVE_BASE_PATCH8_2_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-8.bin'
ARCHIVE_BASE_PATCH8_2_PART8_MD5='86c12eda248a536751add38b96d02de9'
ARCHIVE_BASE_PATCH8_2_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-9.bin'
ARCHIVE_BASE_PATCH8_2_PART9_MD5='7f62b01a94242c5db2afd243f60e2e88'
ARCHIVE_BASE_PATCH8_2_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-10.bin'
ARCHIVE_BASE_PATCH8_2_PART10_MD5='bbdf4175ff07be1efafdf3e73075f087'
ARCHIVE_BASE_PATCH8_2_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-11.bin'
ARCHIVE_BASE_PATCH8_2_PART11_MD5='6552d6e137c9062a91c129201aed7326'
ARCHIVE_BASE_PATCH8_2_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-12.bin'
ARCHIVE_BASE_PATCH8_2_PART12_MD5='896ecb909803cb3de08f83ac6eeb9a8e'
ARCHIVE_BASE_PATCH8_2_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-13.bin'
ARCHIVE_BASE_PATCH8_2_PART13_MD5='070c8e06a2ad8ac171bab660b9119397'
ARCHIVE_BASE_PATCH8_2_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-14.bin'
ARCHIVE_BASE_PATCH8_2_PART14_MD5='2d206e61d293fc09610ac6b80dff196a'
ARCHIVE_BASE_PATCH8_2_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-15.bin'
ARCHIVE_BASE_PATCH8_2_PART15_MD5='b93a61010b7a763b5288cfd8e71d8c0a'
ARCHIVE_BASE_PATCH8_2_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-16.bin'
ARCHIVE_BASE_PATCH8_2_PART16_MD5='c9c2e6910244b10d9554f601e734b7c9'
ARCHIVE_BASE_PATCH8_2_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-17.bin'
ARCHIVE_BASE_PATCH8_2_PART17_MD5='7de8b0144275b0f6a0ceda83d92e8126'
ARCHIVE_BASE_PATCH8_2_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-18.bin'
ARCHIVE_BASE_PATCH8_2_PART18_MD5='94f977747745c45f9fa390ffc332fea1'
ARCHIVE_BASE_PATCH8_2_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-19.bin'
ARCHIVE_BASE_PATCH8_2_PART19_MD5='e3a39b31dd8665ed8af6a1d2a38100c5'
ARCHIVE_BASE_PATCH8_2_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-20.bin'
ARCHIVE_BASE_PATCH8_2_PART20_MD5='54f545df48ebe7ddd8c9289d499fcad1'
ARCHIVE_BASE_PATCH8_2_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-21.bin'
ARCHIVE_BASE_PATCH8_2_PART21_MD5='9d0717aab8b4d0e850d20b3372ae21eb'
ARCHIVE_BASE_PATCH8_2_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-22.bin'
ARCHIVE_BASE_PATCH8_2_PART22_MD5='adf0ba691f737d3ce3c506bc8a328847'
ARCHIVE_BASE_PATCH8_2_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-23.bin'
ARCHIVE_BASE_PATCH8_2_PART23_MD5='e3df09af27d7d226854c49ea2920c611'
ARCHIVE_BASE_PATCH8_2_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-24.bin'
ARCHIVE_BASE_PATCH8_2_PART24_MD5='46662dbc81a543c7454870582c4d0ed2'
ARCHIVE_BASE_PATCH8_2_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-25.bin'
ARCHIVE_BASE_PATCH8_2_PART25_MD5='da3b5bb8a2dcb2e7a91ffd2a4646ae7a'
ARCHIVE_BASE_PATCH8_2_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-26.bin'
ARCHIVE_BASE_PATCH8_2_PART26_MD5='254ad9f2b458a6bfc9d7014ffab06672'
ARCHIVE_BASE_PATCH8_2_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-27.bin'
ARCHIVE_BASE_PATCH8_2_PART27_MD5='822856e426a34671ef1534e9a617d948'
ARCHIVE_BASE_PATCH8_2_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-28.bin'
ARCHIVE_BASE_PATCH8_2_PART28_MD5='2d3d186d758483274eea8e7911975ffc'
ARCHIVE_BASE_PATCH8_2_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-29.bin'
ARCHIVE_BASE_PATCH8_2_PART29_MD5='6a3dfb17da8f9509ce79fab1bb2d5518'
ARCHIVE_BASE_PATCH8_2_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-30.bin'
ARCHIVE_BASE_PATCH8_2_PART30_MD5='2609de707253770e070d6f856c949efa'
ARCHIVE_BASE_PATCH8_2_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-31.bin'
ARCHIVE_BASE_PATCH8_2_PART31_MD5='7c72e6936f88dc6755b306cc04282c01'
ARCHIVE_BASE_PATCH8_2_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6848561_-_patch_patch8_hotfix3_(64bit)_(82168)-32.bin'
ARCHIVE_BASE_PATCH8_2_PART32_MD5='b992d8020df4709b63b8c4ec5773faf6'
ARCHIVE_BASE_PATCH8_2_SIZE='152456071'
ARCHIVE_BASE_PATCH8_2_VERSION='4.1.1.6848561-gog82168'
ARCHIVE_BASE_PATCH8_2_URL='https://www.gog.com/game/baldurs_gate_iii'

ARCHIVE_BASE_PATCH8_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757).exe'
ARCHIVE_BASE_PATCH8_1_MD5='27bb31261705ebdd12ee8d0c890ba98e'
ARCHIVE_BASE_PATCH8_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH8_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-1.bin'
ARCHIVE_BASE_PATCH8_1_PART1_MD5='78b1da474c4686448c9b1cf3c9d7cda2'
ARCHIVE_BASE_PATCH8_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-2.bin'
ARCHIVE_BASE_PATCH8_1_PART2_MD5='42ac5a9b7888731f037874efdd4dd430'
ARCHIVE_BASE_PATCH8_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-3.bin'
ARCHIVE_BASE_PATCH8_1_PART3_MD5='cd7c3ed52cadc500e5705dd3e0dde26a'
ARCHIVE_BASE_PATCH8_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-4.bin'
ARCHIVE_BASE_PATCH8_1_PART4_MD5='bedd37f45d1f61c50ff7ce96c25ebfe5'
ARCHIVE_BASE_PATCH8_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-5.bin'
ARCHIVE_BASE_PATCH8_1_PART5_MD5='ca601cfc8cbf1aaabd7c75707bc1f37c'
ARCHIVE_BASE_PATCH8_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-6.bin'
ARCHIVE_BASE_PATCH8_1_PART6_MD5='eb8b82e6cebecbcace2423a6baf6c953'
ARCHIVE_BASE_PATCH8_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-7.bin'
ARCHIVE_BASE_PATCH8_1_PART7_MD5='c13aa46e2e1a923c331ee8ebb0edc3d8'
ARCHIVE_BASE_PATCH8_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-8.bin'
ARCHIVE_BASE_PATCH8_1_PART8_MD5='dc7d9f422b6224b70e410e4dd6106e37'
ARCHIVE_BASE_PATCH8_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-9.bin'
ARCHIVE_BASE_PATCH8_1_PART9_MD5='2fa28ade514946f8e1a0ce041573d018'
ARCHIVE_BASE_PATCH8_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-10.bin'
ARCHIVE_BASE_PATCH8_1_PART10_MD5='66e2d8b372db72f7d44c5cfea05a2d99'
ARCHIVE_BASE_PATCH8_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-11.bin'
ARCHIVE_BASE_PATCH8_1_PART11_MD5='38e9b907f12b267425c71e7b3e4edcfa'
ARCHIVE_BASE_PATCH8_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-12.bin'
ARCHIVE_BASE_PATCH8_1_PART12_MD5='02e033fb490622fd22312af2e44737bb'
ARCHIVE_BASE_PATCH8_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-13.bin'
ARCHIVE_BASE_PATCH8_1_PART13_MD5='9325aba404d72a1f107cb7f839d614c7'
ARCHIVE_BASE_PATCH8_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-14.bin'
ARCHIVE_BASE_PATCH8_1_PART14_MD5='920749a03f2c8a34d73e05642ea25631'
ARCHIVE_BASE_PATCH8_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-15.bin'
ARCHIVE_BASE_PATCH8_1_PART15_MD5='6c98be358adb6e095047c34f24e7acac'
ARCHIVE_BASE_PATCH8_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-16.bin'
ARCHIVE_BASE_PATCH8_1_PART16_MD5='a9828e864cff7007294ddc160cd118ca'
ARCHIVE_BASE_PATCH8_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-17.bin'
ARCHIVE_BASE_PATCH8_1_PART17_MD5='0aa4fa5620908768dd6f06efc03c7fb6'
ARCHIVE_BASE_PATCH8_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-18.bin'
ARCHIVE_BASE_PATCH8_1_PART18_MD5='eecaf035bc10d45ca64971abcae63d00'
ARCHIVE_BASE_PATCH8_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-19.bin'
ARCHIVE_BASE_PATCH8_1_PART19_MD5='d344d5f6da1839b1537080af308ecd24'
ARCHIVE_BASE_PATCH8_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-20.bin'
ARCHIVE_BASE_PATCH8_1_PART20_MD5='7273a61172e2432caef3a519f7c00eb7'
ARCHIVE_BASE_PATCH8_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-21.bin'
ARCHIVE_BASE_PATCH8_1_PART21_MD5='b09e0a4d0cb2ac609e7824cfebab9fe9'
ARCHIVE_BASE_PATCH8_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-22.bin'
ARCHIVE_BASE_PATCH8_1_PART22_MD5='5ebf64d949a2d27376403a29d9968bd8'
ARCHIVE_BASE_PATCH8_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-23.bin'
ARCHIVE_BASE_PATCH8_1_PART23_MD5='2c65662445a753902e384b0d79ba3f39'
ARCHIVE_BASE_PATCH8_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-24.bin'
ARCHIVE_BASE_PATCH8_1_PART24_MD5='64cba3abc9c088ec5789d1213ec31f0e'
ARCHIVE_BASE_PATCH8_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-25.bin'
ARCHIVE_BASE_PATCH8_1_PART25_MD5='4c95eed0e761ad8463303bbe285fff69'
ARCHIVE_BASE_PATCH8_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-26.bin'
ARCHIVE_BASE_PATCH8_1_PART26_MD5='e5ea40b1950bd3754ac7194ae8d5b43f'
ARCHIVE_BASE_PATCH8_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-27.bin'
ARCHIVE_BASE_PATCH8_1_PART27_MD5='8783defea6803d35b3cc13a9aaec7150'
ARCHIVE_BASE_PATCH8_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-28.bin'
ARCHIVE_BASE_PATCH8_1_PART28_MD5='dfe99b4b6a03cacaf1194e0f120265b4'
ARCHIVE_BASE_PATCH8_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-29.bin'
ARCHIVE_BASE_PATCH8_1_PART29_MD5='096e6e04edbf83e2500422963d68044f'
ARCHIVE_BASE_PATCH8_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-30.bin'
ARCHIVE_BASE_PATCH8_1_PART30_MD5='58d4f91743ec887eb013f190ecb0c7a3'
ARCHIVE_BASE_PATCH8_1_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-31.bin'
ARCHIVE_BASE_PATCH8_1_PART31_MD5='373d53e2703748138b6f38e44602f672'
ARCHIVE_BASE_PATCH8_1_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6805605_-_patch_patch8_hotfix1_(64bit)_(81757)-32.bin'
ARCHIVE_BASE_PATCH8_1_PART32_MD5='0dd1bc9ea3aed58a32b4328705b19cdc'
ARCHIVE_BASE_PATCH8_1_SIZE='152165936'
ARCHIVE_BASE_PATCH8_1_VERSION='4.1.1.6805605-gog81757'

ARCHIVE_BASE_PATCH8_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102).exe'
ARCHIVE_BASE_PATCH8_0_MD5='42ff176fcde947ad3f93f48a856cb065'
ARCHIVE_BASE_PATCH8_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH8_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-1.bin'
ARCHIVE_BASE_PATCH8_0_PART1_MD5='f66fe6c024a5cef9380b418dea4affa9'
ARCHIVE_BASE_PATCH8_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-2.bin'
ARCHIVE_BASE_PATCH8_0_PART2_MD5='7789c578aaaba3b7404c2f8c8629b016'
ARCHIVE_BASE_PATCH8_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-3.bin'
ARCHIVE_BASE_PATCH8_0_PART3_MD5='1f4e83be632f7b433c2611e11d5429ec'
ARCHIVE_BASE_PATCH8_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-4.bin'
ARCHIVE_BASE_PATCH8_0_PART4_MD5='f7ffb973042ddddd5f84434708ee6ab6'
ARCHIVE_BASE_PATCH8_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-5.bin'
ARCHIVE_BASE_PATCH8_0_PART5_MD5='0f25b0e95f1d5fb320696b2b6b475f3b'
ARCHIVE_BASE_PATCH8_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-6.bin'
ARCHIVE_BASE_PATCH8_0_PART6_MD5='b345b733fb71a243bf6e047ce23c30f6'
ARCHIVE_BASE_PATCH8_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-7.bin'
ARCHIVE_BASE_PATCH8_0_PART7_MD5='75d54a2f35d042cd390a1ae04d64ee4b'
ARCHIVE_BASE_PATCH8_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-8.bin'
ARCHIVE_BASE_PATCH8_0_PART8_MD5='a343f421467b67f175cf319c6432cbd5'
ARCHIVE_BASE_PATCH8_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-9.bin'
ARCHIVE_BASE_PATCH8_0_PART9_MD5='9a43344a0cc0e6f2b52c7423977ecfc7'
ARCHIVE_BASE_PATCH8_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-10.bin'
ARCHIVE_BASE_PATCH8_0_PART10_MD5='c10dc228be312439f3559dedb1eb070b'
ARCHIVE_BASE_PATCH8_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-11.bin'
ARCHIVE_BASE_PATCH8_0_PART11_MD5='0c0be09e1b5cdd1e8598603a2bf89358'
ARCHIVE_BASE_PATCH8_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-12.bin'
ARCHIVE_BASE_PATCH8_0_PART12_MD5='b4f9e9c569623977582e86d40222607b'
ARCHIVE_BASE_PATCH8_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-13.bin'
ARCHIVE_BASE_PATCH8_0_PART13_MD5='8b2a70d5d3c678127e7fa2447754d2b5'
ARCHIVE_BASE_PATCH8_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-14.bin'
ARCHIVE_BASE_PATCH8_0_PART14_MD5='e0ed1e068ccd9dd783a6be10fa18eba0'
ARCHIVE_BASE_PATCH8_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-15.bin'
ARCHIVE_BASE_PATCH8_0_PART15_MD5='8f0bca5090ebda3438b65693e1aab9ec'
ARCHIVE_BASE_PATCH8_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-16.bin'
ARCHIVE_BASE_PATCH8_0_PART16_MD5='031de42e76ad136ddb4fce0aa0388180'
ARCHIVE_BASE_PATCH8_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-17.bin'
ARCHIVE_BASE_PATCH8_0_PART17_MD5='0a82953a44bff3c6df14eff954044fb2'
ARCHIVE_BASE_PATCH8_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-18.bin'
ARCHIVE_BASE_PATCH8_0_PART18_MD5='f2cb812e4bed1d1c0e28aa4f5e0e5c39'
ARCHIVE_BASE_PATCH8_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-19.bin'
ARCHIVE_BASE_PATCH8_0_PART19_MD5='0ebc01b50d29dc52efa962223d154ee8'
ARCHIVE_BASE_PATCH8_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-20.bin'
ARCHIVE_BASE_PATCH8_0_PART20_MD5='fc1f5b9bfeb262f981e59e27c6bdfb89'
ARCHIVE_BASE_PATCH8_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-21.bin'
ARCHIVE_BASE_PATCH8_0_PART21_MD5='c0d155296f54f54475deedd316b2299f'
ARCHIVE_BASE_PATCH8_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-22.bin'
ARCHIVE_BASE_PATCH8_0_PART22_MD5='b20d70d0bdd953b31681709c2f3e080c'
ARCHIVE_BASE_PATCH8_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-23.bin'
ARCHIVE_BASE_PATCH8_0_PART23_MD5='d7b3d94e5628028d8bd24d56d2d14962'
ARCHIVE_BASE_PATCH8_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-24.bin'
ARCHIVE_BASE_PATCH8_0_PART24_MD5='470a2e21b7c64f911fc2a67a1c65807e'
ARCHIVE_BASE_PATCH8_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-25.bin'
ARCHIVE_BASE_PATCH8_0_PART25_MD5='27dda849c6a1548a1033eb9c49576754'
ARCHIVE_BASE_PATCH8_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-26.bin'
ARCHIVE_BASE_PATCH8_0_PART26_MD5='694d517c2628555637d350b6b05eb3b2'
ARCHIVE_BASE_PATCH8_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-27.bin'
ARCHIVE_BASE_PATCH8_0_PART27_MD5='940a470417f70699e4748890ae1a16e8'
ARCHIVE_BASE_PATCH8_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-28.bin'
ARCHIVE_BASE_PATCH8_0_PART28_MD5='598edbecb4f36c20985d2c3ef88551e0'
ARCHIVE_BASE_PATCH8_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-29.bin'
ARCHIVE_BASE_PATCH8_0_PART29_MD5='e3ee87c7bc9c2b3ed8c996b5eb55b4ed'
ARCHIVE_BASE_PATCH8_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-30.bin'
ARCHIVE_BASE_PATCH8_0_PART30_MD5='0f534eb66be5d46449cc3eeb6b0642c2'
ARCHIVE_BASE_PATCH8_0_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-31.bin'
ARCHIVE_BASE_PATCH8_0_PART31_MD5='1e4f367ec5ada8c44826ecca55a6455c'
ARCHIVE_BASE_PATCH8_0_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6758295_(64bit)_(81102)-32.bin'
ARCHIVE_BASE_PATCH8_0_PART32_MD5='72704470db264922f32d686f0aa461c8'
ARCHIVE_BASE_PATCH8_0_SIZE='151923438'
ARCHIVE_BASE_PATCH8_0_VERSION='4.1.1.6758295-gog81102'

ARCHIVE_BASE_PATCH7_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035).exe'
ARCHIVE_BASE_PATCH7_1_MD5='e49b2196b60ef76d39ece0c3b45e2382'
ARCHIVE_BASE_PATCH7_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH7_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-1.bin'
ARCHIVE_BASE_PATCH7_1_PART1_MD5='ccc70b5170c78451af59378cd07f00c4'
ARCHIVE_BASE_PATCH7_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-2.bin'
ARCHIVE_BASE_PATCH7_1_PART2_MD5='8d63d6e0527ed25093764220cd6697d3'
ARCHIVE_BASE_PATCH7_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-3.bin'
ARCHIVE_BASE_PATCH7_1_PART3_MD5='dc4a7756f4043b38313a02d77a83fb30'
ARCHIVE_BASE_PATCH7_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-4.bin'
ARCHIVE_BASE_PATCH7_1_PART4_MD5='e7da48782fd10869b7c673bf6c440323'
ARCHIVE_BASE_PATCH7_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-5.bin'
ARCHIVE_BASE_PATCH7_1_PART5_MD5='4186fbc6f85228737c1e75e64e5979ea'
ARCHIVE_BASE_PATCH7_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-6.bin'
ARCHIVE_BASE_PATCH7_1_PART6_MD5='a95f13f119e8bfad2ba8e691f37a7b45'
ARCHIVE_BASE_PATCH7_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-7.bin'
ARCHIVE_BASE_PATCH7_1_PART7_MD5='dcdd32dac6148e95784d0967e76631ed'
ARCHIVE_BASE_PATCH7_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-8.bin'
ARCHIVE_BASE_PATCH7_1_PART8_MD5='94632f860d3bf729951cba45a2ef1b49'
ARCHIVE_BASE_PATCH7_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-9.bin'
ARCHIVE_BASE_PATCH7_1_PART9_MD5='50f09f05df55f31a51e4dbe3be2c98ca'
ARCHIVE_BASE_PATCH7_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-10.bin'
ARCHIVE_BASE_PATCH7_1_PART10_MD5='688a0e7731f738550cbfc411e446df59'
ARCHIVE_BASE_PATCH7_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-11.bin'
ARCHIVE_BASE_PATCH7_1_PART11_MD5='6462b7d0535b861cdd12910710283f79'
ARCHIVE_BASE_PATCH7_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-12.bin'
ARCHIVE_BASE_PATCH7_1_PART12_MD5='f3b88af77ca87095d0fbbbe35d4e149b'
ARCHIVE_BASE_PATCH7_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-13.bin'
ARCHIVE_BASE_PATCH7_1_PART13_MD5='83eb0050d03a53a11adcf489657099fc'
ARCHIVE_BASE_PATCH7_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-14.bin'
ARCHIVE_BASE_PATCH7_1_PART14_MD5='002cfe500a6b7d3a26676576505e33f5'
ARCHIVE_BASE_PATCH7_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-15.bin'
ARCHIVE_BASE_PATCH7_1_PART15_MD5='bb72f89ba73b9d8d9db50eccf6d3f37a'
ARCHIVE_BASE_PATCH7_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-16.bin'
ARCHIVE_BASE_PATCH7_1_PART16_MD5='f4812aa946048954fd3d906bdcf1ec63'
ARCHIVE_BASE_PATCH7_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-17.bin'
ARCHIVE_BASE_PATCH7_1_PART17_MD5='a07e72be29ddec457388ec75eb97a0ce'
ARCHIVE_BASE_PATCH7_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-18.bin'
ARCHIVE_BASE_PATCH7_1_PART18_MD5='80ff7ccb2ceb4467af66f1c24d6afc7a'
ARCHIVE_BASE_PATCH7_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-19.bin'
ARCHIVE_BASE_PATCH7_1_PART19_MD5='7715912bf7256332eb1ac29567fb43ff'
ARCHIVE_BASE_PATCH7_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-20.bin'
ARCHIVE_BASE_PATCH7_1_PART20_MD5='811ec163e7a378f3c745e4995c6d696e'
ARCHIVE_BASE_PATCH7_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-21.bin'
ARCHIVE_BASE_PATCH7_1_PART21_MD5='e8bb834f904b0c87f8122b21a2ab3c52'
ARCHIVE_BASE_PATCH7_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-22.bin'
ARCHIVE_BASE_PATCH7_1_PART22_MD5='0ed518e8074550ad482478a299854c7b'
ARCHIVE_BASE_PATCH7_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-23.bin'
ARCHIVE_BASE_PATCH7_1_PART23_MD5='b76e7aed77fe5a135672a39c15670226'
ARCHIVE_BASE_PATCH7_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-24.bin'
ARCHIVE_BASE_PATCH7_1_PART24_MD5='504f1a93c47448c708bbd98949b1da94'
ARCHIVE_BASE_PATCH7_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-25.bin'
ARCHIVE_BASE_PATCH7_1_PART25_MD5='a54f1c6dda05b074d12d85f927483352'
ARCHIVE_BASE_PATCH7_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-26.bin'
ARCHIVE_BASE_PATCH7_1_PART26_MD5='db09910df98ac5d48da3da401a4d48c0'
ARCHIVE_BASE_PATCH7_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-27.bin'
ARCHIVE_BASE_PATCH7_1_PART27_MD5='ecb67780a96b9813153cf9f242e06e06'
ARCHIVE_BASE_PATCH7_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-28.bin'
ARCHIVE_BASE_PATCH7_1_PART28_MD5='3985434483da3658f0d6af669ea0d498'
ARCHIVE_BASE_PATCH7_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-29.bin'
ARCHIVE_BASE_PATCH7_1_PART29_MD5='77e6fb2852c03ed51793f30ed8378d4b'
ARCHIVE_BASE_PATCH7_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-30.bin'
ARCHIVE_BASE_PATCH7_1_PART30_MD5='6b492781abf4ce82ada772247cdb7418'
ARCHIVE_BASE_PATCH7_1_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-31.bin'
ARCHIVE_BASE_PATCH7_1_PART31_MD5='ed85272a3d4d0c8546a79d5f84c7e87b'
ARCHIVE_BASE_PATCH7_1_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.6072089_-_patch_patch7_hotfix3_(64bit)_(77035)-32.bin'
ARCHIVE_BASE_PATCH7_1_PART32_MD5='72b4ebad04dce811414037e87743eb63'
ARCHIVE_BASE_PATCH7_1_SIZE='151202043'
ARCHIVE_BASE_PATCH7_1_VERSION='4.1.1.6072089-gog77035'

ARCHIVE_BASE_PATCH6_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479).exe'
ARCHIVE_BASE_PATCH6_1_MD5='a68f1a0edcf026a1095c20efe1fa6edc'
ARCHIVE_BASE_PATCH6_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH6_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-1.bin'
ARCHIVE_BASE_PATCH6_1_PART1_MD5='c479abb170e4741bf731d5c89cb985c5'
ARCHIVE_BASE_PATCH6_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-2.bin'
ARCHIVE_BASE_PATCH6_1_PART2_MD5='4d3c3d90c5b70abf10502b2eac7e7b91'
ARCHIVE_BASE_PATCH6_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-3.bin'
ARCHIVE_BASE_PATCH6_1_PART3_MD5='34e7830447cfe59b71a6d3cdc627d473'
ARCHIVE_BASE_PATCH6_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-4.bin'
ARCHIVE_BASE_PATCH6_1_PART4_MD5='7700f5bd163051ad3b544920267158a5'
ARCHIVE_BASE_PATCH6_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-5.bin'
ARCHIVE_BASE_PATCH6_1_PART5_MD5='f7e89a93a24a921c71ed7d9efdb2cc52'
ARCHIVE_BASE_PATCH6_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-6.bin'
ARCHIVE_BASE_PATCH6_1_PART6_MD5='cf6044ced2436c68fa644b16c43bd486'
ARCHIVE_BASE_PATCH6_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-7.bin'
ARCHIVE_BASE_PATCH6_1_PART7_MD5='91bb08a6576f56dc7eecdfc8475cbbea'
ARCHIVE_BASE_PATCH6_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-8.bin'
ARCHIVE_BASE_PATCH6_1_PART8_MD5='735d68133f1ad45d43b67a19bdcaf6b7'
ARCHIVE_BASE_PATCH6_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-9.bin'
ARCHIVE_BASE_PATCH6_1_PART9_MD5='76334ea7438e73cb4ff83f03b9aa4f0b'
ARCHIVE_BASE_PATCH6_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-10.bin'
ARCHIVE_BASE_PATCH6_1_PART10_MD5='d9ee57b1a0fa335c9ddbf8857cdf83b6'
ARCHIVE_BASE_PATCH6_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-11.bin'
ARCHIVE_BASE_PATCH6_1_PART11_MD5='eae123041bbf9f775b285da32ffa234c'
ARCHIVE_BASE_PATCH6_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-12.bin'
ARCHIVE_BASE_PATCH6_1_PART12_MD5='ccd6d28381f5e375aec2768714b8f825'
ARCHIVE_BASE_PATCH6_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-13.bin'
ARCHIVE_BASE_PATCH6_1_PART13_MD5='8042f5a7280456fe309dd7840c04125f'
ARCHIVE_BASE_PATCH6_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-14.bin'
ARCHIVE_BASE_PATCH6_1_PART14_MD5='71899991f13404154119dc4eb88ee68d'
ARCHIVE_BASE_PATCH6_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-15.bin'
ARCHIVE_BASE_PATCH6_1_PART15_MD5='23f96cb8a4c49d99935805a9b7c531e1'
ARCHIVE_BASE_PATCH6_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-16.bin'
ARCHIVE_BASE_PATCH6_1_PART16_MD5='2adbe0b025aacbd2a24d8f91caed65c6'
ARCHIVE_BASE_PATCH6_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-17.bin'
ARCHIVE_BASE_PATCH6_1_PART17_MD5='518e9ea117e9bab82e3ba3ff12ee99a3'
ARCHIVE_BASE_PATCH6_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-18.bin'
ARCHIVE_BASE_PATCH6_1_PART18_MD5='d1c1b477754b7f2661b0669c8b3eebd4'
ARCHIVE_BASE_PATCH6_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-19.bin'
ARCHIVE_BASE_PATCH6_1_PART19_MD5='0b93534901cbfb0c523c690181cc4bde'
ARCHIVE_BASE_PATCH6_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-20.bin'
ARCHIVE_BASE_PATCH6_1_PART20_MD5='d8efb4ef169d590c89f884c240a0bf72'
ARCHIVE_BASE_PATCH6_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-21.bin'
ARCHIVE_BASE_PATCH6_1_PART21_MD5='b5babfb43c75a5b919e497d7d54c86bd'
ARCHIVE_BASE_PATCH6_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-22.bin'
ARCHIVE_BASE_PATCH6_1_PART22_MD5='bb9419ce976980f86df35a21646da355'
ARCHIVE_BASE_PATCH6_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-23.bin'
ARCHIVE_BASE_PATCH6_1_PART23_MD5='a2cb3ae76774d36ce04346510dd019b0'
ARCHIVE_BASE_PATCH6_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-24.bin'
ARCHIVE_BASE_PATCH6_1_PART24_MD5='a33ab802e04f0c4d4f17f1e7e9e8b94a'
ARCHIVE_BASE_PATCH6_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-25.bin'
ARCHIVE_BASE_PATCH6_1_PART25_MD5='9bdfa763b6832aff6dc023a2d8d340c9'
ARCHIVE_BASE_PATCH6_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-26.bin'
ARCHIVE_BASE_PATCH6_1_PART26_MD5='c852917906a08488e823e60500cfc175'
ARCHIVE_BASE_PATCH6_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-27.bin'
ARCHIVE_BASE_PATCH6_1_PART27_MD5='608cf14bb3839e87e755683ee22059bb'
ARCHIVE_BASE_PATCH6_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-28.bin'
ARCHIVE_BASE_PATCH6_1_PART28_MD5='f5b16334779fbb662323966ed4735f61'
ARCHIVE_BASE_PATCH6_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-29.bin'
ARCHIVE_BASE_PATCH6_1_PART29_MD5='441e05f65ad6f0cb2642c29468302385'
ARCHIVE_BASE_PATCH6_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-30.bin'
ARCHIVE_BASE_PATCH6_1_PART30_MD5='5565eb0a62b83e3ab2eab663f1ad802e'
ARCHIVE_BASE_PATCH6_1_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-31.bin'
ARCHIVE_BASE_PATCH6_1_PART31_MD5='b73f8e36b290be55b5aec3ba5aaf197e'
ARCHIVE_BASE_PATCH6_1_PART32_NAME='setup_baldurs_gate_3_release_-_v4.1.1.5022896_-_patch_patch6_hotfix9__(64bit)_(72479)-32.bin'
ARCHIVE_BASE_PATCH6_1_PART32_MD5='181d4fc84ee71980b1dce7d04003f5bf'
ARCHIVE_BASE_PATCH6_1_SIZE='149637909'
ARCHIVE_BASE_PATCH6_1_VERSION='4.1.1.5022896-gog72479'

ARCHIVE_BASE_PATCH5_1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408).exe'
ARCHIVE_BASE_PATCH5_1_MD5='41d296389ec755596846312c290188ba'
ARCHIVE_BASE_PATCH5_1_TYPE='innosetup'
ARCHIVE_BASE_PATCH5_1_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-1.bin'
ARCHIVE_BASE_PATCH5_1_PART1_MD5='ebbff6fbb2a38f555a30fe8e5c1a8b31'
ARCHIVE_BASE_PATCH5_1_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-2.bin'
ARCHIVE_BASE_PATCH5_1_PART2_MD5='a6577500e4ae2df79027a3aab47180ce'
ARCHIVE_BASE_PATCH5_1_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-3.bin'
ARCHIVE_BASE_PATCH5_1_PART3_MD5='413949288793c7ef6e7576cb573e6561'
ARCHIVE_BASE_PATCH5_1_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-4.bin'
ARCHIVE_BASE_PATCH5_1_PART4_MD5='ba3b2132916fb1a9924668e9c121eacd'
ARCHIVE_BASE_PATCH5_1_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-5.bin'
ARCHIVE_BASE_PATCH5_1_PART5_MD5='2833f2573f0c231eace28e5d55cdf760'
ARCHIVE_BASE_PATCH5_1_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-6.bin'
ARCHIVE_BASE_PATCH5_1_PART6_MD5='a14412e73266f5284fe3512f8531d5d6'
ARCHIVE_BASE_PATCH5_1_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-7.bin'
ARCHIVE_BASE_PATCH5_1_PART7_MD5='598fb783c55f0e750ce0dc9ff33d4e91'
ARCHIVE_BASE_PATCH5_1_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-8.bin'
ARCHIVE_BASE_PATCH5_1_PART8_MD5='4f15395994841e57ab238a417ad19f76'
ARCHIVE_BASE_PATCH5_1_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-9.bin'
ARCHIVE_BASE_PATCH5_1_PART9_MD5='3e0aeed6e2f499b74889600415bbbee8'
ARCHIVE_BASE_PATCH5_1_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-10.bin'
ARCHIVE_BASE_PATCH5_1_PART10_MD5='bf3b28a6d1c8210cff15a0a49d4c3773'
ARCHIVE_BASE_PATCH5_1_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-11.bin'
ARCHIVE_BASE_PATCH5_1_PART11_MD5='fa4fd60332c20e30217197f58e4bbf1b'
ARCHIVE_BASE_PATCH5_1_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-12.bin'
ARCHIVE_BASE_PATCH5_1_PART12_MD5='d00c210e621ab8163a36ca5973d3b8af'
ARCHIVE_BASE_PATCH5_1_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-13.bin'
ARCHIVE_BASE_PATCH5_1_PART13_MD5='80208dd51f3b41543b34b8a08c611bd8'
ARCHIVE_BASE_PATCH5_1_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-14.bin'
ARCHIVE_BASE_PATCH5_1_PART14_MD5='130710e4e6c422769453b7949a783f85'
ARCHIVE_BASE_PATCH5_1_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-15.bin'
ARCHIVE_BASE_PATCH5_1_PART15_MD5='bfc6635ab6f90b5168f67b88d3f7b57a'
ARCHIVE_BASE_PATCH5_1_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-16.bin'
ARCHIVE_BASE_PATCH5_1_PART16_MD5='84f39956129ff4e43c5dbe61a316315a'
ARCHIVE_BASE_PATCH5_1_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-17.bin'
ARCHIVE_BASE_PATCH5_1_PART17_MD5='fb05f610719dfed7278af617d70093e0'
ARCHIVE_BASE_PATCH5_1_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-18.bin'
ARCHIVE_BASE_PATCH5_1_PART18_MD5='40495dfc26875491f29eadeabeb77308'
ARCHIVE_BASE_PATCH5_1_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-19.bin'
ARCHIVE_BASE_PATCH5_1_PART19_MD5='d428eecb383c1317570ef4f9663045c8'
ARCHIVE_BASE_PATCH5_1_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-20.bin'
ARCHIVE_BASE_PATCH5_1_PART20_MD5='cdb6f938deb3ce2bc122f9effcc489b7'
ARCHIVE_BASE_PATCH5_1_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-21.bin'
ARCHIVE_BASE_PATCH5_1_PART21_MD5='6cbcaa9b7c412231b592b436f4e5b77a'
ARCHIVE_BASE_PATCH5_1_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-22.bin'
ARCHIVE_BASE_PATCH5_1_PART22_MD5='a68accd6f697dc9c7542441ce4373c5f'
ARCHIVE_BASE_PATCH5_1_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-23.bin'
ARCHIVE_BASE_PATCH5_1_PART23_MD5='67045ba580bfe38320d046caebf82799'
ARCHIVE_BASE_PATCH5_1_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-24.bin'
ARCHIVE_BASE_PATCH5_1_PART24_MD5='77d5c61d647007d6c2ee522d82354c10'
ARCHIVE_BASE_PATCH5_1_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-25.bin'
ARCHIVE_BASE_PATCH5_1_PART25_MD5='17db3c1c0706d86d074bad776401dfae'
ARCHIVE_BASE_PATCH5_1_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-26.bin'
ARCHIVE_BASE_PATCH5_1_PART26_MD5='6dc6d4ef5c7b3c6fdef926c1dbb79abe'
ARCHIVE_BASE_PATCH5_1_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-27.bin'
ARCHIVE_BASE_PATCH5_1_PART27_MD5='15d16729ba8fd25eaf3fe95bcfd89863'
ARCHIVE_BASE_PATCH5_1_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-28.bin'
ARCHIVE_BASE_PATCH5_1_PART28_MD5='51458a5835f079f452fbb32e57fe29d3'
ARCHIVE_BASE_PATCH5_1_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-29.bin'
ARCHIVE_BASE_PATCH5_1_PART29_MD5='771fe718c64fa6bfd9ac57cba1c18d4e'
ARCHIVE_BASE_PATCH5_1_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.4494476_-_patch_patch5_hotfix6__(64bit)_(70408)-30.bin'
ARCHIVE_BASE_PATCH5_1_PART30_MD5='9d1e8c2dde7c7e8d7be9684a1d2936dc'
ARCHIVE_BASE_PATCH5_1_SIZE='144316256'
ARCHIVE_BASE_PATCH5_1_VERSION='4.1.1.4494476-gog70408'

ARCHIVE_BASE_PATCH4_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995).exe'
ARCHIVE_BASE_PATCH4_0_MD5='ab6267432b272ff880127131e7b2f5f3'
ARCHIVE_BASE_PATCH4_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH4_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-1.bin'
ARCHIVE_BASE_PATCH4_0_PART1_MD5='df12c48514a6e053123b993536984db1'
ARCHIVE_BASE_PATCH4_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-2.bin'
ARCHIVE_BASE_PATCH4_0_PART2_MD5='7624eae52e3ba390cc451c92eb22971e'
ARCHIVE_BASE_PATCH4_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-3.bin'
ARCHIVE_BASE_PATCH4_0_PART3_MD5='55926fedfbe8bfc55259f43e279506c2'
ARCHIVE_BASE_PATCH4_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-4.bin'
ARCHIVE_BASE_PATCH4_0_PART4_MD5='6521b33ac90d7da85737fd789a035a4b'
ARCHIVE_BASE_PATCH4_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-5.bin'
ARCHIVE_BASE_PATCH4_0_PART5_MD5='9cab7eb4d37f6970d7c75620604f6260'
ARCHIVE_BASE_PATCH4_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-6.bin'
ARCHIVE_BASE_PATCH4_0_PART6_MD5='d6c465c93781fe3ff757c6c20a2ff373'
ARCHIVE_BASE_PATCH4_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-7.bin'
ARCHIVE_BASE_PATCH4_0_PART7_MD5='75a4703c4ab50e922f35c37dc0b2f91c'
ARCHIVE_BASE_PATCH4_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-8.bin'
ARCHIVE_BASE_PATCH4_0_PART8_MD5='2abf5bf419d07af67fa89ab9cf782401'
ARCHIVE_BASE_PATCH4_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-9.bin'
ARCHIVE_BASE_PATCH4_0_PART9_MD5='156c9711f63b8db03f31e41fd22e59af'
ARCHIVE_BASE_PATCH4_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-10.bin'
ARCHIVE_BASE_PATCH4_0_PART10_MD5='32430ec83c9b780c637c1d6b2de9ce68'
ARCHIVE_BASE_PATCH4_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-11.bin'
ARCHIVE_BASE_PATCH4_0_PART11_MD5='d0ae7f626c2f163f7192f2e6d10f09db'
ARCHIVE_BASE_PATCH4_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-12.bin'
ARCHIVE_BASE_PATCH4_0_PART12_MD5='5378372fae1cf46669db85f60091e77c'
ARCHIVE_BASE_PATCH4_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-13.bin'
ARCHIVE_BASE_PATCH4_0_PART13_MD5='f0e0d239c05867ceddd2f630794db82f'
ARCHIVE_BASE_PATCH4_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-14.bin'
ARCHIVE_BASE_PATCH4_0_PART14_MD5='49324f1d65939e8e41ea5530f369d5cd'
ARCHIVE_BASE_PATCH4_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-15.bin'
ARCHIVE_BASE_PATCH4_0_PART15_MD5='a6547b00be69663430c8c72bfa4a9f85'
ARCHIVE_BASE_PATCH4_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-16.bin'
ARCHIVE_BASE_PATCH4_0_PART16_MD5='c285e952585a260478c2d31f29448745'
ARCHIVE_BASE_PATCH4_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-17.bin'
ARCHIVE_BASE_PATCH4_0_PART17_MD5='d6fb24e9f9781f4f72c5435634ac6ac7'
ARCHIVE_BASE_PATCH4_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-18.bin'
ARCHIVE_BASE_PATCH4_0_PART18_MD5='c05f0ef6d178843fb0da80753752b5b5'
ARCHIVE_BASE_PATCH4_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-19.bin'
ARCHIVE_BASE_PATCH4_0_PART19_MD5='626615ae36a91d6f06b66f82090725e7'
ARCHIVE_BASE_PATCH4_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-20.bin'
ARCHIVE_BASE_PATCH4_0_PART20_MD5='e41563ed5af9e65893968dc4f3a3a11f'
ARCHIVE_BASE_PATCH4_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-21.bin'
ARCHIVE_BASE_PATCH4_0_PART21_MD5='f8c9ca01fa54f40c6720907a6754497c'
ARCHIVE_BASE_PATCH4_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-22.bin'
ARCHIVE_BASE_PATCH4_0_PART22_MD5='6c73b251f90ccdfc3478e36dd5c10ba2'
ARCHIVE_BASE_PATCH4_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-23.bin'
ARCHIVE_BASE_PATCH4_0_PART23_MD5='1b3b77c0ec4d9d0355964662ff82c9eb'
ARCHIVE_BASE_PATCH4_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-24.bin'
ARCHIVE_BASE_PATCH4_0_PART24_MD5='49538632c8eb659f017c3ae1a1698a1f'
ARCHIVE_BASE_PATCH4_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-25.bin'
ARCHIVE_BASE_PATCH4_0_PART25_MD5='6ee062ce652cb6606b9747f3ace8706e'
ARCHIVE_BASE_PATCH4_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-26.bin'
ARCHIVE_BASE_PATCH4_0_PART26_MD5='97fda2b27e9bf32387e17294f2dd05ed'
ARCHIVE_BASE_PATCH4_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3956130_-_patch_patch4_hotfix3__(64bit)_(68995)-27.bin'
ARCHIVE_BASE_PATCH4_0_PART27_MD5='c4e2eee7ea51aa41ba1fcd2544a7423c'
ARCHIVE_BASE_PATCH4_0_SIZE='126864164'
ARCHIVE_BASE_PATCH4_0_VERSION='4.1.1.3956130-gog68995'

ARCHIVE_BASE_PATCH3_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008).exe'
ARCHIVE_BASE_PATCH3_0_MD5='e2da307eb714d2e746048e8fb7d646a4'
ARCHIVE_BASE_PATCH3_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH3_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-1.bin'
ARCHIVE_BASE_PATCH3_0_PART1_MD5='c1f97403bf1b7aef31aac7ac8a05c52c'
ARCHIVE_BASE_PATCH3_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-2.bin'
ARCHIVE_BASE_PATCH3_0_PART2_MD5='f758ba3cb8c8b92ec3f87d1b923b7c11'
ARCHIVE_BASE_PATCH3_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-3.bin'
ARCHIVE_BASE_PATCH3_0_PART3_MD5='0a74176898bbe90ba6df280d002c608f'
ARCHIVE_BASE_PATCH3_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-4.bin'
ARCHIVE_BASE_PATCH3_0_PART4_MD5='2839a599a52492bf7fc7e21a0f948792'
ARCHIVE_BASE_PATCH3_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-5.bin'
ARCHIVE_BASE_PATCH3_0_PART5_MD5='e6662560a171acf293da789ba73e66a5'
ARCHIVE_BASE_PATCH3_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-6.bin'
ARCHIVE_BASE_PATCH3_0_PART6_MD5='3fa48d0c2cbdb8d2bed0d7b1120e4807'
ARCHIVE_BASE_PATCH3_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-7.bin'
ARCHIVE_BASE_PATCH3_0_PART7_MD5='435d3b387cbd7f77149f4fd48e97172e'
ARCHIVE_BASE_PATCH3_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-8.bin'
ARCHIVE_BASE_PATCH3_0_PART8_MD5='3e6a2f03e58ec7067c9cebffc913144d'
ARCHIVE_BASE_PATCH3_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-9.bin'
ARCHIVE_BASE_PATCH3_0_PART9_MD5='9560938b6aa92559096c7db471c437fa'
ARCHIVE_BASE_PATCH3_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-10.bin'
ARCHIVE_BASE_PATCH3_0_PART10_MD5='42e9165bd6665754052936cf5949269a'
ARCHIVE_BASE_PATCH3_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-11.bin'
ARCHIVE_BASE_PATCH3_0_PART11_MD5='b536ed99f08843c8bb6c7af50f3a14b9'
ARCHIVE_BASE_PATCH3_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-12.bin'
ARCHIVE_BASE_PATCH3_0_PART12_MD5='86a43810f51761fd09a653f1b89e9936'
ARCHIVE_BASE_PATCH3_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-13.bin'
ARCHIVE_BASE_PATCH3_0_PART13_MD5='83d3432202ca5a775952afc001086a03'
ARCHIVE_BASE_PATCH3_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-14.bin'
ARCHIVE_BASE_PATCH3_0_PART14_MD5='db7dcdd36279cf06e014b3d51d06e978'
ARCHIVE_BASE_PATCH3_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-15.bin'
ARCHIVE_BASE_PATCH3_0_PART15_MD5='9e472641d3c34199dfeba8851f7bdcf5'
ARCHIVE_BASE_PATCH3_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-16.bin'
ARCHIVE_BASE_PATCH3_0_PART16_MD5='1f7d14f63ecafdbbcd727de7ac38223c'
ARCHIVE_BASE_PATCH3_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-17.bin'
ARCHIVE_BASE_PATCH3_0_PART17_MD5='f1359a59c61a955f0620febc487a1269'
ARCHIVE_BASE_PATCH3_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-18.bin'
ARCHIVE_BASE_PATCH3_0_PART18_MD5='bfd969ab39637c49b64f7cfaa1f20804'
ARCHIVE_BASE_PATCH3_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-19.bin'
ARCHIVE_BASE_PATCH3_0_PART19_MD5='e8eae4f90a2cea5bcbdee08a1b712aef'
ARCHIVE_BASE_PATCH3_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-20.bin'
ARCHIVE_BASE_PATCH3_0_PART20_MD5='b88525457e4b590b78c34f40e1ba60f0'
ARCHIVE_BASE_PATCH3_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-21.bin'
ARCHIVE_BASE_PATCH3_0_PART21_MD5='d74266b799d4d911838cf9173c87fda6'
ARCHIVE_BASE_PATCH3_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-22.bin'
ARCHIVE_BASE_PATCH3_0_PART22_MD5='75b917c7abbf4483a82b56b5395e39c0'
ARCHIVE_BASE_PATCH3_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-23.bin'
ARCHIVE_BASE_PATCH3_0_PART23_MD5='bd518745958733216fb50f9fce5cb494'
ARCHIVE_BASE_PATCH3_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-24.bin'
ARCHIVE_BASE_PATCH3_0_PART24_MD5='404946034a46864f9172c7b9cf13002b'
ARCHIVE_BASE_PATCH3_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-25.bin'
ARCHIVE_BASE_PATCH3_0_PART25_MD5='f6255a2a3130642c3f96fd43252e9dec'
ARCHIVE_BASE_PATCH3_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-26.bin'
ARCHIVE_BASE_PATCH3_0_PART26_MD5='d2bbcc99329999915b2b478e9d9218e4'
ARCHIVE_BASE_PATCH3_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-27.bin'
ARCHIVE_BASE_PATCH3_0_PART27_MD5='3e8cc3d3b3028f065e73296dcc714712'
ARCHIVE_BASE_PATCH3_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-28.bin'
ARCHIVE_BASE_PATCH3_0_PART28_MD5='1ad835b73e36f5fd9706f5a3e3ccd276'
ARCHIVE_BASE_PATCH3_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-29.bin'
ARCHIVE_BASE_PATCH3_0_PART29_MD5='27564ccea2ef5b369feee3b246631060'
ARCHIVE_BASE_PATCH3_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-30.bin'
ARCHIVE_BASE_PATCH3_0_PART30_MD5='c3729516a6fb77dad2f760ef9d21bb9a'
ARCHIVE_BASE_PATCH3_0_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-31.bin'
ARCHIVE_BASE_PATCH3_0_PART31_MD5='5fb4854aaac674f56a563dc4616b8792'
ARCHIVE_BASE_PATCH3_0_SIZE='156835644'
ARCHIVE_BASE_PATCH3_0_VERSION='4.1.1.3767641-gog68008'

ARCHIVE_BASE_PATCH2_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336).exe'
ARCHIVE_BASE_PATCH2_0_MD5='6eeac06fdc264d09052dd52a5d8f85fb'
ARCHIVE_BASE_PATCH2_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH2_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-1.bin'
ARCHIVE_BASE_PATCH2_0_PART1_MD5='a8ac39fc4ddd9dc8c8b451ddceb2bed7'
ARCHIVE_BASE_PATCH2_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-2.bin'
ARCHIVE_BASE_PATCH2_0_PART2_MD5='1e1806b014056b87e1d8d38310d27843'
ARCHIVE_BASE_PATCH2_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-3.bin'
ARCHIVE_BASE_PATCH2_0_PART3_MD5='3caaa1250e79563a94689b6cc7777226'
ARCHIVE_BASE_PATCH2_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-4.bin'
ARCHIVE_BASE_PATCH2_0_PART4_MD5='c73405adb39664c2580444be4d8f1e77'
ARCHIVE_BASE_PATCH2_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-5.bin'
ARCHIVE_BASE_PATCH2_0_PART5_MD5='d380505dfa53dfda7cfd446781cadc1e'
ARCHIVE_BASE_PATCH2_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-6.bin'
ARCHIVE_BASE_PATCH2_0_PART6_MD5='bbd932a09811206b178cbaaa3e1961f4'
ARCHIVE_BASE_PATCH2_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-7.bin'
ARCHIVE_BASE_PATCH2_0_PART7_MD5='9096d0e0d58509b010366140d74d0387'
ARCHIVE_BASE_PATCH2_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-8.bin'
ARCHIVE_BASE_PATCH2_0_PART8_MD5='bbfceef39180a8066727f23c9e494f9a'
ARCHIVE_BASE_PATCH2_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-9.bin'
ARCHIVE_BASE_PATCH2_0_PART9_MD5='5a118078fc27f3aa102023ef6f0f8b38'
ARCHIVE_BASE_PATCH2_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-10.bin'
ARCHIVE_BASE_PATCH2_0_PART10_MD5='0f221f4cb8c70bec4a76f605842e4b5a'
ARCHIVE_BASE_PATCH2_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-11.bin'
ARCHIVE_BASE_PATCH2_0_PART11_MD5='03bb396186275434f3630dcaea22f847'
ARCHIVE_BASE_PATCH2_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-12.bin'
ARCHIVE_BASE_PATCH2_0_PART12_MD5='94e6c7a3957f0692587dd1e17e57bd6b'
ARCHIVE_BASE_PATCH2_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-13.bin'
ARCHIVE_BASE_PATCH2_0_PART13_MD5='0e492c7302256ec45e5f01cb6d86f194'
ARCHIVE_BASE_PATCH2_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-14.bin'
ARCHIVE_BASE_PATCH2_0_PART14_MD5='2d476b947cd51d52d5406eb22772b370'
ARCHIVE_BASE_PATCH2_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-15.bin'
ARCHIVE_BASE_PATCH2_0_PART15_MD5='932de8332ecef4512f15942f306e35d9'
ARCHIVE_BASE_PATCH2_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-16.bin'
ARCHIVE_BASE_PATCH2_0_PART16_MD5='e7fd6a1d8b1191726d29beeb671db49a'
ARCHIVE_BASE_PATCH2_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-17.bin'
ARCHIVE_BASE_PATCH2_0_PART17_MD5='586951c282b7937106f303a80911245b'
ARCHIVE_BASE_PATCH2_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-18.bin'
ARCHIVE_BASE_PATCH2_0_PART18_MD5='f9a7d5f8dacd3469bdb79126bd4838e7'
ARCHIVE_BASE_PATCH2_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-19.bin'
ARCHIVE_BASE_PATCH2_0_PART19_MD5='9099f94ffe643239596ce857c1720e08'
ARCHIVE_BASE_PATCH2_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-20.bin'
ARCHIVE_BASE_PATCH2_0_PART20_MD5='9e20afbabdaea6d69bc51045da768f69'
ARCHIVE_BASE_PATCH2_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-21.bin'
ARCHIVE_BASE_PATCH2_0_PART21_MD5='4230156c15022f0634edd98542020683'
ARCHIVE_BASE_PATCH2_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-22.bin'
ARCHIVE_BASE_PATCH2_0_PART22_MD5='0471d8d45cd5eb7accdd16c563c1e972'
ARCHIVE_BASE_PATCH2_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-23.bin'
ARCHIVE_BASE_PATCH2_0_PART23_MD5='50d0b713eaa36adaf530f9bf87600baa'
ARCHIVE_BASE_PATCH2_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-24.bin'
ARCHIVE_BASE_PATCH2_0_PART24_MD5='05c0bdfd7c1b01083d511054f6a9f23a'
ARCHIVE_BASE_PATCH2_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-25.bin'
ARCHIVE_BASE_PATCH2_0_PART25_MD5='96141571c42a53a9bf78960e4c7d83ab'
ARCHIVE_BASE_PATCH2_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-26.bin'
ARCHIVE_BASE_PATCH2_0_PART26_MD5='3e23b9e016c006fae2c3c60a5af44a47'
ARCHIVE_BASE_PATCH2_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-27.bin'
ARCHIVE_BASE_PATCH2_0_PART27_MD5='b50cb9a55312f948909ee57c6ed09469'
ARCHIVE_BASE_PATCH2_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-28.bin'
ARCHIVE_BASE_PATCH2_0_PART28_MD5='24910c2975faf1762a177df3cb95c593'
ARCHIVE_BASE_PATCH2_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-29.bin'
ARCHIVE_BASE_PATCH2_0_PART29_MD5='2e4c222aabc70fd6068ad8834aaa7b2c'
ARCHIVE_BASE_PATCH2_0_SIZE='145464212'
ARCHIVE_BASE_PATCH2_0_VERSION='4.1.1.3700362-gog67336'

ARCHIVE_BASE_PATCH1_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052).exe'
ARCHIVE_BASE_PATCH1_0_MD5='09401cf3b960c56032b9c8d5492d2316'
ARCHIVE_BASE_PATCH1_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH1_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-1.bin'
ARCHIVE_BASE_PATCH1_0_PART1_MD5='f3a8409e3f4dd3db98bc5df6ce0742f5'
ARCHIVE_BASE_PATCH1_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-2.bin'
ARCHIVE_BASE_PATCH1_0_PART2_MD5='9135194fb160d8d8fb35aac207b668b3'
ARCHIVE_BASE_PATCH1_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-3.bin'
ARCHIVE_BASE_PATCH1_0_PART3_MD5='489c13ad3282beb71aa3de4db880fade'
ARCHIVE_BASE_PATCH1_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-4.bin'
ARCHIVE_BASE_PATCH1_0_PART4_MD5='24caf894181a2d7be008bfd6bce865a6'
ARCHIVE_BASE_PATCH1_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-5.bin'
ARCHIVE_BASE_PATCH1_0_PART5_MD5='17a4f372bd3d56a3b531eb2bf1c9f14d'
ARCHIVE_BASE_PATCH1_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-6.bin'
ARCHIVE_BASE_PATCH1_0_PART6_MD5='5897dad5e3de1419b13ea78ffb200510'
ARCHIVE_BASE_PATCH1_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-7.bin'
ARCHIVE_BASE_PATCH1_0_PART7_MD5='f652711efa1f8328d097be81527260f4'
ARCHIVE_BASE_PATCH1_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-8.bin'
ARCHIVE_BASE_PATCH1_0_PART8_MD5='748370642aefced9eb5647cc4e431828'
ARCHIVE_BASE_PATCH1_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-9.bin'
ARCHIVE_BASE_PATCH1_0_PART9_MD5='01e5e27b88c2d9a610136fafdb4b8f02'
ARCHIVE_BASE_PATCH1_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-10.bin'
ARCHIVE_BASE_PATCH1_0_PART10_MD5='084d3daf2161b8054e5a4d58fd859e80'
ARCHIVE_BASE_PATCH1_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-11.bin'
ARCHIVE_BASE_PATCH1_0_PART11_MD5='6a2e64ba408cfacc1cf4d4c87ef0ef7b'
ARCHIVE_BASE_PATCH1_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-12.bin'
ARCHIVE_BASE_PATCH1_0_PART12_MD5='c7936ac74791438308efb79b748a1a9e'
ARCHIVE_BASE_PATCH1_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-13.bin'
ARCHIVE_BASE_PATCH1_0_PART13_MD5='262a4d8e4c34d382a6220acf44205b84'
ARCHIVE_BASE_PATCH1_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-14.bin'
ARCHIVE_BASE_PATCH1_0_PART14_MD5='ccf42f75bdd18740ddc3680ece6c06b2'
ARCHIVE_BASE_PATCH1_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-15.bin'
ARCHIVE_BASE_PATCH1_0_PART15_MD5='2e2558d1b7c1d5252afcb6a0542b3848'
ARCHIVE_BASE_PATCH1_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-16.bin'
ARCHIVE_BASE_PATCH1_0_PART16_MD5='a7d40cc96e64cdb85aeccc2471900acc'
ARCHIVE_BASE_PATCH1_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-17.bin'
ARCHIVE_BASE_PATCH1_0_PART17_MD5='53b77f130bc641baf7e26007f9fc3849'
ARCHIVE_BASE_PATCH1_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-18.bin'
ARCHIVE_BASE_PATCH1_0_PART18_MD5='26ecb989f6d025bb4ab5ea726cacb496'
ARCHIVE_BASE_PATCH1_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-19.bin'
ARCHIVE_BASE_PATCH1_0_PART19_MD5='8f507b0da3729dba21989460f96d3781'
ARCHIVE_BASE_PATCH1_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-20.bin'
ARCHIVE_BASE_PATCH1_0_PART20_MD5='40493a3fb33da7202533823f1444b526'
ARCHIVE_BASE_PATCH1_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-21.bin'
ARCHIVE_BASE_PATCH1_0_PART21_MD5='8f2abd65aaaae133ac4e6233efda0654'
ARCHIVE_BASE_PATCH1_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-22.bin'
ARCHIVE_BASE_PATCH1_0_PART22_MD5='f5a21a6a93328adb55459b28d7096608'
ARCHIVE_BASE_PATCH1_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-23.bin'
ARCHIVE_BASE_PATCH1_0_PART23_MD5='0f2f3783421bbf5c7c714b0d99dc0bc2'
ARCHIVE_BASE_PATCH1_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-24.bin'
ARCHIVE_BASE_PATCH1_0_PART24_MD5='11ee20ad29f1dfa7ba9618664c974fa9'
ARCHIVE_BASE_PATCH1_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-25.bin'
ARCHIVE_BASE_PATCH1_0_PART25_MD5='4c93abd831b0469f2061f27b6ecaebe0'
ARCHIVE_BASE_PATCH1_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-26.bin'
ARCHIVE_BASE_PATCH1_0_PART26_MD5='610b63465163f61c5e645092800bc3d9'
ARCHIVE_BASE_PATCH1_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-27.bin'
ARCHIVE_BASE_PATCH1_0_PART27_MD5='9e81fa436fb596f0ae071ae1d7d660d6'
ARCHIVE_BASE_PATCH1_0_PART28_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-28.bin'
ARCHIVE_BASE_PATCH1_0_PART28_MD5='8581ed928d138c89a05d68a116684d7a'
ARCHIVE_BASE_PATCH1_0_SIZE='140000000'
ARCHIVE_BASE_PATCH1_0_VERSION='4.1.1.3669438-gog67052'

ARCHIVE_BASE_PATCH0_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683).exe'
ARCHIVE_BASE_PATCH0_0_MD5='986cbd346ca2444eba5ca65921557abc'
ARCHIVE_BASE_PATCH0_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH0_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-1.bin'
ARCHIVE_BASE_PATCH0_0_PART1_MD5='14c9146c4ef5c86dae1edcc4ffcf5953'
ARCHIVE_BASE_PATCH0_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-2.bin'
ARCHIVE_BASE_PATCH0_0_PART2_MD5='2768930a5a1f20998c087c483c298d4e'
ARCHIVE_BASE_PATCH0_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-3.bin'
ARCHIVE_BASE_PATCH0_0_PART3_MD5='f6de17882cf9c14bf4d9c35d1408b370'
ARCHIVE_BASE_PATCH0_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-4.bin'
ARCHIVE_BASE_PATCH0_0_PART4_MD5='57821851b52dbc96735e19ed4cea4412'
ARCHIVE_BASE_PATCH0_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-5.bin'
ARCHIVE_BASE_PATCH0_0_PART5_MD5='2699c17f29e4385685fedf8f4c722942'
ARCHIVE_BASE_PATCH0_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-6.bin'
ARCHIVE_BASE_PATCH0_0_PART6_MD5='dfda5cb12822ab47d0fbec331a3bf4e9'
ARCHIVE_BASE_PATCH0_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-7.bin'
ARCHIVE_BASE_PATCH0_0_PART7_MD5='a9c6c86ba6b752fdfe3b17e2bb671da9'
ARCHIVE_BASE_PATCH0_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-8.bin'
ARCHIVE_BASE_PATCH0_0_PART8_MD5='6b8124c98e89a4476fd5ebc5fb6eac4e'
ARCHIVE_BASE_PATCH0_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-9.bin'
ARCHIVE_BASE_PATCH0_0_PART9_MD5='0b40958f3d74bc799e39c0b6757dd210'
ARCHIVE_BASE_PATCH0_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-10.bin'
ARCHIVE_BASE_PATCH0_0_PART10_MD5='274034a44d58e127f845664c7ba290ee'
ARCHIVE_BASE_PATCH0_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-11.bin'
ARCHIVE_BASE_PATCH0_0_PART11_MD5='2f4d7c82fb650731a2e215d28b4aefc8'
ARCHIVE_BASE_PATCH0_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-12.bin'
ARCHIVE_BASE_PATCH0_0_PART12_MD5='bd3a022fe59b2089d97e5f3905bc3962'
ARCHIVE_BASE_PATCH0_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-13.bin'
ARCHIVE_BASE_PATCH0_0_PART13_MD5='712abe64604b05e2fbbc7bd9aacb1413'
ARCHIVE_BASE_PATCH0_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-14.bin'
ARCHIVE_BASE_PATCH0_0_PART14_MD5='4dfd9e4a56ce1d63293a0e7bcc66e7a4'
ARCHIVE_BASE_PATCH0_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-15.bin'
ARCHIVE_BASE_PATCH0_0_PART15_MD5='512fa657892ca991d3f626e21f2d6821'
ARCHIVE_BASE_PATCH0_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-16.bin'
ARCHIVE_BASE_PATCH0_0_PART16_MD5='e364b2302d2e23e79478eceda835b95f'
ARCHIVE_BASE_PATCH0_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-17.bin'
ARCHIVE_BASE_PATCH0_0_PART17_MD5='0623bd7550eb187d569ee66cf2bad6c1'
ARCHIVE_BASE_PATCH0_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-18.bin'
ARCHIVE_BASE_PATCH0_0_PART18_MD5='886a04f956eb69f6a644dd9faff319d0'
ARCHIVE_BASE_PATCH0_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-19.bin'
ARCHIVE_BASE_PATCH0_0_PART19_MD5='c6d3c5c670066872c7e0cf78162d96ad'
ARCHIVE_BASE_PATCH0_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-20.bin'
ARCHIVE_BASE_PATCH0_0_PART20_MD5='6517b23d62e752d5f28e607157690f9b'
ARCHIVE_BASE_PATCH0_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-21.bin'
ARCHIVE_BASE_PATCH0_0_PART21_MD5='e80bbbd92fa5992792679bf0f46d32ad'
ARCHIVE_BASE_PATCH0_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-22.bin'
ARCHIVE_BASE_PATCH0_0_PART22_MD5='16c82788a087f3ad44939854aed5b812'
ARCHIVE_BASE_PATCH0_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-23.bin'
ARCHIVE_BASE_PATCH0_0_PART23_MD5='ee096b68eb210b732348d31e940702ea'
ARCHIVE_BASE_PATCH0_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-24.bin'
ARCHIVE_BASE_PATCH0_0_PART24_MD5='df2a50351cc593ebaf7316afe7a0ae72'
ARCHIVE_BASE_PATCH0_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-25.bin'
ARCHIVE_BASE_PATCH0_0_PART25_MD5='1db116cd2f589addfa9cf258429c085b'
ARCHIVE_BASE_PATCH0_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-26.bin'
ARCHIVE_BASE_PATCH0_0_PART26_MD5='f937efd190dc0a93b918061f97d24ba9'
ARCHIVE_BASE_PATCH0_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-27.bin'
ARCHIVE_BASE_PATCH0_0_PART27_MD5='2c61a47bea3ed93960382139ba15c6b7'
ARCHIVE_BASE_PATCH0_0_SIZE='131000000'
ARCHIVE_BASE_PATCH0_0_VERSION='4.1.1.3635601-gog66683'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bin'
CONTENT_GAME_L10N_VOICES_FILES='
data/localization/voicemeta.pak'
CONTENT_GAME_L10N_COMMON_FILES='
data/localization/english.pak
data/localization/english_animations.pak'
CONTENT_GAME_L10N_FR_FILES='
data/localization/french'
CONTENT_GAME_DATA_MODELS_FILES='
data/models.pak'
CONTENT_GAME_DATA_SOUNDS_FILES='
data/sharedsoundbanks.pak'
CONTENT_GAME_DATA_TEXTURES_1_FILES='
data/gustav_textures.pak
data/textures.pak
data/textures_1.pak'
CONTENT_GAME_DATA_TEXTURES_2_FILES='
data/textures_2.pak
data/textures_3.pak
data/virtualtextures.pak'
CONTENT_GAME_DATA_TEXTURES_3_FILES='
data/virtualtextures_1.pak
data/virtualtextures_2.pak'
CONTENT_GAME_DATA_TEXTURES_4_FILES='
data/virtualtextures_3.pak
data/virtualtextures_4.pak'
CONTENT_GAME_DATA_TEXTURES_5_FILES='
data/virtualtextures_5.pak
data/virtualtextures_6.pak'
CONTENT_GAME_DATA_TEXTURES_6_FILES='
data/virtualtextures_7.pak
data/virtualtextures_8.pak'
CONTENT_GAME_DATA_TEXTURES_7_FILES='
data/virtualtextures_9.pak
data/virtualtextures_10.pak'
CONTENT_GAME_DATA_TEXTURES_8_FILES='
data/virtualtextures_11.pak
data/virtualtextures_12.pak'
CONTENT_GAME_DATA_TEXTURES_9_FILES='
data/virtualtextures_13.pak
data/virtualtextures_14.pak'
CONTENT_GAME_DATA_TEXTURES_10_FILES='
data/virtualtextures_15.pak
data/virtualtextures_16.pak'
CONTENT_GAME_DATA_TEXTURES_11_FILES='
data/virtualtextures_17.pak
data/virtualtextures_18.pak'
CONTENT_GAME_DATA_TEXTURES_12_FILES='
data/virtualtextures_*.pak'
CONTENT_GAME_DATA_PATCH0_FILES='
data/patch0_hotfix*.pak'
CONTENT_GAME_DATA_PATCH1_FILES='
data/patch1.pak'
CONTENT_GAME_DATA_PATCH2_FILES='
data/patch2.pak
data/patch2_hotfix*.pak'
CONTENT_GAME_DATA_PATCH3_FILES='
data/patch3_hotfix*.pak'
CONTENT_GAME_DATA_PATCH4_FILES='
data/patch4_hotfix*.pak'
CONTENT_GAME_DATA_PATCH5_FILES='
data/patch5_hotfix*.pak'
CONTENT_GAME_DATA_PATCH6_FILES='
data/patch6_hotfix*.pak'
CONTENT_GAME_DATA_PATCH7_FILES='
data/patch7_hotfix*.pak'
CONTENT_GAME_DATA_PATCH8_FILES='
data/patch8_hotfix*.pak'
CONTENT_GAME_DATA_FILES='
data/assets.pak
data/day0.pak
data/diceset??.pak
data/effects.pak
data/engine.pak
data/engineshaders.pak
data/game.pak
data/gameplatform.pak
data/gustav_navcloud.pak
data/gustav_video.pak
data/gustavx.pak
data/icons.pak
data/lowtex.pak
data/materials.pak
data/psocache.pak
data/shared.pak'

HUGE_FILES_L10N_VOICES='
data/localization/voice.pak'
HUGE_FILES_DATA='
data/gustav.pak'
## The size of sharedsounds.pak goes over the .deb size limit only with patch 5,
## but ./play.it has no problem "splitting" a file into a single chunk,
## at the cost of more time spent in post-install scripts.
## TODO: The library-side implementation of huge files should probably skip files under the size limit,
##       putting the whole file into a dedicated package without "splitting" it into a single chunk first.
HUGE_FILES_DATA_SOUNDS='
data/sharedsounds.pak'
## The _PATCH3 suffix is doubled so this matches:
## PKG_DATA_PATCH3 in the context of ARCHIVE_BASE_PATCH3
## but does not match:
## PKG_DATA in the context of ARCHIVE_BASE_PATCH3.
HUGE_FILES_DATA_PATCH3_PATCH3='
data/patch3.pak'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/Larian Studios/Baldur's Gate 3"
## mfc140u.dll is required.
## TODO: Check if this is still required with current WINE
WINE_WINETRICKS_VERBS='mfc140'

APP_MAIN_EXE='bin/bg3.exe'
## The game crashes on launch when forcing the use of the wayland SDL backend
APP_MAIN_PRERUN='
# The game crashes on launch when forcing the use of the wayland SDL backend
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST_BASE='
PKG_BIN
PKG_L10N_VOICES
PKG_L10N_COMMON
PKG_L10N_EN
PKG_L10N_FR
PKG_DATA_MODELS
PKG_DATA_SOUNDS
PKG_DATA_TEXTURES_1
PKG_DATA_TEXTURES_2
PKG_DATA_TEXTURES_3
PKG_DATA_TEXTURES_4
PKG_DATA_TEXTURES_5
PKG_DATA_TEXTURES_6
PKG_DATA_TEXTURES_7
PKG_DATA_TEXTURES_8
PKG_DATA_TEXTURES_9
PKG_DATA_TEXTURES_10
PKG_DATA_TEXTURES_11
PKG_DATA'
PACKAGES_LIST_PATCH0="$PACKAGES_LIST_BASE
PKG_DATA_PATCH0"
PACKAGES_LIST_PATCH1="$PACKAGES_LIST_BASE
PKG_DATA_PATCH0
PKG_DATA_PATCH1"
PACKAGES_LIST_PATCH2="$PACKAGES_LIST_BASE
PKG_DATA_PATCH0
PKG_DATA_PATCH1
PKG_DATA_PATCH2"
PACKAGES_LIST_PATCH3="$PACKAGES_LIST_BASE
PKG_DATA_PATCH0
PKG_DATA_PATCH1
PKG_DATA_PATCH2
PKG_DATA_PATCH3"
PACKAGES_LIST_PATCH4="$PACKAGES_LIST_BASE
PKG_DATA_PATCH4"
PACKAGES_LIST_PATCH5="$PACKAGES_LIST_BASE
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH5"
PACKAGES_LIST_PATCH6="$PACKAGES_LIST_BASE
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH6"
PACKAGES_LIST_PATCH7="$PACKAGES_LIST_BASE
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH7"
PACKAGES_LIST_PATCH8="$PACKAGES_LIST_BASE
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH8"
## Before patch 8 hotfix 1, no extra data/patch8*.pak file is provided.
PACKAGES_LIST_PATCH8_0="$PACKAGES_LIST_BASE
PKG_DATA_TEXTURES_12"

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_EN_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_EN_DESCRIPTION='English localization'
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_DEPENDENCIES_SIBLINGS='
PKG_L10N_COMMON
PKG_L10N_VOICES'
PKG_L10N_EN_DEPENDENCIES_SIBLINGS="$PKG_L10N_DEPENDENCIES_SIBLINGS"
PKG_L10N_FR_DEPENDENCIES_SIBLINGS="$PKG_L10N_DEPENDENCIES_SIBLINGS"

PKG_L10N_COMMON_ID="${PKG_L10N_ID}-common"
PKG_L10N_COMMON_DESCRIPTION='localizations - shared files'

PKG_L10N_VOICES_ID="${PKG_L10N_ID}-voices"
PKG_L10N_VOICES_DESCRIPTION='localizations - voices'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_MODELS
PKG_DATA_SOUNDS
PKG_DATA_TEXTURES_1
PKG_DATA_TEXTURES_2
PKG_DATA_TEXTURES_3
PKG_DATA_TEXTURES_4
PKG_DATA_TEXTURES_5
PKG_DATA_TEXTURES_6
PKG_DATA_TEXTURES_7
PKG_DATA_TEXTURES_8
PKG_DATA_TEXTURES_9
PKG_DATA_TEXTURES_10
PKG_DATA_TEXTURES_11'
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH0="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_PATCH0"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH1="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_PATCH0
PKG_DATA_PATCH1"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH2="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_PATCH0
PKG_DATA_PATCH1
PKG_DATA_PATCH2"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH3="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_PATCH0
PKG_DATA_PATCH1
PKG_DATA_PATCH2
PKG_DATA_PATCH3"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH4="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_PATCH4"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH5="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH5"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH6="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH6"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH7="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH7"
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH8="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_TEXTURES_12
PKG_DATA_PATCH8"
## Before patch 8 hotfix 1, no extra data/patch8*.pak file is provided.
PKG_DATA_DEPENDENCIES_SIBLINGS_PATCH8_0="$PKG_DATA_DEPENDENCIES_SIBLINGS
PKG_DATA_TEXTURES_12"

PKG_DATA_MODELS_ID="${PKG_DATA_ID}-models"
PKG_DATA_MODELS_DESCRIPTION="$PKG_DATA_DESCRIPTION - models"

PKG_DATA_SOUNDS_ID="${PKG_DATA_ID}-sounds"
PKG_DATA_SOUNDS_DESCRIPTION="$PKG_DATA_DESCRIPTION - sounds"

PKG_DATA_TEXTURES_ID="${PKG_DATA_ID}-textures"
PKG_DATA_TEXTURES_1_ID="${PKG_DATA_TEXTURES_ID}-1"
PKG_DATA_TEXTURES_2_ID="${PKG_DATA_TEXTURES_ID}-2"
PKG_DATA_TEXTURES_3_ID="${PKG_DATA_TEXTURES_ID}-3"
PKG_DATA_TEXTURES_4_ID="${PKG_DATA_TEXTURES_ID}-4"
PKG_DATA_TEXTURES_5_ID="${PKG_DATA_TEXTURES_ID}-5"
PKG_DATA_TEXTURES_6_ID="${PKG_DATA_TEXTURES_ID}-6"
PKG_DATA_TEXTURES_7_ID="${PKG_DATA_TEXTURES_ID}-7"
PKG_DATA_TEXTURES_8_ID="${PKG_DATA_TEXTURES_ID}-8"
PKG_DATA_TEXTURES_9_ID="${PKG_DATA_TEXTURES_ID}-9"
PKG_DATA_TEXTURES_10_ID="${PKG_DATA_TEXTURES_ID}-10"
PKG_DATA_TEXTURES_11_ID="${PKG_DATA_TEXTURES_ID}-11"
PKG_DATA_TEXTURES_12_ID="${PKG_DATA_TEXTURES_ID}-12"
PKG_DATA_TEXTURES_DESCRIPTION="$PKG_DATA_DESCRIPTION - textures"
PKG_DATA_TEXTURES_1_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 1"
PKG_DATA_TEXTURES_2_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 2"
PKG_DATA_TEXTURES_3_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 3"
PKG_DATA_TEXTURES_4_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 4"
PKG_DATA_TEXTURES_5_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 5"
PKG_DATA_TEXTURES_6_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 6"
PKG_DATA_TEXTURES_7_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 7"
PKG_DATA_TEXTURES_8_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 8"
PKG_DATA_TEXTURES_9_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 9"
PKG_DATA_TEXTURES_10_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 10"
PKG_DATA_TEXTURES_11_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 11"
PKG_DATA_TEXTURES_12_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 12"

PKG_DATA_PATCH0_ID="${PKG_DATA_ID}-patch0"
PKG_DATA_PATCH1_ID="${PKG_DATA_ID}-patch1"
PKG_DATA_PATCH2_ID="${PKG_DATA_ID}-patch2"
PKG_DATA_PATCH3_ID="${PKG_DATA_ID}-patch3"
PKG_DATA_PATCH4_ID="${PKG_DATA_ID}-patch4"
PKG_DATA_PATCH5_ID="${PKG_DATA_ID}-patch5"
PKG_DATA_PATCH6_ID="${PKG_DATA_ID}-patch6"
PKG_DATA_PATCH7_ID="${PKG_DATA_ID}-patch7"
PKG_DATA_PATCH8_ID="${PKG_DATA_ID}-patch8"
PKG_DATA_PATCH0_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch0"
PKG_DATA_PATCH1_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch1"
PKG_DATA_PATCH2_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch2"
PKG_DATA_PATCH3_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch3"
PKG_DATA_PATCH4_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch4"
PKG_DATA_PATCH5_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch5"
PKG_DATA_PATCH6_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch6"
PKG_DATA_PATCH7_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch7"
PKG_DATA_PATCH8_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch8"

## Archives patch0*.pak, patch1*.pak, patch2*.pak and patch3*.pak are dropped with the patch 4 release.
PKG_DATA_PROVIDES_PATCH4="
$PKG_DATA_PATCH0_ID
$PKG_DATA_PATCH1_ID
$PKG_DATA_PATCH2_ID
$PKG_DATA_PATCH3_ID
${PKG_DATA_PATCH3_ID}-chunk1
${PKG_DATA_PATCH3_ID}-chunk2"
## Archives patch4*.pak are dropped with the patch 5 release.
PKG_DATA_PROVIDES_PATCH5="$PKG_DATA_PROVIDES_PATCH4
$PKG_DATA_PATCH4_ID"
## Archives patch5*.pak are dropped with the patch 6 release.
PKG_DATA_PROVIDES_PATCH6="$PKG_DATA_PROVIDES_PATCH5
$PKG_DATA_PATCH5_ID"
## Archives patch6*.pak are dropped with the patch 7 release.
PKG_DATA_PROVIDES_PATCH7="$PKG_DATA_PROVIDES_PATCH6
$PKG_DATA_PATCH6_ID"
## Archives patch7*.pak are dropped with the patch 8 release.
PKG_DATA_PROVIDES_PATCH8="$PKG_DATA_PROVIDES_PATCH7
$PKG_DATA_PATCH7_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Generate localizations configuration

l10n_config_source="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/localization/language.lsx"
l10n_config_pattern='<attribute id="Value" value=".*" type="20" />'

l10n_config_destination_en="$(package_path 'PKG_L10N_EN')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_en='<attribute id="Value" value="English" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_en")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_en};" \
	"$l10n_config_source" > "$l10n_config_destination_en"

l10n_config_destination_fr="$(package_path 'PKG_L10N_FR')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_fr='<attribute id="Value" value="French" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_fr")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_fr};" \
	"$l10n_config_source" > "$l10n_config_destination_fr"

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd bin
	$(wine_command) bg3.exe "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
case "$(messages_language)" in
	('fr')
		message='version %s :'
		lang_en='anglaise'
		lang_fr='française'
	;;
	('en'|*)
		message='%s version:'
		lang_en='English'
		lang_fr='French'
	;;
esac
printf '\n'
## English localization
printf "$message" "$lang_en"
## Silence a ShellCheck false positive, word splitting is expected here
## SC2046 (warning): Quote this to prevent word splitting.
# shellcheck disable=SC2046
print_instructions $(packages_list | sed 's/PKG_L10N_FR//')
## French localization
printf "$message" "$lang_fr"
## Silence a ShellCheck false positive, word splitting is expected here
## SC2046 (warning): Quote this to prevent word splitting.
# shellcheck disable=SC2046
print_instructions $(packages_list | sed 's/PKG_L10N_EN//')

# Clean up

working_directory_cleanup

exit 0
