/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Bitmap;
import com.fluendo.jkate.Palette;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class TigerBitmap {
    private Image image;
    private Image scaled_image;

    public TigerBitmap(Component component, Bitmap bitmap, Palette palette) {
        this.image = bitmap == null ? null : (bitmap.bpp == 0 ? this.createPNGBitmap(component, bitmap, palette) : (palette == null ? null : this.createPalettedBitmap(component, bitmap, palette)));
    }

    public Image getScaled(int n, int n2) {
        if (this.scaled_image == null || n != this.scaled_image.getWidth(null) || n2 != this.scaled_image.getHeight(null)) {
            this.scaled_image = this.image.getScaledInstance(n, n2, 4);
        }
        return this.scaled_image;
    }

    private Image createPNGBitmap(Component component, Bitmap bitmap, Palette palette) {
        Debug.warning("PNG bitmaps not supported yet");
        return null;
    }

    private Image createPalettedBitmap(Component component, Bitmap bitmap, Palette palette) {
        byte[] byArray = new byte[4 * palette.colors.length];
        int n = 0;
        while (n < palette.colors.length) {
            byArray[n * 4 + 0] = palette.colors[n].r;
            byArray[n * 4 + 1] = palette.colors[n].g;
            byArray[n * 4 + 2] = palette.colors[n].b;
            byArray[n * 4 + 3] = palette.colors[n].a;
            ++n;
        }
        IndexColorModel indexColorModel = new IndexColorModel(bitmap.bpp, palette.colors.length, byArray, 0, true);
        return component.createImage(new MemoryImageSource(bitmap.width, bitmap.height, (ColorModel)indexColorModel, bitmap.pixels, 0, bitmap.width));
    }
}

