#ifndef MODULE_LIST_H
#define MODULE_LIST_H

#include "cdi.h"
#include "modules.h"
#include "module_definitions.h"
#include "operator_help.h"

// clang-format off


//                                             FuncName        Help                OperatorList               internal                    RestrictionType
//                                             |               |                    |                         |          cdi-numbertype          |
//                                             |               |                    |                         |          |         in   out      |
//                                             |               |                    |                         |          |          |    |       |
static const module_t module_Adisit         = {Adisit         , AdisitHelp        , AdisitOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Afterburner    = {Afterburner    , AfterburnerHelp   , AfterburnerOperators    , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Arith          = {Arith          , ArithHelp         , ArithOperators          , EXPOSED  , CDI_BOTH , 2  , 1     , NoRestriction };
static const module_t module_Arithc         = {Arithc         , ArithcHelp        , ArithcOperators         , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Arithdays      = {Arithdays      , ArithdaysHelp     , ArithdaysOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Arithlat       = {Arithlat       , {}                , ArithlatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Apply          = {nullptr        , ApplyHelp         , {"apply"}               , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Cat            = {Cat            , CopyHelp          , CatOperators            , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_CDItest        = {CDItest        , {}                , CDItestOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_CDIread        = {CDIread        , {}                , CDIreadOperators        , EXPOSED  , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_CDIwrite       = {CDIwrite       , {}                , CDIwriteOperators       , EXPOSED  , CDI_REAL , 0  , 1     , NoRestriction };
static const module_t module_Change         = {Change         , ChangeHelp        , ChangeOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Change_e5slm   = {Change_e5slm   , {}                , Change_e5slmOperators   , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Cloudlayer     = {Cloudlayer     , {}                , CloudlayerOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_CMOR           = {CMOR           , CMORHelp          , CMOROperators           , EXPOSED  , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_CMOR_lite      = {CMOR_lite      , CMORliteHelp      , CMORliteOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_CMOR_table     = {CMOR_table     , {}                , CMORtableOperators      , EXPOSED  , CDI_REAL , 0  , 0     , NoRestriction };
static const module_t module_Collgrid       = {Collgrid       , CollgridHelp      , CollgridOperators       , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Command        = {Command        , {}                , CommandOperators        , INTERNAL , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_Comp           = {Comp           , CompHelp          , CompOperators           , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Compc          = {Compc          , CompcHelp         , CompcOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Complextorect  = {Complextorect  , {}                , ComplextorectOperators  , EXPOSED  , CDI_COMP , 1  , 2     , OnlyFirst     };
static const module_t module_Cond           = {Cond           , CondHelp          , CondOperators           , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Cond2          = {Cond2          , Cond2Help         , Cond2Operators          , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Condc          = {Condc          , CondcHelp         , CondcOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Consecstat     = {Consecstat     , ConsecstatHelp    , ConsecstatOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Copy           = {Copy           , CopyHelp          , CopyOperators           , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Deltat         = {Deltat         , DeltatHelp        , DeltatOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Deltime        = {Deltime        , {}                , DeltimeOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Derivepar      = {Derivepar      , DeriveparHelp     , DeriveparOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Detrend        = {Detrend        , DetrendHelp       , DetrendOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Diff           = {Diff           , DiffHelp          , DiffOperators           , EXPOSED  , CDI_BOTH , 2  , 0     , NoRestriction };
static const module_t module_Distgrid       = {Distgrid       , DistgridHelp      , DistgridOperators       , EXPOSED  , CDI_REAL , 1  , OBASE , NoRestriction };
static const module_t module_Duplicate      = {Duplicate      , DuplicateHelp     , DuplicateOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Echam5ini      = {Echam5ini      , {}                , Echam5iniOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Enlarge        = {Enlarge        , EnlargeHelp       , EnlargeOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Enlargegrid    = {Enlargegrid    , {}                , EnlargegridOperators    , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Ensstat        = {Ensstat        , EnsstatHelp       , EnsstatOperators        , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Ensstat3       = {Ensstat3       , Ensstat2Help      , Ensstat3Operators       , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Ensval         = {Ensval         , EnsvalHelp        , EnsvalOperators         , EXPOSED  , CDI_REAL , -1 , OBASE , NoRestriction };
static const module_t module_Eofcoeff       = {Eofcoeff       , EofcoeffHelp      , EofcoeffOperators       , EXPOSED  , CDI_REAL , 2  , OBASE , NoRestriction };
static const module_t module_Eofcoeff3d     = {Eofcoeff3d     , EofcoeffHelp      , Eofcoeff3dOperators     , EXPOSED  , CDI_REAL , 2  , OBASE , NoRestriction };
static const module_t module_EOFs           = {EOFs           , EOFsHelp          , EOFsOperators           , EXPOSED  , CDI_REAL , 1  , 2     , OnlyFirst     };
static const module_t module_EOF3d          = {EOF3d          , EOFsHelp          , EOF3dOperators          , EXPOSED  , CDI_REAL , 1  , 2     , OnlyFirst     };
static const module_t module_EstFreq        = {EstFreq        , {}                , EstFreqOperators        , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Expr           = {Expr           , ExprHelp          , ExprOperators           , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_FC             = {FC             , {}                , FCOperators             , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Filedes        = {Filedes        , FiledesHelp       , FiledesOperators        , EXPOSED  , CDI_BOTH , 1  , 0     , NoRestriction };
static const module_t module_Fillmiss       = {Fillmiss       , {}                , FillmissOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Filter         = {Filter         , FilterHelp        , FilterOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Fldrms         = {Fldrms         , {}                , FldrmsOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Fldstat        = {Fldstat        , FldstatHelp       , FldstatOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Fldstatcor     = {Fldstat2       , FldcorHelp        , FldcorOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Fldstatvar     = {Fldstat2       , FldcovarHelp      , FldcovarOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Fourier        = {Fourier        , FourierHelp       , FourierOperators        , EXPOSED  , CDI_COMP , 1  , 1     , NoRestriction };
static const module_t module_Gengrid        = {Gengrid        , {}                , GengridOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Gradsdes       = {Gradsdes       , GradsdesHelp      , GradsdesOperators       , EXPOSED  , CDI_REAL , 1  , 0     , FilesOnly };
static const module_t module_Gridboxstat    = {Gridboxstat    , GridboxstatHelp   , GridboxstatOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Gridcell       = {Gridcell       , GridcellHelp      , GridcellOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Gridsearch     = {Gridsearch     , {}                , GridsearchOperators     , EXPOSED  , CDI_REAL , 0  , 0     , NoRestriction };
static const module_t module_Harmonic       = {Harmonic       , {}                , HarmonicOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Histogram      = {Histogram      , HistogramHelp     , HistogramOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Importamsr     = {Importamsr     , ImportamsrHelp    , ImportamsrOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Importbinary   = {Importbinary   , ImportbinaryHelp  , ImportbinaryOperators   , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Importcmsaf    = {Importcmsaf    , ImportcmsafHelp   , ImportcmsafOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Importobs      = {Importobs      , {}                , ImportobsOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Importfv3grid  = {Importfv3grid  , {}                , Importfv3gridOperators  , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Info           = {Info           , InfoHelp          , InfoOperators           , EXPOSED  , CDI_BOTH , -1 , 0     , NoRestriction };
static const module_t module_Input          = {Input          , InputHelp         , InputOperators          , EXPOSED  , CDI_REAL , 0  , 1     , NoRestriction };
static const module_t module_Intgrid        = {Intgrid        , {}                , IntgridOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Intgridtraj    = {Intgridtraj    , {}                , IntgridtrajOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Intlevel       = {Intlevel       , IntlevelHelp      , IntlevelOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Intlevel3d     = {Intlevel3d     , Intlevel3dHelp    , Intlevel3dOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Inttime        = {Inttime        , InttimeHelp       , InttimeOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Intntime       = {Intntime       , InttimeHelp       , IntntimeOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Intyear        = {Intyear        , IntyearHelp       , IntyearOperators        , EXPOSED  , CDI_REAL , 2  , OBASE , NoRestriction };
static const module_t module_Invert         = {Invert         , InvertHelp        , InvertOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Invertlev      = {Invertlev      , InvertlevHelp     , InvertlevOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Isosurface     = {Isosurface     , IsosurfaceHelp    , IsosurfaceOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Lic            = {Lic            , {}                , LicOperators            , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_MapReduce      = {MapReduce      , MapReduceHelp     , MapReduceOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Maskbox        = {Maskbox        , MaskboxHelp       , MaskboxOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Maskregion     = {Maskbox        , MaskregionHelp    , MaskregionOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Mastrfu        = {Mastrfu        , MastrfuHelp       , MastrfuOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Math           = {Math           , MathHelp          , MathOperators           , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Merge          = {Merge          , MergeHelp         , MergeOperators          , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Mergetime      = {Mergetime      , MergeHelp         , MergetimeOperators      , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Mergegrid      = {Mergegrid      , MergegridHelp     , MergegridOperators      , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Merstat        = {Merstat        , MerstatHelp       , MerstatOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Monarith       = {Monarith       , MonarithHelp      , MonarithOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Mrotuv         = {Mrotuv         , {}                , MrotuvOperators         , EXPOSED  , CDI_REAL , 1  , 2     , NoRestriction };
static const module_t module_Mrotuvb        = {Mrotuvb        , {}                , MrotuvbOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_NCL_wind       = {NCL_wind       , NCL_windHelp      , NCL_windOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Ninfo          = {Ninfo          , NinfoHelp         , NinfoOperators          , EXPOSED  , CDI_BOTH , 1  , 0     , NoRestriction };
static const module_t module_Nmldump        = {Nmldump        , {}                , NmldumpOperators        , INTERNAL , CDI_REAL , 0  , 0     , NoRestriction };
static const module_t module_Output         = {Output         , OutputHelp        , OutputOperators         , EXPOSED  , CDI_BOTH , -1 , 0     , NoRestriction };
static const module_t module_Outputtab      = {Output         , OutputtabHelp     , OutputtabOperators      , EXPOSED  , CDI_REAL , -1 , 0     , NoRestriction };
static const module_t module_Outputgmt      = {Outputgmt      , OutputgmtHelp     , OutputgmtOperators      , EXPOSED  , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_Pack           = {Pack           , PackHelp          , PackOperators           , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Pardup         = {Pardup         , {}                , PardupOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Pinfo          = {Pinfo          , {}                , PinfoOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Pressure       = {Pressure       , {}                , PressureOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Recttocomplex  = {Recttocomplex  , {}                , RecttocomplexOperators  , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Regres         = {Regres         , RegresHelp        , RegresOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remap          = {Remap          , RemapHelp         , RemapOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapbil       = {Remap          , RemapbilHelp      , RemapbilOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapbic       = {Remap          , RemapbicHelp      , RemapbicOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapnn        = {Remap          , RemapnnHelp       , RemapnnOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapdis       = {Remap          , RemapdisHelp      , RemapdisOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapcon       = {Remap          , RemapconHelp      , RemapconOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapycon2     = {Remap          , Remapcon2Help     , Remapycon2Operators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapscon      = {Remap          , {}                , RemapsconOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapcon2      = {Remap          , Remapcon2Help     , Remapcon2Operators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remaplaf       = {Remap          , RemaplafHelp      , RemaplafOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapavg       = {Remap          , {}                , RemapavgOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapweights   = {Remapweights   , {}                , RemapweightsOperators   , EXPOSED  , CDI_REAL , 0  , 0     , NoRestriction };
static const module_t module_Remapeta       = {Remapeta       , RemapetaHelp      , RemapetaOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Remapstat      = {Remapstat      , {}                , RemapstatOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Replace        = {Replace        , ReplaceHelp       , ReplaceOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Replacevalues  = {Replacevalues  , ReplacevaluesHelp , ReplacevaluesOperators  , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Rhopot         = {Rhopot         , RhopotHelp        , RhopotOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Rotuv          = {Rotuv          , RotuvbHelp        , RotuvOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Runpctl        = {Runpctl        , RunpctlHelp       , RunpctlOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Runstat        = {Runstat        , RunstatHelp       , RunstatOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Samplegridicon = {Samplegridicon , {}                , SamplegridiconOperators , EXPOSED  , CDI_REAL , 1  , 2     , OnlyFirst     };
static const module_t module_Seascount      = {Seascount      , {}                , SeascountOperators      , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Seaspctl       = {Seaspctl       , SeaspctlHelp      , SeaspctlOperators       , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Seasstat       = {Seasstat       , SeasstatHelp      , SeasstatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Selbox         = {Selbox         , SelboxHelp        , SelboxOperators         , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Selgridcell    = {Selgridcell    , SelgridcellHelp   , SelgridcellOperators    , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Select         = {Select         , SelectHelp        , SelectOperators         , EXPOSED  , CDI_BOTH , -1 , 1     , NoRestriction };
static const module_t module_Selvar         = {Selvar         , SelvarHelp        , SelvarOperators         , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Selrec         = {Selrec         , SelvarHelp        , SelrecOperators         , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Seloperator    = {Seloperator    , {}                , SeloperatorOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Seltime        = {Seltime        , SeltimeHelp       , SeltimeOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Selyearidx     = {Selyearidx     , SelyearidxHelp    , SelyearidxOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Set            = {Set            , SetHelp           , SetOperators            , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Setattribute   = {Setattribute   , SetattributeHelp  , SetattributeOperators   , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setbox         = {Setbox         , SetboxHelp        , SetboxOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setgatt        = {Setgatt        , {}                , SetgattOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Setgrid        = {Setgrid        , SetgridHelp       , SetgridOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Sethalo        = {Sethalo        , SethaloHelp       , SethaloOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setmiss        = {Setmiss        , SetmissHelp       , SetmissOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setmisstonn    = {Fillmiss       , SetmissHelp       , SetmisstonnOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setcodetab     = {Setpartab      , SetHelp           , SetcodetabOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setpartab      = {Setpartab      , SetpartabHelp     , SetpartabOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Setrcaname     = {Setrcaname     , {}                , SetrcanameOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Settime        = {Settime        , SettimeHelp       , SettimeOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Setzaxis       = {Setzaxis       , SetzaxisHelp      , SetzaxisOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Shiftxy        = {Shiftxy        , ShiftxyHelp       , ShiftxyOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Showinfo       = {Showinfo       , ShowinfoHelp      , ShowinfoOperators       , EXPOSED  , CDI_BOTH , 1  , 0     , NoRestriction };
static const module_t module_Showattribute  = {Showattribute  , ShowattributeHelp , ShowattributeOperators  , EXPOSED  , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_Sinfo          = {Sinfo          , SinfoHelp         , SinfoOperators          , EXPOSED  , CDI_BOTH , -1 , 0     , NoRestriction };
static const module_t module_Smooth         = {Smooth         , SmoothHelp        , SmoothOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Sort           = {Sort           , {}                , SortOperators           , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Sorttimestamp  = {Sorttimestamp  , {}                , SorttimestampOperators  , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
static const module_t module_Specinfo       = {Specinfo       , {}                , SpecinfoOperators       , EXPOSED  , CDI_REAL , 0  , 0     , NoRestriction };
static const module_t module_Spectral       = {Spectral       , SpectralHelp      , SpectralOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Specconv       = {Spectral       , SpecconvHelp      , SpecconvOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Spectrum       = {Spectrum       , {}                , SpectrumOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Split          = {Split          , SplitHelp         , SplitOperators          , EXPOSED  , CDI_BOTH , 1  , OBASE , NoRestriction };
static const module_t module_Splitrec       = {Splitrec       , SplitHelp         , SplitrecOperators       , EXPOSED  , CDI_BOTH , 1  , OBASE , NoRestriction };
static const module_t module_Splitsel       = {Splitsel       , SplitselHelp      , SplitselOperators       , EXPOSED  , CDI_BOTH , 1  , OBASE , OnlyFirst };
static const module_t module_Splittime      = {Splittime      , SplittimeHelp     , SplittimeOperators      , EXPOSED  , CDI_BOTH , 1  , OBASE , OnlyFirst };
static const module_t module_Splityear      = {Splityear      , SplittimeHelp     , SplityearOperators      , EXPOSED  , CDI_BOTH , 1  , OBASE , NoRestriction };
static const module_t module_Tee            = {Tee            , TeeHelp           , TeeOperators            , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Template1      = {Template1      , {}                , Template1Operators      , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Template2      = {Template2      , {}                , Template2Operators      , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Test           = {Test           , {}                , TestOperators           , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Test2          = {Test2          , {}                , Test2Operators          , INTERNAL , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Testdata       = {Testdata       , {}                , TestdataOperators       , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Tests          = {Tests          , {}                , TestsOperators          , INTERNAL , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Timcount       = {Timcount       , {}                , TimcountOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Yearcount      = {Timcount       , {}                , YearcountOperators      , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Moncount       = {Timcount       , {}                , MoncountOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Daycount       = {Timcount       , {}                , DaycountOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Hourcount      = {Timcount       , {}                , HourcountOperators      , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Timcumsum      = {Timcumsum      , TimcumsumHelp     , TimcumsumOperators      , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Timpctl        = {Timpctl        , TimpctlHelp       , TimpctlOperators        , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Yearpctl       = {Timpctl        , YearpctlHelp      , YearpctlOperators       , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Monpctl        = {Timpctl        , MonpctlHelp       , MonpctlOperators        , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Daypctl        = {Timpctl        , DaypctlHelp       , DaypctlOperators        , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Hourpctl       = {Timpctl        , HourpctlHelp      , HourpctlOperators       , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Timselpctl     = {Timselpctl     , TimselpctlHelp    , TimselpctlOperators     , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Timsort        = {Timsort        , TimsortHelp       , TimsortOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Timselstat     = {Timselstat     , TimselstatHelp    , TimselstatOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_XTimstat       = {XTimstat       , {}                , XTimstatOperators       , INTERNAL , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Timstat        = {Timstat        , TimstatHelp       , TimstatOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Yearstat       = {Timstat        , YearstatHelp      , YearstatOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Monstat        = {Timstat        , MonstatHelp       , MonstatOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Daystat        = {Timstat        , DaystatHelp       , DaystatOperators        , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Hourstat       = {Timstat        , HourstatHelp      , HourstatOperators       , EXPOSED  , CDI_BOTH , 1  , 1     , NoRestriction };
static const module_t module_Timcor         = {Timstat2       , TimcorHelp        , TimcorOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Timcorvar      = {Timstat2       , TimcovarHelp      , TimcovarOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Timrmsd        = {Timstat2       , {}                , TimrmsdOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Timstat3       = {Timstat3       , {}                , Timstat3Operators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Tinfo          = {Tinfo          , {}                , TinfoOperators          , EXPOSED  , CDI_BOTH , 1  , 0     , NoRestriction };
static const module_t module_Tocomplex      = {Tocomplex      , {}                , TocomplexOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Transpose      = {Transpose      , {}                , TransposeOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Trend          = {Trend          , TrendHelp         , TrendOperators          , EXPOSED  , CDI_REAL , 1  , 2     , OnlyFirst     };
static const module_t module_Trendarith     = {Trendarith     , TrendarithHelp    , TrendarithOperators     , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Tstepcount     = {Tstepcount     , {}                , TstepcountOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Unpack         = {Unpack         , {}                , UnpackOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vargen         = {Vargen         , VargenHelp        , VargenOperators         , EXPOSED  , CDI_REAL , 0  , 1     , NoRestriction };
static const module_t module_Varrms         = {Varrms         , {}                , VarrmsOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Varsstat       = {Varsstat       , VarsstatHelp      , VarsstatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertintap      = {Vertintap      , VertintapHelp     , VertintapOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertintgh      = {Vertintgh      , VertintghHelp     , VertintghOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertintml      = {Vertintml      , VertintmlHelp     , VertintmlOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertstat       = {Vertstat       , VertstatHelp      , VertstatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertcum        = {Vertcum        , {}                , VertcumOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Vertwind       = {Vertwind       , {}                , VertwindOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Verifygrid     = {Verifygrid     , VerifygridHelp    , VerifygridOperators     , EXPOSED  , CDI_REAL , 1  , 0     , NoRestriction };
static const module_t module_Wind           = {Wind           , WindHelp          , WindOperators           , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Wind2          = {Wind           , Wind2Help         , Wind2Operators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Writegrid      = {Writegrid      , {}                , WritegridOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction }; // no cdi output
static const module_t module_Writerandom    = {Writerandom    , {}                , WriterandomOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Yeararith      = {Yeararith      , YeararithHelp     , YeararithOperators      , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Yearmonstat    = {Yearmonstat    , YearmonstatHelp   , YearmonstatOperators    , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Ydayarith      = {Ydayarith      , YdayarithHelp     , YdayarithOperators      , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Ydaypctl       = {Ydaypctl       , YdaypctlHelp      , YdaypctlOperators       , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Ydaystat       = {Ydaystat       , YdaystatHelp      , YdaystatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Ydrunpctl      = {Ydrunpctl      , YdrunpctlHelp     , YdrunpctlOperators      , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Ydrunstat      = {Ydrunstat      , YdrunstatHelp     , YdrunstatOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Yhourarith     = {Yhourarith     , YhourarithHelp    , YhourarithOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Yhourstat      = {Yhourstat      , YhourstatHelp     , YhourstatOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Dhourstat      = {Yhourstat      , DhourstatHelp     , DhourstatOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Ymonarith      = {Ymonarith      , YmonarithHelp     , YmonarithOperators      , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Yseasarith     = {Ymonarith      , YseasarithHelp    , YseasarithOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Ymonpctl       = {Ymonpctl       , YmonpctlHelp      , YmonpctlOperators       , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Ymonstat       = {Ymonstat       , YmonstatHelp      , YmonstatOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Yseaspctl      = {Yseaspctl      , YseaspctlHelp     , YseaspctlOperators      , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Yseasstat      = {Yseasstat      , YseasstatHelp     , YseasstatOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Zonstat        = {Zonstat        , ZonstatHelp       , ZonstatOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaCfd         = {EcaCfd         , EcaCfdHelp        , EcaCfdOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaCsu         = {EcaCsu         , EcaCsuHelp        , EcaCsuOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaCwdi        = {EcaCwdi        , EcaCwdiHelp       , EcaCwdiOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaCwfi        = {EcaCwfi        , EcaCwfiHelp       , EcaCwfiOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaEtr         = {EcaEtr         , EcaEtrHelp        , EcaEtrOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaEtccdi      = {EcaEtccdi      , EcaEtccdiHelp     , EcaEtccdiOperators      , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_EcaFd          = {EcaFd          , EcaFdHelp         , EcaFdOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaGsl         = {EcaGsl         , EcaGslHelp        , EcaGslOperators         , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaHd          = {EcaHd          , EcaHdHelp         , EcaHdOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaHwdi        = {EcaHwdi        , EcaHwdiHelp       , EcaHwdiOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaHwfi        = {EcaHwfi        , EcaHwfiHelp       , EcaHwfiOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaId          = {EcaId          , EcaIdHelp         , EcaIdOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaSu          = {EcaSu          , EcaSuHelp         , EcaSuOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaTr          = {EcaTr          , EcaTrHelp         , EcaTrOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaTg10p       = {EcaTg10p       , EcaTg10pHelp      , EcaTg10pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaTg90p       = {EcaTg90p       , EcaTg90pHelp      , EcaTg90pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaTn10p       = {EcaTn10p       , EcaTn10pHelp      , EcaTn10pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaTn90p       = {EcaTn90p       , EcaTn90pHelp      , EcaTn90pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaTx10p       = {EcaTx10p       , EcaTx10pHelp      , EcaTx10pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaTx90p       = {EcaTx90p       , EcaTx90pHelp      , EcaTx90pOperators       , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaCdd         = {EcaCdd         , EcaCddHelp        , EcaCddOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaCwd         = {EcaCwd         , EcaCwdHelp        , EcaCwdOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaRr1         = {EcaRr1         , EcaRr1Help        , EcaRr1Operators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaPd          = {EcaPd          , EcaPdHelp         , EcaPdOperators          , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaR75p        = {EcaR75p        , EcaR75pHelp       , EcaR75pOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR75ptot     = {EcaR75ptot     , EcaR75ptotHelp    , EcaR75ptotOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR90p        = {EcaR90p        , EcaR90pHelp       , EcaR90pOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR90ptot     = {EcaR90ptot     , EcaR90ptotHelp    , EcaR90ptotOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR95p        = {EcaR95p        , EcaR95pHelp       , EcaR95pOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR95ptot     = {EcaR95ptot     , EcaR95ptotHelp    , EcaR95ptotOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR99p        = {EcaR99p        , EcaR99pHelp       , EcaR99pOperators        , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaR99ptot     = {EcaR99ptot     , EcaR99ptotHelp    , EcaR99ptotOperators     , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_EcaRx1day      = {EcaRx1day      , EcaRx1dayHelp     , EcaRx1dayOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaRx5day      = {EcaRx5day      , EcaRx5dayHelp     , EcaRx5dayOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_EcaSdii        = {EcaSdii        , EcaSdiiHelp       , EcaSdiiOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Fdns           = {Fdns           , FdnsHelp          , FdnsOperators           , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Strwin         = {Strwin         , StrwinHelp        , StrwinOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Strbre         = {Strbre         , StrbreHelp        , StrbreOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Strgal         = {Strgal         , StrgalHelp        , StrgalOperators         , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Hurr           = {Hurr           , HurrHelp          , HurrOperators           , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
//static const module_t module_Hi           = { Hi            , {}                , HiOperators             , EXPOSED  , CDI_REAL , 3  , 1     , NoRestriction };
static const module_t module_Wct            = {Wct            , WctHelp           , WctOperators            , EXPOSED  , CDI_REAL , 2  , 1     , NoRestriction };
static const module_t module_Magplot        = {Magplot        , MagplotHelp       , MagplotOperators        , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Magvector      = {Magvector      , MagvectorHelp     , MagvectorOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Maggraph       = {Maggraph       , MaggraphHelp      , MaggraphOperators       , EXPOSED  , CDI_REAL , -1 , 1     , NoRestriction };
// HIRLAM_EXTENSIONS
static const module_t module_Samplegrid     = {Samplegrid     , SamplegridHelp    , SamplegridOperators     , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_Selmulti       = {Selmulti       , SelmultiHelp      , SelmultiOperators       , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
static const module_t module_WindTrans      = {WindTrans      , WindTransHelp     , WindTransOperators      , EXPOSED  , CDI_REAL , 1  , 1     , NoRestriction };
// clang-format on

#endif
