import { jsx as _jsx } from "react/jsx-runtime";
/**
 * header-row.tsx
 *
 * Forked from reactabular-table version 8.14.0
 * https://github.com/reactabular/reactabular/tree/v8.14.0/packages/reactabular-table/src
 */
import { createElement } from 'react';
import { evaluateFormatters } from '../../../../components/Table/base/evaluate-formatters';
import { evaluateTransforms } from '../../../../components/Table/base/evaluate-transforms';
import { mergeProps } from '../../../../components/Table/base/merge-props';
import { HeaderCellInfoWrapper } from '../../../../components';
export const HeaderRow = ({ rowData, rowIndex, renderers, onRow = () => ({}) }) => createElement(renderers.row, onRow(rowData, { rowIndex }), rowData.map((column, columnIndex) => {
    const { property, header = {}, props = {} } = column;
    const evaluatedProperty = property || (header && header.property);
    const { label, transforms = [], formatters = [], info = {} } = header;
    const extraParameters = {
        columnIndex,
        property: evaluatedProperty,
        column
    };
    const transformedProps = evaluateTransforms(transforms, label, extraParameters);
    if (!transformedProps) {
        // tslint:disable-next-line:no-console
        console.warn('Table.Header - Failed to receive a transformed result'); // eslint-disable-line no-console
    }
    let cellNode;
    const { tooltip, tooltipProps, popover, popoverProps, ariaLabel, className } = info;
    // consumer can specify header cell tooltip/popover in two ways, but the transforms approach is preferred,
    // especially for sorting tables that use `transforms: [sortable]`
    // {
    //   title: 'Repositories',
    //   header: {
    //     info: {
    //       tooltip: 'More information about repositories',
    //       className: 'repositories-info-tip',
    //       tooltipProps: {
    //         isContentLeftAligned: true
    //       }
    //     }
    //   }
    // }
    //
    // {
    //   title: 'Repositories',
    //   transforms: [
    //     info({
    //       tooltip: 'More information about repositories',
    //       className: 'repositories-info-tip',
    //       tooltipProps: {
    //         isContentLeftAligned: true
    //       }
    //     }),
    //     sortable
    //   ]
    // },
    if (tooltip) {
        cellNode = (_jsx(HeaderCellInfoWrapper, { variant: "tooltip", info: tooltip, tooltipProps: tooltipProps, ariaLabel: ariaLabel, className: className, children: transformedProps.children || evaluateFormatters(formatters)(label, extraParameters) }));
    }
    else if (popover) {
        cellNode = (_jsx(HeaderCellInfoWrapper, { variant: "popover", info: popover, popoverProps: popoverProps, ariaLabel: ariaLabel, className: className, children: transformedProps.children || evaluateFormatters(formatters)(label, extraParameters) }));
    }
    else {
        cellNode = transformedProps.children || evaluateFormatters(formatters)(label, extraParameters);
    }
    return createElement(renderers.cell, Object.assign({ key: `${columnIndex}-header` }, mergeProps(props, header && header.props, transformedProps)), cellNode);
}));
HeaderRow.displayName = 'HeaderRow';
//# sourceMappingURL=header-row.js.map