<!---
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

Reporting New Security Problems with Apache Commons Components
--------------------------------------------------------------

The [Apache Software Foundation](https://www.apache.org) takes a very active stance in eliminating security problems and denial of service attacks against its products.

We strongly encourage folks to report such problems to our private security mailing list first, before disclosing them in a public forum.

Please note that the security mailing list should only be used for reporting undisclosed security vulnerabilities and managing the process of fixing such vulnerabilities. 
We cannot accept regular bug reports or other queries at this address. 
All mail sent to this address that does not relate to an undisclosed security problem in our source code will be ignored.

If you need to report a bug that isn't an undisclosed security vulnerability, please use the [bug reporting page](https://commons.apache.org/patches.html#Submitting_A_Patch).

The private security mailing address is: [security@commons.apache.org](mailto:security@commons.apache.org)

Asking Questions About Known Security Problems
----------------------------------------------

Questions about:

- if a vulnerability applies to your particular application
- obtaining further information on a published vulnerability
- availability of patches and/or new releases

should be addressed to the users mailing list. 

Please see the [mailing lists page](https://commons.apache.org/mail-lists.html) for details of how to subscribe.

Known Security Vulnerabilities
------------------------------

Known security vulnerabilities fixed in released versions of [Apache Commons](https://commons.apache.org) components are listed in specific pages for each component.

If you have encountered an unlisted security vulnerability or other unexpected behavior that has security impact, or if the descriptions in one of the pages are incomplete, please report them privately to the Apache Security Team. 

Errors and Omissions
--------------------

Please report any errors or omissions to the [dev mailing list](https://commons.apache.org/mail-lists.html).

Thank you,  
The Apache Commons Team
