# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Routes for the server application."""

from typing import TYPE_CHECKING, cast

from django.urls import path

from debusine.server import consumers

if TYPE_CHECKING:
    from channels.routing import _ExtendedURLPattern

    _ExtendedURLPattern  # fake usage for vulture

websocket_urlpatterns = [
    cast(
        "_ExtendedURLPattern",
        path(
            "api/ws/1.0/worker/connect/",
            # TODO: Is this a bug in django-stubs?  as_asgi returns a callable
            # returning None, not HTTPResponseBase.
            consumers.WorkerConsumer.as_asgi(),  # type: ignore[arg-type]
            name='ws-connect',
        ),
    ),
    cast(
        "_ExtendedURLPattern",
        path(
            "api/ws/1.0/work-request/on-completed/",
            # TODO: Is this a bug in django-stubs?  as_asgi returns a callable
            # returning None, not HTTPResponseBase.
            consumers.OnWorkRequestCompletedConsumer.as_asgi(),  # type: ignore[arg-type]  # noqa: E501
            name="ws-work-request-on-completed",
        ),
    ),
]
