"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeOtl = writeOtl;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_layout_1 = require("@ot-builder/ot-layout");
const var_store_1 = require("@ot-builder/var-store");
const variance_1 = require("@ot-builder/variance");
const base_1 = require("../base");
const gdef_1 = require("../gdef");
const gpos_1 = require("../gpos");
const gsub_1 = require("../gsub");
const math_1 = require("../math");
const stat_1 = require("../stat");
function writeOtl(
// out
outSink, 
// inOut
// in
otl, cfg, gOrd, md) {
    let { gsub, gpos, gdef } = otl;
    const designSpace = md.fvar ? md.fvar.getDesignSpace() : null;
    const ivs = md.fvar ? var_store_1.WriteTimeIVS.create(new variance_1.OtVar.MasterSet()) : null;
    const stat = md.os2 ? new stat_1.Os2MaxContextStat(md.os2) : new stat_1.EmptyStat();
    if (gsub || gpos) {
        if (ivs && !gdef)
            gdef = new ot_layout_1.Gdef.Table();
        const twc = { gOrd, gdef, designSpace, ivs, stat };
        if (gsub)
            outSink.add(ot_layout_1.Gsub.Tag, bin_util_1.Frag.packFrom(gsub_1.GsubTableIo, gsub, cfg, twc));
        if (gpos)
            outSink.add(ot_layout_1.Gpos.Tag, bin_util_1.Frag.packFrom(gpos_1.GposTableIo, gpos, cfg, twc));
    }
    if (gdef)
        outSink.add(ot_layout_1.Gdef.Tag, bin_util_1.Frag.packFrom(gdef_1.GdefTableIo, gdef, cfg, gOrd, ivs, designSpace));
    stat.settle();
    if (otl.base)
        outSink.add(ot_layout_1.Base.Tag, bin_util_1.Frag.packFrom(base_1.BaseTableIo, otl.base, gOrd, designSpace));
    if (otl.math)
        outSink.add(ot_layout_1.Math.Tag, bin_util_1.Frag.packFrom(math_1.MathTableIo, otl.math, gOrd));
}
//# sourceMappingURL=write.js.map