"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTtcSlices = createTtcSlices;
const ot_builder_1 = require("ot-builder");
const sparse_glyf_data_processor_1 = require("./sparse-glyf-data-processor");
const sparse_gvar_data_processor_1 = require("./sparse-gvar-data-processor");
function createTtcSlices(input, sharing) {
    const fonts = [];
    for (const file of input)
        fonts.push(convertSfntToCustom(ot_builder_1.FontIo.readSfntOtf(file)));
    if (sharing) {
        (0, sparse_glyf_data_processor_1.sparseShareGlyfData)(fonts, sharing);
        (0, sparse_gvar_data_processor_1.sparseShareGvarData)(fonts, sharing);
    }
    return fonts;
}
function convertSfntToCustom(sfnt) {
    const ds = { version: sfnt.version, tables: new Map() };
    for (const [tag, table] of sfnt.tables)
        ds.tables.set(tag, { data: table, start: 0, length: table.byteLength });
    return ds;
}
//# sourceMappingURL=create-ttc.js.map