# Підручник #

Повна документація методів: [`fpdf.FPDF` – документація API](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF)

## Туторіал 1 — Мінімальний приклад ##

Почнемо з класичного прикладу:

```python
{% include "../tutorial/tuto1.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto1.pdf)

Після підключення бібліотеки ми створюємо об’єкт `FPDF`. 
Конструктор [FPDF](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF) тут використовується зі значеннями за замовчуванням: 
сторінки формату A4, орієнтація — книжкова (portrait), одиниця виміру — міліметри.
Це можна було б задати явно так:

```python
pdf = FPDF(orientation="P", unit="mm", format="A4")
```

Можна встановити альбомну орієнтацію сторінки (`L`) або використати інші формати сторінок
(наприклад, `Letter` і `Legal`) та одиниці виміру (`pt`, `cm`, `in`).

Поки що сторінок немає, тож треба додати одну за допомогою 
[add_page](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_page). Початок координат — у верхньому лівому куті,
поточна позиція за замовчуванням розміщена на відстані 1 см від країв; поля можна змінити за допомогою 
[set_margins](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_margins).

Перш ніж друкувати текст, обов’язково потрібно обрати шрифт за допомогою 
[set_font](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font), інакше документ буде некоректним.
Обираємо Helvetica напівжирний розміру 16:

```python
pdf.set_font('Helvetica', style='B', size=16)
```

Можна було б вказати курсив через `I`, підкреслення — через `U`, або звичайний шрифт
— порожнім рядком (або будь-якою комбінацією). Зверніть увагу, що розмір шрифту задається в
пунктах, а не в міліметрах (чи інших одиницях користувача); це єдиний виняток.
Інші вбудовані шрифти: `Times`, `Courier`, `Symbol` та `ZapfDingbats`.

Тепер можемо вивести «комірку» за допомогою [cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.cell). Комірка — це прямокутна
область, за потреби з рамкою, що містить текст. Вона рендериться у поточній
позиції. Ми задаємо її розміри, текст (вирівняний по центру або інакше), чи потрібно
малювати рамку, а також куди має зміститися поточна позиція після виведення (праворуч,
вниз або на початок наступного рядка). Щоб додати рамку, зробимо так:

```python
pdf.cell(40, 10, 'Hello World!', 1)
```

Щоб додати поруч нову комірку з текстом, вирівняним по центру, і перейти на новий рядок, зробимо так:

```python
pdf.cell(60, 10, 'Powered by FPDF.', new_x="LMARGIN", new_y="NEXT", align='C')
```

**Примітка**: розрив рядка також можна зробити методом [ln](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.ln). Цей
метод додатково дозволяє вказати висоту розриву.

Нарешті, документ закривається й зберігається за вказаним шляхом файлу за допомогою
[output](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.output). Якщо параметри не передано, `output()`
повертає PDF як буфер `bytearray`.

## Туторіал 2 — Колонтитули, розрив сторінки та зображення ##

Ось приклад на дві сторінки з верхнім/нижнім колонтитулами та логотипом:

```python
{% include "../tutorial/tuto2.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto2.pdf)

У цьому прикладі використовуються методи [header](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.header) і 
[footer](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.footer) для обробки колонтитулів. Вони
викликаються автоматично. Ці методи вже є в класі FPDF, але нічого не роблять,
тому ми розширюємо клас і перевизначаємо їх.

Логотип виводиться методом [image](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image) із зазначенням
його координат верхнього лівого кута та ширини. Висота обчислюється автоматично, щоб
зберегти пропорції зображення.

Щоб вивести номер сторінки, ширину комірки задаємо нульовою. Це означає,
що комірка розширюється до правого поля сторінки; це зручно для
центрування тексту. Поточний номер сторінки повертає
метод [page_no](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.page_no); а загальну кількість сторінок отримують за допомогою спеціального значення `{nb}`,
яке буде підставлене під час закриття документа (це значення можна змінити методом 
[alias_nb_pages()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.alias_nb_pages)).
Зверніть увагу на використання методу [set_y](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_y), який дозволяє встановити
позицію в абсолютному місці на сторінці — від верху або віднизу.

Тут також використано цікаву можливість: автоматичні розриви сторінки. Щойно
комірка переходить через межу сторінки (стандартно за 2 сантиметри від низу),
виконується розрив, а шрифт відновлюється. Хоча в колонтитулах обрано власний шрифт (`helvetica`),
основний текст продовжується зі шрифтом `Times`.
Цей механізм автоматичного відновлення також стосується кольорів і товщини ліній.
Межу, що ініціює розриви сторінок, задають методом 
[set_auto_page_break](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_auto_page_break).


## Туторіал 3 — Розриви рядків і кольори ##

Продовжимо прикладом, що друкує вирівняні по ширині абзаци. Він також
демонструє роботу з кольорами.

```python
{% include "../tutorial/tuto3.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto3.pdf)

[Текст Жюля Верна](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

Метод [get_string_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.get_string_width) дозволяє визначити
довжину рядка в поточному шрифті — тут це використовується, щоб розрахувати
позицію й ширину рамки навколо заголовка. Далі встановлюємо кольори
(через [set_draw_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_draw_color),
[set_fill_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_fill_color) і 
[set_text_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_text_color)) та товщину лінії 1 мм
(проти 0,2 за замовчуванням) за допомогою
[set_line_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_line_width). Нарешті, виводимо комірку
(останній параметр, встановлений у `True`, означає, що тло треба зафарбувати).

Для друку абзаців використовується метод [multi_cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell). Текст за замовчуванням вирівнюється по ширині.
Кожного разу, коли рядок сягає правої межі комірки або зустрічається символ переведення рядка (`\n`),
виконується розрив рядка, і автоматично створюється нова комірка під поточною.
Автоматичний розрив відбувається в позиції найближчого пробілу або «м’якого переносу» (`\u00ad`) перед правою межею.
Під час переносу рядка «м’який перенос» буде замінено на звичайний дефіс; інакше він ігнорується.

Задаються дві властивості документа: заголовок 
([set_title](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_title)) та автор 
([set_author](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_author)). Переглянути властивості можна двома способами.
Перший — відкрити документ у Acrobat Reader, перейти в меню File
і обрати Document Properties. Другий — доступний також із плагіна: натиснути правою кнопкою та вибрати Document Properties.

## Туторіал 4 — Декілька колонок ##

Цей приклад — варіант попереднього, демонструє, як розмістити текст у кількох колонках.

```python
{% include "../tutorial/tuto4.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto4.pdf)

[Текст Жюля Верна](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

Ключова відмінність від попереднього туторіалу — використання методу 
[`text_columns`](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.text_column). 
Він збирає весь текст (можливо, по частинах) і розподіляє його на вказану кількість колонок, автоматично вставляючи розриви сторінок за потреби. Зверніть увагу: доки екземпляр `TextColumns` активний як контекстний менеджер, стилі тексту та інші властивості шрифтів можна змінювати — ці зміни будуть обмежені цим контекстом. Після його закриття попередні параметри буде відновлено.


## Туторіал 5 — Створення таблиць ##

У цьому туторіалі пояснюється, як створити дві різні таблиці,
щоб продемонструвати, чого можна досягти простими налаштуваннями.

```python
{% include "../tutorial/tuto5.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto5.pdf) —
[CSV-дані про країни](https://github.com/py-pdf/fpdf2/raw/master/tutorial/countries.txt)

Перший приклад реалізовано максимально простим способом — передаючи дані в [`FPDF.table()`](https://py-pdf.github.io/fpdf2/Tables.html). Результат елементарний, але отримується дуже швидко.

Друга таблиця містить покращення: кольори, обмежену ширину таблиці, зменшену висоту рядків,
вирівнювання заголовків по центру, колонки з користувацькими ширинами, вирівнювання чисел праворуч...
Крім того, горизонтальні лінії прибрано.
Цього досягнуто вибором значення `borders_layout` з-поміж доступних у
[`TableBordersLayout`](https://py-pdf.github.io/fpdf2/fpdf/enums.html#fpdf.enums.TableBordersLayout).

## Туторіал 6 — Створення посилань і змішування стилів тексту ##

У цьому туторіалі показано кілька способів вставки посилань у PDF-документ,
а також додавання посилань на зовнішні ресурси.

Також буде показано кілька способів використання різних стилів тексту
(напівжирний, курсив, підкреслений) в одному фрагменті.

```python
{% include "../tutorial/tuto6.py" %}
```

[Отриманий PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto6.pdf) —
[fpdf2-logo](https://py-pdf.github.io/fpdf2/fpdf2-logo.png)

Новий метод, що використовується тут для виведення тексту, —
[write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write).
Він дуже схожий на
[multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell),
але з такими ключовими відмінностями:

- Кінець рядка — на правому полі, а наступний рядок починається від лівого
поля.
- Поточна позиція зміщується в кінець виведеного тексту.

Тож метод дозволяє написати фрагмент тексту, змінити стиль шрифту
і продовжити з того самого місця.
З іншого боку, головний недолік полягає в тому, що не можна вирівняти текст по ширині,
як це робить метод
[multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell).

На першій сторінці прикладу ми використали
[write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)
саме з цією метою. Початок речення надруковано звичайним стилем,
потім за допомогою
[set_font()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font)
перемкнулися на підкреслення і завершили речення.

Щоб додати внутрішнє посилання на другу сторінку, ми використали
метод [add_link()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_link),
який створює клікабельну область (ми назвали її «link»), що веде
на іншу сторінку документа.

Щоб створити зовнішнє посилання за допомогою зображення, ми використали
[image()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image).
Цей метод має
параметр для передавання посилання. Посилання може бути як внутрішнім,
так і зовнішнім.

Як альтернативу, для зміни стилю шрифту та додавання посилань можна
використати метод `write_html()`. Це HTML-розбірник, що дозволяє додавати текст,
змінювати стиль шрифту та додавати посилання за допомогою HTML.

## Туторіал 7 — Створення документів PDF/A ##

_Нове у [:octicons-tag-24: 2.8.3](https://github.com/py-pdf/fpdf2/blob/master/CHANGELOG.md)_

### Стандарти PDF/A ###

<b>PDF/A-1</b> використовує PDF-версію 1.4. Усі ресурси (зображення, графіка, шрифти) мають бути вбудовані в документ. Керування кольорами має бути точним і платформонезалежним, із зазначенням профілів ICC, а метадані документа мають бути надані у вигляді XMP-метаданих.

<b>PDF/A-2</b> використовує PDF-версію 1.7. Дозволяє стиснення JPEG2000, прозорі елементи, шрифти OpenType та цифрові підписи.

Єдине розширення для <b>PDF/A-3</b> — можливість вбудовувати будь-які файли.

### Класи відповідності ###

Рівень A (accessible, «доступний») охоплює всі вимоги стандарту, зокрема
відображення структурованого змісту та правильний порядок читання вмісту документа. Текст має бути витягуваним, а структура — відображати природну послідовність читання.

Рівень B (Basic, «базовий») гарантує чітке візуальне відтворення вмісту. Рівень B зазвичай легше згенерувати, ніж рівень A, але він не забезпечує 100-відсоткового вилучення тексту чи можливості пошуку. Безпроблемне повторне використання вмісту не обов’язково гарантоване.

Щоб цього досягти, ось невеликий приклад:

```python
{% include "../tutorial/tuto7.py" %}
```

[Отриманий PDF: tuto7.pdf](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto7.pdf)

Такі інструменти, як [VeraPDF](https://verapdf.org/), можуть перевірити відповідність створених PDF-документів:

    verapdf --format text -v tutorial/tuto7.pdf

Результат:

    PASS fpdf2/tutorial/tuto7.pdf 3b
