//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotsecurity

import "time"

// DefenderSettingsClientCreateOrUpdateOptions contains the optional parameters for the DefenderSettingsClient.CreateOrUpdate
// method.
type DefenderSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsClientDeleteOptions contains the optional parameters for the DefenderSettingsClient.Delete method.
type DefenderSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsClientDownloadManagerActivationOptions contains the optional parameters for the DefenderSettingsClient.DownloadManagerActivation
// method.
type DefenderSettingsClientDownloadManagerActivationOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsClientGetOptions contains the optional parameters for the DefenderSettingsClient.Get method.
type DefenderSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsClientListOptions contains the optional parameters for the DefenderSettingsClient.List method.
type DefenderSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsClientPackageDownloadsOptions contains the optional parameters for the DefenderSettingsClient.PackageDownloads
// method.
type DefenderSettingsClientPackageDownloadsOptions struct {
	// placeholder for future optional parameters
}

// DefenderSettingsList - List of IoT Defender settings
type DefenderSettingsList struct {
	// READ-ONLY; List data
	Value []*DefenderSettingsModel `json:"value,omitempty" azure:"ro"`
}

// DefenderSettingsModel - IoT Defender settings
type DefenderSettingsModel struct {
	// IoT Defender settings properties
	Properties *DefenderSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DefenderSettingsProperties - IoT Defender settings properties
type DefenderSettingsProperties struct {
	// REQUIRED; Size of the device quota. Value is required to be in multiples of 100.
	DeviceQuota *int32 `json:"deviceQuota,omitempty"`

	// REQUIRED; MDE integration configuration
	MdeIntegration *DefenderSettingsPropertiesMdeIntegration `json:"mdeIntegration,omitempty"`

	// REQUIRED; The kind of onboarding for the subscription
	OnboardingKind *OnboardingKind `json:"onboardingKind,omitempty"`

	// REQUIRED; Sentinel Workspace Resource Ids
	SentinelWorkspaceResourceIDs []*string `json:"sentinelWorkspaceResourceIds,omitempty"`

	// READ-ONLY; End time of the evaluation period, if such exist
	EvaluationEndTime *time.Time `json:"evaluationEndTime,omitempty" azure:"ro"`
}

// DefenderSettingsPropertiesMdeIntegration - MDE integration configuration
type DefenderSettingsPropertiesMdeIntegration struct {
	// REQUIRED; Integration status
	Status *MdeIntegration `json:"status,omitempty"`
}

// DeviceGroupList - List of device groups
type DeviceGroupList struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List data
	Value []*DeviceGroupModel `json:"value,omitempty" azure:"ro"`
}

// DeviceGroupModel - Device group
type DeviceGroupModel struct {
	// Device group properties
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceGroupsClientCreateOrUpdateOptions contains the optional parameters for the DeviceGroupsClient.CreateOrUpdate method.
type DeviceGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DeviceGroupsClientDeleteOptions contains the optional parameters for the DeviceGroupsClient.Delete method.
type DeviceGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DeviceGroupsClientGetOptions contains the optional parameters for the DeviceGroupsClient.Get method.
type DeviceGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeviceGroupsClientListOptions contains the optional parameters for the DeviceGroupsClient.List method.
type DeviceGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// DeviceList - List of devices
type DeviceList struct {
	// READ-ONLY; When there are too many devices for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List data
	Value []*DeviceModel `json:"value,omitempty" azure:"ro"`
}

// DeviceModel - Device
type DeviceModel struct {
	// Device properties
	Properties *DeviceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceProperties - Device properties
type DeviceProperties struct {
	// A bag of fields which extends the device information.
	AdditionalFields interface{} `json:"additionalFields,omitempty"`

	// Authorized state of the device.
	AuthorizedState *AuthorizedState `json:"authorizedState,omitempty"`

	// Device business function
	BusinessFunction *string `json:"businessFunction,omitempty"`

	// Device criticality.
	Criticality *Criticality `json:"criticality,omitempty"`

	// Device category id
	DeviceCategoryID *int32 `json:"deviceCategoryId,omitempty"`

	// Device name
	DeviceName *string `json:"deviceName,omitempty"`

	// Device sub type id
	DeviceSubTypeID *int32 `json:"deviceSubTypeId,omitempty"`

	// Device tags
	DeviceTags []*string `json:"deviceTags,omitempty"`

	// Device type id
	DeviceTypeID *int32 `json:"deviceTypeId,omitempty"`

	// List of device firmwares.
	Firmwares []*Firmware `json:"firmwares,omitempty"`

	// Device hardware data
	Hardware *Hardware `json:"hardware,omitempty"`

	// Device operating system data
	OperatingSystem *OperatingSystem `json:"operatingSystem,omitempty"`

	// List of device packages
	Packages []*Package `json:"packages,omitempty"`

	// Purdue level of the device.
	PurdueLevel *PurdueLevel `json:"purdueLevel,omitempty"`

	// READ-ONLY; List of Common Platform Enumeration (CPE)
	Cpes []*string `json:"cpes,omitempty" azure:"ro"`

	// READ-ONLY; Device category display name
	DeviceCategoryDisplayName *string `json:"deviceCategoryDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Device data source.
	DeviceDataSource *DeviceDataSource `json:"deviceDataSource,omitempty" azure:"ro"`

	// READ-ONLY; Device status.
	DeviceStatus *DeviceStatus `json:"deviceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Device sub type display name
	DeviceSubTypeDisplayName *string `json:"deviceSubTypeDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Device type display name
	DeviceTypeDisplayName *string `json:"deviceTypeDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; First time the device was seen.
	FirstSeen *time.Time `json:"firstSeen,omitempty" azure:"ro"`

	// READ-ONLY; last time the device was programming or programed.
	LastProgrammingTime *time.Time `json:"lastProgrammingTime,omitempty" azure:"ro"`

	// READ-ONLY; Last time the device was seen.
	LastSeen *time.Time `json:"lastSeen,omitempty" azure:"ro"`

	// READ-ONLY; Last time the device was updated by the profiler.
	LastUpdated *time.Time `json:"lastUpdated,omitempty" azure:"ro"`

	// READ-ONLY; List of merged devices data
	MergedDevices []*MergedDevice `json:"mergedDevices,omitempty" azure:"ro"`

	// READ-ONLY; The device Id that this device was merged into
	MergedToDeviceID *string `json:"mergedToDeviceId,omitempty" azure:"ro"`

	// READ-ONLY; List of the device network interface cards.
	Nics []*Nic `json:"nics,omitempty" azure:"ro"`

	// READ-ONLY; Device onboarding status.
	OnboardingStatus *OnboardingStatus `json:"onboardingStatus,omitempty" azure:"ro"`

	// READ-ONLY; For nested device, this is the parent device id.
	ParentDeviceID *string `json:"parentDeviceId,omitempty" azure:"ro"`

	// READ-ONLY; For nested device, this is the rack number in the parent device that holds the nested device.
	ParentRackNumber *int32 `json:"parentRackNumber,omitempty" azure:"ro"`

	// READ-ONLY; For nested device, this is the slot number in the parent device that holds the nested device.
	ParentSlotNumber *int32 `json:"parentSlotNumber,omitempty" azure:"ro"`

	// READ-ONLY; Confidence of the device profile
	ProfilingConfidence *int32 `json:"profilingConfidence,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether this device is programming
	ProgrammingState *ProgrammingState `json:"programmingState,omitempty" azure:"ro"`

	// READ-ONLY; risk score of the device.
	RiskScore *int32 `json:"riskScore,omitempty" azure:"ro"`

	// READ-ONLY; Version of the device model schema
	SchemaVersion *string `json:"schemaVersion,omitempty" azure:"ro"`

	// READ-ONLY; Sensor that scanned this device.
	Sensor *Sensor `json:"sensor,omitempty" azure:"ro"`

	// READ-ONLY; List of the device slot in the backplane
	Slots []*Slot `json:"slots,omitempty" azure:"ro"`
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListOptions contains the optional parameters for the DevicesClient.List method.
type DevicesClientListOptions struct {
	// Skip token used for pagination
	SkipToken *string
}

// DimensionProperties - properties for dimension
type DimensionProperties struct {
	// localized display name of the dimension to customer
	DisplayName *string `json:"displayName,omitempty"`

	// dimension name
	Name *string `json:"name,omitempty"`

	// flag indicating whether this dimension should be included to the customer in Azure Monitor logs (aka Shoebox)
	ToBeExportedForCustomer *bool `json:"toBeExportedForCustomer,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorModel - Default error model
type ErrorModel struct {
	// READ-ONLY; Gets or sets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the details.
	Details []*ErrorModel `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the messages.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ErrorResponseModel - Default error response model
type ErrorResponseModel struct {
	// READ-ONLY; Gets or sets the error.
	Error *ErrorResponseModelError `json:"error,omitempty" azure:"ro"`
}

// ErrorResponseModelError - Gets or sets the error.
type ErrorResponseModelError struct {
	// READ-ONLY; Gets or sets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the details.
	Details []*ErrorModel `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the messages.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// Firmware - Device firmware data
type Firmware struct {
	// A bag of fields which extends the firmware information.
	AdditionalFields interface{} `json:"additionalFields,omitempty"`

	// Firmware module address.
	ModuleAddress *string `json:"moduleAddress,omitempty"`

	// Firmware name.
	Name *string `json:"name,omitempty"`

	// Firmware serial.
	Serial *string `json:"serial,omitempty"`

	// Firmware vendor.
	Vendor *string `json:"vendor,omitempty"`

	// Firmware version.
	Version *string `json:"version,omitempty"`
}

// Hardware - Device hardware data
type Hardware struct {
	// Hardware model.
	Model *string `json:"model,omitempty"`

	// Hardware serial number.
	SerialNumber *string `json:"serialNumber,omitempty"`

	// Hardware vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// LocationList - List of Defender for IoT locations
type LocationList struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List data
	Value []*LocationModel `json:"value,omitempty" azure:"ro"`
}

// LocationModel - IoT Defender location
type LocationModel struct {
	// IoT Defender location properties
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocationsClientGetOptions contains the optional parameters for the LocationsClient.Get method.
type LocationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListOptions contains the optional parameters for the LocationsClient.List method.
type LocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// MergedDevice - Merged device data
type MergedDevice struct {
	// READ-ONLY; Device data source
	DeviceDataSource *DeviceDataSource `json:"deviceDataSource,omitempty" azure:"ro"`

	// READ-ONLY; device id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Device sensor data
	Sensor *Sensor `json:"sensor,omitempty" azure:"ro"`
}

// Nic - Network interface card properties
type Nic struct {
	// READ-ONLY; Ipv4 address
	IPv4Address *string `json:"ipv4Address,omitempty" azure:"ro"`

	// READ-ONLY; Ipv6 address
	IPv6Address *string `json:"ipv6Address,omitempty" azure:"ro"`

	// READ-ONLY; Last seen time
	LastSeen *time.Time `json:"lastSeen,omitempty" azure:"ro"`

	// READ-ONLY; Mac address
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the association of the mac to the ip address is certain or a guess.
	MacCertainty *MacCertainty `json:"macCertainty,omitempty" azure:"ro"`

	// READ-ONLY; Network adapter vendor.
	NetworkAdapterVendor *string `json:"networkAdapterVendor,omitempty" azure:"ro"`

	// READ-ONLY; List of virtual LAN (vlan)
	Vlans []*string `json:"vlans,omitempty" azure:"ro"`
}

// OnPremiseSensor - On-premise IoT sensor
type OnPremiseSensor struct {
	// On-premise IoT sensor properties
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OnPremiseSensorsClientCreateOrUpdateOptions contains the optional parameters for the OnPremiseSensorsClient.CreateOrUpdate
// method.
type OnPremiseSensorsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsClientDeleteOptions contains the optional parameters for the OnPremiseSensorsClient.Delete method.
type OnPremiseSensorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsClientDownloadActivationOptions contains the optional parameters for the OnPremiseSensorsClient.DownloadActivation
// method.
type OnPremiseSensorsClientDownloadActivationOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsClientDownloadResetPasswordOptions contains the optional parameters for the OnPremiseSensorsClient.DownloadResetPassword
// method.
type OnPremiseSensorsClientDownloadResetPasswordOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsClientGetOptions contains the optional parameters for the OnPremiseSensorsClient.Get method.
type OnPremiseSensorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsClientListOptions contains the optional parameters for the OnPremiseSensorsClient.List method.
type OnPremiseSensorsClientListOptions struct {
	// placeholder for future optional parameters
}

// OnPremiseSensorsList - List of on-premise IoT sensors
type OnPremiseSensorsList struct {
	// READ-ONLY; List data
	Value []*OnPremiseSensor `json:"value,omitempty" azure:"ro"`
}

// OperatingSystem - Device operating system data
type OperatingSystem struct {
	// OS architecture
	Architecture *string `json:"architecture,omitempty"`

	// OS build
	Build *string `json:"build,omitempty"`

	// OS distribution
	Distribution *string `json:"distribution,omitempty"`

	// OS platform
	Platform *string `json:"platform,omitempty"`

	// OS version
	Version *string `json:"version,omitempty"`
}

// Operation resource
type Operation struct {
	// Properties on the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Whether operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name for display purposes
	Name *string `json:"name,omitempty"`

	// origin of the operation
	Origin *string `json:"origin,omitempty"`

	// properties for the operation meta info
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - The response model for get operation properties
type OperationDisplay struct {
	// Description of the operation for display purposes
	Description *string `json:"description,omitempty"`

	// Name of the operation for display purposes
	Operation *string `json:"operation,omitempty"`

	// Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`

	// Name of the resource type for display purposes
	Resource *string `json:"resource,omitempty"`
}

// OperationList - Paged list of operation resources
type OperationList struct {
	// REQUIRED; Collection of items of type results.
	Value []*Operation `json:"value,omitempty"`

	// Total item count.
	Count *int64 `json:"count,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationMetaLogSpecification - log specifications for operation api
type OperationMetaLogSpecification struct {
	// blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// localized name of the log category
	DisplayName *string `json:"displayName,omitempty"`

	// name of the log category
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricSpecification - metric specifications for the operation
type OperationMetaMetricSpecification struct {
	// aggregation type of metric
	AggregationType *string `json:"aggregationType,omitempty"`

	// properties for dimension
	Dimensions []*DimensionProperties `json:"dimensions,omitempty"`

	// description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// localized name of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// enable regional mdm account
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`

	// internal metric name
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// name of the metric
	Name *string `json:"name,omitempty"`

	// dimension name use to replace resource id if specified
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Metric namespace. Only set the namespace if different from the default value, leaving it empty makes it use the value from
	// the ARM manifest.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// supported aggregation types
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// supported time grain types
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// units for the metric
	Unit *string `json:"unit,omitempty"`
}

// OperationMetaServiceSpecification - The operation meta service specification
type OperationMetaServiceSpecification struct {
	// log specifications for the operation
	LogSpecifications []*OperationMetaLogSpecification `json:"logSpecifications,omitempty"`

	// metric specifications for the operation
	MetricSpecifications []*OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationProperties - properties on meta info
type OperationProperties struct {
	// meta service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Package - Device package data
type Package struct {
	// Package name.
	Name *string `json:"name,omitempty"`

	// Package version.
	Version *string `json:"version,omitempty"`
}

// PackageDownloadInfo - Information on a specific package download
type PackageDownloadInfo struct {
	// READ-ONLY; Download link
	Link *string `json:"link,omitempty" azure:"ro"`

	// READ-ONLY; Version number
	Version *string `json:"version,omitempty" azure:"ro"`

	// READ-ONLY; Kind of the version
	VersionKind *VersionKind `json:"versionKind,omitempty" azure:"ro"`
}

// PackageDownloads - Information about package downloads
type PackageDownloads struct {
	// READ-ONLY; Authorized devices import template
	AuthorizedDevicesImportTemplate []*PackageDownloadInfo `json:"authorizedDevicesImportTemplate,omitempty" azure:"ro"`

	// READ-ONLY; All downloads for Central Manager
	CentralManager *PackageDownloadsCentralManager `json:"centralManager,omitempty" azure:"ro"`

	// READ-ONLY; Authorized devices import template
	DeviceInformationUpdateImportTemplate []*PackageDownloadInfo `json:"deviceInformationUpdateImportTemplate,omitempty" azure:"ro"`

	// READ-ONLY; Contains all Sensor binary downloads
	Sensor *PackageDownloadsSensor `json:"sensor,omitempty" azure:"ro"`

	// READ-ONLY; SNMP Server file
	Snmp []*PackageDownloadInfo `json:"snmp,omitempty" azure:"ro"`

	// READ-ONLY; All downloads for threat intelligence
	ThreatIntelligence []*PackageDownloadInfo `json:"threatIntelligence,omitempty" azure:"ro"`

	// READ-ONLY; Used for local configuration export
	WmiTool []*PackageDownloadInfo `json:"wmiTool,omitempty" azure:"ro"`
}

// PackageDownloadsCentralManager - All downloads for Central Manager
type PackageDownloadsCentralManager struct {
	// READ-ONLY; Contains full package downloads
	Full *PackageDownloadsCentralManagerFull `json:"full,omitempty" azure:"ro"`

	// READ-ONLY; Central Manager upgrade package downloads (on existing installations)
	Upgrade []*UpgradePackageDownloadInfo `json:"upgrade,omitempty" azure:"ro"`
}

// PackageDownloadsCentralManagerFull - Contains full package downloads
type PackageDownloadsCentralManagerFull struct {
	// READ-ONLY; Contains all ISO full versions of the Central Manager
	Iso []*PackageDownloadInfo `json:"iso,omitempty" azure:"ro"`

	// READ-ONLY; Contains all OVF (virtual machine) full versions of the Central Manager
	Ovf *PackageDownloadsCentralManagerFullOvf `json:"ovf,omitempty" azure:"ro"`
}

// PackageDownloadsCentralManagerFullOvf - Contains all OVF (virtual machine) full versions of the Central Manager
type PackageDownloadsCentralManagerFullOvf struct {
	// READ-ONLY; The Enterprise package type
	Enterprise []*PackageDownloadInfo `json:"enterprise,omitempty" azure:"ro"`

	// READ-ONLY; The EnterpriseHighAvailability package type
	EnterpriseHighAvailability []*PackageDownloadInfo `json:"enterpriseHighAvailability,omitempty" azure:"ro"`

	// READ-ONLY; The Medium package type
	Medium []*PackageDownloadInfo `json:"medium,omitempty" azure:"ro"`

	// READ-ONLY; The MediumHighAvailability package type
	MediumHighAvailability []*PackageDownloadInfo `json:"mediumHighAvailability,omitempty" azure:"ro"`
}

// PackageDownloadsSensor - Contains all Sensor binary downloads
type PackageDownloadsSensor struct {
	// Sensor upgrade package downloads (on existing installations)
	Upgrade []*UpgradePackageDownloadInfo `json:"upgrade,omitempty"`

	// READ-ONLY; Contains full package downloads
	Full *PackageDownloadsSensorFull `json:"full,omitempty" azure:"ro"`
}

// PackageDownloadsSensorFull - Contains full package downloads
type PackageDownloadsSensorFull struct {
	// Contains all OVF (virtual machine) full versions for the sensor
	Ovf *PackageDownloadsSensorFullOvf `json:"ovf,omitempty"`

	// READ-ONLY; Contains all ISO full versions for the sensor
	Iso []*PackageDownloadInfo `json:"iso,omitempty" azure:"ro"`
}

// PackageDownloadsSensorFullOvf - Contains all OVF (virtual machine) full versions for the sensor
type PackageDownloadsSensorFullOvf struct {
	// READ-ONLY; Enterprise package type
	Enterprise []*PackageDownloadInfo `json:"enterprise,omitempty" azure:"ro"`

	// READ-ONLY; Line package type
	Line []*PackageDownloadInfo `json:"line,omitempty" azure:"ro"`

	// READ-ONLY; Medium package type
	Medium []*PackageDownloadInfo `json:"medium,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResetPasswordInput - Reset password input.
type ResetPasswordInput struct {
	// The appliance id of the sensor.
	ApplianceID *string `json:"applianceId,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Sensor that scanned the device
type Sensor struct {
	// READ-ONLY; Sensor name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Sensor site.
	Site *string `json:"site,omitempty" azure:"ro"`

	// READ-ONLY; Sensor type.
	Type *SensorType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Sensor zone.
	Zone *string `json:"zone,omitempty" azure:"ro"`
}

// SensorModel - IoT sensor model
type SensorModel struct {
	// IoT sensor properties
	Properties *SensorProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SensorProperties - IoT sensor properties
type SensorProperties struct {
	// Type of sensor
	SensorType *SensorType `json:"sensorType,omitempty"`

	// TI Automatic mode status of the IoT sensor
	TiAutomaticUpdates *bool `json:"tiAutomaticUpdates,omitempty"`

	// Zone of the IoT sensor
	Zone *string `json:"zone,omitempty"`

	// READ-ONLY; Last connectivity time of the IoT sensor
	ConnectivityTime *string `json:"connectivityTime,omitempty" azure:"ro"`

	// READ-ONLY; Dynamic mode status of the IoT sensor
	DynamicLearning *bool `json:"dynamicLearning,omitempty" azure:"ro"`

	// READ-ONLY; Learning mode status of the IoT sensor
	LearningMode *bool `json:"learningMode,omitempty" azure:"ro"`

	// READ-ONLY; Status of the IoT sensor
	SensorStatus *SensorStatus `json:"sensorStatus,omitempty" azure:"ro"`

	// READ-ONLY; Version of the IoT sensor
	SensorVersion *string `json:"sensorVersion,omitempty" azure:"ro"`

	// READ-ONLY; TI Status of the IoT sensor
	TiStatus *TiStatus `json:"tiStatus,omitempty" azure:"ro"`

	// READ-ONLY; TI Version of the IoT sensor
	TiVersion *string `json:"tiVersion,omitempty" azure:"ro"`
}

// SensorsClientCreateOrUpdateOptions contains the optional parameters for the SensorsClient.CreateOrUpdate method.
type SensorsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientDeleteOptions contains the optional parameters for the SensorsClient.Delete method.
type SensorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientDownloadActivationOptions contains the optional parameters for the SensorsClient.DownloadActivation method.
type SensorsClientDownloadActivationOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientDownloadResetPasswordOptions contains the optional parameters for the SensorsClient.DownloadResetPassword
// method.
type SensorsClientDownloadResetPasswordOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientGetOptions contains the optional parameters for the SensorsClient.Get method.
type SensorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientListOptions contains the optional parameters for the SensorsClient.List method.
type SensorsClientListOptions struct {
	// placeholder for future optional parameters
}

// SensorsClientTriggerTiPackageUpdateOptions contains the optional parameters for the SensorsClient.TriggerTiPackageUpdate
// method.
type SensorsClientTriggerTiPackageUpdateOptions struct {
	// placeholder for future optional parameters
}

// SensorsList - List of IoT sensors
type SensorsList struct {
	// READ-ONLY; List data
	Value []*SensorModel `json:"value,omitempty" azure:"ro"`
}

// SiteModel - IoT site model
type SiteModel struct {
	// IoT site properties
	Properties *SiteProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteProperties - IoT site properties
type SiteProperties struct {
	// REQUIRED; Display name of the IoT site
	DisplayName *string `json:"displayName,omitempty"`

	// Tags of the IoT site
	Tags map[string]*string `json:"tags,omitempty"`
}

// SitesClientCreateOrUpdateOptions contains the optional parameters for the SitesClient.CreateOrUpdate method.
type SitesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SitesClientDeleteOptions contains the optional parameters for the SitesClient.Delete method.
type SitesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SitesClientGetOptions contains the optional parameters for the SitesClient.Get method.
type SitesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SitesClientListOptions contains the optional parameters for the SitesClient.List method.
type SitesClientListOptions struct {
	// placeholder for future optional parameters
}

// SitesList - List of IoT sites
type SitesList struct {
	// READ-ONLY; List data
	Value []*SiteModel `json:"value,omitempty" azure:"ro"`
}

// Slot data in PLC backplane
type Slot struct {
	// A bag of fields which extends the slot information.
	AdditionalData interface{} `json:"additionalData,omitempty"`

	// Firmware revision of the slot.
	FirmwareVersion *string `json:"firmwareVersion,omitempty"`

	// Hardware revision of the slot.
	HardwareRevision *string `json:"hardwareRevision,omitempty"`

	// Hardware vendor of the slot.
	HardwareVendor *string `json:"hardwareVendor,omitempty"`

	// Model of the slot.
	Model *string `json:"model,omitempty"`

	// Module version of the slot.
	ModuleVersion *string `json:"moduleVersion,omitempty"`

	// Product code of the slot.
	ProductCode *string `json:"productCode,omitempty"`

	// Serial number of the slot.
	SerialNumber *string `json:"serialNumber,omitempty"`

	// Slot type.
	SlotType *SlotType `json:"slotType,omitempty"`

	// READ-ONLY; List of Common Platform Enumeration (CPE) of the slot
	Cpes []*string `json:"cpes,omitempty" azure:"ro"`

	// READ-ONLY; Rack number in the backplane
	RackNumber *int32 `json:"rackNumber,omitempty" azure:"ro"`

	// READ-ONLY; Slot number inside the rack
	SlotNumber *int32 `json:"slotNumber,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UpgradePackageDownloadInfo - Information on a specific package upgrade download
type UpgradePackageDownloadInfo struct {
	// READ-ONLY; Minimum base version for upgrade
	FromVersion *string `json:"fromVersion,omitempty" azure:"ro"`

	// READ-ONLY; Download link
	Link *string `json:"link,omitempty" azure:"ro"`

	// READ-ONLY; Version number
	Version *string `json:"version,omitempty" azure:"ro"`

	// READ-ONLY; Kind of the version
	VersionKind *VersionKind `json:"versionKind,omitempty" azure:"ro"`
}
