//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstreamanalytics

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AggregateFunctionProperties.
func (a AggregateFunctionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Aggregate"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AggregateFunctionProperties.
func (a *AggregateFunctionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroSerialization.
func (a AvroSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", &a.Properties)
	objectMap["type"] = EventSerializationTypeAvro
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroSerialization.
func (a *AvroSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreOutputDataSource.
func (a AzureDataLakeStoreOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.DataLake/Accounts"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreOutputDataSource.
func (a *AzureDataLakeStoreOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionOutputDataSource.
func (a AzureFunctionOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.AzureFunction"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionOutputDataSource.
func (a *AzureFunctionOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningWebServiceFunctionBinding.
func (a AzureMachineLearningWebServiceFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.MachineLearning/WebService"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningWebServiceFunctionBinding.
func (a *AzureMachineLearningWebServiceFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningWebServiceFunctionBindingProperties.
func (a AzureMachineLearningWebServiceFunctionBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiKey", a.APIKey)
	populate(objectMap, "batchSize", a.BatchSize)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "inputs", a.Inputs)
	populate(objectMap, "outputs", a.Outputs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (a AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bindingRetrievalProperties", a.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.MachineLearning/WebService"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &a.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &a.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningWebServiceInputs.
func (a AzureMachineLearningWebServiceInputs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columnNames", a.ColumnNames)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseOutputDataSource.
func (a AzureSQLDatabaseOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/Database"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseOutputDataSource.
func (a *AzureSQLDatabaseOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLReferenceInputDataSource.
func (a AzureSQLReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/Database"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLReferenceInputDataSource.
func (a *AzureSQLReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseOutputDataSource.
func (a AzureSynapseOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/DataWarehouse"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseOutputDataSource.
func (a *AzureSynapseOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableOutputDataSource.
func (a AzureTableOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Storage/Table"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableOutputDataSource.
func (a *AzureTableOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableOutputDataSourceProperties.
func (a AzureTableOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountKey", a.AccountKey)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "batchSize", a.BatchSize)
	populate(objectMap, "columnsToRemove", a.ColumnsToRemove)
	populate(objectMap, "partitionKey", a.PartitionKey)
	populate(objectMap, "rowKey", a.RowKey)
	populate(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BlobDataSourceProperties.
func (b BlobDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BlobOutputDataSource.
func (b BlobOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobOutputDataSource.
func (b *BlobOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobOutputDataSourceProperties.
func (b BlobOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BlobReferenceInputDataSource.
func (b BlobReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobReferenceInputDataSource.
func (b *BlobReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobReferenceInputDataSourceProperties.
func (b BlobReferenceInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BlobStreamInputDataSource.
func (b BlobStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobStreamInputDataSource.
func (b *BlobStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobStreamInputDataSourceProperties.
func (b BlobStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "sourcePartitionCount", b.SourcePartitionCount)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CSVSerialization.
func (c CSVSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	objectMap["type"] = EventSerializationTypeCSV
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSVSerialization.
func (c *CSVSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacityAllocated", c.CapacityAllocated)
	populate(objectMap, "capacityAssigned", c.CapacityAssigned)
	populate(objectMap, "clusterId", c.ClusterID)
	populateTimeRFC3339(objectMap, "createdDate", c.CreatedDate)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityAllocated":
			err = unpopulate(val, "CapacityAllocated", &c.CapacityAllocated)
			delete(rawMsg, key)
		case "capacityAssigned":
			err = unpopulate(val, "CapacityAssigned", &c.CapacityAssigned)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &c.CreatedDate)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Diagnostics.
func (d Diagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "conditions", d.Conditions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbOutputDataSource.
func (d DocumentDbOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	objectMap["type"] = "Microsoft.Storage/DocumentDB"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbOutputDataSource.
func (d *DocumentDbOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubOutputDataSource.
func (e EventHubOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubOutputDataSource.
func (e *EventHubOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubOutputDataSourceProperties.
func (e EventHubOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", e.AuthenticationMode)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "partitionKey", e.PartitionKey)
	populate(objectMap, "propertyColumns", e.PropertyColumns)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", e.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", e.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EventHubStreamInputDataSource.
func (e EventHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubStreamInputDataSource.
func (e *EventHubStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubV2OutputDataSource.
func (e EventHubV2OutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.EventHub/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubV2OutputDataSource.
func (e *EventHubV2OutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubV2StreamInputDataSource.
func (e EventHubV2StreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.EventHub/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubV2StreamInputDataSource.
func (e *EventHubV2StreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Function.
func (f Function) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Function.
func (f *Function) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			f.Properties, err = unmarshalFunctionPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionConfiguration.
func (f FunctionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "binding", f.Binding)
	populate(objectMap, "inputs", f.Inputs)
	populate(objectMap, "output", f.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionConfiguration.
func (f *FunctionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "binding":
			f.Binding, err = unmarshalFunctionBindingClassification(val)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &f.Inputs)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &f.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Input.
func (i Input) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Input.
func (i *Input) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalInputPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputProperties.
func (i InputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compression", i.Compression)
	populate(objectMap, "diagnostics", i.Diagnostics)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "partitionKey", i.PartitionKey)
	populate(objectMap, "serialization", i.Serialization)
	objectMap["type"] = i.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputProperties.
func (i *InputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &i.Compression)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &i.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &i.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			i.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubStreamInputDataSource.
func (i IoTHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", i.Properties)
	objectMap["type"] = "Microsoft.Devices/IotHubs"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubStreamInputDataSource.
func (i *IoTHubStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSerialization.
func (j JSONSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", j.Properties)
	objectMap["type"] = EventSerializationTypeJSON
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSerialization.
func (j *JSONSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionBinding.
func (j JavaScriptFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", j.Properties)
	objectMap["type"] = "Microsoft.StreamAnalytics/JavascriptUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionBinding.
func (j *JavaScriptFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j JavaScriptFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bindingRetrievalProperties", j.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.StreamAnalytics/JavascriptUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j *JavaScriptFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &j.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &j.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Output.
func (o Output) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OutputProperties.
func (o OutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datasource", o.Datasource)
	populate(objectMap, "diagnostics", o.Diagnostics)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "serialization", o.Serialization)
	populate(objectMap, "sizeWindow", o.SizeWindow)
	populate(objectMap, "timeWindow", o.TimeWindow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputProperties.
func (o *OutputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasource":
			o.Datasource, err = unmarshalOutputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &o.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "serialization":
			o.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "sizeWindow":
			err = unpopulate(val, "SizeWindow", &o.SizeWindow)
			delete(rawMsg, key)
		case "timeWindow":
			err = unpopulate(val, "TimeWindow", &o.TimeWindow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParquetSerialization.
func (p ParquetSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", &p.Properties)
	objectMap["type"] = EventSerializationTypeParquet
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParquetSerialization.
func (p *ParquetSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PowerBIOutputDataSource.
func (p PowerBIOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	objectMap["type"] = "PowerBI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PowerBIOutputDataSource.
func (p *PowerBIOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointProperties.
func (p PrivateEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "createdDate", p.CreatedDate)
	populate(objectMap, "manualPrivateLinkServiceConnections", p.ManualPrivateLinkServiceConnections)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionProperties.
func (p PrivateLinkServiceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "privateLinkServiceId", p.PrivateLinkServiceID)
	populate(objectMap, "requestMessage", p.RequestMessage)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceInputProperties.
func (r ReferenceInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compression", r.Compression)
	populate(objectMap, "datasource", r.Datasource)
	populate(objectMap, "diagnostics", r.Diagnostics)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "partitionKey", r.PartitionKey)
	populate(objectMap, "serialization", r.Serialization)
	objectMap["type"] = "Reference"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceInputProperties.
func (r *ReferenceInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &r.Compression)
			delete(rawMsg, key)
		case "datasource":
			r.Datasource, err = unmarshalReferenceInputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &r.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &r.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			r.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalarFunctionProperties.
func (s ScalarFunctionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalarFunctionProperties.
func (s *ScalarFunctionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueOutputDataSource.
func (s ServiceBusQueueOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/Queue"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueOutputDataSource.
func (s *ServiceBusQueueOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueOutputDataSourceProperties.
func (s ServiceBusQueueOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	populate(objectMap, "propertyColumns", s.PropertyColumns)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "serviceBusNamespace", s.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", s.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", s.SharedAccessPolicyName)
	populate(objectMap, "systemPropertyColumns", &s.SystemPropertyColumns)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicOutputDataSource.
func (s ServiceBusTopicOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/Topic"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicOutputDataSource.
func (s *ServiceBusTopicOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicOutputDataSourceProperties.
func (s ServiceBusTopicOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	populate(objectMap, "propertyColumns", s.PropertyColumns)
	populate(objectMap, "serviceBusNamespace", s.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", s.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", s.SharedAccessPolicyName)
	populate(objectMap, "systemPropertyColumns", s.SystemPropertyColumns)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StartStreamingJobParameters.
func (s StartStreamingJobParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "outputStartMode", s.OutputStartMode)
	populateTimeRFC3339(objectMap, "outputStartTime", s.OutputStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StartStreamingJobParameters.
func (s *StartStreamingJobParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "outputStartMode":
			err = unpopulate(val, "OutputStartMode", &s.OutputStartMode)
			delete(rawMsg, key)
		case "outputStartTime":
			err = unpopulateTimeRFC3339(val, "OutputStartTime", &s.OutputStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamInputProperties.
func (s StreamInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compression", s.Compression)
	populate(objectMap, "datasource", s.Datasource)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "partitionKey", s.PartitionKey)
	populate(objectMap, "serialization", s.Serialization)
	objectMap["type"] = "Stream"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamInputProperties.
func (s *StreamInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &s.Compression)
			delete(rawMsg, key)
		case "datasource":
			s.Datasource, err = unmarshalStreamInputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &s.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			s.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingJob.
func (s StreamingJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StreamingJobProperties.
func (s StreamingJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cluster", s.Cluster)
	populate(objectMap, "compatibilityLevel", s.CompatibilityLevel)
	populate(objectMap, "contentStoragePolicy", s.ContentStoragePolicy)
	populateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "dataLocale", s.DataLocale)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "eventsLateArrivalMaxDelayInSeconds", s.EventsLateArrivalMaxDelayInSeconds)
	populate(objectMap, "eventsOutOfOrderMaxDelayInSeconds", s.EventsOutOfOrderMaxDelayInSeconds)
	populate(objectMap, "eventsOutOfOrderPolicy", s.EventsOutOfOrderPolicy)
	populate(objectMap, "functions", s.Functions)
	populate(objectMap, "inputs", s.Inputs)
	populate(objectMap, "jobId", s.JobID)
	populate(objectMap, "jobState", s.JobState)
	populate(objectMap, "jobStorageAccount", s.JobStorageAccount)
	populate(objectMap, "jobType", s.JobType)
	populateTimeRFC3339(objectMap, "lastOutputEventTime", s.LastOutputEventTime)
	populate(objectMap, "outputErrorPolicy", s.OutputErrorPolicy)
	populate(objectMap, "outputStartMode", s.OutputStartMode)
	populateTimeRFC3339(objectMap, "outputStartTime", s.OutputStartTime)
	populate(objectMap, "outputs", s.Outputs)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "transformation", s.Transformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingJobProperties.
func (s *StreamingJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cluster":
			err = unpopulate(val, "Cluster", &s.Cluster)
			delete(rawMsg, key)
		case "compatibilityLevel":
			err = unpopulate(val, "CompatibilityLevel", &s.CompatibilityLevel)
			delete(rawMsg, key)
		case "contentStoragePolicy":
			err = unpopulate(val, "ContentStoragePolicy", &s.ContentStoragePolicy)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "dataLocale":
			err = unpopulate(val, "DataLocale", &s.DataLocale)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "eventsLateArrivalMaxDelayInSeconds":
			err = unpopulate(val, "EventsLateArrivalMaxDelayInSeconds", &s.EventsLateArrivalMaxDelayInSeconds)
			delete(rawMsg, key)
		case "eventsOutOfOrderMaxDelayInSeconds":
			err = unpopulate(val, "EventsOutOfOrderMaxDelayInSeconds", &s.EventsOutOfOrderMaxDelayInSeconds)
			delete(rawMsg, key)
		case "eventsOutOfOrderPolicy":
			err = unpopulate(val, "EventsOutOfOrderPolicy", &s.EventsOutOfOrderPolicy)
			delete(rawMsg, key)
		case "functions":
			err = unpopulate(val, "Functions", &s.Functions)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &s.Inputs)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &s.JobID)
			delete(rawMsg, key)
		case "jobState":
			err = unpopulate(val, "JobState", &s.JobState)
			delete(rawMsg, key)
		case "jobStorageAccount":
			err = unpopulate(val, "JobStorageAccount", &s.JobStorageAccount)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &s.JobType)
			delete(rawMsg, key)
		case "lastOutputEventTime":
			err = unpopulateTimeRFC3339(val, "LastOutputEventTime", &s.LastOutputEventTime)
			delete(rawMsg, key)
		case "outputErrorPolicy":
			err = unpopulate(val, "OutputErrorPolicy", &s.OutputErrorPolicy)
			delete(rawMsg, key)
		case "outputStartMode":
			err = unpopulate(val, "OutputStartMode", &s.OutputStartMode)
			delete(rawMsg, key)
		case "outputStartTime":
			err = unpopulateTimeRFC3339(val, "OutputStartTime", &s.OutputStartTime)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &s.Outputs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "transformation":
			err = unpopulate(val, "Transformation", &s.Transformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Transformation.
func (t Transformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TransformationProperties.
func (t TransformationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "query", t.Query)
	populate(objectMap, "streamingUnits", t.StreamingUnits)
	populate(objectMap, "validStreamingUnits", t.ValidStreamingUnits)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
