=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiIssueWithRoleRequest
    # The requested Subject Alternative Names, if any, in a comma-delimited list. If email protection is enabled for the role, this may contain email addresses.
    attr_accessor :alt_names

    # The requested common name; if you want more than one, specify the alternative names in the alt_names map. If email protection is enabled in the role, this may be an email address.
    attr_accessor :common_name

    # If true, the Common Name will not be included in DNS or Email Subject Alternate Names. Defaults to false (CN is included).
    attr_accessor :exclude_cn_from_sans

    # Format for returned data. Can be \"pem\", \"der\", or \"pem_bundle\". If \"pem_bundle\", any private key and issuing cert will be appended to the certificate pem. If \"der\", the value will be base64 encoded. Defaults to \"pem\".
    attr_accessor :format

    # The requested IP SANs, if any, in a comma-delimited list
    attr_accessor :ip_sans

    # Reference to a existing issuer; either \"default\" for the configured default issuer, an identifier or the name assigned to the issuer.
    attr_accessor :issuer_ref

    # The number of bits to use. Allowed values are 0 (universal default); with rsa key_type: 2048 (default), 3072, or 4096; with ec key_type: 224, 256 (default), 384, or 521; ignored with ed25519.
    attr_accessor :key_bits

    # The type of key to use; defaults to the empty string to use whatever is specified by the role. \"rsa\",\"ec\", and \"ed25519\" are the only valid values outside of the empty string.
    attr_accessor :key_type

    # Set the not after field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ
    attr_accessor :not_after

    # Requested other SANs, in an array with the format <oid>;UTF8:<utf8 string value> for each entry.
    attr_accessor :other_sans

    # Format for the returned private key. Generally the default will be controlled by the \"format\" parameter as either base64-encoded DER or PEM-encoded DER. However, this can be set to \"pkcs8\" to have the returned private key contain base64-encoded pkcs8 or PEM-encoded pkcs8 instead. Defaults to \"der\".
    attr_accessor :private_key_format

    # Whether or not to remove self-signed CA certificates in the output of the ca_chain field.
    attr_accessor :remove_roots_from_chain

    # The Subject's requested serial number, if any. See RFC 4519 Section 2.31 'serialNumber' for a description of this field. If you want more than one, specify alternative names in the alt_names map using OID 2.5.4.5. This has no impact on the final certificate's Serial Number field.
    attr_accessor :serial_number

    # The requested Time To Live for the certificate; sets the expiration date. If not specified the role default, backend default, or system default TTL is used, in that order. Cannot be larger than the role max TTL.
    attr_accessor :ttl

    # The requested URI SANs, if any, in a comma-delimited list.
    attr_accessor :uri_sans

    # The requested user_ids value to place in the subject, if any, in a comma-delimited list. Restricted by allowed_user_ids. Any values are added with OID 0.9.2342.19200300.100.1.1.
    attr_accessor :user_ids

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'alt_names' => :'alt_names',
        :'common_name' => :'common_name',
        :'exclude_cn_from_sans' => :'exclude_cn_from_sans',
        :'format' => :'format',
        :'ip_sans' => :'ip_sans',
        :'issuer_ref' => :'issuer_ref',
        :'key_bits' => :'key_bits',
        :'key_type' => :'key_type',
        :'not_after' => :'not_after',
        :'other_sans' => :'other_sans',
        :'private_key_format' => :'private_key_format',
        :'remove_roots_from_chain' => :'remove_roots_from_chain',
        :'serial_number' => :'serial_number',
        :'ttl' => :'ttl',
        :'uri_sans' => :'uri_sans',
        :'user_ids' => :'user_ids'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'alt_names' => :'String',
        :'common_name' => :'String',
        :'exclude_cn_from_sans' => :'Boolean',
        :'format' => :'String',
        :'ip_sans' => :'Array<String>',
        :'issuer_ref' => :'String',
        :'key_bits' => :'Integer',
        :'key_type' => :'String',
        :'not_after' => :'String',
        :'other_sans' => :'Array<String>',
        :'private_key_format' => :'String',
        :'remove_roots_from_chain' => :'Boolean',
        :'serial_number' => :'String',
        :'ttl' => :'Integer',
        :'uri_sans' => :'Array<String>',
        :'user_ids' => :'Array<String>'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiIssueWithRoleRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiIssueWithRoleRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'alt_names')
        self.alt_names = attributes[:'alt_names']
      end

      if attributes.key?(:'common_name')
        self.common_name = attributes[:'common_name']
      end

      if attributes.key?(:'exclude_cn_from_sans')
        self.exclude_cn_from_sans = attributes[:'exclude_cn_from_sans']
      else
        self.exclude_cn_from_sans = false
      end

      if attributes.key?(:'format')
        self.format = attributes[:'format']
      else
        self.format = 'pem'
      end

      if attributes.key?(:'ip_sans')
        if (value = attributes[:'ip_sans']).is_a?(Array)
          self.ip_sans = value
        end
      end

      if attributes.key?(:'issuer_ref')
        self.issuer_ref = attributes[:'issuer_ref']
      else
        self.issuer_ref = 'default'
      end

      if attributes.key?(:'key_bits')
        self.key_bits = attributes[:'key_bits']
      else
        self.key_bits = 0
      end

      if attributes.key?(:'key_type')
        self.key_type = attributes[:'key_type']
      else
        self.key_type = ''
      end

      if attributes.key?(:'not_after')
        self.not_after = attributes[:'not_after']
      end

      if attributes.key?(:'other_sans')
        if (value = attributes[:'other_sans']).is_a?(Array)
          self.other_sans = value
        end
      end

      if attributes.key?(:'private_key_format')
        self.private_key_format = attributes[:'private_key_format']
      else
        self.private_key_format = 'der'
      end

      if attributes.key?(:'remove_roots_from_chain')
        self.remove_roots_from_chain = attributes[:'remove_roots_from_chain']
      else
        self.remove_roots_from_chain = false
      end

      if attributes.key?(:'serial_number')
        self.serial_number = attributes[:'serial_number']
      end

      if attributes.key?(:'ttl')
        self.ttl = attributes[:'ttl']
      end

      if attributes.key?(:'uri_sans')
        if (value = attributes[:'uri_sans']).is_a?(Array)
          self.uri_sans = value
        end
      end

      if attributes.key?(:'user_ids')
        if (value = attributes[:'user_ids']).is_a?(Array)
          self.user_ids = value
        end
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      format_validator = EnumAttributeValidator.new('String', ["pem", "der", "pem_bundle"])
      return false unless format_validator.valid?(@format)
      key_type_validator = EnumAttributeValidator.new('String', ["", "rsa", "ec", "ed25519"])
      return false unless key_type_validator.valid?(@key_type)
      private_key_format_validator = EnumAttributeValidator.new('String', ["", "der", "pem", "pkcs8"])
      return false unless private_key_format_validator.valid?(@private_key_format)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] format Object to be assigned
    def format=(format)
      validator = EnumAttributeValidator.new('String', ["pem", "der", "pem_bundle"])
      unless validator.valid?(format)
        fail ArgumentError, "invalid value for \"format\", must be one of #{validator.allowable_values}."
      end
      @format = format
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] key_type Object to be assigned
    def key_type=(key_type)
      validator = EnumAttributeValidator.new('String', ["", "rsa", "ec", "ed25519"])
      unless validator.valid?(key_type)
        fail ArgumentError, "invalid value for \"key_type\", must be one of #{validator.allowable_values}."
      end
      @key_type = key_type
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] private_key_format Object to be assigned
    def private_key_format=(private_key_format)
      validator = EnumAttributeValidator.new('String', ["", "der", "pem", "pkcs8"])
      unless validator.valid?(private_key_format)
        fail ArgumentError, "invalid value for \"private_key_format\", must be one of #{validator.allowable_values}."
      end
      @private_key_format = private_key_format
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          alt_names == o.alt_names &&
          common_name == o.common_name &&
          exclude_cn_from_sans == o.exclude_cn_from_sans &&
          format == o.format &&
          ip_sans == o.ip_sans &&
          issuer_ref == o.issuer_ref &&
          key_bits == o.key_bits &&
          key_type == o.key_type &&
          not_after == o.not_after &&
          other_sans == o.other_sans &&
          private_key_format == o.private_key_format &&
          remove_roots_from_chain == o.remove_roots_from_chain &&
          serial_number == o.serial_number &&
          ttl == o.ttl &&
          uri_sans == o.uri_sans &&
          user_ids == o.user_ids
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [alt_names, common_name, exclude_cn_from_sans, format, ip_sans, issuer_ref, key_bits, key_type, not_after, other_sans, private_key_format, remove_roots_from_chain, serial_number, ttl, uri_sans, user_ids].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
