// Code generated by smithy-go-codegen DO NOT EDIT.

package swf

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/swf/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Used by deciders to tell the service that the DecisionTask identified by the
// taskToken has successfully completed. The decisions argument specifies the list
// of decisions made while processing the task. A DecisionTaskCompleted event is
// added to the workflow history. The executionContext specified is attached to the
// event in the workflow execution history. Access Control If an IAM policy grants
// permission to use RespondDecisionTaskCompleted, it can express permissions for
// the list of decisions in the decisions parameter. Each of the decisions has one
// or more parameters, much like a regular API call. To allow for policies to be as
// readable as possible, you can express permissions on decisions as if they were
// actual API calls, including applying conditions to some parameters. For more
// information, see Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
func (c *Client) RespondDecisionTaskCompleted(ctx context.Context, params *RespondDecisionTaskCompletedInput, optFns ...func(*Options)) (*RespondDecisionTaskCompletedOutput, error) {
	if params == nil {
		params = &RespondDecisionTaskCompletedInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RespondDecisionTaskCompleted", params, optFns, c.addOperationRespondDecisionTaskCompletedMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RespondDecisionTaskCompletedOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input data for a TaskCompleted response to a decision task.
type RespondDecisionTaskCompletedInput struct {

	// The taskToken from the DecisionTask. taskToken is generated by the service and
	// should be treated as an opaque value. If the task is passed to another process,
	// its taskToken must also be passed. This enables it to provide its progress and
	// respond with results.
	//
	// This member is required.
	TaskToken *string

	// The list of decisions (possibly empty) made by the decider while processing this
	// decision task. See the docs for the Decision structure for details.
	Decisions []types.Decision

	// User defined context to add to workflow execution.
	ExecutionContext *string

	noSmithyDocumentSerde
}

type RespondDecisionTaskCompletedOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRespondDecisionTaskCompletedMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRespondDecisionTaskCompleted{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRespondDecisionTaskCompleted{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRespondDecisionTaskCompletedValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRespondDecisionTaskCompleted(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRespondDecisionTaskCompleted(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "swf",
		OperationName: "RespondDecisionTaskCompleted",
	}
}
