//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeventhub_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventhub/armeventhub"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceList.json
func ExampleNamespacesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EHNamespaceListResult = armeventhub.EHNamespaceListResult{
		// 	Value: []*armeventhub.EHNamespace{
		// 		{
		// 			Name: to.Ptr("NamespaceSample"),
		// 			Type: to.Ptr("Microsoft.EventHub/Namespaces"),
		// 			ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armeventhub.Identity{
		// 				Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("PrincipalIdGUID"),
		// 				TenantID: to.Ptr("TenantIdGUID"),
		// 				UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
		// 					"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": &armeventhub.UserAssignedIdentity{
		// 						ClientID: to.Ptr("ClientIdGUID"),
		// 						PrincipalID: to.Ptr("PrincipalIdGUID"),
		// 					},
		// 					"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": &armeventhub.UserAssignedIdentity{
		// 						ClientID: to.Ptr("6a35400f-6ccb-4817-8f1a-ce19ea4523bc"),
		// 						PrincipalID: to.Ptr("ce2d5953-5c15-40ca-9d51-cc3f4a63b0f5"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armeventhub.EHNamespaceProperties{
		// 				ClusterArmID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/clusters/enc-test"),
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
		// 				DisableLocalAuth: to.Ptr(false),
		// 				Encryption: &armeventhub.Encryption{
		// 					KeySource: to.Ptr("Microsoft.KeyVault"),
		// 					KeyVaultProperties: []*armeventhub.KeyVaultProperties{
		// 						{
		// 							Identity: &armeventhub.UserAssignedIdentityProperties{
		// 								UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
		// 							},
		// 							KeyName: to.Ptr("Samplekey"),
		// 							KeyVaultURI: to.Ptr("https://sample-keyvault-user.vault-int.azure-int.net"),
		// 							KeyVersion: to.Ptr(""),
		// 					}},
		// 					RequireInfrastructureEncryption: to.Ptr(false),
		// 				},
		// 				IsAutoInflateEnabled: to.Ptr(false),
		// 				MaximumThroughputUnits: to.Ptr[int32](0),
		// 				MetricID: to.Ptr("MetricGUID:NamespaceSample"),
		// 				MinimumTLSVersion: to.Ptr(armeventhub.TLSVersionOne2),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ServiceBusEndpoint: to.Ptr("https://NamespaceSample.servicebus.windows-int.net:443/"),
		// 				UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:30:55.143Z"); return t}()),
		// 				ZoneRedundant: to.Ptr(false),
		// 			},
		// 			SKU: &armeventhub.SKU{
		// 				Name: to.Ptr(armeventhub.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](0),
		// 				Tier: to.Ptr(armeventhub.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceListByResourceGroup.json
func ExampleNamespacesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListByResourceGroupPager("ResurceGroupSample", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EHNamespaceListResult = armeventhub.EHNamespaceListResult{
		// 	Value: []*armeventhub.EHNamespace{
		// 		{
		// 			Name: to.Ptr("NamespaceSample"),
		// 			Type: to.Ptr("Microsoft.EventHub/Namespaces"),
		// 			ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armeventhub.Identity{
		// 				Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("PrincipalIdGUID"),
		// 				TenantID: to.Ptr("TenantIdGUID"),
		// 				UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
		// 					"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": &armeventhub.UserAssignedIdentity{
		// 						ClientID: to.Ptr("ClientIdGUID"),
		// 						PrincipalID: to.Ptr("PrincipalIdGUID"),
		// 					},
		// 					"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": &armeventhub.UserAssignedIdentity{
		// 						ClientID: to.Ptr("6a35400f-6ccb-4817-8f1a-ce19ea4523bc"),
		// 						PrincipalID: to.Ptr("ce2d5953-5c15-40ca-9d51-cc3f4a63b0f5"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armeventhub.EHNamespaceProperties{
		// 				ClusterArmID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/clusters/enc-test"),
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
		// 				DisableLocalAuth: to.Ptr(false),
		// 				Encryption: &armeventhub.Encryption{
		// 					KeySource: to.Ptr("Microsoft.KeyVault"),
		// 					KeyVaultProperties: []*armeventhub.KeyVaultProperties{
		// 						{
		// 							Identity: &armeventhub.UserAssignedIdentityProperties{
		// 								UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
		// 							},
		// 							KeyName: to.Ptr("Samplekey"),
		// 							KeyVaultURI: to.Ptr("https://sample-keyvault-user.vault-int.azure-int.net"),
		// 							KeyVersion: to.Ptr(""),
		// 					}},
		// 					RequireInfrastructureEncryption: to.Ptr(false),
		// 				},
		// 				IsAutoInflateEnabled: to.Ptr(false),
		// 				MaximumThroughputUnits: to.Ptr[int32](0),
		// 				MetricID: to.Ptr("MetricGUID:NamespaceSample"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ServiceBusEndpoint: to.Ptr("https://NamespaceSample.servicebus.windows-int.net:443/"),
		// 				UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:30:55.143Z"); return t}()),
		// 				ZoneRedundant: to.Ptr(false),
		// 			},
		// 			SKU: &armeventhub.SKU{
		// 				Name: to.Ptr(armeventhub.SKUNameStandard),
		// 				Capacity: to.Ptr[int32](1),
		// 				Tier: to.Ptr(armeventhub.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceCreate.json
func ExampleNamespacesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespacesClient().BeginCreateOrUpdate(ctx, "ResurceGroupSample", "NamespaceSample", armeventhub.EHNamespace{
		Location: to.Ptr("East US"),
		Identity: &armeventhub.Identity{
			Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
				"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": {},
				"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": {},
			},
		},
		Properties: &armeventhub.EHNamespaceProperties{
			ClusterArmID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/clusters/enc-test"),
			Encryption: &armeventhub.Encryption{
				KeySource: to.Ptr("Microsoft.KeyVault"),
				KeyVaultProperties: []*armeventhub.KeyVaultProperties{
					{
						Identity: &armeventhub.UserAssignedIdentityProperties{
							UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
						},
						KeyName:     to.Ptr("Samplekey"),
						KeyVaultURI: to.Ptr("https://aprao-keyvault-user.vault-int.azure-int.net/"),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EHNamespace = armeventhub.EHNamespace{
	// 	Name: to.Ptr("NamespaceSample"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces"),
	// 	ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armeventhub.Identity{
	// 		Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 		TenantID: to.Ptr("TenantIdGUID"),
	// 		UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
	// 			"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": &armeventhub.UserAssignedIdentity{
	// 				ClientID: to.Ptr("ClientIdGUID"),
	// 				PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 			},
	// 			"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": &armeventhub.UserAssignedIdentity{
	// 				ClientID: to.Ptr("6a35400f-6ccb-4817-8f1a-ce19ea4523bc"),
	// 				PrincipalID: to.Ptr("ce2d5953-5c15-40ca-9d51-cc3f4a63b0f5"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armeventhub.EHNamespaceProperties{
	// 		ClusterArmID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/clusters/enc-test"),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-16T22:36:06.107Z"); return t}()),
	// 		DisableLocalAuth: to.Ptr(false),
	// 		Encryption: &armeventhub.Encryption{
	// 			KeySource: to.Ptr("Microsoft.KeyVault"),
	// 			KeyVaultProperties: []*armeventhub.KeyVaultProperties{
	// 				{
	// 					Identity: &armeventhub.UserAssignedIdentityProperties{
	// 						UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
	// 					},
	// 					KeyName: to.Ptr("Samplekey"),
	// 					KeyVaultURI: to.Ptr("https://sample-keyvault-user.vault-int.azure-int.net"),
	// 					KeyVersion: to.Ptr(""),
	// 			}},
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 		},
	// 		IsAutoInflateEnabled: to.Ptr(false),
	// 		KafkaEnabled: to.Ptr(false),
	// 		MaximumThroughputUnits: to.Ptr[int32](0),
	// 		MetricID: to.Ptr("MetricGUID:NamespaceSample"),
	// 		MinimumTLSVersion: to.Ptr(armeventhub.TLSVersionOne2),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServiceBusEndpoint: to.Ptr("https://NamespaceSample.servicebus.windows-int.net:443/"),
	// 		UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-16T22:37:42.290Z"); return t}()),
	// 		ZoneRedundant: to.Ptr(false),
	// 	},
	// 	SKU: &armeventhub.SKU{
	// 		Name: to.Ptr(armeventhub.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armeventhub.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceDelete.json
func ExampleNamespacesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespacesClient().BeginDelete(ctx, "ResurceGroupSample", "NamespaceSample", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceGet.json
func ExampleNamespacesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().Get(ctx, "ResurceGroupSample", "NamespaceSample", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EHNamespace = armeventhub.EHNamespace{
	// 	Name: to.Ptr("NamespaceSample"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces"),
	// 	ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armeventhub.Identity{
	// 		Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 		TenantID: to.Ptr("TenantIdGUID"),
	// 		UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
	// 			"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": &armeventhub.UserAssignedIdentity{
	// 				ClientID: to.Ptr("ClientIdGUID"),
	// 				PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 			},
	// 			"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": &armeventhub.UserAssignedIdentity{
	// 				ClientID: to.Ptr("6a35400f-6ccb-4817-8f1a-ce19ea4523bc"),
	// 				PrincipalID: to.Ptr("ce2d5953-5c15-40ca-9d51-cc3f4a63b0f5"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armeventhub.EHNamespaceProperties{
	// 		ClusterArmID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/clusters/enc-test"),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 		DisableLocalAuth: to.Ptr(false),
	// 		Encryption: &armeventhub.Encryption{
	// 			KeySource: to.Ptr("Microsoft.KeyVault"),
	// 			KeyVaultProperties: []*armeventhub.KeyVaultProperties{
	// 				{
	// 					Identity: &armeventhub.UserAssignedIdentityProperties{
	// 						UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
	// 					},
	// 					KeyName: to.Ptr("Samplekey"),
	// 					KeyVaultURI: to.Ptr("https://sample-keyvault-user.vault-int.azure-int.net"),
	// 					KeyVersion: to.Ptr(""),
	// 			}},
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 		},
	// 		IsAutoInflateEnabled: to.Ptr(false),
	// 		MaximumThroughputUnits: to.Ptr[int32](0),
	// 		MetricID: to.Ptr("MetricGUID:NamespaceSample"),
	// 		MinimumTLSVersion: to.Ptr(armeventhub.TLSVersionOne2),
	// 		PrivateEndpointConnections: []*armeventhub.PrivateEndpointConnection{
	// 			{
	// 				Name: to.Ptr("privateEndpointConnectionName"),
	// 				Type: to.Ptr("Microsoft.EventHub/Namespaces/PrivateEndpointConnections"),
	// 				ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample/privateEndpointConnections/privateEndpointConnectionName"),
	// 				Properties: &armeventhub.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armeventhub.PrivateEndpoint{
	// 						ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.Network/privateEndpoints/NamespaceSample"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armeventhub.ConnectionState{
	// 						Description: to.Ptr("Auto-Approved"),
	// 						Status: to.Ptr(armeventhub.PrivateLinkConnectionStatusApproved),
	// 					},
	// 					ProvisioningState: to.Ptr(armeventhub.EndPointProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServiceBusEndpoint: to.Ptr("https://NamespaceSample.servicebus.windows-int.net:443"),
	// 		UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:30:55.143Z"); return t}()),
	// 		ZoneRedundant: to.Ptr(false),
	// 	},
	// 	SKU: &armeventhub.SKU{
	// 		Name: to.Ptr(armeventhub.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armeventhub.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceUpdate.json
func ExampleNamespacesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().Update(ctx, "ResurceGroupSample", "NamespaceSample", armeventhub.EHNamespace{
		Location: to.Ptr("East US"),
		Identity: &armeventhub.Identity{
			Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
				"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud2": nil,
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EHNamespace = armeventhub.EHNamespace{
	// 	Name: to.Ptr("NamespaceSample"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces"),
	// 	ID: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.EventHub/namespaces/NamespaceSample"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armeventhub.Identity{
	// 		Type: to.Ptr(armeventhub.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 		TenantID: to.Ptr("TenantIdGUID"),
	// 		UserAssignedIdentities: map[string]*armeventhub.UserAssignedIdentity{
	// 			"/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1": &armeventhub.UserAssignedIdentity{
	// 				ClientID: to.Ptr("ClientIdGUID"),
	// 				PrincipalID: to.Ptr("PrincipalIdGUID"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armeventhub.EHNamespaceProperties{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 		DisableLocalAuth: to.Ptr(false),
	// 		Encryption: &armeventhub.Encryption{
	// 			KeySource: to.Ptr("Microsoft.KeyVault"),
	// 			KeyVaultProperties: []*armeventhub.KeyVaultProperties{
	// 				{
	// 					Identity: &armeventhub.UserAssignedIdentityProperties{
	// 						UserAssignedIdentity: to.Ptr("/subscriptions/SampleSubscription/resourceGroups/ResurceGroupSample/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ud1"),
	// 					},
	// 					KeyName: to.Ptr("Samplekey"),
	// 					KeyVaultURI: to.Ptr("https://sample-keyvault-user.vault-int.azure-int.net"),
	// 					KeyVersion: to.Ptr(""),
	// 			}},
	// 			RequireInfrastructureEncryption: to.Ptr(false),
	// 		},
	// 		IsAutoInflateEnabled: to.Ptr(false),
	// 		MaximumThroughputUnits: to.Ptr[int32](0),
	// 		MetricID: to.Ptr("MetricGUID:NamespaceSample"),
	// 		MinimumTLSVersion: to.Ptr(armeventhub.TLSVersionOne1),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServiceBusEndpoint: to.Ptr("https://NamespaceSample.servicebus.windows-int.net:443/"),
	// 		UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:31:13.657Z"); return t}()),
	// 		ZoneRedundant: to.Ptr(false),
	// 	},
	// 	SKU: &armeventhub.SKU{
	// 		Name: to.Ptr(armeventhub.SKUNameStandard),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr(armeventhub.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/VirtualNetworkRule/EHNetworkRuleSetCreate.json
func ExampleNamespacesClient_CreateOrUpdateNetworkRuleSet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().CreateOrUpdateNetworkRuleSet(ctx, "ResourceGroup", "sdk-Namespace-6019", armeventhub.NetworkRuleSet{
		Properties: &armeventhub.NetworkRuleSetProperties{
			DefaultAction: to.Ptr(armeventhub.DefaultActionDeny),
			IPRules: []*armeventhub.NWRuleSetIPRules{
				{
					Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
					IPMask: to.Ptr("1.1.1.1"),
				},
				{
					Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
					IPMask: to.Ptr("1.1.1.2"),
				},
				{
					Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
					IPMask: to.Ptr("1.1.1.3"),
				},
				{
					Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
					IPMask: to.Ptr("1.1.1.4"),
				},
				{
					Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
					IPMask: to.Ptr("1.1.1.5"),
				}},
			VirtualNetworkRules: []*armeventhub.NWRuleSetVirtualNetworkRules{
				{
					IgnoreMissingVnetServiceEndpoint: to.Ptr(true),
					Subnet: &armeventhub.Subnet{
						ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
					},
				},
				{
					IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
					Subnet: &armeventhub.Subnet{
						ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
					},
				},
				{
					IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
					Subnet: &armeventhub.Subnet{
						ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkRuleSet = armeventhub.NetworkRuleSet{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/NetworkRuleSet"),
	// 	ID: to.Ptr("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourceGroups/resourcegroupid/providers/Microsoft.EventHub/namespaces/sdk-Namespace-9659/networkruleset/default"),
	// 	Properties: &armeventhub.NetworkRuleSetProperties{
	// 		DefaultAction: to.Ptr(armeventhub.DefaultActionDeny),
	// 		IPRules: []*armeventhub.NWRuleSetIPRules{
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.1"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.2"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.3"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.4"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.5"),
	// 		}},
	// 		VirtualNetworkRules: []*armeventhub.NWRuleSetVirtualNetworkRules{
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(true),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
	// 				},
	// 			},
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
	// 				},
	// 			},
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
	// 				},
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/VirtualNetworkRule/EHNetworkRuleSetGet.json
func ExampleNamespacesClient_GetNetworkRuleSet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().GetNetworkRuleSet(ctx, "ResourceGroup", "sdk-Namespace-6019", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkRuleSet = armeventhub.NetworkRuleSet{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/NetworkRuleSet"),
	// 	ID: to.Ptr("/subscriptions/subscriptionid/resourceGroups/resourcegroupid/providers/Microsoft.EventHub/namespaces/sdk-Namespace-9659/networkruleset/default"),
	// 	Properties: &armeventhub.NetworkRuleSetProperties{
	// 		DefaultAction: to.Ptr(armeventhub.DefaultActionDeny),
	// 		IPRules: []*armeventhub.NWRuleSetIPRules{
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.1"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.2"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.3"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.4"),
	// 			},
	// 			{
	// 				Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 				IPMask: to.Ptr("1.1.1.5"),
	// 		}},
	// 		VirtualNetworkRules: []*armeventhub.NWRuleSetVirtualNetworkRules{
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(true),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
	// 				},
	// 			},
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
	// 				},
	// 			},
	// 			{
	// 				IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 				Subnet: &armeventhub.Subnet{
	// 					ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
	// 				},
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/VirtualNetworkRule/EHNetworkRuleSetList.json
func ExampleNamespacesClient_ListNetworkRuleSet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().ListNetworkRuleSet(ctx, "ResourceGroup", "sdk-Namespace-6019", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkRuleSetListResult = armeventhub.NetworkRuleSetListResult{
	// 	Value: []*armeventhub.NetworkRuleSet{
	// 		{
	// 			Name: to.Ptr("default"),
	// 			Type: to.Ptr("Microsoft.EventHub/Namespaces/NetworkRuleSet"),
	// 			ID: to.Ptr("/subscriptions/subscriptionid/resourceGroups/resourcegroupid/providers/Microsoft.EventHub/namespaces/sdk-Namespace-9659/networkruleset/default"),
	// 			Properties: &armeventhub.NetworkRuleSetProperties{
	// 				DefaultAction: to.Ptr(armeventhub.DefaultActionDeny),
	// 				IPRules: []*armeventhub.NWRuleSetIPRules{
	// 					{
	// 						Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 						IPMask: to.Ptr("1.1.1.1"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 						IPMask: to.Ptr("1.1.1.2"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 						IPMask: to.Ptr("1.1.1.3"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 						IPMask: to.Ptr("1.1.1.4"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armeventhub.NetworkRuleIPActionAllow),
	// 						IPMask: to.Ptr("1.1.1.5"),
	// 				}},
	// 				VirtualNetworkRules: []*armeventhub.NWRuleSetVirtualNetworkRules{
	// 					{
	// 						IgnoreMissingVnetServiceEndpoint: to.Ptr(true),
	// 						Subnet: &armeventhub.Subnet{
	// 							ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
	// 						},
	// 					},
	// 					{
	// 						IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 						Subnet: &armeventhub.Subnet{
	// 							ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
	// 						},
	// 					},
	// 					{
	// 						IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 						Subnet: &armeventhub.Subnet{
	// 							ID: to.Ptr("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
	// 						},
	// 				}},
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleListAll.json
func ExampleNamespacesClient_NewListAuthorizationRulesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListAuthorizationRulesPager("ArunMonocle", "sdk-Namespace-2702", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AuthorizationRuleListResult = armeventhub.AuthorizationRuleListResult{
		// 	Value: []*armeventhub.AuthorizationRule{
		// 		{
		// 			Name: to.Ptr("RootManageSharedAccessKey"),
		// 			Type: to.Ptr("Microsoft.EventHub/Namespaces/AuthorizationRules"),
		// 			ID: to.Ptr("/subscriptions/5f750a97-50d9-4e36-8081-c9ee4c0210d4/resourceGroups/ArunMonocle/providers/Microsoft.EventHub/namespaces/sdk-Namespace-2702/AuthorizationRules?api-version=2017-04-01/RootManageSharedAccessKey"),
		// 			Properties: &armeventhub.AuthorizationRuleProperties{
		// 				Rights: []*armeventhub.AccessRights{
		// 					to.Ptr(armeventhub.AccessRightsListen),
		// 					to.Ptr(armeventhub.AccessRightsManage),
		// 					to.Ptr(armeventhub.AccessRightsSend)},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("sdk-Authrules-1746"),
		// 				Type: to.Ptr("Microsoft.EventHub/Namespaces/AuthorizationRules"),
		// 				ID: to.Ptr("/subscriptions/5f750a97-50d9-4e36-8081-c9ee4c0210d4/resourceGroups/ArunMonocle/providers/Microsoft.EventHub/namespaces/sdk-Namespace-2702/AuthorizationRules?api-version=2017-04-01/sdk-Authrules-1746"),
		// 				Properties: &armeventhub.AuthorizationRuleProperties{
		// 					Rights: []*armeventhub.AccessRights{
		// 						to.Ptr(armeventhub.AccessRightsListen),
		// 						to.Ptr(armeventhub.AccessRightsSend)},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleCreate.json
func ExampleNamespacesClient_CreateOrUpdateAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().CreateOrUpdateAuthorizationRule(ctx, "ArunMonocle", "sdk-Namespace-2702", "sdk-Authrules-1746", armeventhub.AuthorizationRule{
		Properties: &armeventhub.AuthorizationRuleProperties{
			Rights: []*armeventhub.AccessRights{
				to.Ptr(armeventhub.AccessRightsListen),
				to.Ptr(armeventhub.AccessRightsSend)},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AuthorizationRule = armeventhub.AuthorizationRule{
	// 	Name: to.Ptr("sdk-Authrules-1746"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/AuthorizationRules"),
	// 	ID: to.Ptr("/subscriptions/5f750a97-50d9-4e36-8081-c9ee4c0210d4/resourceGroups/ArunMonocle/providers/Microsoft.EventHub/namespaces/sdk-Namespace-2702/AuthorizationRules/sdk-Authrules-1746"),
	// 	Properties: &armeventhub.AuthorizationRuleProperties{
	// 		Rights: []*armeventhub.AccessRights{
	// 			to.Ptr(armeventhub.AccessRightsListen),
	// 			to.Ptr(armeventhub.AccessRightsSend)},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleDelete.json
func ExampleNamespacesClient_DeleteAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNamespacesClient().DeleteAuthorizationRule(ctx, "ArunMonocle", "sdk-Namespace-8980", "sdk-Authrules-8929", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleGet.json
func ExampleNamespacesClient_GetAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().GetAuthorizationRule(ctx, "ArunMonocle", "sdk-Namespace-2702", "sdk-Authrules-1746", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AuthorizationRule = armeventhub.AuthorizationRule{
	// 	Name: to.Ptr("sdk-Authrules-1746"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/AuthorizationRules"),
	// 	ID: to.Ptr("/subscriptions/5f750a97-50d9-4e36-8081-c9ee4c0210d4/resourceGroups/ArunMonocle/providers/Microsoft.EventHub/namespaces/sdk-Namespace-2702/AuthorizationRules/sdk-Authrules-1746"),
	// 	Properties: &armeventhub.AuthorizationRuleProperties{
	// 		Rights: []*armeventhub.AccessRights{
	// 			to.Ptr(armeventhub.AccessRightsListen),
	// 			to.Ptr(armeventhub.AccessRightsSend)},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleListKey.json
func ExampleNamespacesClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().ListKeys(ctx, "ArunMonocle", "sdk-Namespace-2702", "sdk-Authrules-1746", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessKeys = armeventhub.AccessKeys{
	// 	KeyName: to.Ptr("sdk-Authrules-1746"),
	// 	PrimaryConnectionString: to.Ptr("Endpoint=sb://sdk-namespace-2702.servicebus.windows-int.net/;SharedAccessKeyName=sdk-Authrules-1746;SharedAccessKey=############################################"),
	// 	PrimaryKey: to.Ptr("############################################"),
	// 	SecondaryConnectionString: to.Ptr("Endpoint=sb://sdk-namespace-2702.servicebus.windows-int.net/;SharedAccessKeyName=sdk-Authrules-1746;SharedAccessKey=############################################"),
	// 	SecondaryKey: to.Ptr("############################################"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceAuthorizationRuleRegenerateKey.json
func ExampleNamespacesClient_RegenerateKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().RegenerateKeys(ctx, "ArunMonocle", "sdk-Namespace-8980", "sdk-Authrules-8929", armeventhub.RegenerateAccessKeyParameters{
		KeyType: to.Ptr(armeventhub.KeyTypePrimaryKey),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessKeys = armeventhub.AccessKeys{
	// 	KeyName: to.Ptr("sdk-Authrules-8929"),
	// 	PrimaryConnectionString: to.Ptr("Endpoint=sb://sdk-namespace-8980.servicebus.windows-int.net/;SharedAccessKeyName=sdk-Authrules-8929;SharedAccessKey=############################################"),
	// 	PrimaryKey: to.Ptr("############################################"),
	// 	SecondaryConnectionString: to.Ptr("Endpoint=sb://sdk-namespace-8980.servicebus.windows-int.net/;SharedAccessKeyName=sdk-Authrules-8929;SharedAccessKey=############################################"),
	// 	SecondaryKey: to.Ptr("############################################"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-10-01-preview/examples/NameSpaces/EHNameSpaceCheckNameAvailability.json
func ExampleNamespacesClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().CheckNameAvailability(ctx, armeventhub.CheckNameAvailabilityParameter{
		Name: to.Ptr("sdk-Namespace-8458"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armeventhub.CheckNameAvailabilityResult{
	// 	Message: to.Ptr(""),
	// 	NameAvailable: to.Ptr(true),
	// 	Reason: to.Ptr(armeventhub.UnavailableReasonNone),
	// }
}
