//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// EmergingIssuesServer is a fake server for instances of the armresourcehealth.EmergingIssuesClient type.
type EmergingIssuesServer struct {
	// Get is the fake for method EmergingIssuesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, issueName armresourcehealth.IssueNameParameter, options *armresourcehealth.EmergingIssuesClientGetOptions) (resp azfake.Responder[armresourcehealth.EmergingIssuesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method EmergingIssuesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armresourcehealth.EmergingIssuesClientListOptions) (resp azfake.PagerResponder[armresourcehealth.EmergingIssuesClientListResponse])
}

// NewEmergingIssuesServerTransport creates a new instance of EmergingIssuesServerTransport with the provided implementation.
// The returned EmergingIssuesServerTransport instance is connected to an instance of armresourcehealth.EmergingIssuesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEmergingIssuesServerTransport(srv *EmergingIssuesServer) *EmergingIssuesServerTransport {
	return &EmergingIssuesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armresourcehealth.EmergingIssuesClientListResponse]](),
	}
}

// EmergingIssuesServerTransport connects instances of armresourcehealth.EmergingIssuesClient to instances of EmergingIssuesServer.
// Don't use this type directly, use NewEmergingIssuesServerTransport instead.
type EmergingIssuesServerTransport struct {
	srv          *EmergingIssuesServer
	newListPager *tracker[azfake.PagerResponder[armresourcehealth.EmergingIssuesClientListResponse]]
}

// Do implements the policy.Transporter interface for EmergingIssuesServerTransport.
func (e *EmergingIssuesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EmergingIssuesClient.Get":
		resp, err = e.dispatchGet(req)
	case "EmergingIssuesClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EmergingIssuesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ResourceHealth/emergingIssues/(?P<issueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	issueNameParam, err := parseWithCast(matches[regex.SubexpIndex("issueName")], func(v string) (armresourcehealth.IssueNameParameter, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armresourcehealth.IssueNameParameter(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), issueNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EmergingIssuesGetResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EmergingIssuesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		resp := e.srv.NewListPager(nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armresourcehealth.EmergingIssuesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}
