// Code generated by ./gen/main.go. DO NOT EDIT.

package setof

import (
	"bytes"
	"fmt"
	"testing"

	"github.com/tinylib/msgp/msgp"
)

func TestString_RoundTrip(t *testing.T) {
	set := make(String)
	set["val0"] = struct{}{}
	set["val1"] = struct{}{}
	set["val2"] = struct{}{}
	set["val3"] = struct{}{}
	set["val4"] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded String
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled String
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestString_AsSlice(t *testing.T) {
	set := make(String)
	set["val0"] = struct{}{}
	set["val1"] = struct{}{}
	set["val2"] = struct{}{}
	set["val3"] = struct{}{}
	set["val4"] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[string]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestString_FromSlice(t *testing.T) {
	slice := []string{"val0", "val1", "val2", "val3", "val4"}
	set := StringFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestString_NilHandling(t *testing.T) {
	var nilSet String

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded String
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled String
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := StringFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestString_EmptySet(t *testing.T) {
	set := make(String)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded String
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled String
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestStringSorted_RoundTrip(t *testing.T) {
	set := make(StringSorted)
	set["val0"] = struct{}{}
	set["val1"] = struct{}{}
	set["val2"] = struct{}{}
	set["val3"] = struct{}{}
	set["val4"] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded StringSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled StringSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestStringSorted_AsSlice(t *testing.T) {
	set := make(StringSorted)
	set["val0"] = struct{}{}
	set["val1"] = struct{}{}
	set["val2"] = struct{}{}
	set["val3"] = struct{}{}
	set["val4"] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[string]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestStringSorted_FromSlice(t *testing.T) {
	slice := []string{"val0", "val1", "val2", "val3", "val4"}
	set := StringSortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestStringSorted_NilHandling(t *testing.T) {
	var nilSet StringSorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded StringSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled StringSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := StringSortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestStringSorted_EmptySet(t *testing.T) {
	set := make(StringSorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded StringSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled StringSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkString_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(String)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkString_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(String)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded String
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkString_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(String)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkString_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(String)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded String
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkString_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(String)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkString_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]string, size)
			for i := 0; i < size; i++ {
				slice[i] = fmt.Sprintf("val%d", i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = StringFromSlice(slice)
			}
		})
	}
}

func BenchmarkStringSorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(StringSorted)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkStringSorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(StringSorted)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded StringSorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkStringSorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(StringSorted)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkStringSorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(StringSorted)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded StringSorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkStringSorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(StringSorted)
			for i := 0; i < size; i++ {
				set[fmt.Sprintf("val%d", i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkStringSorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]string, size)
			for i := 0; i < size; i++ {
				slice[i] = fmt.Sprintf("val%d", i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = StringSortedFromSlice(slice)
			}
		})
	}
}

func TestInt_RoundTrip(t *testing.T) {
	set := make(Int)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt_AsSlice(t *testing.T) {
	set := make(Int)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt_FromSlice(t *testing.T) {
	slice := []int{0, 1, 2, 3, 4}
	set := IntFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt_NilHandling(t *testing.T) {
	var nilSet Int

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := IntFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt_EmptySet(t *testing.T) {
	set := make(Int)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestIntSorted_RoundTrip(t *testing.T) {
	set := make(IntSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded IntSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled IntSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestIntSorted_AsSlice(t *testing.T) {
	set := make(IntSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestIntSorted_FromSlice(t *testing.T) {
	slice := []int{0, 1, 2, 3, 4}
	set := IntSortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestIntSorted_NilHandling(t *testing.T) {
	var nilSet IntSorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded IntSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled IntSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := IntSortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestIntSorted_EmptySet(t *testing.T) {
	set := make(IntSorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded IntSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled IntSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkInt_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int, size)
			for i := 0; i < size; i++ {
				slice[i] = int(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = IntFromSlice(slice)
			}
		})
	}
}

func BenchmarkIntSorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(IntSorted)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkIntSorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(IntSorted)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded IntSorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkIntSorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(IntSorted)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkIntSorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(IntSorted)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded IntSorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkIntSorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(IntSorted)
			for i := 0; i < size; i++ {
				set[int(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkIntSorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int, size)
			for i := 0; i < size; i++ {
				slice[i] = int(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = IntSortedFromSlice(slice)
			}
		})
	}
}

func TestUint_RoundTrip(t *testing.T) {
	set := make(Uint)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint_AsSlice(t *testing.T) {
	set := make(Uint)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint_FromSlice(t *testing.T) {
	slice := []uint{0, 1, 2, 3, 4}
	set := UintFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint_NilHandling(t *testing.T) {
	var nilSet Uint

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := UintFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint_EmptySet(t *testing.T) {
	set := make(Uint)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestUintSorted_RoundTrip(t *testing.T) {
	set := make(UintSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded UintSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled UintSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUintSorted_AsSlice(t *testing.T) {
	set := make(UintSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUintSorted_FromSlice(t *testing.T) {
	slice := []uint{0, 1, 2, 3, 4}
	set := UintSortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUintSorted_NilHandling(t *testing.T) {
	var nilSet UintSorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded UintSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled UintSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := UintSortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUintSorted_EmptySet(t *testing.T) {
	set := make(UintSorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded UintSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled UintSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkUint_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint, size)
			for i := 0; i < size; i++ {
				slice[i] = uint(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = UintFromSlice(slice)
			}
		})
	}
}

func BenchmarkUintSorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(UintSorted)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUintSorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(UintSorted)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded UintSorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUintSorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(UintSorted)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUintSorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(UintSorted)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded UintSorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUintSorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(UintSorted)
			for i := 0; i < size; i++ {
				set[uint(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUintSorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint, size)
			for i := 0; i < size; i++ {
				slice[i] = uint(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = UintSortedFromSlice(slice)
			}
		})
	}
}

func TestByte_RoundTrip(t *testing.T) {
	set := make(Byte)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Byte
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Byte
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestByte_AsSlice(t *testing.T) {
	set := make(Byte)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[byte]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestByte_FromSlice(t *testing.T) {
	slice := []byte{0, 1, 2, 3, 4}
	set := ByteFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestByte_NilHandling(t *testing.T) {
	var nilSet Byte

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Byte
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Byte
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := ByteFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestByte_EmptySet(t *testing.T) {
	set := make(Byte)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Byte
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Byte
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestByteSorted_RoundTrip(t *testing.T) {
	set := make(ByteSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded ByteSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled ByteSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestByteSorted_AsSlice(t *testing.T) {
	set := make(ByteSorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[byte]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestByteSorted_FromSlice(t *testing.T) {
	slice := []byte{0, 1, 2, 3, 4}
	set := ByteSortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestByteSorted_NilHandling(t *testing.T) {
	var nilSet ByteSorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded ByteSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled ByteSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := ByteSortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestByteSorted_EmptySet(t *testing.T) {
	set := make(ByteSorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded ByteSorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled ByteSorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkByte_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Byte)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkByte_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Byte)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Byte
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkByte_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Byte)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkByte_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Byte)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Byte
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkByte_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Byte)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkByte_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]byte, size)
			for i := 0; i < size; i++ {
				slice[i] = byte(i % 256)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = ByteFromSlice(slice)
			}
		})
	}
}

func BenchmarkByteSorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(ByteSorted)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkByteSorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(ByteSorted)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded ByteSorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkByteSorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(ByteSorted)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkByteSorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(ByteSorted)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded ByteSorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkByteSorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(ByteSorted)
			for i := 0; i < size; i++ {
				set[byte(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkByteSorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]byte, size)
			for i := 0; i < size; i++ {
				slice[i] = byte(i % 256)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = ByteSortedFromSlice(slice)
			}
		})
	}
}

func TestInt8_RoundTrip(t *testing.T) {
	set := make(Int8)
	set[-128] = struct{}{}
	set[-127] = struct{}{}
	set[-126] = struct{}{}
	set[-125] = struct{}{}
	set[-124] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt8_AsSlice(t *testing.T) {
	set := make(Int8)
	set[-128] = struct{}{}
	set[-127] = struct{}{}
	set[-126] = struct{}{}
	set[-125] = struct{}{}
	set[-124] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int8]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt8_FromSlice(t *testing.T) {
	slice := []int8{-128, -127, -126, -125, -124}
	set := Int8FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt8_NilHandling(t *testing.T) {
	var nilSet Int8

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int8FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt8_EmptySet(t *testing.T) {
	set := make(Int8)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestInt8Sorted_RoundTrip(t *testing.T) {
	set := make(Int8Sorted)
	set[-128] = struct{}{}
	set[-127] = struct{}{}
	set[-126] = struct{}{}
	set[-125] = struct{}{}
	set[-124] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt8Sorted_AsSlice(t *testing.T) {
	set := make(Int8Sorted)
	set[-128] = struct{}{}
	set[-127] = struct{}{}
	set[-126] = struct{}{}
	set[-125] = struct{}{}
	set[-124] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int8]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt8Sorted_FromSlice(t *testing.T) {
	slice := []int8{-128, -127, -126, -125, -124}
	set := Int8SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt8Sorted_NilHandling(t *testing.T) {
	var nilSet Int8Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int8SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt8Sorted_EmptySet(t *testing.T) {
	set := make(Int8Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkInt8_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt8_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int8
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt8_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt8_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int8
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt8_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt8_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int8, size)
			for i := 0; i < size; i++ {
				slice[i] = int8((i % 256) - 128)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int8FromSlice(slice)
			}
		})
	}
}

func BenchmarkInt8Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8Sorted)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt8Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8Sorted)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int8Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt8Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8Sorted)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt8Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8Sorted)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int8Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt8Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int8Sorted)
			for i := 0; i < size; i++ {
				set[int8((i%256)-128)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt8Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int8, size)
			for i := 0; i < size; i++ {
				slice[i] = int8((i % 256) - 128)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int8SortedFromSlice(slice)
			}
		})
	}
}

func TestUint8_RoundTrip(t *testing.T) {
	set := make(Uint8)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint8_AsSlice(t *testing.T) {
	set := make(Uint8)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint8]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint8_FromSlice(t *testing.T) {
	slice := []uint8{0, 1, 2, 3, 4}
	set := Uint8FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint8_NilHandling(t *testing.T) {
	var nilSet Uint8

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint8FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint8_EmptySet(t *testing.T) {
	set := make(Uint8)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint8
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint8
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestUint8Sorted_RoundTrip(t *testing.T) {
	set := make(Uint8Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint8Sorted_AsSlice(t *testing.T) {
	set := make(Uint8Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint8]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint8Sorted_FromSlice(t *testing.T) {
	slice := []uint8{0, 1, 2, 3, 4}
	set := Uint8SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint8Sorted_NilHandling(t *testing.T) {
	var nilSet Uint8Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint8SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint8Sorted_EmptySet(t *testing.T) {
	set := make(Uint8Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint8Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint8Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkUint8_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint8_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint8
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint8_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint8_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint8
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint8_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint8_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint8, size)
			for i := 0; i < size; i++ {
				slice[i] = uint8(i % 256)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint8FromSlice(slice)
			}
		})
	}
}

func BenchmarkUint8Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8Sorted)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint8Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8Sorted)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint8Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint8Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8Sorted)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint8Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8Sorted)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint8Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint8Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint8Sorted)
			for i := 0; i < size; i++ {
				set[uint8(i%256)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint8Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint8, size)
			for i := 0; i < size; i++ {
				slice[i] = uint8(i % 256)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint8SortedFromSlice(slice)
			}
		})
	}
}

func TestInt16_RoundTrip(t *testing.T) {
	set := make(Int16)
	set[-32768] = struct{}{}
	set[-32767] = struct{}{}
	set[-32766] = struct{}{}
	set[-32765] = struct{}{}
	set[-32764] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt16_AsSlice(t *testing.T) {
	set := make(Int16)
	set[-32768] = struct{}{}
	set[-32767] = struct{}{}
	set[-32766] = struct{}{}
	set[-32765] = struct{}{}
	set[-32764] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int16]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt16_FromSlice(t *testing.T) {
	slice := []int16{-32768, -32767, -32766, -32765, -32764}
	set := Int16FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt16_NilHandling(t *testing.T) {
	var nilSet Int16

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int16FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt16_EmptySet(t *testing.T) {
	set := make(Int16)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestInt16Sorted_RoundTrip(t *testing.T) {
	set := make(Int16Sorted)
	set[-32768] = struct{}{}
	set[-32767] = struct{}{}
	set[-32766] = struct{}{}
	set[-32765] = struct{}{}
	set[-32764] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt16Sorted_AsSlice(t *testing.T) {
	set := make(Int16Sorted)
	set[-32768] = struct{}{}
	set[-32767] = struct{}{}
	set[-32766] = struct{}{}
	set[-32765] = struct{}{}
	set[-32764] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int16]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt16Sorted_FromSlice(t *testing.T) {
	slice := []int16{-32768, -32767, -32766, -32765, -32764}
	set := Int16SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt16Sorted_NilHandling(t *testing.T) {
	var nilSet Int16Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int16SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt16Sorted_EmptySet(t *testing.T) {
	set := make(Int16Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkInt16_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt16_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int16
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt16_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt16_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int16
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt16_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt16_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int16, size)
			for i := 0; i < size; i++ {
				slice[i] = int16((i % 65536) - 32768)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int16FromSlice(slice)
			}
		})
	}
}

func BenchmarkInt16Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16Sorted)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt16Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16Sorted)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int16Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt16Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16Sorted)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt16Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16Sorted)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int16Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt16Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int16Sorted)
			for i := 0; i < size; i++ {
				set[int16((i%65536)-32768)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt16Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int16, size)
			for i := 0; i < size; i++ {
				slice[i] = int16((i % 65536) - 32768)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int16SortedFromSlice(slice)
			}
		})
	}
}

func TestUint16_RoundTrip(t *testing.T) {
	set := make(Uint16)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint16_AsSlice(t *testing.T) {
	set := make(Uint16)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint16]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint16_FromSlice(t *testing.T) {
	slice := []uint16{0, 1, 2, 3, 4}
	set := Uint16FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint16_NilHandling(t *testing.T) {
	var nilSet Uint16

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint16FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint16_EmptySet(t *testing.T) {
	set := make(Uint16)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint16
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint16
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestUint16Sorted_RoundTrip(t *testing.T) {
	set := make(Uint16Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint16Sorted_AsSlice(t *testing.T) {
	set := make(Uint16Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint16]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint16Sorted_FromSlice(t *testing.T) {
	slice := []uint16{0, 1, 2, 3, 4}
	set := Uint16SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint16Sorted_NilHandling(t *testing.T) {
	var nilSet Uint16Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint16SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint16Sorted_EmptySet(t *testing.T) {
	set := make(Uint16Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint16Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint16Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkUint16_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint16_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint16
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint16_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint16_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint16
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint16_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint16_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint16, size)
			for i := 0; i < size; i++ {
				slice[i] = uint16(i % 65536)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint16FromSlice(slice)
			}
		})
	}
}

func BenchmarkUint16Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16Sorted)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint16Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16Sorted)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint16Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint16Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16Sorted)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint16Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16Sorted)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint16Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint16Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint16Sorted)
			for i := 0; i < size; i++ {
				set[uint16(i%65536)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint16Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint16, size)
			for i := 0; i < size; i++ {
				slice[i] = uint16(i % 65536)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint16SortedFromSlice(slice)
			}
		})
	}
}

func TestInt32_RoundTrip(t *testing.T) {
	set := make(Int32)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt32_AsSlice(t *testing.T) {
	set := make(Int32)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt32_FromSlice(t *testing.T) {
	slice := []int32{0, 1, 2, 3, 4}
	set := Int32FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt32_NilHandling(t *testing.T) {
	var nilSet Int32

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int32FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt32_EmptySet(t *testing.T) {
	set := make(Int32)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestInt32Sorted_RoundTrip(t *testing.T) {
	set := make(Int32Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt32Sorted_AsSlice(t *testing.T) {
	set := make(Int32Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt32Sorted_FromSlice(t *testing.T) {
	slice := []int32{0, 1, 2, 3, 4}
	set := Int32SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt32Sorted_NilHandling(t *testing.T) {
	var nilSet Int32Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int32SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt32Sorted_EmptySet(t *testing.T) {
	set := make(Int32Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkInt32_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt32_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int32
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt32_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt32_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int32
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt32_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt32_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int32, size)
			for i := 0; i < size; i++ {
				slice[i] = int32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int32FromSlice(slice)
			}
		})
	}
}

func BenchmarkInt32Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32Sorted)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt32Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32Sorted)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int32Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt32Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32Sorted)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt32Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32Sorted)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int32Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt32Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int32Sorted)
			for i := 0; i < size; i++ {
				set[int32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt32Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int32, size)
			for i := 0; i < size; i++ {
				slice[i] = int32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int32SortedFromSlice(slice)
			}
		})
	}
}

func TestUint32_RoundTrip(t *testing.T) {
	set := make(Uint32)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint32_AsSlice(t *testing.T) {
	set := make(Uint32)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint32_FromSlice(t *testing.T) {
	slice := []uint32{0, 1, 2, 3, 4}
	set := Uint32FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint32_NilHandling(t *testing.T) {
	var nilSet Uint32

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint32FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint32_EmptySet(t *testing.T) {
	set := make(Uint32)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestUint32Sorted_RoundTrip(t *testing.T) {
	set := make(Uint32Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint32Sorted_AsSlice(t *testing.T) {
	set := make(Uint32Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint32Sorted_FromSlice(t *testing.T) {
	slice := []uint32{0, 1, 2, 3, 4}
	set := Uint32SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint32Sorted_NilHandling(t *testing.T) {
	var nilSet Uint32Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint32SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint32Sorted_EmptySet(t *testing.T) {
	set := make(Uint32Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkUint32_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint32_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint32
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint32_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint32_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint32
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint32_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint32_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint32, size)
			for i := 0; i < size; i++ {
				slice[i] = uint32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint32FromSlice(slice)
			}
		})
	}
}

func BenchmarkUint32Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32Sorted)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint32Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32Sorted)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint32Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint32Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32Sorted)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint32Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32Sorted)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint32Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint32Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint32Sorted)
			for i := 0; i < size; i++ {
				set[uint32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint32Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint32, size)
			for i := 0; i < size; i++ {
				slice[i] = uint32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint32SortedFromSlice(slice)
			}
		})
	}
}

func TestInt64_RoundTrip(t *testing.T) {
	set := make(Int64)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt64_AsSlice(t *testing.T) {
	set := make(Int64)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt64_FromSlice(t *testing.T) {
	slice := []int64{0, 1, 2, 3, 4}
	set := Int64FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt64_NilHandling(t *testing.T) {
	var nilSet Int64

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int64FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt64_EmptySet(t *testing.T) {
	set := make(Int64)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestInt64Sorted_RoundTrip(t *testing.T) {
	set := make(Int64Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Int64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Int64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestInt64Sorted_AsSlice(t *testing.T) {
	set := make(Int64Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[int64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestInt64Sorted_FromSlice(t *testing.T) {
	slice := []int64{0, 1, 2, 3, 4}
	set := Int64SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestInt64Sorted_NilHandling(t *testing.T) {
	var nilSet Int64Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Int64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Int64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Int64SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestInt64Sorted_EmptySet(t *testing.T) {
	set := make(Int64Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Int64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Int64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkInt64_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt64_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int64
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt64_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt64_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int64
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt64_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt64_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int64, size)
			for i := 0; i < size; i++ {
				slice[i] = int64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int64FromSlice(slice)
			}
		})
	}
}

func BenchmarkInt64Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64Sorted)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkInt64Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64Sorted)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Int64Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkInt64Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64Sorted)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt64Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64Sorted)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Int64Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkInt64Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Int64Sorted)
			for i := 0; i < size; i++ {
				set[int64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkInt64Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]int64, size)
			for i := 0; i < size; i++ {
				slice[i] = int64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Int64SortedFromSlice(slice)
			}
		})
	}
}

func TestUint64_RoundTrip(t *testing.T) {
	set := make(Uint64)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint64_AsSlice(t *testing.T) {
	set := make(Uint64)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint64_FromSlice(t *testing.T) {
	slice := []uint64{0, 1, 2, 3, 4}
	set := Uint64FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint64_NilHandling(t *testing.T) {
	var nilSet Uint64

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint64FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint64_EmptySet(t *testing.T) {
	set := make(Uint64)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestUint64Sorted_RoundTrip(t *testing.T) {
	set := make(Uint64Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Uint64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Uint64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestUint64Sorted_AsSlice(t *testing.T) {
	set := make(Uint64Sorted)
	set[0] = struct{}{}
	set[1] = struct{}{}
	set[2] = struct{}{}
	set[3] = struct{}{}
	set[4] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[uint64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestUint64Sorted_FromSlice(t *testing.T) {
	slice := []uint64{0, 1, 2, 3, 4}
	set := Uint64SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestUint64Sorted_NilHandling(t *testing.T) {
	var nilSet Uint64Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Uint64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Uint64SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestUint64Sorted_EmptySet(t *testing.T) {
	set := make(Uint64Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Uint64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Uint64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkUint64_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint64_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint64
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint64_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint64_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint64
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint64_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint64_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint64, size)
			for i := 0; i < size; i++ {
				slice[i] = uint64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint64FromSlice(slice)
			}
		})
	}
}

func BenchmarkUint64Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64Sorted)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkUint64Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64Sorted)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Uint64Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkUint64Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64Sorted)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint64Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64Sorted)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Uint64Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkUint64Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Uint64Sorted)
			for i := 0; i < size; i++ {
				set[uint64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkUint64Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]uint64, size)
			for i := 0; i < size; i++ {
				slice[i] = uint64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Uint64SortedFromSlice(slice)
			}
		})
	}
}

func TestFloat64_RoundTrip(t *testing.T) {
	set := make(Float64)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Float64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Float64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestFloat64_AsSlice(t *testing.T) {
	set := make(Float64)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[float64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestFloat64_FromSlice(t *testing.T) {
	slice := []float64{0.0, 1.0, 2.0, 3.0, 4.0}
	set := Float64FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestFloat64_NilHandling(t *testing.T) {
	var nilSet Float64

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Float64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Float64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Float64FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestFloat64_EmptySet(t *testing.T) {
	set := make(Float64)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Float64
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Float64
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestFloat64Sorted_RoundTrip(t *testing.T) {
	set := make(Float64Sorted)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Float64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Float64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestFloat64Sorted_AsSlice(t *testing.T) {
	set := make(Float64Sorted)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[float64]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestFloat64Sorted_FromSlice(t *testing.T) {
	slice := []float64{0.0, 1.0, 2.0, 3.0, 4.0}
	set := Float64SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestFloat64Sorted_NilHandling(t *testing.T) {
	var nilSet Float64Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Float64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Float64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Float64SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestFloat64Sorted_EmptySet(t *testing.T) {
	set := make(Float64Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Float64Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Float64Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkFloat64_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkFloat64_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Float64
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkFloat64_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat64_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Float64
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat64_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkFloat64_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]float64, size)
			for i := 0; i < size; i++ {
				slice[i] = float64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Float64FromSlice(slice)
			}
		})
	}
}

func BenchmarkFloat64Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64Sorted)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkFloat64Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64Sorted)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Float64Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkFloat64Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64Sorted)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat64Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64Sorted)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Float64Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat64Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float64Sorted)
			for i := 0; i < size; i++ {
				set[float64(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkFloat64Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]float64, size)
			for i := 0; i < size; i++ {
				slice[i] = float64(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Float64SortedFromSlice(slice)
			}
		})
	}
}

func TestFloat32_RoundTrip(t *testing.T) {
	set := make(Float32)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Float32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Float32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestFloat32_AsSlice(t *testing.T) {
	set := make(Float32)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[float32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestFloat32_FromSlice(t *testing.T) {
	slice := []float32{0.0, 1.0, 2.0, 3.0, 4.0}
	set := Float32FromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestFloat32_NilHandling(t *testing.T) {
	var nilSet Float32

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Float32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Float32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Float32FromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestFloat32_EmptySet(t *testing.T) {
	set := make(Float32)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Float32
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Float32
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func TestFloat32Sorted_RoundTrip(t *testing.T) {
	set := make(Float32Sorted)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	// Test EncodeMsg/DecodeMsg
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed: %v", err)
	}
	writer.Flush()

	reader := msgp.NewReader(&buf)
	var decoded Float32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed: %v", err)
	}

	if len(set) != len(decoded) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(decoded))
	}

	for k := range set {
		if _, ok := decoded[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}

	// Test MarshalMsg/UnmarshalMsg
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed: %v", err)
	}

	var unmarshaled Float32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed: %v", err)
	}

	if len(set) != len(unmarshaled) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(unmarshaled))
	}

	for k := range set {
		if _, ok := unmarshaled[k]; !ok {
			t.Fatalf("missing key: %v", k)
		}
	}
}

func TestFloat32Sorted_AsSlice(t *testing.T) {
	set := make(Float32Sorted)
	set[0.0] = struct{}{}
	set[1.0] = struct{}{}
	set[2.0] = struct{}{}
	set[3.0] = struct{}{}
	set[4.0] = struct{}{}

	slice := set.AsSlice()
	if len(slice) != len(set) {
		t.Fatalf("length mismatch: expected %d, got %d", len(set), len(slice))
	}

	found := make(map[float32]bool)
	for _, v := range slice {
		found[v] = true
	}

	for k := range set {
		if !found[k] {
			t.Fatalf("missing key in slice: %v", k)
		}
	}
}

func TestFloat32Sorted_FromSlice(t *testing.T) {
	slice := []float32{0.0, 1.0, 2.0, 3.0, 4.0}
	set := Float32SortedFromSlice(slice)

	if len(set) != len(slice) {
		t.Fatalf("length mismatch: expected %d, got %d", len(slice), len(set))
	}

	for _, v := range slice {
		if _, ok := set[v]; !ok {
			t.Fatalf("missing key: %v", v)
		}
	}
}

func TestFloat32Sorted_NilHandling(t *testing.T) {
	var nilSet Float32Sorted

	// Test nil encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := nilSet.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for nil: %v", err)
	}
	writer.Flush()

	// Test nil decoding
	reader := msgp.NewReader(&buf)
	var decoded Float32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for nil: %v", err)
	}

	if decoded != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test nil marshaling
	data, err := nilSet.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for nil: %v", err)
	}

	// Test nil unmarshaling
	var unmarshaled Float32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for nil: %v", err)
	}

	if unmarshaled != nil {
		t.Fatal("expected nil, got non-nil")
	}

	// Test AsSlice on nil
	slice := nilSet.AsSlice()
	if slice != nil {
		t.Fatal("expected nil slice, got non-nil")
	}

	// Test FromSlice with nil
	fromNilSlice := Float32SortedFromSlice(nil)
	if fromNilSlice != nil {
		t.Fatal("expected nil from nil slice, got non-nil")
	}
}

func TestFloat32Sorted_EmptySet(t *testing.T) {
	set := make(Float32Sorted)

	// Test empty set encoding
	var buf bytes.Buffer
	writer := msgp.NewWriter(&buf)
	err := set.EncodeMsg(writer)
	if err != nil {
		t.Fatalf("EncodeMsg failed for empty: %v", err)
	}
	writer.Flush()

	// Test empty set decoding
	reader := msgp.NewReader(&buf)
	var decoded Float32Sorted
	err = decoded.DecodeMsg(reader)
	if err != nil {
		t.Fatalf("DecodeMsg failed for empty: %v", err)
	}

	if len(decoded) != 0 {
		t.Fatalf("expected empty set, got length %d", len(decoded))
	}

	// Test empty set marshaling
	data, err := set.MarshalMsg(nil)
	if err != nil {
		t.Fatalf("MarshalMsg failed for empty: %v", err)
	}

	// Test empty set unmarshaling
	var unmarshaled Float32Sorted
	_, err = unmarshaled.UnmarshalMsg(data)
	if err != nil {
		t.Fatalf("UnmarshalMsg failed for empty: %v", err)
	}

	if len(unmarshaled) != 0 {
		t.Fatalf("expected empty set, got length %d", len(unmarshaled))
	}
}

func BenchmarkFloat32_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkFloat32_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Float32
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkFloat32_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat32_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Float32
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat32_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkFloat32_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]float32, size)
			for i := 0; i < size; i++ {
				slice[i] = float32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Float32FromSlice(slice)
			}
		})
	}
}

func BenchmarkFloat32Sorted_EncodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32Sorted)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				buf.Reset()
				writer.Reset(&buf)
				set.EncodeMsg(writer)
				writer.Flush()
			}
		})
	}
}

func BenchmarkFloat32Sorted_DecodeMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32Sorted)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			var buf bytes.Buffer
			writer := msgp.NewWriter(&buf)
			set.EncodeMsg(writer)
			writer.Flush()
			encoded := buf.Bytes()

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				reader := msgp.NewReader(bytes.NewReader(encoded))
				var decoded Float32Sorted
				decoded.DecodeMsg(reader)
			}
		})
	}
}

func BenchmarkFloat32Sorted_MarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32Sorted)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, err := set.MarshalMsg(nil)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat32Sorted_UnmarshalMsg(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32Sorted)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			data, _ := set.MarshalMsg(nil)

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				var decoded Float32Sorted
				_, err := decoded.UnmarshalMsg(data)
				if err != nil {
					b.Fatal(err)
				}
			}
		})
	}
}

func BenchmarkFloat32Sorted_AsSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			set := make(Float32Sorted)
			for i := 0; i < size; i++ {
				set[float32(i)] = struct{}{}
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = set.AsSlice()
			}
		})
	}
}

func BenchmarkFloat32Sorted_FromSlice(b *testing.B) {
	sizes := []int{10, 100, 1000}

	for _, size := range sizes {
		b.Run(fmt.Sprintf("%d", size), func(b *testing.B) {
			slice := make([]float32, size)
			for i := 0; i < size; i++ {
				slice[i] = float32(i)
			}

			b.ReportAllocs()
			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_ = Float32SortedFromSlice(slice)
			}
		})
	}
}
