/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

#ifndef _LOG_H
#define _LOG_H

#include <config.h>
#include <state.h>
#include <stdio.h>

#define INFO(...) log_write(state, __VA_ARGS__)
#define DEBUG(...) if (state->flag & STATE_DEBUG) INFO(__VA_ARGS__)
#define ERROR(...) { fprintf(stderr, "%s: ", PACKAGE_NAME); fprintf(stderr, __VA_ARGS__); }

int log_open(state_t *state, const char *filename);
int log_close(state_t *state);
int log_write(state_t *state, const char *fmt, ...);

#endif /* _LOG_H */
