/* Generated by wayland-scanner 1.23.1 */

#ifndef UKUI_WINDOW_MANAGEMENT_CLIENT_PROTOCOL_H
#define UKUI_WINDOW_MANAGEMENT_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ukui_window_management The ukui_window_management protocol
 * @section page_ifaces_ukui_window_management Interfaces
 * - @subpage page_iface_ukui_window_management - application windows management
 * - @subpage page_iface_ukui_window - interface to control application windows
 * - @subpage page_iface_org_ukui_activation_feedback - activation feedback
 * - @subpage page_iface_org_ukui_activation - 
 * @section page_copyright_ukui_window_management Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
 * SPDX-FileCopyrightText: 2024 Hongfei Shang
 *
 * SPDX-License-Identifier: MulanPSL-2.0
 *
 * </pre>
 */
struct org_ukui_activation;
struct org_ukui_activation_feedback;
struct ukui_window;
struct ukui_window_management;
struct wl_output;
struct wl_surface;

#ifndef UKUI_WINDOW_MANAGEMENT_INTERFACE
#define UKUI_WINDOW_MANAGEMENT_INTERFACE
/**
 * @page page_iface_ukui_window_management ukui_window_management
 * @section page_iface_ukui_window_management_desc Description
 *
 * This interface manages application windows. It provides requests to show and hide the desktop
 * and emits an event every time a window is created so that the client can use it to manage the
 * window.
 * @section page_iface_ukui_window_management_api API
 * See @ref iface_ukui_window_management.
 */
/**
 * @defgroup iface_ukui_window_management The ukui_window_management interface
 *
 * This interface manages application windows. It provides requests to show and hide the desktop
 * and emits an event every time a window is created so that the client can use it to manage the
 * window.
 */
extern const struct wl_interface ukui_window_management_interface;
#endif
#ifndef UKUI_WINDOW_INTERFACE
#define UKUI_WINDOW_INTERFACE
/**
 * @page page_iface_ukui_window ukui_window
 * @section page_iface_ukui_window_desc Description
 *
 * Manages and control an application window.
 * @section page_iface_ukui_window_api API
 * See @ref iface_ukui_window.
 */
/**
 * @defgroup iface_ukui_window The ukui_window interface
 *
 * Manages and control an application window.
 */
extern const struct wl_interface ukui_window_interface;
#endif
#ifndef ORG_UKUI_ACTIVATION_FEEDBACK_INTERFACE
#define ORG_UKUI_ACTIVATION_FEEDBACK_INTERFACE
/**
 * @page page_iface_org_ukui_activation_feedback org_ukui_activation_feedback
 * @section page_iface_org_ukui_activation_feedback_desc Description
 *
 * The activation manager interface provides a way to get notified when an application is about
 * to be activated.
 * @section page_iface_org_ukui_activation_feedback_api API
 * See @ref iface_org_ukui_activation_feedback.
 */
/**
 * @defgroup iface_org_ukui_activation_feedback The org_ukui_activation_feedback interface
 *
 * The activation manager interface provides a way to get notified when an application is about
 * to be activated.
 */
extern const struct wl_interface org_ukui_activation_feedback_interface;
#endif
#ifndef ORG_UKUI_ACTIVATION_INTERFACE
#define ORG_UKUI_ACTIVATION_INTERFACE
/**
 * @page page_iface_org_ukui_activation org_ukui_activation
 * @section page_iface_org_ukui_activation_api API
 * See @ref iface_org_ukui_activation.
 */
/**
 * @defgroup iface_org_ukui_activation The org_ukui_activation interface
 */
extern const struct wl_interface org_ukui_activation_interface;
#endif

#ifndef UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM
#define UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM
enum ukui_window_management_show_desktop {
	UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_DISABLED = 0,
	UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENABLED = 1,
};
#endif /* UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM */

/**
 * @ingroup iface_ukui_window_management
 * @struct ukui_window_management_listener
 */
struct ukui_window_management_listener {
	/**
	 * notify the client when the show desktop mode is entered/left
	 *
	 * This event will be sent whenever the show desktop mode
	 * changes. E.g. when it is entered or left.
	 *
	 * On binding the interface the current state is sent.
	 * @param state new state
	 */
	void (*show_desktop_changed)(void *data,
				     struct ukui_window_management *ukui_window_management,
				     uint32_t state);
	/**
	 * notify the client when stacking order changed
	 *
	 * This event will be sent when stacking order changed and on
	 * bind
	 * @param uuids internal windows uuid, use ';' separated
	 */
	void (*stacking_order_changed)(void *data,
				       struct ukui_window_management *ukui_window_management,
				       const char *uuids);
	/**
	 * notify the client that a window was mapped
	 *
	 * This event will be sent immediately after a window is mapped.
	 * @param uuid internal window uuid
	 */
	void (*window_created)(void *data,
			       struct ukui_window_management *ukui_window_management,
			       const char *uuid);
};

/**
 * @ingroup iface_ukui_window_management
 */
static inline int
ukui_window_management_add_listener(struct ukui_window_management *ukui_window_management,
				    const struct ukui_window_management_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_window_management,
				     (void (**)(void)) listener, data);
}

#define UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP 0
#define UKUI_WINDOW_MANAGEMENT_CREATE_WINDOW 1

/**
 * @ingroup iface_ukui_window_management
 */
#define UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window_management
 */
#define UKUI_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window_management
 */
#define UKUI_WINDOW_MANAGEMENT_WINDOW_CREATED_SINCE_VERSION 1

/**
 * @ingroup iface_ukui_window_management
 */
#define UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window_management
 */
#define UKUI_WINDOW_MANAGEMENT_CREATE_WINDOW_SINCE_VERSION 1

/** @ingroup iface_ukui_window_management */
static inline void
ukui_window_management_set_user_data(struct ukui_window_management *ukui_window_management, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_window_management, user_data);
}

/** @ingroup iface_ukui_window_management */
static inline void *
ukui_window_management_get_user_data(struct ukui_window_management *ukui_window_management)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_window_management);
}

static inline uint32_t
ukui_window_management_get_version(struct ukui_window_management *ukui_window_management)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_window_management);
}

/** @ingroup iface_ukui_window_management */
static inline void
ukui_window_management_destroy(struct ukui_window_management *ukui_window_management)
{
	wl_proxy_destroy((struct wl_proxy *) ukui_window_management);
}

/**
 * @ingroup iface_ukui_window_management
 *
 * Tell the compositor to show/hide the desktop.
 */
static inline void
ukui_window_management_show_desktop(struct ukui_window_management *ukui_window_management, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window_management,
			 UKUI_WINDOW_MANAGEMENT_SHOW_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window_management), 0, state);
}

/**
 * @ingroup iface_ukui_window_management
 */
static inline struct ukui_window *
ukui_window_management_create_window(struct ukui_window_management *ukui_window_management, const char *internal_window_uuid)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_window_management,
			 UKUI_WINDOW_MANAGEMENT_CREATE_WINDOW, &ukui_window_interface, wl_proxy_get_version((struct wl_proxy *) ukui_window_management), 0, NULL, internal_window_uuid);

	return (struct ukui_window *) id;
}

#ifndef UKUI_WINDOW_STATE_ENUM
#define UKUI_WINDOW_STATE_ENUM
enum ukui_window_state {
	UKUI_WINDOW_STATE_ACTIVE = 0x1,
	UKUI_WINDOW_STATE_MINIMIZED = 0x2,
	UKUI_WINDOW_STATE_MAXIMIZED = 0x4,
	UKUI_WINDOW_STATE_FULLSCREEN = 0x8,
	UKUI_WINDOW_STATE_KEEP_ABOVE = 0x10,
	UKUI_WINDOW_STATE_KEEP_BELOW = 0x20,
	UKUI_WINDOW_STATE_ON_ALL_DESKTOPS = 0x40,
	UKUI_WINDOW_STATE_DEMANDS_ATTENTION = 0x80,
	UKUI_WINDOW_STATE_CLOSEABLE = 0x100,
	UKUI_WINDOW_STATE_MINIMIZABLE = 0x200,
	UKUI_WINDOW_STATE_MAXIMIZABLE = 0x400,
	UKUI_WINDOW_STATE_FULLSCREENABLE = 0x800,
	UKUI_WINDOW_STATE_SHADEABLE = 0x1000,
	UKUI_WINDOW_STATE_SHADED = 0x2000,
	UKUI_WINDOW_STATE_MOVABLE = 0x4000,
	UKUI_WINDOW_STATE_RESIZABLE = 0x8000,
	UKUI_WINDOW_STATE_VIRTUAL_DESKTOP_CHANGEABLE = 0x10000,
	UKUI_WINDOW_STATE_ACCEPT_FOCUS = 0x20000,
	UKUI_WINDOW_STATE_SKIPTASKBAR = 0x40000,
	UKUI_WINDOW_STATE_SKIPSWITCHER = 0x80000,
	UKUI_WINDOW_STATE_MODALITY = 0x100000,
};
#endif /* UKUI_WINDOW_STATE_ENUM */

/**
 * @ingroup iface_ukui_window
 * @struct ukui_window_listener
 */
struct ukui_window_listener {
	/**
	 * window title has been changed
	 *
	 * This event will be sent as soon as the window title is
	 * changed.
	 * @param title window title
	 */
	void (*title_changed)(void *data,
			      struct ukui_window *ukui_window,
			      const char *title);
	/**
	 * application identifier has been changed
	 *
	 * This event will be sent as soon as the application identifier
	 * is changed.
	 */
	void (*app_id_changed)(void *data,
			       struct ukui_window *ukui_window,
			       const char *app_id);
	/**
	 * window state has been changed
	 *
	 * This event will be sent as soon as the window state changes.
	 *
	 * Values for state argument are described by
	 * ukui_window_management.state. It contains the whole new state of
	 * the window.
	 * @param flags bitfield of state flags
	 */
	void (*state_changed)(void *data,
			      struct ukui_window *ukui_window,
			      uint32_t flags);
	/**
	 * window's icon name changed
	 *
	 * This event will be sent whenever the themed icon name changes.
	 * May be null.
	 * @param name the new themed icon name
	 */
	void (*themed_icon_name_changed)(void *data,
					 struct ukui_window *ukui_window,
					 const char *name);
	/**
	 * window's surface was unmapped
	 *
	 * This event will be sent immediately after the window is closed
	 * and its surface is unmapped.
	 */
	void (*unmapped)(void *data,
			 struct ukui_window *ukui_window);
	/**
	 * All initial known state is submitted
	 *
	 * This event will be sent immediately after all initial state
	 * been sent to the client. If the Plasma window is already
	 * unmapped, the unmapped event will be sent before the
	 * initial_state event.
	 */
	void (*initial_state)(void *data,
			      struct ukui_window *ukui_window);
	/**
	 * The parent window changed
	 *
	 * This event will be sent whenever the parent window of this
	 * ukui_window changes. The passed parent is another ukui_window
	 * and this ukui_window is a transient window to the parent window.
	 * If the parent argument is null, this ukui_window does not have a
	 * parent window.
	 * @param parent The parent window
	 */
	void (*parent_window)(void *data,
			      struct ukui_window *ukui_window,
			      struct ukui_window *parent);
	/**
	 * The geometry of this window in absolute coordinates
	 *
	 * This event will be sent whenever the window geometry of this
	 * ukui_window changes. The coordinates are in absolute coordinates
	 * of the windowing system.
	 * @param x x position of the ukui_window
	 * @param y y position of the ukui_window
	 * @param width width of the ukui_window
	 * @param height height of the ukui_window
	 */
	void (*geometry)(void *data,
			 struct ukui_window *ukui_window,
			 int32_t x,
			 int32_t y,
			 uint32_t width,
			 uint32_t height);
	/**
	 * The icon of the window changed
	 *
	 * This event will be sent whenever the icon of the window
	 * changes, but there is no themed icon name. Common examples are
	 * Xwayland windows which have a pixmap based icon.
	 *
	 * The client can request the icon using get_icon.
	 */
	void (*icon_changed)(void *data,
			     struct ukui_window *ukui_window);
	/**
	 * process id of application owning the window has changed
	 *
	 * This event will be sent when the compositor has set the
	 * process id this window belongs to. This should be set once
	 * before the initial_state is sent.
	 * @param pid process id
	 */
	void (*pid_changed)(void *data,
			    struct ukui_window *ukui_window,
			    uint32_t pid);
	/**
	 * the window entered a new virtual desktop
	 *
	 * This event will be sent when the window has entered a new
	 * virtual desktop. The window can be on more than one desktop, or
	 * none: then is considered on all of them.
	 * @param id desktop id
	 */
	void (*virtual_desktop_entered)(void *data,
					struct ukui_window *ukui_window,
					const char *id);
	/**
	 * the window left a virtual desktop
	 *
	 * This event will be sent when the window left a virtual
	 * desktop. If the window leaves all desktops, it can be considered
	 * on all. If the window gets manually added on all desktops, the
	 * server has to send virtual_desktop_left for every previous
	 * desktop it was in for the window to be really considered on all
	 * desktops.
	 * @param is desktop id
	 */
	void (*virtual_desktop_left)(void *data,
				     struct ukui_window *ukui_window,
				     const char *is);
	/**
	 * notify the client that the current appmenu changed
	 *
	 * This event will be sent after the application menu for the
	 * window has changed.
	 */
	void (*application_menu)(void *data,
				 struct ukui_window *ukui_window,
				 const char *service_name,
				 const char *object_path);
	/**
	 * the window entered an activity
	 *
	 * This event will be sent when the window has entered an
	 * activity. The window can be on more than one activity, or none:
	 * then is considered on all of them.
	 * @param id activity id
	 */
	void (*activity_entered)(void *data,
				 struct ukui_window *ukui_window,
				 const char *id);
	/**
	 * the window left an activity
	 *
	 * This event will be sent when the window left an activity. If
	 * the window leaves all activities, it will be considered on all.
	 * If the window gets manually added on all activities, the server
	 * has to send activity_left for every previous activity it was in
	 * for the window to be really considered on all activities.
	 * @param id activity id
	 */
	void (*activity_left)(void *data,
			      struct ukui_window *ukui_window,
			      const char *id);
	/**
	 * X11 resource name has changed
	 *
	 * This event will be sent when the X11 resource name of the
	 * window has changed. This is only set for XWayland windows.
	 * @param resource_name resource name
	 */
	void (*resource_name_changed)(void *data,
				      struct ukui_window *ukui_window,
				      const char *resource_name);
};

/**
 * @ingroup iface_ukui_window
 */
static inline int
ukui_window_add_listener(struct ukui_window *ukui_window,
			 const struct ukui_window_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_window,
				     (void (**)(void)) listener, data);
}

#define UKUI_WINDOW_SET_STATE 0
#define UKUI_WINDOW_SET_STARTUP_GEOMETRY 1
#define UKUI_WINDOW_SET_MINIMIZED_GEOMETRY 2
#define UKUI_WINDOW_UNSET_MINIMIZED_GEOMETRY 3
#define UKUI_WINDOW_CLOSE 4
#define UKUI_WINDOW_REQUEST_MOVE 5
#define UKUI_WINDOW_REQUEST_RESIZE 6
#define UKUI_WINDOW_DESTROY 7
#define UKUI_WINDOW_GET_ICON 8
#define UKUI_WINDOW_REQUEST_ENTER_VIRTUAL_DESKTOP 9
#define UKUI_WINDOW_REQUEST_ENTER_NEW_VIRTUAL_DESKTOP 10
#define UKUI_WINDOW_REQUEST_LEAVE_VIRTUAL_DESKTOP 11
#define UKUI_WINDOW_REQUEST_ENTER_ACTIVITY 12
#define UKUI_WINDOW_REQUEST_LEAVE_ACTIVITY 13
#define UKUI_WINDOW_SEND_TO_OUTPUT 14
#define UKUI_WINDOW_HIGHLIGHT 15
#define UKUI_WINDOW_UNSET_HIGHLIGHT 16

/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_TITLE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_APP_ID_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_STATE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_THEMED_ICON_NAME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_UNMAPPED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_INITIAL_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_PARENT_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_ICON_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_PID_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_VIRTUAL_DESKTOP_ENTERED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_VIRTUAL_DESKTOP_LEFT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_APPLICATION_MENU_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_ACTIVITY_ENTERED_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_ACTIVITY_LEFT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_RESOURCE_NAME_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_SET_STARTUP_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_SET_MINIMIZED_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_UNSET_MINIMIZED_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_MOVE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_RESIZE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_GET_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_ENTER_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_ENTER_NEW_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_LEAVE_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_ENTER_ACTIVITY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_REQUEST_LEAVE_ACTIVITY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_SEND_TO_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_HIGHLIGHT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_window
 */
#define UKUI_WINDOW_UNSET_HIGHLIGHT_SINCE_VERSION 1

/** @ingroup iface_ukui_window */
static inline void
ukui_window_set_user_data(struct ukui_window *ukui_window, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_window, user_data);
}

/** @ingroup iface_ukui_window */
static inline void *
ukui_window_get_user_data(struct ukui_window *ukui_window)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_window);
}

static inline uint32_t
ukui_window_get_version(struct ukui_window *ukui_window)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_window);
}

/**
 * @ingroup iface_ukui_window
 *
 * Set window state. Can set multiple states at once.
 *
 * Values for state argument are described by ukui_window_management.state and can be used
 * together in a bitfield.
 * The flags bitfield describes which flags are supposed to be set, the
 * state bitfield the value for the set flags.
 *
 * The state argument is not a boolean value, but a bitfield, so it is possible to set multiple
 * states at once. Only the states that are set in the flags bitfield will be changed.
 *
 * For example:
 *
 * If flags was 0x14(keep_above|maximized) and state was 0x04(maximized), the window would be
 * maximized, but not keep above.
 *
 * If flags was 0x04(maximized) and state was 0x14(keep_above|maximized), the window would be
 * maximized but not change keep above state.
 */
static inline void
ukui_window_set_state(struct ukui_window *ukui_window, uint32_t flags, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_SET_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, flags, state);
}

/**
 * @ingroup iface_ukui_window
 *
 * Sets the geometry of the taskbar/desktop entry for this window. The geometry is relative to
 * a panel/desktop in particular.
 */
static inline void
ukui_window_set_startup_geometry(struct ukui_window *ukui_window, struct wl_surface *entry, uint32_t x, uint32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_SET_STARTUP_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, entry, x, y, width, height);
}

/**
 * @ingroup iface_ukui_window
 *
 * Sets the geometry of the taskbar entry for this window. The geometry is relative to a panel
 * in particular.
 */
static inline void
ukui_window_set_minimized_geometry(struct ukui_window *ukui_window, struct wl_surface *panel, uint32_t x, uint32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_SET_MINIMIZED_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, panel, x, y, width, height);
}

/**
 * @ingroup iface_ukui_window
 *
 * Remove the task geometry information for a particular panel.
 */
static inline void
ukui_window_unset_minimized_geometry(struct ukui_window *ukui_window, struct wl_surface *panel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_UNSET_MINIMIZED_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, panel);
}

/**
 * @ingroup iface_ukui_window
 *
 * Close this window.
 */
static inline void
ukui_window_close(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_CLOSE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_ukui_window
 *
 * Request an interactive move for this window. The pointer will move to the center of the
 * window and move with the pointer.
 *
 * When mouse button is released, the interactive move ends.
 */
static inline void
ukui_window_request_move(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_MOVE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_ukui_window
 *
 * Request an interactive resize for this window. The pointer will move to window right bottom
 * corner and resize with the pointer.
 *
 * When mouse button is released, the interactive resize ends.
 */
static inline void
ukui_window_request_resize(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_RESIZE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_ukui_window
 *
 * Removes the resource bound for this ukui_window.
 */
static inline void
ukui_window_destroy(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_window
 *
 * The compositor will write the window icon into the provided file descriptor.
 * This is an array of 32bit packed CARDINAL ARGB with high byte being A, low byte
 * being B. The first two cardinals are width, height. Data is in rows, left to
 * right and top to bottom.
 */
static inline void
ukui_window_get_icon(struct ukui_window *ukui_window, int32_t fd)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_GET_ICON, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, fd);
}

/**
 * @ingroup iface_ukui_window
 *
 * Make the window enter a virtual desktop. A window can enter more than one virtual desktop.
 * if the id is empty or invalid, no action will be performed.
 */
static inline void
ukui_window_request_enter_virtual_desktop(struct ukui_window *ukui_window, const char *id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_ENTER_VIRTUAL_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, id);
}

/**
 * @ingroup iface_ukui_window
 * RFC: do this with an empty id to
 * request_enter_virtual_desktop?
 * Make the window enter a new virtual desktop. If the server consents the request, it will
 * create a new virtual desktop and assign the window to it.
 */
static inline void
ukui_window_request_enter_new_virtual_desktop(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_ENTER_NEW_VIRTUAL_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_ukui_window
 *
 * Make the window exit a virtual desktop. If it exits all desktops it will be considered on
 * all of them.
 */
static inline void
ukui_window_request_leave_virtual_desktop(struct ukui_window *ukui_window, const char *id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_LEAVE_VIRTUAL_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, id);
}

/**
 * @ingroup iface_ukui_window
 *
 * Make the window enter an activity. A window can enter more activity. If the id is empty or
 * invalid, no action will be performed.
 */
static inline void
ukui_window_request_enter_activity(struct ukui_window *ukui_window, const char *id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_ENTER_ACTIVITY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, id);
}

/**
 * @ingroup iface_ukui_window
 *
 * Make the window exit a an activity. If it exits all activities it will be considered on all
 * of them.
 */
static inline void
ukui_window_request_leave_activity(struct ukui_window *ukui_window, const char *id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_REQUEST_LEAVE_ACTIVITY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, id);
}

/**
 * @ingroup iface_ukui_window
 *
 * Requests this window to be displayed in a specific output.
 */
static inline void
ukui_window_send_to_output(struct ukui_window *ukui_window, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_SEND_TO_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0, output);
}

/**
 * @ingroup iface_ukui_window
 *
 * Tell the compositor to highlight this window.
 */
static inline void
ukui_window_highlight(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_HIGHLIGHT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_ukui_window
 *
 * Tell the compositor to unset highlight window.
 */
static inline void
ukui_window_unset_highlight(struct ukui_window *ukui_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_window,
			 UKUI_WINDOW_UNSET_HIGHLIGHT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_window), 0);
}

/**
 * @ingroup iface_org_ukui_activation_feedback
 * @struct org_ukui_activation_feedback_listener
 */
struct org_ukui_activation_feedback_listener {
	/**
	 * notify that an app is starting
	 *
	 * Will be issued when an app is set to be activated. It offers
	 * an instance of org_ukui_activation that will tell us the app_id
	 * and the extent of the activation.
	 */
	void (*activation)(void *data,
			   struct org_ukui_activation_feedback *org_ukui_activation_feedback,
			   struct org_ukui_activation *id);
};

/**
 * @ingroup iface_org_ukui_activation_feedback
 */
static inline int
org_ukui_activation_feedback_add_listener(struct org_ukui_activation_feedback *org_ukui_activation_feedback,
					  const struct org_ukui_activation_feedback_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_ukui_activation_feedback,
				     (void (**)(void)) listener, data);
}

#define ORG_UKUI_ACTIVATION_FEEDBACK_DESTROY 0

/**
 * @ingroup iface_org_ukui_activation_feedback
 */
#define ORG_UKUI_ACTIVATION_FEEDBACK_ACTIVATION_SINCE_VERSION 1

/**
 * @ingroup iface_org_ukui_activation_feedback
 */
#define ORG_UKUI_ACTIVATION_FEEDBACK_DESTROY_SINCE_VERSION 1

/** @ingroup iface_org_ukui_activation_feedback */
static inline void
org_ukui_activation_feedback_set_user_data(struct org_ukui_activation_feedback *org_ukui_activation_feedback, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_ukui_activation_feedback, user_data);
}

/** @ingroup iface_org_ukui_activation_feedback */
static inline void *
org_ukui_activation_feedback_get_user_data(struct org_ukui_activation_feedback *org_ukui_activation_feedback)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_ukui_activation_feedback);
}

static inline uint32_t
org_ukui_activation_feedback_get_version(struct org_ukui_activation_feedback *org_ukui_activation_feedback)
{
	return wl_proxy_get_version((struct wl_proxy *) org_ukui_activation_feedback);
}

/**
 * @ingroup iface_org_ukui_activation_feedback
 *
 * Destroy the activation manager object. The activation objects introduced by this manager
 * object will be unaffected.
 */
static inline void
org_ukui_activation_feedback_destroy(struct org_ukui_activation_feedback *org_ukui_activation_feedback)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_ukui_activation_feedback,
			 ORG_UKUI_ACTIVATION_FEEDBACK_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) org_ukui_activation_feedback), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_org_ukui_activation
 * @struct org_ukui_activation_listener
 */
struct org_ukui_activation_listener {
	/**
	 * Offers the app_id
	 *
	 * 
	 * @param app_id application id, as described in xdg_activation_v1
	 */
	void (*app_id)(void *data,
		       struct org_ukui_activation *org_ukui_activation,
		       const char *app_id);
	/**
	 * Notifies about activation finished, either by activation or because it got invalidated
	 *
	 * 
	 */
	void (*finished)(void *data,
			 struct org_ukui_activation *org_ukui_activation);
};

/**
 * @ingroup iface_org_ukui_activation
 */
static inline int
org_ukui_activation_add_listener(struct org_ukui_activation *org_ukui_activation,
				 const struct org_ukui_activation_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_ukui_activation,
				     (void (**)(void)) listener, data);
}

#define ORG_UKUI_ACTIVATION_DESTROY 0

/**
 * @ingroup iface_org_ukui_activation
 */
#define ORG_UKUI_ACTIVATION_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_org_ukui_activation
 */
#define ORG_UKUI_ACTIVATION_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_org_ukui_activation
 */
#define ORG_UKUI_ACTIVATION_DESTROY_SINCE_VERSION 1

/** @ingroup iface_org_ukui_activation */
static inline void
org_ukui_activation_set_user_data(struct org_ukui_activation *org_ukui_activation, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_ukui_activation, user_data);
}

/** @ingroup iface_org_ukui_activation */
static inline void *
org_ukui_activation_get_user_data(struct org_ukui_activation *org_ukui_activation)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_ukui_activation);
}

static inline uint32_t
org_ukui_activation_get_version(struct org_ukui_activation *org_ukui_activation)
{
	return wl_proxy_get_version((struct wl_proxy *) org_ukui_activation);
}

/**
 * @ingroup iface_org_ukui_activation
 *
 * Notify the compositor that the org_ukui_activation object will no longer be used.
 */
static inline void
org_ukui_activation_destroy(struct org_ukui_activation *org_ukui_activation)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_ukui_activation,
			 ORG_UKUI_ACTIVATION_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) org_ukui_activation), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
