/**
 * \file pappsomspp/processing/cbor/psm/psmfilescanprocessandcopy.h
 * \date 15/07/2025
 * \author Olivier Langella
 * \brief PSM file reader designed to parallelize scan process and then copy the results in PSM cbor
 * output stream
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "psmfilescanprocess.h"
#include "pappsomspp/core/processing/cbor/cborstreamwriter.h"


namespace pappso
{
namespace cbor
{
namespace psm
{

/**
 * @brief Basic PSM file reader to process scan (parallelized scan processing) and write a new
 * resulting PSM file
 */
class PsmFileScanProcessAndCopy : public PsmFileScanProcess
{
  public:
  /**
   * Default constructor
   */
  PsmFileScanProcessAndCopy(std::size_t buffer_scan_size,
                            CborStreamWriter *cbor_output_p,
                            const QString &operation);

  /**
   * Destructor
   */
  virtual ~PsmFileScanProcessAndCopy();

  void close() override;


  protected:
  /**
   */
  void delayProteinMapInMemory();
  void informationsReady(pappso::UiMonitorInterface &monitor) override;
  void logReady(pappso::UiMonitorInterface &monitor) override;
  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;
  void fastaFilesReady(pappso::UiMonitorInterface &monitor) override;
  virtual void proteinMapReady(pappso::UiMonitorInterface &monitor) override;

  virtual void processBufferScanDone(pappso::UiMonitorInterface &monitor) override;

  void sampleStarted(pappso::UiMonitorInterface &monitor) override;

  void sampleFinished(pappso::UiMonitorInterface &monitor) override;


  void sampleListStarted(pappso::UiMonitorInterface &monitor) override;
  void sampleListFinished(pappso::UiMonitorInterface &monitor) override;

  protected:
  CborStreamWriter *mp_cborOutput;
  CborStreamWriter *mp_copyCborOutput = nullptr;
  QString m_operation;


  pappso::cbor::psm::PsmProteinMap m_psmNewProteinMap;
  QBuffer *mpa_bufferAfterProteinMap                              = nullptr;
  pappso::cbor::CborStreamWriter *mpa_bufferWriterAfterProteinMap = nullptr;
};

} // namespace psm
} // namespace cbor
} // namespace pappso
