// Maria transition qualifier expression class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "TransitionQualifier.h"
#include "Net.h"
#include "BoolType.h"
#include "Transition.h"
#include "Printer.h"

/** @file TransitionQualifier.C
 * Transition instance qualifier
 */

/* Copyright  1998-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

TransitionQualifier::TransitionQualifier (const class Transition& transition,
					  class Expression& expr) :
  Expression (),
  myTransition (&transition), myExpr (&expr)
{
  assert (myExpr->getType ()->getKind () == Type::tBool);
  setType (*myExpr->getType ());
}

TransitionQualifier::~TransitionQualifier ()
{
  myExpr->destroy ();
}

class Expression*
TransitionQualifier::ground (const class Valuation& valuation,
			     class Transition* transition,
			     bool declare)
{
  class Expression* e = myExpr->ground (valuation, transition, declare);
  if (!e)
    return NULL;
  assert (valuation.isOK ());
  if (e == myExpr) {
    e->destroy ();
    return copy ();
  }
  else
    return (new class TransitionQualifier (*myTransition, *e))->cse ();
}

class Expression*
TransitionQualifier::substitute (class Substitution& substitution)
{
  class Expression* e = myExpr->substitute (substitution);
  if (!e)
    return NULL;
  if (e == myExpr) {
    e->destroy ();
    return copy ();
  }
  else
    return (new class TransitionQualifier (*myTransition, *e))->cse ();
}

bool
TransitionQualifier::depends (const class VariableSet& vars,
			      bool complement) const
{
  return myExpr->depends (vars, complement);
}

bool
TransitionQualifier::forExpressions (bool (*operation)
				     (const class Expression&,void*),
				     void* data) const
{
  return
    (*operation) (*this, data) &&
    myExpr->forExpressions (operation, data);
}

class Expression*
TransitionQualifier::disqualify (const class Transition& transition)
{
  return myTransition == &transition ? myExpr->copy () : 0;
}

void
TransitionQualifier::display (const class Printer& printer) const
{
  printer.printRaw ("trans");
  printer.delimiter (' ');
  printer.print (myTransition->getName ());
  if (myExpr) {
    printer.delimiter (':');
    myExpr->display (printer);
  }
}
