# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class LinearCellExtrusionFilter(PolyDataAlgorithm):
    r"""
    LinearCellExtrusionFilter - extrude polygonal data to create 3D
    cells from 2D cells
    
    Superclass: PolyDataAlgorithm
    
    LinearCellExtrusionFilter is a modeling filter. It takes polygonal
    data as input and generates an unstructured grid data on output. The
    input dataset is swept according to the input cell data array value
    along the cell normal and creates new 3D primitives. Triangles will
    become Wedges, Quads will become Hexahedrons, and Polygons will
    become Polyhedrons. This filter currently takes into account only
    polys and discard vertices, lines and strips. Unlike the
    LinearExtrusionFilter, this filter is designed to extrude each
    cell independently using its normal and its scalar value.
    
    @sa
    LinearExtrusionFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLinearCellExtrusionFilter, obj, update, **traits)
    
    merge_duplicate_points = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify if the algorithm should merge duplicate points. Default
        is false
        """
    )

    def _merge_duplicate_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergeDuplicatePoints,
                        self.merge_duplicate_points_)

    use_user_vector = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify if the algorithm should use the specified vector instead
        of cell normals. Default is false
        """
    )

    def _use_user_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseUserVector,
                        self.use_user_vector_)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        r"""
        Specify a spatial locator for merging points. By default, an
        instance of MergePoints is used.
        """
    )

    scale_factor = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the scale factor applied on the cell value during
        extrusion. Default is 1.0
        """
    )

    def _scale_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScaleFactor,
                        self.scale_factor)

    user_vector = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Specify the scale factor applied on the cell value during
        extrusion.
        """
    )

    def _user_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUserVector,
                        self.user_vector)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def create_default_locator(self):
        """
        create_default_locator(self) -> None
        C++: void create_default_locator()
        Create default locator. Used to create one when none is
        specified. The locator is used to merge coincident points.
        """
        ret = self._vtk_obj.CreateDefaultLocator()
        return ret
        

    _updateable_traits_ = \
    (('merge_duplicate_points', 'GetMergeDuplicatePoints'),
    ('use_user_vector', 'GetUseUserVector'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('scale_factor', 'GetScaleFactor'),
    ('user_vector', 'GetUserVector'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'merge_duplicate_points', 'release_data_flag', 'use_user_vector',
    'progress_text', 'scale_factor', 'user_vector'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LinearCellExtrusionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LinearCellExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['merge_duplicate_points', 'use_user_vector'], [],
            ['scale_factor', 'user_vector']),
            title='Edit LinearCellExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LinearCellExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

