#!/usr/bin/perl

use strict;
use warnings;

use Module::Build;
my $build      = Module::Build->current;
my $dbdir      = $build->install_path('MUNIN_DBDIR');
my $htmldir    = $build->install_path('MUNIN_HTMLDIR');
my $logdir     = $build->install_path('MUNIN_LOGDIR');
my $rundir     = $build->install_path('MUNIN_RUNDIR');
my $tmpldir    = $build->install_path('MUNIN_CONFDIR') . '/templates';
my $staticdir  = $build->install_path('MUNIN_CONFDIR') . '/static';
my $cgitmpdir  = $build->install_path('MUNIN_CGITMPDIR');
my $includedir = $build->install_path('MUNIN_CONFDIR') . '/munin-conf.d';

my $output_file = shift;
open my $fh, ">", $output_file or die "Can't open $output_file: $!";

print $fh <<"EOF";
# Example configuration file for Munin, generated by 'make build'

# The next three variables specifies where the location of the RRD
# databases, the HTML output, logs and the lock/pid files.  They all
# must be writable by the user running munin-cron.  They are all
# defaulted to the values you see here.
#
#dbdir   $dbdir
#htmldir $htmldir
#logdir  $logdir
#rundir  $rundir

# Where to look for the HTML templates
#
#tmpldir        $tmpldir

# Where to look for the static www files
#
#staticdir $staticdir

# temporary cgi files are here. note that it has to be writable by
# the cgi user (usually nobody or httpd).
#
# cgitmpdir $cgitmpdir

# (Exactly one) directory to include all files from.
includedir $includedir

EOF

print $fh <<'EOF';
# You can choose the time reference for "DERIVE" like graphs, and show
# "per minute", "per hour" values instead of the default "per second"
#
#graph_period second

# Munin HTML templates use this variable to decide whether to use dynamic
# ("lazy") loading of images with javascript so that images are loaded as they
# are scrolled in view. This prevents excessive load on the web
# server. Default is 0 (off).
#
#html_dynamic_images 1

# munin-cgi-graph is invoked by the web server up to very many times at the
# same time.  This is not optimal since it results in high CPU and memory
# consumption to the degree that the system can thrash.  Again the default is
# 6.  Most likely the optimal number for max_cgi_graph_jobs is the same as
# max_graph_jobs.
#
#munin_cgi_graph_jobs 6

# If the automatic CGI url is wrong for your system override it here:
#
#cgiurl_graph /munin-cgi/munin-cgi-graph

# max_size_x and max_size_y are the max size of images in pixel.
# Default is 4000. Do not make it too large otherwise RRD might use all
# RAM to generate the images.
#
#max_size_x 4000
#max_size_y 4000

# munin-update runs in parallel.
#
# The default max number of processes is 16, and is probably ok for you.
#
# If set too high, it might hit some process/ram/filedesc limits.
# If set too low, munin-update might take more than 5 min.
#
# If you want munin-update to not be parallel set it to 1.
#
#max_processes 16

# RRD updates are per default, performed directly on the rrd files.
# To reduce IO and enable the use of the rrdcached, uncomment it and set it to
# the location of the socket that rrdcached uses.
#
#rrdcached_socket /var/run/rrdcached.sock

# Drop somejuser\@fnord.comm and anotheruser\@blibb.comm an email every time
# something changes (OK -> WARNING, CRITICAL -> OK, etc)
#contact.someuser.command mail -s "Munin ${var:worst}: ${var:group}::${var:host}::${var:plugin}" somejuser\@fnord.comm
#contact.anotheruser.command mail -s "Munin ${var:worst}: ${var:group}::${var:host}::${var:plugin}" anotheruser\@blibb.comm
#
# For those with Nagios, the following might come in handy. In addition,
# the services must be defined in the Nagios server as well.
#contact.nagios.command /usr/bin/send_nsca nagios.host.comm -c /etc/nsca.conf
EOF

print $fh <<"EOF";
# a simple host tree
[munin.example.com]
        address 127.0.0.1
        use_node_name yes
EOF

print $fh <<'EOF';
#
# A more complex example of a host tree
#
## First our "normal" host.
# [fii.foo.com]
#       address foo
#
## Then our other host...
# [fay.foo.com]
#       address fay
#
## IPv6 host. note that the ip address has to be in brackets
# [ip6.foo.com]
#       address [2001::1234:1]
#
## Then we want totals...
# [foo.com;Totals] #Force it into the "foo.com"-domain...
#       update no   # Turn off data-fetching for this "host".
#
#   # The graph "load1". We want to see the loads of both machines...
#   # "fii=fii.foo.com:load.load" means "label=machine:graph.field"
#       load1.graph_title Loads side by side
#       load1.graph_order fii=fii.foo.com:load.load fay=fay.foo.com:load.load
#
#   # The graph "load2". Now we want them stacked on top of each other.
#       load2.graph_title Loads on top of each other
#       load2.dummy_field.stack fii=fii.foo.com:load.load fay=fay.foo.com:load.load
#       load2.dummy_field.draw AREA # We want area instead the default LINE2.
#       load2.dummy_field.label dummy # This is needed. Silly, really.
#
#   # The graph "load3". Now we want them summarised into one field
#       load3.graph_title Loads summarised
#       load3.combined_loads.sum fii.foo.com:load.load fay.foo.com:load.load
#       load3.combined_loads.label Combined loads # Must be set, as this is
#                                                 # not a dummy field!
#
## ...and on a side note, I want them listen in another order (default is
## alphabetically)
#
# # Since [foo.com] would be interpreted as a host in the domain "com", we
# # specify that this is a domain by adding a semicolon.
# [foo.com;]
#       node_order Totals fii.foo.com fay.foo.com
#
EOF
