/* --------------------------------------------------- */
/* Automatically generated by mwrap                    */
/* --------------------------------------------------- */

/* Code generated by mwrap 1.3 */
/*
  Copyright statement for mwrap:

  mwrap -- MEX file generation for MATLAB and Octave
  Copyright (c) 2007-2008 David Bindel

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  You may distribute a work that contains part or all of the source code
  generated by mwrap under the terms of your choice.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <stdio.h>
#include <string.h>
#include <stddef.h>

#include <mex.h>

#if MX_HAS_INTERLEAVED_COMPLEX
#include <matrix.h>
#endif


/*
 * Records for call profile.
 */
int* mexprofrecord_= NULL;

double mxWrapGetScalar_char(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxCHAR_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid char argument";
        return 0;
    }
    return (char) (*mxGetChars(a));
}

/*
 * Support routines for copying data into and out of the MEX stubs, R2018a
 */

#if MX_HAS_INTERLEAVED_COMPLEX

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = NULL;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxDOUBLE_CLASS && mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && (*mxGetComplexDoubles(a)).real == 0 )
        return NULL;
    }
    if (mxGetClassID(a) == mxDOUBLE_CLASS && !mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && *mxGetDoubles(a) == 0)
        return NULL;
    }
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetDoubles(z) = 0;
        return z;
    } else {
        char pbuf[128];
        snprintf(pbuf, sizeof(pbuf), fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetDoubles(z) = 0;
        return z;
    }
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    if( mxIsComplex(a) )
      return (double) (*mxGetComplexDoubles(a)).real;
    else
      return (double) (*mxGetDoubles(a));
}

#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    mxComplexDouble* z; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*z++).real;			\
      } \
    else \
      {				   \
	q = mxGetDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*q++);			\
      } \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p;	\
    mxComplexDouble* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  (*z++).real = (double) *q++;	\
	  (*z++).imag = 0;	\
      } \
    else \
      {				   \
	p = mxGetDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = (double) *q++;		\
      } \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetDoubles(a); \
        for (i = 0; i < m*n; ++i) \
	  *p++ = (double) *q++;	  \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz)	\
void func(T* z, const mxArray* a) \
{ \
    if( mxIsComplex(a) ) \
      { \
  setz(z, (ZT) (*mxGetComplexDoubles(a)).real, (ZT) (*mxGetComplexDoubles(a)).imag); \
      } \
    else \
      {				   \
  setz(z, (ZT) (*mxGetComplexDoubles(a)).real, (ZT) 0);	\
      } \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz)      \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    mxComplexDouble* z; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < arraylen; ++i) {	\
	  setz(p, (ZT) (*z).real, (ZT) (*z).imag);	\
  	  ++p; ++z; }					\
      } \
    else \
      {				   \
	q = mxGetDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)	{	\
	  setz(p, (ZT) (*q), (ZT) 0 );		\
          ++p; ++q; }			\
      }						\
    return array; \
}


#define mxWrapCopyZDef(func, T, freal, fimag)	    \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p;	\
    mxComplexDouble* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < n; ++i)	{		\
          (*z).real = freal(*q);			\
	  (*z).imag = fimag(*q);			\
	  ++z; ++q; 	}			\
      } \
    else \
      {				   \
	p = mxGetDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = freal(*q++);		\
      } \
}


#define mxWrapReturnZDef(func, T, freal, fimag)	      \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    mxComplexDouble* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        p = mxGetComplexDoubles(a); \
        for (i = 0; i < m*n; ++i) {	  \
          (*p).real = freal(*q);			\
	  (*p).imag = fimag(*q);			\
	  ++p; ++q; 	}			\
        return a; \
    } \
}






void* mxWrapGetP_single(const mxArray* a, const char* fmt, const char** e)
{
    void* p = NULL;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxSINGLE_CLASS && mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && (*mxGetComplexSingles(a)).real == 0 )
        return NULL;
    }
    if (mxGetClassID(a) == mxSINGLE_CLASS && !mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && *mxGetSingles(a) == 0)
        return NULL;
    }
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP_single(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *mxGetSingles(z) = 0;
        return z;
    } else {
        char pbuf[128];
        snprintf(pbuf, sizeof(pbuf), fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy_single(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *mxGetSingles(z) = 0;
        return z;
    }
}

float mxWrapGetScalar_single(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    if( mxIsComplex(a) )
      return (float) (*mxGetComplexSingles(a)).real;
    else
      return (float) (*mxGetSingles(a));
}


char* mxWrapGetString_single(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}

#define mxWrapGetArrayDef_single(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    mxComplexSingle* z; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*z++).real;			\
      } \
    else \
      {				   \
	q = mxGetSingles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*q++);			\
      } \
    return array; \
}


#define mxWrapCopyDef_single(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p;	\
    mxComplexSingle* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  (*z++).real = (float) *q++;	\
	  (*z++).imag = 0;	\
      } \
    else \
      {				   \
	p = mxGetSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = (float) *q++;		\
      } \
}


#define mxWrapReturnDef_single(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* p; \
    if (!q) { \
        return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxREAL); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxREAL); \
        p = mxGetSingles(a); \
        for (i = 0; i < m*n; ++i) \
	  *p++ = (float) *q++;	  \
        return a; \
    } \
}


#define mxWrapGetScalarZDef_single(func, T, ZT, setz)	\
void func(T* z, const mxArray* a) \
{ \
    if( mxIsComplex(a) ) \
      { \
  setz(z, (ZT) (*mxGetComplexSingles(a)).real, (ZT) (*mxGetComplexSingles(a)).imag); \
      } \
    else \
      {				   \
  setz(z, (ZT) (*mxGetComplexSingles(a)).real, (ZT) 0);	\
      } \
}


#define mxWrapGetArrayZDef_single(func, T, ZT, setz)      \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    mxComplexSingle* z; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < arraylen; ++i) {	\
	  setz(p, (ZT) (*z).real, (ZT) (*z).imag);	\
  	  ++p; ++z; }					\
      } \
    else \
      {				   \
	q = mxGetSingles(a);	   \
	for (i = 0; i < arraylen; ++i)	{	\
	  setz(p, (ZT) (*q), (ZT) 0 );		\
          ++p; ++q; }			\
      }						\
    return array; \
}


#define mxWrapCopyZDef_single(func, T, freal, fimag)	    \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p;	\
    mxComplexSingle* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < n; ++i)	{		\
          (*z).real = freal(*q);			\
	  (*z).imag = fimag(*q);			\
	  ++z; ++q; 	}			\
      } \
    else \
      {				   \
	p = mxGetSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = freal(*q++);		\
      } \
}


#define mxWrapReturnZDef_single(func, T, freal, fimag)	      \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    mxComplexSingle* p; \
    if (!q) { \
        return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxCOMPLEX); \
        p = mxGetComplexSingles(a); \
        for (i = 0; i < m*n; ++i) {	  \
          (*p).real = freal(*q);			\
	  (*p).imag = fimag(*q);			\
	  ++p; ++q; 	}			\
        return a; \
    } \
}



#else

/*
 * Support routines for copying data into and out of the MEX stubs, -R2017b
 */

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxDOUBLE_CLASS && 
        mxGetM(a)*mxGetN(a) == 1 && *mxGetPr(a) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    } else {
        char pbuf[128];
        snprintf(pbuf, sizeof(pbuf), fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    }
}

double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *mxGetPr(a);
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* qr; \
    double* qi; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = mxGetPr(a); \
    qi = mxGetPi(a); \
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef(func, T, real, imag) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef(func, T, real, imag) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* pr; \
    double* pi; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        pr = mxGetPr(a); \
        pi = mxGetPi(a); \
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}






void* mxWrapGetP_single(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxSINGLE_CLASS && 
        mxGetM(a)*mxGetN(a) == 1 && *((float*)mxGetData(a)) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP_single(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *((float*)mxGetData(z)) = 0;
        return z;
    } else {
        char pbuf[128];
        snprintf(pbuf, sizeof(pbuf), fmt, p);
        return mxCreateString(pbuf);
    }
}
mxArray* mxWrapStrncpy_single(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *((float*)mxGetData(z)) = 0;
        return z;
    }
}

float mxWrapGetScalar_single(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *((float*)mxGetData(a));
}

char* mxWrapGetString_single(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument, mxSINGLE_CLASS expected";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef_single(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = (float*) mxGetData(a);	   \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef_single(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p = (float*) mxGetData(a);		\
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef_single(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* p; \
    if (!q) { \
      return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxREAL); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxREAL);\
        p = (float*) mxGetData(a);				\
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef_single(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    float* pr = (float*) mxGetData(a);		\
    float* pi = (float*) mxGetImagData(a);		 \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef_single(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* qr; \
    float* qi; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = (float*) mxGetData(a);			\
    qi = (float*) mxGetImagData(a);			\
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef_single(func, T, real, imag) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* pr = (float*) mxGetData(a);		\
    float* pi = (float*) mxGetImagData(a);		\
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef_single(func, T, real, imag) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* pr; \
    float* pi; \
    if (!q) { \
      return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxCOMPLEX);\
        pr = (float*) mxGetData(a);					\
        pi = (float*) mxGetImagData(a);					\
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}





#endif


#include <stdio.h>
#include <string.h>

struct Pair {
    Pair(double x, double y) { xy[0] = x; xy[1] = y; }
    double xy[2];
    double x() { return xy[0]; }
    double y() { return xy[1]; }
};

struct BadPair {
    double x;
};

struct DerivedPair : public Pair {
    DerivedPair() : Pair(7,11) {}
};

#include <complex>
typedef std::complex<double> cmplx;
#define real_cmplx(z) (z).real()
#define imag_cmplx(z) (z).imag()
#define setz_cmplx(zp, r, i)  *zp = cmplx(r,i)

typedef unsigned char uchar;
typedef unsigned long ulong;

class Parent1 {
public:
    Parent1(int data) : data1_(data) {}
    virtual ~Parent1() {}
    virtual int data1() { return data1_; }
protected:
    int data1_;
};

class Parent2 {
public:
    Parent2(int data) : data2_(data) {}
    virtual ~Parent2() {}
    virtual int data2() { return data2_; }
protected:
    int data2_;
};

class Child : public Parent1, public Parent2 {
public:
    Child() : Parent1(1), Parent2(2) {}
    virtual int data1() { return data1_ + 1; }
    virtual int data2() { return data2_ + 1; }
    int datas() { return data1_ + data2_; }
};

 class OuterClass {
 public:
   static int static_method() { return 123; }
 };
 int literal_plus1(int x) { return x+1; }
 typedef unsigned char byte;
 void takes_double(double& x) {}
 void takes_float(float& x) {}
 void takes_long(long& x) {}
 void takes_int(int& x) {}
 void takes_char(char& x) {}
 void takes_ulong(unsigned long& x) {}
 void takes_uint(unsigned int& x) {}
 void takes_uchar(unsigned char& x) {}
 void takes_bool(bool& x) {}
 void takes_size_t(size_t& x) {}
 cmplx zsum(cmplx* zarray, int n) {
     cmplx sum(0);
     for (int i = 0; i < n; ++i) sum += zarray[i];
     return sum;
 }
 Pair* null_pair() { return NULL; }
 int is_null(Pair* p) { return !p; }
 char* null_string() { return NULL; }
 int is_null(double* data) { return !data; }
 void test_null_obj(Pair& p) { }
 void test_bad_pair(Pair* p) { }
 Pair test_return_obj() { return Pair(1.5, 2.5); }
 double* test_return_array(Pair& p) { return p.xy; }
 double* test_return_array2(Pair& p) { return p.xy; }
 double test_return_scalar(double* xy) { return xy[0] + xy[1]; }
 cmplx test_return_zscalar(cmplx* xy) { return xy[0] + xy[1]; }
 const char* test_return_string() { return "Hello, world!"; }
 Pair* test_return_p_obj() { return new Pair(3, 5); }
 int* test_return_p_scalar(int* a, int* b) { return (*a > *b) ? a : b; }
 cmplx* test_return_p_zscalar(cmplx* a, cmplx* b) { 
     return (a->real() > b->real()) ? a : b; 
 }
 Pair& test_return_r_obj(Pair& p) { return p; }
 int& test_return_r_scalar(int& a, int& b) { return (a > b) ? a : b; }
 cmplx& test_return_r_zscalar(cmplx& a, cmplx& b) { 
     return (a.real() > b.real()) ? a : b; 
 }
 double test_input_obj(Pair p) { return p.xy[0] + p.xy[1]; }
 double test_input_array(double* xy) { return xy[0] + xy[1]; }
 double test_input_array2(double* xy) { return xy[0] + xy[1]; }
 cmplx test_input_zarray(cmplx* xy) { return xy[0] + xy[1]; }
 int test_input_scalar(int x) { return x+1; }
 cmplx test_input_zscalar(cmplx x) { return x+1.0; }
 int test_input_string(char* s) { return strlen(s); }
 double test_input_p_obj(Pair* p) { return p->xy[0] + p->xy[1]; }
 int test_input_p_scalar(int* x) { return *x+1; }
 cmplx test_input_p_zscalar(cmplx* x) { return *x+1.0; }
 double test_input_r_obj(Pair& p) { return p.xy[0] + p.xy[1]; }
 int test_input_r_scalar(int& x) { return x+1; }
 cmplx test_input_r_zscalar(cmplx& x) { return x+1.0; }
 void test_output_array(double* xy) { xy[0] = 1; xy[1] = 2; }
 void test_output_rarray(const double*& xy) { 
   static double result[2] = {7, 11};
   xy = result;
 }
 void test_output_rarray2(const double*& xy) { xy = NULL; }
 void test_output_zarray(cmplx* xy) { xy[0] = 1; xy[1] = 2; }
 void test_output_zarray2(cmplx* xy) { xy[0] = cmplx(1,3); xy[1] = 2; }
 void test_output_p_scalar(int* i) { *i = 202; }
 void test_output_p_zscalar(cmplx* z) { *z = cmplx(202,303); }
 void test_output_r_scalar(int& i) { i = 303; }
 void test_output_r_zscalar(cmplx& z) { z = cmplx(303,404); }
 void test_inout_array(double* xy) { xy[0] += 1; xy[1] += 1; }
 void test_inout_p_scalar(int* i) { *i += 202; }
 void test_inout_r_scalar(int& i) { i += 303; }
 #include <mex.h>
 double test_mx_input(const mxArray* x) { return *mxGetPr(x); }
 void test_mx_output(mxArray** x)
 {
     *x = mxCreateString("foobar");
 }
 mxArray* test_mx_return() 
 { 
     mxArray* m = mxCreateDoubleMatrix(1,1, mxREAL);
     *mxGetPr(m) = 42;
     return m;
 }
 const int TEST_CONST = 42;
 int identity(int i) { return i; }

struct my_struct_t {
    double x;
    double y;
};

int my_struct_allocs = 0;

int get_my_struct_allocs()
{
    return my_struct_allocs;
}

my_struct_t* mxWrapGet_my_struct_t(const mxArray* a, const char** e)
{
    // Note -- there really ought to be an error check here
    ++my_struct_allocs;
    my_struct_t* o = new my_struct_t;
    o->x = mxGetPr(a)[0];
    o->y = mxGetPr(a)[1];
    return o;
}

mxArray* mxWrapSet_my_struct_t(my_struct_t* o)
{
    mxArray* a = mxCreateDoubleMatrix(2,1,mxREAL);
    mxGetPr(a)[0] = o->x;
    mxGetPr(a)[1] = o->y;
    return a;
}

my_struct_t* mxWrapAlloc_my_struct_t()
{
    ++my_struct_allocs;
    return new my_struct_t;
}

void mxWrapFree_my_struct_t(my_struct_t* o)
{
    --my_struct_allocs;
    delete o;
}

void unpack_struct(my_struct_t& o, double* xy)
{
    xy[0] = o.x;
    xy[1] = o.y;
}

void pack_struct(my_struct_t& o, double* xy)
{
    o.x = xy[0];
    o.y = xy[1];
}

void swap_struct(my_struct_t& o)
{
    double tmp = o.x;
    o.x = o.y;
    o.y = tmp;
}

my_struct_t& rightmost(my_struct_t& p1, my_struct_t& p2)
{
    return (p1.x >= p2.x) ? p1 : p2;
}

my_struct_t* add1(my_struct_t& o)
{
    o.x += 1;
    o.y += 1;
    return &o;
}




/* Array copier definitions */
mxWrapGetArrayDef(mxWrapGetArray_bool, bool)
mxWrapCopyDef    (mxWrapCopy_bool,     bool)
mxWrapReturnDef  (mxWrapReturn_bool,   bool)
mxWrapGetArrayDef_single(mxWrapGetArray_single_bool, bool)
mxWrapCopyDef_single    (mxWrapCopy_single_bool,     bool)
mxWrapReturnDef_single  (mxWrapReturn_single_bool,   bool)
mxWrapGetArrayDef(mxWrapGetArray_byte, byte)
mxWrapCopyDef    (mxWrapCopy_byte,     byte)
mxWrapReturnDef  (mxWrapReturn_byte,   byte)
mxWrapGetArrayDef_single(mxWrapGetArray_single_byte, byte)
mxWrapCopyDef_single    (mxWrapCopy_single_byte,     byte)
mxWrapReturnDef_single  (mxWrapReturn_single_byte,   byte)
mxWrapGetArrayDef(mxWrapGetArray_char, char)
mxWrapCopyDef    (mxWrapCopy_char,     char)
mxWrapReturnDef  (mxWrapReturn_char,   char)
mxWrapGetArrayDef_single(mxWrapGetArray_single_char, char)
mxWrapCopyDef_single    (mxWrapCopy_single_char,     char)
mxWrapReturnDef_single  (mxWrapReturn_single_char,   char)
mxWrapGetArrayDef(mxWrapGetArray_double, double)
mxWrapCopyDef    (mxWrapCopy_double,     double)
mxWrapReturnDef  (mxWrapReturn_double,   double)
mxWrapGetArrayDef_single(mxWrapGetArray_single_double, double)
mxWrapCopyDef_single    (mxWrapCopy_single_double,     double)
mxWrapReturnDef_single  (mxWrapReturn_single_double,   double)
mxWrapGetArrayDef(mxWrapGetArray_float, float)
mxWrapCopyDef    (mxWrapCopy_float,     float)
mxWrapReturnDef  (mxWrapReturn_float,   float)
mxWrapGetArrayDef_single(mxWrapGetArray_single_float, float)
mxWrapCopyDef_single    (mxWrapCopy_single_float,     float)
mxWrapReturnDef_single  (mxWrapReturn_single_float,   float)
mxWrapGetArrayDef(mxWrapGetArray_int, int)
mxWrapCopyDef    (mxWrapCopy_int,     int)
mxWrapReturnDef  (mxWrapReturn_int,   int)
mxWrapGetArrayDef_single(mxWrapGetArray_single_int, int)
mxWrapCopyDef_single    (mxWrapCopy_single_int,     int)
mxWrapReturnDef_single  (mxWrapReturn_single_int,   int)
mxWrapGetArrayDef(mxWrapGetArray_long, long)
mxWrapCopyDef    (mxWrapCopy_long,     long)
mxWrapReturnDef  (mxWrapReturn_long,   long)
mxWrapGetArrayDef_single(mxWrapGetArray_single_long, long)
mxWrapCopyDef_single    (mxWrapCopy_single_long,     long)
mxWrapReturnDef_single  (mxWrapReturn_single_long,   long)
mxWrapGetArrayDef(mxWrapGetArray_ptrdiff_t, ptrdiff_t)
mxWrapCopyDef    (mxWrapCopy_ptrdiff_t,     ptrdiff_t)
mxWrapReturnDef  (mxWrapReturn_ptrdiff_t,   ptrdiff_t)
mxWrapGetArrayDef_single(mxWrapGetArray_single_ptrdiff_t, ptrdiff_t)
mxWrapCopyDef_single    (mxWrapCopy_single_ptrdiff_t,     ptrdiff_t)
mxWrapReturnDef_single  (mxWrapReturn_single_ptrdiff_t,   ptrdiff_t)
mxWrapGetArrayDef(mxWrapGetArray_short, short)
mxWrapCopyDef    (mxWrapCopy_short,     short)
mxWrapReturnDef  (mxWrapReturn_short,   short)
mxWrapGetArrayDef_single(mxWrapGetArray_single_short, short)
mxWrapCopyDef_single    (mxWrapCopy_single_short,     short)
mxWrapReturnDef_single  (mxWrapReturn_single_short,   short)
mxWrapGetArrayDef(mxWrapGetArray_size_t, size_t)
mxWrapCopyDef    (mxWrapCopy_size_t,     size_t)
mxWrapReturnDef  (mxWrapReturn_size_t,   size_t)
mxWrapGetArrayDef_single(mxWrapGetArray_single_size_t, size_t)
mxWrapCopyDef_single    (mxWrapCopy_single_size_t,     size_t)
mxWrapReturnDef_single  (mxWrapReturn_single_size_t,   size_t)
mxWrapGetArrayDef(mxWrapGetArray_uchar, uchar)
mxWrapCopyDef    (mxWrapCopy_uchar,     uchar)
mxWrapReturnDef  (mxWrapReturn_uchar,   uchar)
mxWrapGetArrayDef_single(mxWrapGetArray_single_uchar, uchar)
mxWrapCopyDef_single    (mxWrapCopy_single_uchar,     uchar)
mxWrapReturnDef_single  (mxWrapReturn_single_uchar,   uchar)
mxWrapGetArrayDef(mxWrapGetArray_uint, uint)
mxWrapCopyDef    (mxWrapCopy_uint,     uint)
mxWrapReturnDef  (mxWrapReturn_uint,   uint)
mxWrapGetArrayDef_single(mxWrapGetArray_single_uint, uint)
mxWrapCopyDef_single    (mxWrapCopy_single_uint,     uint)
mxWrapReturnDef_single  (mxWrapReturn_single_uint,   uint)
mxWrapGetArrayDef(mxWrapGetArray_ulong, ulong)
mxWrapCopyDef    (mxWrapCopy_ulong,     ulong)
mxWrapReturnDef  (mxWrapReturn_ulong,   ulong)
mxWrapGetArrayDef_single(mxWrapGetArray_single_ulong, ulong)
mxWrapCopyDef_single    (mxWrapCopy_single_ulong,     ulong)
mxWrapReturnDef_single  (mxWrapReturn_single_ulong,   ulong)
mxWrapGetScalarZDef(mxWrapGetScalar_cmplx, cmplx,
                    double, setz_cmplx)
mxWrapGetArrayZDef (mxWrapGetArray_cmplx, cmplx,
                    double, setz_cmplx)
mxWrapCopyZDef     (mxWrapCopy_cmplx, cmplx,
                    real_cmplx, imag_cmplx)
mxWrapReturnZDef   (mxWrapReturn_cmplx, cmplx,
                    real_cmplx, imag_cmplx)
mxWrapGetScalarZDef_single(mxWrapGetScalar_single_cmplx, cmplx,
                    double, setz_cmplx)
mxWrapGetArrayZDef_single (mxWrapGetArray_single_cmplx, cmplx,
                    double, setz_cmplx)
mxWrapCopyZDef_single     (mxWrapCopy_single_cmplx, cmplx,
                    real_cmplx, imag_cmplx)
mxWrapReturnZDef_single   (mxWrapReturn_single_cmplx, cmplx,
                    real_cmplx, imag_cmplx)


Pair* mxWrapGetP_Pair(const mxArray* a, const char** e)
{
    char pbuf[128];
    if (mxGetClassID(a) == mxDOUBLE_CLASS &&
        mxGetM(a)*mxGetN(a) == 1 &&
#if MX_HAS_INTERLEAVED_COMPLEX
        ((mxIsComplex(a) ? ((*mxGetComplexDoubles(a)).real == 0 && (*mxGetComplexDoubles(a)).imag == 0) : *mxGetDoubles(a) == 0))
#else
        *mxGetPr(a) == 0
#endif
        )
        return NULL;
    if (!mxIsChar(a)) {
#ifdef R2008OO
        mxArray* ap = mxGetProperty(a, 0, "mwptr");
        if (ap)
            return mxWrapGetP_Pair(ap, e);
#endif
        *e = "Invalid pointer";
        return NULL;
    }
    mxGetString(a, pbuf, sizeof(pbuf));

    Pair* p_Pair = NULL;
    sscanf(pbuf, "Pair:%p", &p_Pair);
    if (p_Pair)
        return p_Pair;

    DerivedPair* p_DerivedPair = NULL;
    sscanf(pbuf, "DerivedPair:%p", &p_DerivedPair);
    if (p_DerivedPair)
        return p_DerivedPair;

    *e = "Invalid pointer to Pair";
    return NULL;
}


Parent1* mxWrapGetP_Parent1(const mxArray* a, const char** e)
{
    char pbuf[128];
    if (mxGetClassID(a) == mxDOUBLE_CLASS &&
        mxGetM(a)*mxGetN(a) == 1 &&
#if MX_HAS_INTERLEAVED_COMPLEX
        ((mxIsComplex(a) ? ((*mxGetComplexDoubles(a)).real == 0 && (*mxGetComplexDoubles(a)).imag == 0) : *mxGetDoubles(a) == 0))
#else
        *mxGetPr(a) == 0
#endif
        )
        return NULL;
    if (!mxIsChar(a)) {
#ifdef R2008OO
        mxArray* ap = mxGetProperty(a, 0, "mwptr");
        if (ap)
            return mxWrapGetP_Parent1(ap, e);
#endif
        *e = "Invalid pointer";
        return NULL;
    }
    mxGetString(a, pbuf, sizeof(pbuf));

    Parent1* p_Parent1 = NULL;
    sscanf(pbuf, "Parent1:%p", &p_Parent1);
    if (p_Parent1)
        return p_Parent1;

    Child* p_Child = NULL;
    sscanf(pbuf, "Child:%p", &p_Child);
    if (p_Child)
        return p_Child;

    *e = "Invalid pointer to Parent1";
    return NULL;
}


Parent2* mxWrapGetP_Parent2(const mxArray* a, const char** e)
{
    char pbuf[128];
    if (mxGetClassID(a) == mxDOUBLE_CLASS &&
        mxGetM(a)*mxGetN(a) == 1 &&
#if MX_HAS_INTERLEAVED_COMPLEX
        ((mxIsComplex(a) ? ((*mxGetComplexDoubles(a)).real == 0 && (*mxGetComplexDoubles(a)).imag == 0) : *mxGetDoubles(a) == 0))
#else
        *mxGetPr(a) == 0
#endif
        )
        return NULL;
    if (!mxIsChar(a)) {
#ifdef R2008OO
        mxArray* ap = mxGetProperty(a, 0, "mwptr");
        if (ap)
            return mxWrapGetP_Parent2(ap, e);
#endif
        *e = "Invalid pointer";
        return NULL;
    }
    mxGetString(a, pbuf, sizeof(pbuf));

    Parent2* p_Parent2 = NULL;
    sscanf(pbuf, "Parent2:%p", &p_Parent2);
    if (p_Parent2)
        return p_Parent2;

    Child* p_Child = NULL;
    sscanf(pbuf, "Child:%p", &p_Child);
    if (p_Child)
        return p_Child;

    *e = "Invalid pointer to Parent2";
    return NULL;
}

/* ---- test_transfers.mw: 81 ----
 * Child* c = new();
 */
static const char* stubids1_ = "c o Child* = new()";

void mexStub1(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Child*      out0_=0; /* c          */

    if (mexprofrecord_)
        mexprofrecord_[1]++;
    out0_ = new Child();
    plhs[0] = mxWrapCreateP(out0_, "Child:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 82 ----
 * int d1 = c->Parent1.data1();
 */
static const char* stubids2_ = "c o int = c->Parent1.data1()";

void mexStub2(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Parent1*    in0_ =0; /* c          */
    int         out0_;   /* d1         */

    in0_ = mxWrapGetP_Parent1(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[2]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->data1();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 83 ----
 * int d2 = c->Parent2.data2();
 */
static const char* stubids3_ = "c o int = c->Parent2.data2()";

void mexStub3(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Parent2*    in0_ =0; /* c          */
    int         out0_;   /* d2         */

    in0_ = mxWrapGetP_Parent2(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[3]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->data2();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 84 ----
 * int dd = c->Child.datas();
 */
static const char* stubids4_ = "c o int = c->Child.datas()";

void mexStub4(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Child*      in0_ =0; /* c          */
    int         out0_;   /* dd         */

    in0_ = (Child*) mxWrapGetP(prhs[0], "Child:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[4]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->datas();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 97 ----
 * int x = OuterClass::static_method();
 */
static const char* stubids5_ = "c o int = OuterClass::static_method()";

void mexStub5(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         out0_;   /* x          */

    if (mexprofrecord_)
        mexprofrecord_[5]++;
    out0_ = OuterClass::static_method();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 105 ----
 * int y = literal_plus1(int 7);
 */
static const char* stubids6_ = "c o int = literal_plus1(c i int)";

void mexStub6(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* 7          */
    int         out0_;   /* y          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[6]++;
    out0_ = literal_plus1(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 106 ----
 * int l = strlen(cstring 'Test');
 */
static const char* stubids7_ = "c o int = strlen(c i cstring)";

void mexStub7(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* 'Test'     */
    int         out0_;   /* l          */

    in0_ = mxWrapGetString(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[7]++;
    out0_ = strlen(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 127 ----
 * takes_double(double& x);
 */
static const char* stubids8_ = "takes_double(c i double&)";

void mexStub8(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double      in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (double) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[8]++;
    takes_double(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 128 ----
 * takes_float(float& xs);
 */
static const char* stubids9_ = "takes_float(c i float&)";

void mexStub9(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    float       in0_;    /* xs         */

    if( mxGetClassID(prhs[0]) != mxSINGLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxSINGLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (float) mxWrapGetScalar_single(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[9]++;
    takes_float(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 129 ----
 * takes_long(long& x);
 */
static const char* stubids10_ = "takes_long(c i long&)";

void mexStub10(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    long        in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (long) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[10]++;
    takes_long(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 130 ----
 * takes_int(int& x);
 */
static const char* stubids11_ = "takes_int(c i int&)";

void mexStub11(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[11]++;
    takes_int(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 131 ----
 * takes_char(char& xc);
 */
static const char* stubids12_ = "takes_char(c i char&)";

void mexStub12(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char        in0_;    /* xc         */

    if( mxGetClassID(prhs[0]) != mxCHAR_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxCHAR_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (char) mxWrapGetScalar_char(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[12]++;
    takes_char(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 132 ----
 * takes_ulong(ulong& x);
 */
static const char* stubids13_ = "takes_ulong(c i ulong&)";

void mexStub13(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    ulong       in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (ulong) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[13]++;
    takes_ulong(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 133 ----
 * takes_uint(uint& x);
 */
static const char* stubids14_ = "takes_uint(c i uint&)";

void mexStub14(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    uint        in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (uint) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[14]++;
    takes_uint(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 134 ----
 * takes_uchar(uchar& x);
 */
static const char* stubids15_ = "takes_uchar(c i uchar&)";

void mexStub15(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    uchar       in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (uchar) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[15]++;
    takes_uchar(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 135 ----
 * takes_uchar(byte& x);
 */
static const char* stubids16_ = "takes_uchar(c i byte&)";

void mexStub16(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    byte        in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (byte) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[16]++;
    takes_uchar(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 136 ----
 * takes_bool(bool& x);
 */
static const char* stubids17_ = "takes_bool(c i bool&)";

void mexStub17(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    bool        in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (bool) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[17]++;
    takes_bool(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 137 ----
 * takes_size_t(size_t& x);
 */
static const char* stubids18_ = "takes_size_t(c i size_t&)";

void mexStub18(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    size_t      in0_;    /* x          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (size_t) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[18]++;
    takes_size_t(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 140 ----
 * DerivedPair* dp = new();
 */
static const char* stubids19_ = "c o DerivedPair* = new()";

void mexStub19(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    DerivedPair*  out0_=0; /* dp         */

    if (mexprofrecord_)
        mexprofrecord_[19]++;
    out0_ = new DerivedPair();
    plhs[0] = mxWrapCreateP(out0_, "DerivedPair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 141 ----
 * double x = dp->Pair.x();
 */
static const char* stubids20_ = "c o double = dp->Pair.x()";

void mexStub20(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* dp         */
    double      out0_;   /* x          */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[20]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->x();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 156 ----
 * cmplx result = zsum(cmplx[] zarray, int n);
 */
static const char* stubids21_ = "c o cmplx = zsum(c i cmplx[], c i int)";

void mexStub21(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx*      in0_ =0; /* zarray     */
    int         in1_;    /* n          */
    cmplx       out0_;   /* result     */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        in0_ = mxWrapGetArray_cmplx(prhs[0], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in0_ = NULL;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[21]++;
    out0_ = zsum(in0_, in1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 164 ----
 * Pair* p = null_pair();
 */
static const char* stubids22_ = "c o Pair* = null_pair()";

void mexStub22(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       out0_=0; /* p          */

    if (mexprofrecord_)
        mexprofrecord_[22]++;
    out0_ = null_pair();
    plhs[0] = mxWrapCreateP(out0_, "Pair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 168 ----
 * int flag = is_null(Pair* p);
 */
static const char* stubids23_ = "c o int = is_null(c i Pair*)";

void mexStub23(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    int         out0_;   /* flag       */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[23]++;
    out0_ = is_null(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 172 ----
 * cstring s = null_string();
 */
static const char* stubids24_ = "c o cstring = null_string()";

void mexStub24(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;

    if (mexprofrecord_)
        mexprofrecord_[24]++;
    plhs[0] = mxWrapStrncpy(null_string());

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 175 ----
 * char* c = null_string();
 */
static const char* stubids25_ = "c o char* = null_string()";

void mexStub25(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;

    if (mexprofrecord_)
        mexprofrecord_[25]++;
    plhs[0] = mxWrapReturn_char(null_string(), 1, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 180 ----
 * int flag = is_null(double[] nil);
 */
static const char* stubids26_ = "c o int = is_null(c i double[])";

void mexStub26(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* nil        */
    int         out0_;   /* flag       */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
            mw_err_txt_ = "Invalid array argument, mxDOUBLE_CLASS expected";
        if (mw_err_txt_) goto mw_err_label;
#if MX_HAS_INTERLEAVED_COMPLEX
        in0_ = mxGetDoubles(prhs[0]);
#else
        in0_ = mxGetPr(prhs[0]);
#endif
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[26]++;
    out0_ = is_null(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 183 ----
 * char[1] ca = null_string();
 */
static const char* stubids27_ = "c o char[x] = null_string()";

void mexStub27(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    mwSize      dim0_;   /* 1          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    if (mexprofrecord_)
        mexprofrecord_[27]++;
    plhs[0] = mxWrapReturn_char(null_string(), dim0_, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 188 ----
 * test_null_obj(Pair p);
 */
static const char* stubids28_ = "test_null_obj(c i Pair)";

void mexStub28(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[28]++;
    test_null_obj(*in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 192 ----
 * test_null_obj(Pair& p);
 */
static const char* stubids29_ = "test_null_obj(c i Pair&)";

void mexStub29(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[29]++;
    test_null_obj(*in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 197 ----
 * double x = p->Pair.x();
 * Also at test_transfers.mw: 216
 */
static const char* stubids30_ = "c o double = p->Pair.x()";

void mexStub30(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    double      out0_;   /* x          */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[30]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->x();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 201 ----
 * BadPair* bp = new();
 */
static const char* stubids31_ = "c o BadPair* = new()";

void mexStub31(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    BadPair*    out0_=0; /* bp         */

    if (mexprofrecord_)
        mexprofrecord_[31]++;
    out0_ = new BadPair();
    plhs[0] = mxWrapCreateP(out0_, "BadPair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 204 ----
 * test_bad_pair(Pair* bp);
 */
static const char* stubids32_ = "test_bad_pair(c i Pair*)";

void mexStub32(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* bp         */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[32]++;
    test_bad_pair(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 207 ----
 * delete(BadPair* bp);
 */
static const char* stubids33_ = "delete(c i BadPair*)";

void mexStub33(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    BadPair*    in0_ =0; /* bp         */

    in0_ = (BadPair*) mxWrapGetP(prhs[0], "BadPair:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[33]++;
    delete(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 215 ----
 * Pair* p = new(double x, double y);
 * Also at test_transfers.mw: 296
 */
static const char* stubids34_ = "c o Pair* = new(c i double, c i double)";

void mexStub34(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double      in0_;    /* x          */
    double      in1_;    /* y          */
    Pair*       out0_=0; /* p          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (double) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (double) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[34]++;
    out0_ = new Pair(in0_, in1_);
    plhs[0] = mxWrapCreateP(out0_, "Pair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 217 ----
 * double yy = p->Pair.y();
 */
static const char* stubids36_ = "c o double = p->Pair.y()";

void mexStub36(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    double      out0_;   /* yy         */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[36]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    out0_ = in0_->y();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 218 ----
 * delete(Pair* p);
 * Also at test_transfers.mw: 288
 */
static const char* stubids37_ = "delete(c i Pair*)";

void mexStub37(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[37]++;
    delete(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 227 ----
 * Pair p1 = test_return_obj();
 */
static const char* stubids38_ = "c o Pair = test_return_obj()";

void mexStub38(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       out0_=0; /* p1         */

    if (mexprofrecord_)
        mexprofrecord_[38]++;
    out0_ = new Pair(test_return_obj());
    plhs[0] = mxWrapCreateP(out0_, "Pair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 231 ----
 * double[2] xy = test_return_array(Pair& p1);
 * Also at test_transfers.mw: 255
 */
static const char* stubids39_ = "c o double[x] = test_return_array(c i Pair&)";

void mexStub39(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p1         */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p1 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[39]++;
    plhs[0] = mxWrapReturn_double(test_return_array(*in0_), dim1_, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 235 ----
 * double[2] xy = test_return_array2(Pair& p1);
 */
static const char* stubids40_ = "c o double[x] = test_return_array2(c i Pair&)";

void mexStub40(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p1         */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p1 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[40]++;
    plhs[0] = mxWrapReturn_double(test_return_array2(*in0_), dim1_, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 239 ----
 * double sum = test_return_scalar(double[] xy);
 */
static const char* stubids41_ = "c o double = test_return_scalar(c i double[])";

void mexStub41(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* xy         */
    double      out0_;   /* sum        */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
            mw_err_txt_ = "Invalid array argument, mxDOUBLE_CLASS expected";
        if (mw_err_txt_) goto mw_err_label;
#if MX_HAS_INTERLEAVED_COMPLEX
        in0_ = mxGetDoubles(prhs[0]);
#else
        in0_ = mxGetPr(prhs[0]);
#endif
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[41]++;
    out0_ = test_return_scalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 244 ----
 * cmplx sum1 = test_return_zscalar(cmplx[] xy);
 * Also at test_transfers.mw: 245
 */
static const char* stubids42_ = "c o cmplx = test_return_zscalar(c i cmplx[])";

void mexStub42(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx*      in0_ =0; /* xy         */
    cmplx       out0_;   /* sum1       */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        in0_ = mxWrapGetArray_cmplx(prhs[0], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[42]++;
    out0_ = test_return_zscalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 250 ----
 * cstring s = test_return_string();
 */
static const char* stubids44_ = "c o cstring = test_return_string()";

void mexStub44(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;

    if (mexprofrecord_)
        mexprofrecord_[44]++;
    plhs[0] = mxWrapStrncpy(test_return_string());

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 254 ----
 * Pair* p2 = test_return_p_obj();
 */
static const char* stubids45_ = "c o Pair* = test_return_p_obj()";

void mexStub45(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       out0_=0; /* p2         */

    if (mexprofrecord_)
        mexprofrecord_[45]++;
    out0_ = test_return_p_obj();
    plhs[0] = mxWrapCreateP(out0_, "Pair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 260 ----
 * int* z1 = test_return_p_scalar(int* a, int* b);
 */
static const char* stubids47_ = "c o int* = test_return_p_scalar(c i int*, c i int*)";

void mexStub47(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* a          */
    int         in1_;    /* b          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[47]++;
    plhs[0] = mxWrapReturn_int(test_return_p_scalar(&in0_, &in1_), 1, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 267 ----
 * cmplx* z1 = test_return_p_zscalar(cmplx* a, cmplx* b);
 * Also at test_transfers.mw: 268
 */
static const char* stubids48_ = "c o cmplx* = test_return_p_zscalar(c i cmplx*, c i cmplx*)";

void mexStub48(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       in0_;    /* a          */
    cmplx       in1_;    /* b          */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in0_, prhs[0]);

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in1_, prhs[1]);

    if (mexprofrecord_)
        mexprofrecord_[48]++;
    plhs[0] = mxWrapReturn_cmplx(test_return_p_zscalar(&in0_, &in1_), 1, 1);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 273 ----
 * Pair& p2c = test_return_r_obj(Pair& p2);
 */
static const char* stubids50_ = "c o Pair& = test_return_r_obj(c i Pair&)";

void mexStub50(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p2         */
    Pair*       out0_=0; /* p2c        */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p2 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[50]++;
    out0_ = &(test_return_r_obj(*in0_));
    plhs[0] = mxWrapCreateP(out0_, "Pair:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 277 ----
 * int& z2 = test_return_r_scalar(int& a, int& b);
 */
static const char* stubids51_ = "c o int& = test_return_r_scalar(c i int&, c i int&)";

void mexStub51(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* a          */
    int         in1_;    /* b          */
    int         out0_;   /* z2         */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[51]++;
    out0_ = test_return_r_scalar(in0_, in1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 283 ----
 * cmplx& z2 = test_return_r_zscalar(cmplx& a, cmplx& b);
 * Also at test_transfers.mw: 284
 */
static const char* stubids52_ = "c o cmplx& = test_return_r_zscalar(c i cmplx&, c i cmplx&)";

void mexStub52(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       in0_;    /* a          */
    cmplx       in1_;    /* b          */
    cmplx       out0_;   /* z2         */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in0_, prhs[0]);

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in1_, prhs[1]);

    if (mexprofrecord_)
        mexprofrecord_[52]++;
    out0_ = test_return_r_zscalar(in0_, in1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 298 ----
 * double sum = test_input_obj(Pair p);
 */
static const char* stubids57_ = "c o double = test_input_obj(c i Pair)";

void mexStub57(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    double      out0_;   /* sum        */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[57]++;
    out0_ = test_input_obj(*in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 303 ----
 * double sum = test_input_array(double[2] xy);
 */
static const char* stubids58_ = "c o double = test_input_array(c i double[x])";

void mexStub58(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* xy         */
    double      out0_;   /* sum        */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != dim1_) {
        mw_err_txt_ = "Bad argument size: xy";        goto mw_err_label;
    }

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
            mw_err_txt_ = "Invalid array argument, mxDOUBLE_CLASS expected";
        if (mw_err_txt_) goto mw_err_label;
#if MX_HAS_INTERLEAVED_COMPLEX
        in0_ = mxGetDoubles(prhs[0]);
#else
        in0_ = mxGetPr(prhs[0]);
#endif
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[58]++;
    out0_ = test_input_array(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 307 ----
 * double sum = test_input_array2(double[2] xy);
 */
static const char* stubids59_ = "c o double = test_input_array2(c i double[x])";

void mexStub59(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* xy         */
    double      out0_;   /* sum        */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != dim1_) {
        mw_err_txt_ = "Bad argument size: xy";        goto mw_err_label;
    }

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
            mw_err_txt_ = "Invalid array argument, mxDOUBLE_CLASS expected";
        if (mw_err_txt_) goto mw_err_label;
#if MX_HAS_INTERLEAVED_COMPLEX
        in0_ = mxGetDoubles(prhs[0]);
#else
        in0_ = mxGetPr(prhs[0]);
#endif
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[59]++;
    out0_ = test_input_array2(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 312 ----
 * cmplx sum = test_input_zarray(cmplx[2] xy);
 * Also at test_transfers.mw: 313
 */
static const char* stubids60_ = "c o cmplx = test_input_zarray(c i cmplx[x])";

void mexStub60(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx*      in0_ =0; /* xy         */
    cmplx       out0_;   /* sum        */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != dim1_) {
        mw_err_txt_ = "Bad argument size: xy";        goto mw_err_label;
    }

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        in0_ = mxWrapGetArray_cmplx(prhs[0], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[60]++;
    out0_ = test_input_zarray(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 318 ----
 * int xp1 = test_input_scalar(int x);
 */
static const char* stubids62_ = "c o int = test_input_scalar(c i int)";

void mexStub62(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* x          */
    int         out0_;   /* xp1        */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[62]++;
    out0_ = test_input_scalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 323 ----
 * cmplx xp1 = test_input_zscalar(cmplx x);
 * Also at test_transfers.mw: 324
 */
static const char* stubids63_ = "c o cmplx = test_input_zscalar(c i cmplx)";

void mexStub63(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       in0_;    /* x          */
    cmplx       out0_;   /* xp1        */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in0_, prhs[0]);

    if (mexprofrecord_)
        mexprofrecord_[63]++;
    out0_ = test_input_zscalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 330 ----
 * int msglen = test_input_string(cstring msg);
 */
static const char* stubids65_ = "c o int = test_input_string(c i cstring)";

void mexStub65(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* msg        */
    int         out0_;   /* msglen     */

    in0_ = mxWrapGetString(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[65]++;
    out0_ = test_input_string(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 334 ----
 * double sum2 = test_input_p_obj(Pair* p);
 */
static const char* stubids66_ = "c o double = test_input_p_obj(c i Pair*)";

void mexStub66(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    double      out0_;   /* sum2       */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[66]++;
    out0_ = test_input_p_obj(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 338 ----
 * int xp1b = test_input_p_scalar(int* x);
 */
static const char* stubids67_ = "c o int = test_input_p_scalar(c i int*)";

void mexStub67(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* x          */
    int         out0_;   /* xp1b       */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[67]++;
    out0_ = test_input_p_scalar(&in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 342 ----
 * cmplx xp1b = test_input_p_zscalar(cmplx* x);
 * Also at test_transfers.mw: 343
 */
static const char* stubids68_ = "c o cmplx = test_input_p_zscalar(c i cmplx*)";

void mexStub68(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       in0_;    /* x          */
    cmplx       out0_;   /* xp1b       */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in0_, prhs[0]);

    if (mexprofrecord_)
        mexprofrecord_[68]++;
    out0_ = test_input_p_zscalar(&in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 348 ----
 * double sum3 = test_input_r_obj(Pair& p);
 */
static const char* stubids70_ = "c o double = test_input_r_obj(c i Pair&)";

void mexStub70(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Pair*       in0_ =0; /* p          */
    double      out0_;   /* sum3       */

    in0_ = mxWrapGetP_Pair(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument p cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[70]++;
    out0_ = test_input_r_obj(*in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 352 ----
 * int xp1c = test_input_r_scalar(int& x);
 */
static const char* stubids71_ = "c o int = test_input_r_scalar(c i int&)";

void mexStub71(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* x          */
    int         out0_;   /* xp1c       */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[71]++;
    out0_ = test_input_r_scalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 356 ----
 * cmplx xp1c = test_input_r_zscalar(cmplx& x);
 * Also at test_transfers.mw: 357
 */
static const char* stubids72_ = "c o cmplx = test_input_r_zscalar(c i cmplx&)";

void mexStub72(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       in0_;    /* x          */
    cmplx       out0_;   /* xp1c       */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    mxWrapGetScalar_cmplx(&in0_, prhs[0]);

    if (mexprofrecord_)
        mexprofrecord_[72]++;
    out0_ = test_input_r_zscalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 368 ----
 * test_output_array(output double[2] xy);
 */
static const char* stubids75_ = "test_output_array(c o double[x])";

void mexStub75(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     out0_=0; /* xy         */
    mwSize      dim0_;   /* 2          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    out0_ = (double*) mxMalloc(dim0_*sizeof(double));
    if (mexprofrecord_)
        mexprofrecord_[75]++;
    test_output_array(out0_);
    plhs[0] = mxCreateDoubleMatrix(dim0_, 1, mxREAL);
    mxWrapCopy_double(plhs[0], out0_, dim0_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 375 ----
 * test_output_rarray(output doubler xyr);
 */
static const char* stubids76_ = "test_output_rarray(c o doubler)";

void mexStub76(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const double*  out0_;   /* xyr        */
    mwSize      dim0_;   /* 2          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    out0_ = (double*) NULL;
    if (mexprofrecord_)
        mexprofrecord_[76]++;
    test_output_rarray(out0_);
    if (out0_ == NULL) {
        plhs[0] = mxCreateDoubleMatrix(0,0, mxREAL);
    } else {
        plhs[0] = mxCreateDoubleMatrix(dim0_, 1, mxREAL);
        mxWrapCopy_double(plhs[0], out0_, dim0_);
    }

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 379 ----
 * test_output_rarray2(output doubler xyr2);
 */
static const char* stubids77_ = "test_output_rarray2(c o doubler)";

void mexStub77(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const double*  out0_;   /* xyr2       */
    mwSize      dim0_;   /* 2          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    out0_ = (double*) NULL;
    if (mexprofrecord_)
        mexprofrecord_[77]++;
    test_output_rarray2(out0_);
    if (out0_ == NULL) {
        plhs[0] = mxCreateDoubleMatrix(0,0, mxREAL);
    } else {
        plhs[0] = mxCreateDoubleMatrix(dim0_, 1, mxREAL);
        mxWrapCopy_double(plhs[0], out0_, dim0_);
    }

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 384 ----
 * test_output_zarray(output cmplx[2] xy);
 */
static const char* stubids78_ = "test_output_zarray(c o cmplx[x])";

void mexStub78(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx*      out0_=0; /* xy         */
    mwSize      dim0_;   /* 2          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    out0_ = (cmplx*) mxMalloc(dim0_*sizeof(cmplx));
    if (mexprofrecord_)
        mexprofrecord_[78]++;
    test_output_zarray(out0_);
    plhs[0] = mxCreateDoubleMatrix(dim0_, 1, mxCOMPLEX);
    mxWrapCopy_cmplx(plhs[0], out0_, dim0_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 385 ----
 * test_output_zarray2(output cmplx[2] xy_z);
 */
static const char* stubids79_ = "test_output_zarray2(c o cmplx[x])";

void mexStub79(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx*      out0_=0; /* xy_z       */
    mwSize      dim0_;   /* 2          */

    dim0_ = (mwSize) mxWrapGetScalar(prhs[0], &mw_err_txt_);

    out0_ = (cmplx*) mxMalloc(dim0_*sizeof(cmplx));
    if (mexprofrecord_)
        mexprofrecord_[79]++;
    test_output_zarray2(out0_);
    plhs[0] = mxCreateDoubleMatrix(dim0_, 1, mxCOMPLEX);
    mxWrapCopy_cmplx(plhs[0], out0_, dim0_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 390 ----
 * snprintf(output cstring[128] buf, int 128, cstring fmt, int i);
 */
static const char* stubids80_ = "snprintf(c o cstring[x], c i int, c i cstring, c i int)";

void mexStub80(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* 128        */
    char*       in1_ =0; /* fmt        */
    int         in2_;    /* i          */
    char*       out0_=0; /* buf        */
    mwSize      dim3_;   /* 128        */

    dim3_ = (mwSize) mxWrapGetScalar(prhs[3], &mw_err_txt_);

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in1_ = mxWrapGetString(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[2]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    out0_ = (char*) mxMalloc(dim3_*sizeof(char));
    if (mexprofrecord_)
        mexprofrecord_[80]++;
    snprintf(out0_, in0_, in1_, in2_);
    plhs[0] = mxCreateString(out0_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 394 ----
 * test_output_p_scalar(output int* i2);
 */
static const char* stubids81_ = "test_output_p_scalar(c o int*)";

void mexStub81(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         out0_;   /* i2         */

    if (mexprofrecord_)
        mexprofrecord_[81]++;
    test_output_p_scalar(&out0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 398 ----
 * test_output_p_zscalar(output cmplx* z2);
 */
static const char* stubids82_ = "test_output_p_zscalar(c o cmplx*)";

void mexStub82(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       out0_;   /* z2         */

    if (mexprofrecord_)
        mexprofrecord_[82]++;
    test_output_p_zscalar(&out0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 402 ----
 * test_output_r_scalar(output int& i3);
 */
static const char* stubids83_ = "test_output_r_scalar(c o int&)";

void mexStub83(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         out0_;   /* i3         */

    if (mexprofrecord_)
        mexprofrecord_[83]++;
    test_output_r_scalar(out0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 406 ----
 * test_output_r_zscalar(output cmplx& z3);
 */
static const char* stubids84_ = "test_output_r_zscalar(c o cmplx&)";

void mexStub84(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cmplx       out0_;   /* z3         */

    if (mexprofrecord_)
        mexprofrecord_[84]++;
    test_output_r_zscalar(out0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    mxGetComplexDoubles(plhs[0])->real = real_cmplx(out0_);
    mxGetComplexDoubles(plhs[0])->imag = imag_cmplx(out0_);
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxCOMPLEX);
    *mxGetPr(plhs[0]) = real_cmplx(out0_);
    *mxGetPi(plhs[0]) = imag_cmplx(out0_);
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 415 ----
 * test_inout_array(inout double[] xy);
 */
static const char* stubids85_ = "test_inout_array(c io double[])";

void mexStub85(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* xy         */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        in0_ = mxWrapGetArray_double(prhs[0], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in0_ = NULL;

    if (mexprofrecord_)
        mexprofrecord_[85]++;
    test_inout_array(in0_);
    plhs[0] = mxCreateDoubleMatrix(mxGetM(prhs[0]), mxGetN(prhs[0]), mxREAL);
    mxWrapCopy_double(plhs[0], in0_, mxGetM(prhs[0])*mxGetN(prhs[0]));

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 420 ----
 * strcat(inout cstring[128] s1, cstring s2);
 */
static const char* stubids86_ = "strcat(c io cstring[x], c i cstring)";

void mexStub86(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* s1         */
    char*       in1_ =0; /* s2         */
    mwSize      dim2_;   /* 128        */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (char*) mxMalloc(dim2_*sizeof(char));
    if (mxGetString(prhs[0], in0_, dim2_) != 0) {
        mw_err_txt_ = "Invalid string argument";
        goto mw_err_label;
    }

    in1_ = mxWrapGetString(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[86]++;
    strcat(in0_, in1_);
    plhs[0] = mxCreateString(in0_);

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 425 ----
 * test_inout_p_scalar(inout int* i1);
 */
static const char* stubids87_ = "test_inout_p_scalar(c io int*)";

void mexStub87(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* i1         */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[87]++;
    test_inout_p_scalar(&in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = in0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = in0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 430 ----
 * test_inout_r_scalar(inout int& i2);
 */
static const char* stubids88_ = "test_inout_r_scalar(c io int&)";

void mexStub88(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* i2         */

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[88]++;
    test_inout_r_scalar(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = in0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = in0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 441 ----
 * double out1 = test_mx_input(mxArray in1);
 */
static const char* stubids89_ = "c o double = test_mx_input(c i mxArray)";

void mexStub89(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const mxArray*  in0_;    /* in1        */
    double      out0_;   /* out1       */

    in0_ = prhs[0];

    if (mexprofrecord_)
        mexprofrecord_[89]++;
    out0_ = test_mx_input(in0_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 448 ----
 * test_mx_output(output mxArray out2);
 */
static const char* stubids90_ = "test_mx_output(c o mxArray)";

void mexStub90(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;

    if (mexprofrecord_)
        mexprofrecord_[90]++;
    test_mx_output(plhs+0);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 457 ----
 * mxArray out3 = test_mx_return();
 */
static const char* stubids91_ = "c o mxArray = test_mx_return()";

void mexStub91(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;

    if (mexprofrecord_)
        mexprofrecord_[91]++;
    plhs[0] = test_mx_return();

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 466 ----
 * int result = identity(const TEST_CONST);
 * Also at test_transfers.mw: 468
 */
static const char* stubids92_ = "c o int = identity(c i const TEST_CONST)";

void mexStub92(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         out0_;   /* result     */

    if (mexprofrecord_)
        mexprofrecord_[92]++;
    out0_ = identity(TEST_CONST);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 554 ----
 * unpack_struct(my_struct_t& xy1, output double[2] xy2);
 */
static const char* stubids94_ = "unpack_struct(c i my_struct_t&, c o double[x])";

void mexStub94(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    my_struct_t*  in0_ =0; /* xy1        */
    double*     out0_=0; /* xy2        */
    mwSize      dim1_;   /* 2          */

    dim1_ = (mwSize) mxWrapGetScalar(prhs[1], &mw_err_txt_);

    in0_ = mxWrapGet_my_struct_t(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument xy1 cannot be null";
        goto mw_err_label;
    }
    out0_ = (double*) mxMalloc(dim1_*sizeof(double));
    if (mexprofrecord_)
        mexprofrecord_[94]++;
    unpack_struct(*in0_, out0_);
    plhs[0] = mxCreateDoubleMatrix(dim1_, 1, mxREAL);
    mxWrapCopy_double(plhs[0], out0_, dim1_);

mw_err_label:
    if (in0_)  mxWrapFree_my_struct_t(in0_);
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 557 ----
 * pack_struct(output my_struct_t xy3, double[] xy1);
 */
static const char* stubids95_ = "pack_struct(c o my_struct_t, c i double[])";

void mexStub95(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    double*     in0_ =0; /* xy1        */
    my_struct_t*  out0_=0; /* xy3        */

    if (mxGetM(prhs[0])*mxGetN(prhs[0]) != 0) {
        if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
            mw_err_txt_ = "Invalid array argument, mxDOUBLE_CLASS expected";
        if (mw_err_txt_) goto mw_err_label;
#if MX_HAS_INTERLEAVED_COMPLEX
        in0_ = mxGetDoubles(prhs[0]);
#else
        in0_ = mxGetPr(prhs[0]);
#endif
    } else
        in0_ = NULL;

    out0_ = mxWrapAlloc_my_struct_t();
    if (mexprofrecord_)
        mexprofrecord_[95]++;
    pack_struct(*out0_, in0_);
    plhs[0] = mxWrapSet_my_struct_t(out0_);

mw_err_label:
    if (out0_) mxWrapFree_my_struct_t(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 561 ----
 * swap_struct(inout my_struct_t xy4);
 */
static const char* stubids96_ = "swap_struct(c io my_struct_t)";

void mexStub96(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    my_struct_t*  in0_ =0; /* xy4        */

    in0_ = mxWrapGet_my_struct_t(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument xy4 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[96]++;
    swap_struct(*in0_);
    plhs[0] = mxWrapSet_my_struct_t(in0_);

mw_err_label:
    if (in0_)  mxWrapFree_my_struct_t(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 564 ----
 * my_struct_t& result = rightmost(my_struct_t& xy1, my_struct_t& xy4);
 */
static const char* stubids97_ = "c o my_struct_t& = rightmost(c i my_struct_t&, c i my_struct_t&)";

void mexStub97(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    my_struct_t*  in0_ =0; /* xy1        */
    my_struct_t*  in1_ =0; /* xy4        */
    my_struct_t*  out0_=0; /* result     */

    in0_ = mxWrapGet_my_struct_t(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in1_ = mxWrapGet_my_struct_t(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument xy1 cannot be null";
        goto mw_err_label;
    }
    if (!in1_) {
        mw_err_txt_ = "Argument xy4 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[97]++;
    plhs[0] = mxWrapSet_my_struct_t(&(rightmost(*in0_, *in1_)));

mw_err_label:
    if (in0_)  mxWrapFree_my_struct_t(in0_);
    if (in1_)  mxWrapFree_my_struct_t(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 567 ----
 * my_struct_t* xy5 = add1(my_struct_t& xy4);
 */
static const char* stubids98_ = "c o my_struct_t* = add1(c i my_struct_t&)";

void mexStub98(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    my_struct_t*  in0_ =0; /* xy4        */
    my_struct_t*  out0_=0; /* xy5        */

    in0_ = mxWrapGet_my_struct_t(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument xy4 cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[98]++;
    plhs[0] = mxWrapSet_my_struct_t(add1(*in0_));

mw_err_label:
    if (in0_)  mxWrapFree_my_struct_t(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- test_transfers.mw: 570 ----
 * int alloc_count = get_my_struct_allocs();
 */
static const char* stubids99_ = "c o int = get_my_struct_allocs()";

void mexStub99(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         out0_;   /* alloc_count */

    if (mexprofrecord_)
        mexprofrecord_[99]++;
    out0_ = get_my_struct_allocs();
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

typedef void (*mwStubFunc_t)(int nlhs, mxArray* plhs[],
                             int nrhs, const mxArray* prhs[]);

static mwStubFunc_t mwStubs_[] = {
    NULL,
    mexStub1,
    mexStub2,
    mexStub3,
    mexStub4,
    mexStub5,
    mexStub6,
    mexStub7,
    mexStub8,
    mexStub9,
    mexStub10,
    mexStub11,
    mexStub12,
    mexStub13,
    mexStub14,
    mexStub15,
    mexStub16,
    mexStub17,
    mexStub18,
    mexStub19,
    mexStub20,
    mexStub21,
    mexStub22,
    mexStub23,
    mexStub24,
    mexStub25,
    mexStub26,
    mexStub27,
    mexStub28,
    mexStub29,
    mexStub30,
    mexStub31,
    mexStub32,
    mexStub33,
    mexStub34,
    mexStub30,
    mexStub36,
    mexStub37,
    mexStub38,
    mexStub39,
    mexStub40,
    mexStub41,
    mexStub42,
    mexStub42,
    mexStub44,
    mexStub45,
    mexStub39,
    mexStub47,
    mexStub48,
    mexStub48,
    mexStub50,
    mexStub51,
    mexStub52,
    mexStub52,
    mexStub37,
    mexStub37,
    mexStub34,
    mexStub57,
    mexStub58,
    mexStub59,
    mexStub60,
    mexStub60,
    mexStub62,
    mexStub63,
    mexStub63,
    mexStub65,
    mexStub66,
    mexStub67,
    mexStub68,
    mexStub68,
    mexStub70,
    mexStub71,
    mexStub72,
    mexStub72,
    mexStub37,
    mexStub75,
    mexStub76,
    mexStub77,
    mexStub78,
    mexStub79,
    mexStub80,
    mexStub81,
    mexStub82,
    mexStub83,
    mexStub84,
    mexStub85,
    mexStub86,
    mexStub87,
    mexStub88,
    mexStub89,
    mexStub90,
    mexStub91,
    mexStub92,
    mexStub92,
    mexStub94,
    mexStub95,
    mexStub96,
    mexStub97,
    mexStub98,
    mexStub99
};

static int mwNumStubs_ = 99;

/* ----
 */
void mexFunction(int nlhs, mxArray* plhs[],
                 int nrhs, const mxArray* prhs[])
{
    if (nrhs == 0) {
        mexPrintf("Mex function installed\n");
        return;
    }

    /* Fast path: integer stub ID */
    if (!mxIsChar(prhs[0])) {
        int stub_id = (int) mxGetScalar(prhs[0]);
        if (stub_id > 0 && stub_id <= mwNumStubs_ && mwStubs_[stub_id])
            mwStubs_[stub_id](nlhs, plhs, nrhs-1, prhs+1);
        else
            mexErrMsgTxt("Unknown function ID");
        return;
    }



    char id[1024];
    if (mxGetString(prhs[0], id, sizeof(id)) != 0)
        mexErrMsgTxt("Identifier should be a string");
    else if (strcmp(id, stubids1_) == 0)
        mexStub1(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids2_) == 0)
        mexStub2(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids3_) == 0)
        mexStub3(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids4_) == 0)
        mexStub4(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids5_) == 0)
        mexStub5(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids6_) == 0)
        mexStub6(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids7_) == 0)
        mexStub7(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids8_) == 0)
        mexStub8(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids9_) == 0)
        mexStub9(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids10_) == 0)
        mexStub10(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids11_) == 0)
        mexStub11(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids12_) == 0)
        mexStub12(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids13_) == 0)
        mexStub13(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids14_) == 0)
        mexStub14(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids15_) == 0)
        mexStub15(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids16_) == 0)
        mexStub16(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids17_) == 0)
        mexStub17(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids18_) == 0)
        mexStub18(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids19_) == 0)
        mexStub19(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids20_) == 0)
        mexStub20(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids21_) == 0)
        mexStub21(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids22_) == 0)
        mexStub22(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids23_) == 0)
        mexStub23(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids24_) == 0)
        mexStub24(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids25_) == 0)
        mexStub25(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids26_) == 0)
        mexStub26(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids27_) == 0)
        mexStub27(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids28_) == 0)
        mexStub28(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids29_) == 0)
        mexStub29(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids30_) == 0)
        mexStub30(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids31_) == 0)
        mexStub31(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids32_) == 0)
        mexStub32(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids33_) == 0)
        mexStub33(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids34_) == 0)
        mexStub34(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids36_) == 0)
        mexStub36(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids37_) == 0)
        mexStub37(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids38_) == 0)
        mexStub38(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids39_) == 0)
        mexStub39(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids40_) == 0)
        mexStub40(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids41_) == 0)
        mexStub41(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids42_) == 0)
        mexStub42(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids44_) == 0)
        mexStub44(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids45_) == 0)
        mexStub45(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids47_) == 0)
        mexStub47(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids48_) == 0)
        mexStub48(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids50_) == 0)
        mexStub50(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids51_) == 0)
        mexStub51(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids52_) == 0)
        mexStub52(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids57_) == 0)
        mexStub57(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids58_) == 0)
        mexStub58(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids59_) == 0)
        mexStub59(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids60_) == 0)
        mexStub60(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids62_) == 0)
        mexStub62(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids63_) == 0)
        mexStub63(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids65_) == 0)
        mexStub65(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids66_) == 0)
        mexStub66(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids67_) == 0)
        mexStub67(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids68_) == 0)
        mexStub68(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids70_) == 0)
        mexStub70(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids71_) == 0)
        mexStub71(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids72_) == 0)
        mexStub72(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids75_) == 0)
        mexStub75(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids76_) == 0)
        mexStub76(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids77_) == 0)
        mexStub77(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids78_) == 0)
        mexStub78(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids79_) == 0)
        mexStub79(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids80_) == 0)
        mexStub80(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids81_) == 0)
        mexStub81(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids82_) == 0)
        mexStub82(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids83_) == 0)
        mexStub83(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids84_) == 0)
        mexStub84(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids85_) == 0)
        mexStub85(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids86_) == 0)
        mexStub86(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids87_) == 0)
        mexStub87(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids88_) == 0)
        mexStub88(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids89_) == 0)
        mexStub89(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids90_) == 0)
        mexStub90(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids91_) == 0)
        mexStub91(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids92_) == 0)
        mexStub92(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids94_) == 0)
        mexStub94(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids95_) == 0)
        mexStub95(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids96_) == 0)
        mexStub96(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids97_) == 0)
        mexStub97(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids98_) == 0)
        mexStub98(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids99_) == 0)
        mexStub99(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, "*profile on*") == 0) {
        if (!mexprofrecord_) {
            mexprofrecord_ = (int*) malloc(100 * sizeof(int));
            mexLock();
        }
        memset(mexprofrecord_, 0, 100 * sizeof(int));
    } else if (strcmp(id, "*profile off*") == 0) {
        if (mexprofrecord_) {
            free(mexprofrecord_);
            mexUnlock();
        }
        mexprofrecord_ = NULL;
    } else if (strcmp(id, "*profile report*") == 0) {
        if (!mexprofrecord_)
            mexPrintf("Profiler inactive\n");
        mexPrintf("%d calls to test_transfers.mw:81\n", mexprofrecord_[1]);
        mexPrintf("%d calls to test_transfers.mw:82\n", mexprofrecord_[2]);
        mexPrintf("%d calls to test_transfers.mw:83\n", mexprofrecord_[3]);
        mexPrintf("%d calls to test_transfers.mw:84\n", mexprofrecord_[4]);
        mexPrintf("%d calls to test_transfers.mw:97\n", mexprofrecord_[5]);
        mexPrintf("%d calls to test_transfers.mw:105\n", mexprofrecord_[6]);
        mexPrintf("%d calls to test_transfers.mw:106\n", mexprofrecord_[7]);
        mexPrintf("%d calls to test_transfers.mw:127\n", mexprofrecord_[8]);
        mexPrintf("%d calls to test_transfers.mw:128\n", mexprofrecord_[9]);
        mexPrintf("%d calls to test_transfers.mw:129\n", mexprofrecord_[10]);
        mexPrintf("%d calls to test_transfers.mw:130\n", mexprofrecord_[11]);
        mexPrintf("%d calls to test_transfers.mw:131\n", mexprofrecord_[12]);
        mexPrintf("%d calls to test_transfers.mw:132\n", mexprofrecord_[13]);
        mexPrintf("%d calls to test_transfers.mw:133\n", mexprofrecord_[14]);
        mexPrintf("%d calls to test_transfers.mw:134\n", mexprofrecord_[15]);
        mexPrintf("%d calls to test_transfers.mw:135\n", mexprofrecord_[16]);
        mexPrintf("%d calls to test_transfers.mw:136\n", mexprofrecord_[17]);
        mexPrintf("%d calls to test_transfers.mw:137\n", mexprofrecord_[18]);
        mexPrintf("%d calls to test_transfers.mw:140\n", mexprofrecord_[19]);
        mexPrintf("%d calls to test_transfers.mw:141\n", mexprofrecord_[20]);
        mexPrintf("%d calls to test_transfers.mw:156\n", mexprofrecord_[21]);
        mexPrintf("%d calls to test_transfers.mw:164\n", mexprofrecord_[22]);
        mexPrintf("%d calls to test_transfers.mw:168\n", mexprofrecord_[23]);
        mexPrintf("%d calls to test_transfers.mw:172\n", mexprofrecord_[24]);
        mexPrintf("%d calls to test_transfers.mw:175\n", mexprofrecord_[25]);
        mexPrintf("%d calls to test_transfers.mw:180\n", mexprofrecord_[26]);
        mexPrintf("%d calls to test_transfers.mw:183\n", mexprofrecord_[27]);
        mexPrintf("%d calls to test_transfers.mw:188\n", mexprofrecord_[28]);
        mexPrintf("%d calls to test_transfers.mw:192\n", mexprofrecord_[29]);
        mexPrintf("%d calls to test_transfers.mw:197 (test_transfers.mw:216)\n", mexprofrecord_[30]);
        mexPrintf("%d calls to test_transfers.mw:201\n", mexprofrecord_[31]);
        mexPrintf("%d calls to test_transfers.mw:204\n", mexprofrecord_[32]);
        mexPrintf("%d calls to test_transfers.mw:207\n", mexprofrecord_[33]);
        mexPrintf("%d calls to test_transfers.mw:215 (test_transfers.mw:296)\n", mexprofrecord_[34]);
        mexPrintf("%d calls to test_transfers.mw:217\n", mexprofrecord_[36]);
        mexPrintf("%d calls to test_transfers.mw:218 (test_transfers.mw:288)\n", mexprofrecord_[37]);
        mexPrintf("%d calls to test_transfers.mw:227\n", mexprofrecord_[38]);
        mexPrintf("%d calls to test_transfers.mw:231 (test_transfers.mw:255)\n", mexprofrecord_[39]);
        mexPrintf("%d calls to test_transfers.mw:235\n", mexprofrecord_[40]);
        mexPrintf("%d calls to test_transfers.mw:239\n", mexprofrecord_[41]);
        mexPrintf("%d calls to test_transfers.mw:244 (test_transfers.mw:245)\n", mexprofrecord_[42]);
        mexPrintf("%d calls to test_transfers.mw:250\n", mexprofrecord_[44]);
        mexPrintf("%d calls to test_transfers.mw:254\n", mexprofrecord_[45]);
        mexPrintf("%d calls to test_transfers.mw:260\n", mexprofrecord_[47]);
        mexPrintf("%d calls to test_transfers.mw:267 (test_transfers.mw:268)\n", mexprofrecord_[48]);
        mexPrintf("%d calls to test_transfers.mw:273\n", mexprofrecord_[50]);
        mexPrintf("%d calls to test_transfers.mw:277\n", mexprofrecord_[51]);
        mexPrintf("%d calls to test_transfers.mw:283 (test_transfers.mw:284)\n", mexprofrecord_[52]);
        mexPrintf("%d calls to test_transfers.mw:298\n", mexprofrecord_[57]);
        mexPrintf("%d calls to test_transfers.mw:303\n", mexprofrecord_[58]);
        mexPrintf("%d calls to test_transfers.mw:307\n", mexprofrecord_[59]);
        mexPrintf("%d calls to test_transfers.mw:312 (test_transfers.mw:313)\n", mexprofrecord_[60]);
        mexPrintf("%d calls to test_transfers.mw:318\n", mexprofrecord_[62]);
        mexPrintf("%d calls to test_transfers.mw:323 (test_transfers.mw:324)\n", mexprofrecord_[63]);
        mexPrintf("%d calls to test_transfers.mw:330\n", mexprofrecord_[65]);
        mexPrintf("%d calls to test_transfers.mw:334\n", mexprofrecord_[66]);
        mexPrintf("%d calls to test_transfers.mw:338\n", mexprofrecord_[67]);
        mexPrintf("%d calls to test_transfers.mw:342 (test_transfers.mw:343)\n", mexprofrecord_[68]);
        mexPrintf("%d calls to test_transfers.mw:348\n", mexprofrecord_[70]);
        mexPrintf("%d calls to test_transfers.mw:352\n", mexprofrecord_[71]);
        mexPrintf("%d calls to test_transfers.mw:356 (test_transfers.mw:357)\n", mexprofrecord_[72]);
        mexPrintf("%d calls to test_transfers.mw:368\n", mexprofrecord_[75]);
        mexPrintf("%d calls to test_transfers.mw:375\n", mexprofrecord_[76]);
        mexPrintf("%d calls to test_transfers.mw:379\n", mexprofrecord_[77]);
        mexPrintf("%d calls to test_transfers.mw:384\n", mexprofrecord_[78]);
        mexPrintf("%d calls to test_transfers.mw:385\n", mexprofrecord_[79]);
        mexPrintf("%d calls to test_transfers.mw:390\n", mexprofrecord_[80]);
        mexPrintf("%d calls to test_transfers.mw:394\n", mexprofrecord_[81]);
        mexPrintf("%d calls to test_transfers.mw:398\n", mexprofrecord_[82]);
        mexPrintf("%d calls to test_transfers.mw:402\n", mexprofrecord_[83]);
        mexPrintf("%d calls to test_transfers.mw:406\n", mexprofrecord_[84]);
        mexPrintf("%d calls to test_transfers.mw:415\n", mexprofrecord_[85]);
        mexPrintf("%d calls to test_transfers.mw:420\n", mexprofrecord_[86]);
        mexPrintf("%d calls to test_transfers.mw:425\n", mexprofrecord_[87]);
        mexPrintf("%d calls to test_transfers.mw:430\n", mexprofrecord_[88]);
        mexPrintf("%d calls to test_transfers.mw:441\n", mexprofrecord_[89]);
        mexPrintf("%d calls to test_transfers.mw:448\n", mexprofrecord_[90]);
        mexPrintf("%d calls to test_transfers.mw:457\n", mexprofrecord_[91]);
        mexPrintf("%d calls to test_transfers.mw:466 (test_transfers.mw:468)\n", mexprofrecord_[92]);
        mexPrintf("%d calls to test_transfers.mw:554\n", mexprofrecord_[94]);
        mexPrintf("%d calls to test_transfers.mw:557\n", mexprofrecord_[95]);
        mexPrintf("%d calls to test_transfers.mw:561\n", mexprofrecord_[96]);
        mexPrintf("%d calls to test_transfers.mw:564\n", mexprofrecord_[97]);
        mexPrintf("%d calls to test_transfers.mw:567\n", mexprofrecord_[98]);
        mexPrintf("%d calls to test_transfers.mw:570\n", mexprofrecord_[99]);
    } else if (strcmp(id, "*profile log*") == 0) {
        FILE* logfp;
        if (nrhs != 2 || mxGetString(prhs[1], id, sizeof(id)) != 0)
            mexErrMsgTxt("Must have two string arguments");
        logfp = fopen(id, "w+");
        if (!logfp)
            mexErrMsgTxt("Cannot open log for output");
        if (!mexprofrecord_)
            fprintf(logfp, "Profiler inactive\n");
        fprintf(logfp, "%d calls to test_transfers.mw:81\n", mexprofrecord_[1]);
        fprintf(logfp, "%d calls to test_transfers.mw:82\n", mexprofrecord_[2]);
        fprintf(logfp, "%d calls to test_transfers.mw:83\n", mexprofrecord_[3]);
        fprintf(logfp, "%d calls to test_transfers.mw:84\n", mexprofrecord_[4]);
        fprintf(logfp, "%d calls to test_transfers.mw:97\n", mexprofrecord_[5]);
        fprintf(logfp, "%d calls to test_transfers.mw:105\n", mexprofrecord_[6]);
        fprintf(logfp, "%d calls to test_transfers.mw:106\n", mexprofrecord_[7]);
        fprintf(logfp, "%d calls to test_transfers.mw:127\n", mexprofrecord_[8]);
        fprintf(logfp, "%d calls to test_transfers.mw:128\n", mexprofrecord_[9]);
        fprintf(logfp, "%d calls to test_transfers.mw:129\n", mexprofrecord_[10]);
        fprintf(logfp, "%d calls to test_transfers.mw:130\n", mexprofrecord_[11]);
        fprintf(logfp, "%d calls to test_transfers.mw:131\n", mexprofrecord_[12]);
        fprintf(logfp, "%d calls to test_transfers.mw:132\n", mexprofrecord_[13]);
        fprintf(logfp, "%d calls to test_transfers.mw:133\n", mexprofrecord_[14]);
        fprintf(logfp, "%d calls to test_transfers.mw:134\n", mexprofrecord_[15]);
        fprintf(logfp, "%d calls to test_transfers.mw:135\n", mexprofrecord_[16]);
        fprintf(logfp, "%d calls to test_transfers.mw:136\n", mexprofrecord_[17]);
        fprintf(logfp, "%d calls to test_transfers.mw:137\n", mexprofrecord_[18]);
        fprintf(logfp, "%d calls to test_transfers.mw:140\n", mexprofrecord_[19]);
        fprintf(logfp, "%d calls to test_transfers.mw:141\n", mexprofrecord_[20]);
        fprintf(logfp, "%d calls to test_transfers.mw:156\n", mexprofrecord_[21]);
        fprintf(logfp, "%d calls to test_transfers.mw:164\n", mexprofrecord_[22]);
        fprintf(logfp, "%d calls to test_transfers.mw:168\n", mexprofrecord_[23]);
        fprintf(logfp, "%d calls to test_transfers.mw:172\n", mexprofrecord_[24]);
        fprintf(logfp, "%d calls to test_transfers.mw:175\n", mexprofrecord_[25]);
        fprintf(logfp, "%d calls to test_transfers.mw:180\n", mexprofrecord_[26]);
        fprintf(logfp, "%d calls to test_transfers.mw:183\n", mexprofrecord_[27]);
        fprintf(logfp, "%d calls to test_transfers.mw:188\n", mexprofrecord_[28]);
        fprintf(logfp, "%d calls to test_transfers.mw:192\n", mexprofrecord_[29]);
        fprintf(logfp, "%d calls to test_transfers.mw:197 (test_transfers.mw:216)\n", mexprofrecord_[30]);
        fprintf(logfp, "%d calls to test_transfers.mw:201\n", mexprofrecord_[31]);
        fprintf(logfp, "%d calls to test_transfers.mw:204\n", mexprofrecord_[32]);
        fprintf(logfp, "%d calls to test_transfers.mw:207\n", mexprofrecord_[33]);
        fprintf(logfp, "%d calls to test_transfers.mw:215 (test_transfers.mw:296)\n", mexprofrecord_[34]);
        fprintf(logfp, "%d calls to test_transfers.mw:217\n", mexprofrecord_[36]);
        fprintf(logfp, "%d calls to test_transfers.mw:218 (test_transfers.mw:288)\n", mexprofrecord_[37]);
        fprintf(logfp, "%d calls to test_transfers.mw:227\n", mexprofrecord_[38]);
        fprintf(logfp, "%d calls to test_transfers.mw:231 (test_transfers.mw:255)\n", mexprofrecord_[39]);
        fprintf(logfp, "%d calls to test_transfers.mw:235\n", mexprofrecord_[40]);
        fprintf(logfp, "%d calls to test_transfers.mw:239\n", mexprofrecord_[41]);
        fprintf(logfp, "%d calls to test_transfers.mw:244 (test_transfers.mw:245)\n", mexprofrecord_[42]);
        fprintf(logfp, "%d calls to test_transfers.mw:250\n", mexprofrecord_[44]);
        fprintf(logfp, "%d calls to test_transfers.mw:254\n", mexprofrecord_[45]);
        fprintf(logfp, "%d calls to test_transfers.mw:260\n", mexprofrecord_[47]);
        fprintf(logfp, "%d calls to test_transfers.mw:267 (test_transfers.mw:268)\n", mexprofrecord_[48]);
        fprintf(logfp, "%d calls to test_transfers.mw:273\n", mexprofrecord_[50]);
        fprintf(logfp, "%d calls to test_transfers.mw:277\n", mexprofrecord_[51]);
        fprintf(logfp, "%d calls to test_transfers.mw:283 (test_transfers.mw:284)\n", mexprofrecord_[52]);
        fprintf(logfp, "%d calls to test_transfers.mw:298\n", mexprofrecord_[57]);
        fprintf(logfp, "%d calls to test_transfers.mw:303\n", mexprofrecord_[58]);
        fprintf(logfp, "%d calls to test_transfers.mw:307\n", mexprofrecord_[59]);
        fprintf(logfp, "%d calls to test_transfers.mw:312 (test_transfers.mw:313)\n", mexprofrecord_[60]);
        fprintf(logfp, "%d calls to test_transfers.mw:318\n", mexprofrecord_[62]);
        fprintf(logfp, "%d calls to test_transfers.mw:323 (test_transfers.mw:324)\n", mexprofrecord_[63]);
        fprintf(logfp, "%d calls to test_transfers.mw:330\n", mexprofrecord_[65]);
        fprintf(logfp, "%d calls to test_transfers.mw:334\n", mexprofrecord_[66]);
        fprintf(logfp, "%d calls to test_transfers.mw:338\n", mexprofrecord_[67]);
        fprintf(logfp, "%d calls to test_transfers.mw:342 (test_transfers.mw:343)\n", mexprofrecord_[68]);
        fprintf(logfp, "%d calls to test_transfers.mw:348\n", mexprofrecord_[70]);
        fprintf(logfp, "%d calls to test_transfers.mw:352\n", mexprofrecord_[71]);
        fprintf(logfp, "%d calls to test_transfers.mw:356 (test_transfers.mw:357)\n", mexprofrecord_[72]);
        fprintf(logfp, "%d calls to test_transfers.mw:368\n", mexprofrecord_[75]);
        fprintf(logfp, "%d calls to test_transfers.mw:375\n", mexprofrecord_[76]);
        fprintf(logfp, "%d calls to test_transfers.mw:379\n", mexprofrecord_[77]);
        fprintf(logfp, "%d calls to test_transfers.mw:384\n", mexprofrecord_[78]);
        fprintf(logfp, "%d calls to test_transfers.mw:385\n", mexprofrecord_[79]);
        fprintf(logfp, "%d calls to test_transfers.mw:390\n", mexprofrecord_[80]);
        fprintf(logfp, "%d calls to test_transfers.mw:394\n", mexprofrecord_[81]);
        fprintf(logfp, "%d calls to test_transfers.mw:398\n", mexprofrecord_[82]);
        fprintf(logfp, "%d calls to test_transfers.mw:402\n", mexprofrecord_[83]);
        fprintf(logfp, "%d calls to test_transfers.mw:406\n", mexprofrecord_[84]);
        fprintf(logfp, "%d calls to test_transfers.mw:415\n", mexprofrecord_[85]);
        fprintf(logfp, "%d calls to test_transfers.mw:420\n", mexprofrecord_[86]);
        fprintf(logfp, "%d calls to test_transfers.mw:425\n", mexprofrecord_[87]);
        fprintf(logfp, "%d calls to test_transfers.mw:430\n", mexprofrecord_[88]);
        fprintf(logfp, "%d calls to test_transfers.mw:441\n", mexprofrecord_[89]);
        fprintf(logfp, "%d calls to test_transfers.mw:448\n", mexprofrecord_[90]);
        fprintf(logfp, "%d calls to test_transfers.mw:457\n", mexprofrecord_[91]);
        fprintf(logfp, "%d calls to test_transfers.mw:466 (test_transfers.mw:468)\n", mexprofrecord_[92]);
        fprintf(logfp, "%d calls to test_transfers.mw:554\n", mexprofrecord_[94]);
        fprintf(logfp, "%d calls to test_transfers.mw:557\n", mexprofrecord_[95]);
        fprintf(logfp, "%d calls to test_transfers.mw:561\n", mexprofrecord_[96]);
        fprintf(logfp, "%d calls to test_transfers.mw:564\n", mexprofrecord_[97]);
        fprintf(logfp, "%d calls to test_transfers.mw:567\n", mexprofrecord_[98]);
        fprintf(logfp, "%d calls to test_transfers.mw:570\n", mexprofrecord_[99]);
        fclose(logfp);
    } else
        mexErrMsgTxt("Unknown identifier");
}

