/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class ActionLoader
extends GenericLoader {
    private static ActionLoader instance = new ActionLoader(TurbineResources.getInt("action.cache.size", 20));

    private void addInstance(String name, Action action) {
        if (this.cache()) {
            this.put(name, action);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).perform(data);
    }

    public Action getInstance(String name) throws Exception {
        Action action = null;
        if (this.cache() && this.containsKey(name)) {
            action = (Action)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                action = (Action)ab.getAssembler("action", name);
            }
            catch (ClassCastException cce) {
                action = null;
            }
            if (action == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Action not found: " + name + "\n" + "\tTurbine looked in the following modules.packages " + "path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, action);
            }
        }
        return action;
    }

    public static ActionLoader getInstance() {
        return instance;
    }

    private ActionLoader() {
    }

    private ActionLoader(int i) {
        super(i);
    }
}

