/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMeldfInput
extends AbstractBasisSetXmlToText {
    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("$END\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        Iterator iterator = descriptionList.iterator();
        while (iterator.hasNext()) {
            Element description = (Element)iterator.next();
            output.append("$ " + elementName.toUpperCase());
            output.append("       " + description.getValue() + "\n");
            iterator.remove();
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        int shellCount = 1;
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            Matrix[] matricesList = this.splitMatrixNcolumnTo2column(matrix);
            try {
                for (int m = 0; m < matricesList.length; ++m) {
                    int rows2 = matricesList[m].getNumRows();
                    int columns2 = matricesList[m].getNumColumns();
                    output.append(element + shellCount + shell);
                    output.append("  " + rows2 + "    " + shell + "\n");
                    for (int j = 1; j >= 0; --j) {
                        for (int i = 0; i < rows2; ++i) {
                            if (i % 5 == 0) {
                                output.append("\n");
                            }
                            String value = this.formattedValue(matricesList[m].getValue(i, j));
                            output.append(value);
                        }
                    }
                    output.append("\n");
                    ++shellCount;
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

