# config.tcl

namespace eval config {
    variable installDir
    variable docDir
    variable licenseDir
    variable exampleDir
    variable languageDir
    variable defaultBrowser
    variable defaultPrintcmd
    variable version {2.0.8}
    variable dbversion {1.5.0}

    set installDir [file dirname [file normalize [info script]]]
    if {[string equal $tcl_platform(platform) "unix"]} then {
        set configFile [file join $installDir {pfm.conf}]
        if {![file exists $configFile]} then {
            set configFile {/etc/pfm.conf}
        }
        if {[catch {open $configFile r} confChan]} then {
            tk_messageBox -type ok -icon error -message $confChan
            exit
        } else {
            while {![eof $confChan]} {
                set line [gets $confChan]
                if {([string length $line] != 0) && \
                        ([string compare -length 1 $line "#"] != 0)} then {
                    set [lindex $line 0] [lindex $line 1]
                }
            }
            close $confChan
            if {[string compare -length 1 $docDir "/"] != 0} then {
                # The directory indicated is relative to the installDir
                set docDir [file join $installDir $docDir]
            }
            if {[string compare -length 1 $licenseDir "/"] != 0} then {
                # The directory indicated is relative to the installDir
                set licenseDir [file join $installDir $licenseDir]
            }
            if {[string compare -length 1 $exampleDir "/"] != 0} then {
                # The directory indicated is relative to the installDir
                set exampleDir [file join $installDir $exampleDir]
            }
            if {[string compare -length 1 $languageDir "/"] != 0} then {
                # The directory indicated is relative to the installDir
                set languageDir [file join $installDir $languageDir]
            }
        }
    } else {
        # On non-UNIX platforms there is no configuration file.
        set docDir [file join $installDir {doc}]
        set licenseDir [file join $installDir {license}]
        set exampleDir [file join $installDir {examples}]
        set languageDir [file join $installDir {msgs}]
        set defaultBrowser {}
        set defaultPrintcmd {}
    }
}

