/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.SuggestedPalette;

class SuggestedPaletteImpl
implements SuggestedPalette {
    private final String name;
    private final int sampleDepth;
    private final byte[] bytes;
    private final int entrySize;
    private final int sampleCount;

    public SuggestedPaletteImpl(String name, int sampleDepth, byte[] bytes) {
        this.name = name;
        this.sampleDepth = sampleDepth;
        this.bytes = bytes;
        this.entrySize = sampleDepth == 8 ? 6 : 10;
        this.sampleCount = bytes.length / this.entrySize;
    }

    public String getName() {
        return this.name;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getSampleDepth() {
        return this.sampleDepth;
    }

    public void getSample(int index, short[] pixel) {
        int from = index * this.entrySize;
        if (this.sampleDepth == 8) {
            for (int j = 0; j < 4; ++j) {
                int a = 0xFF & this.bytes[from++];
                pixel[j] = (short)a;
            }
        } else {
            for (int j = 0; j < 4; ++j) {
                int a = 0xFF & this.bytes[from++];
                int b = 0xFF & this.bytes[from++];
                pixel[j] = (short)(a << 8 | b);
            }
        }
    }

    public int getFrequency(int index) {
        int from = (index + 1) * this.entrySize - 2;
        int a = 0xFF & this.bytes[from];
        int b = 0xFF & this.bytes[from + 1];
        return a << 8 | b;
    }
}

