#!/bin/sh
#
# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later

myself="$(readlink -f -- "$0")"
test_dir="$(dirname -- "$myself")"
. "$test_dir/tap-functions.sh"

[ -z "$PRIPS" ] && PRIPS='./prips'

if ! feature-check feature-check feature-check 2>/dev/null; then
	skip_all_ 'The feature-check tool does not seem to be present'
fi

if [ "${PRIPS#*[$IFS]}" != "$PRIPS" ]; then
	skip_all_ 'PRIPS does not specify a single program path or name'
fi

plan_ 5

v=`feature-check -v $PRIPS prips`
res="$?"
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ -n "$v" ]; then ok_; else not_ok_ "empty 'prips' feature version"; fi
prips_version="$v"

v=`feature-check $PRIPS 'prips >= 1.3.1'`
res="$?"
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi

if feature-check -l $PRIPS | grep -Eqe '^prips-impl-'; then ok_; else not_ok_ 'no prips-impl-* features'; fi
if feature-check -l $PRIPS | awk -v expected="$prips_version" '/^prips-impl-/ { if ($2 != expected) { exit(1); } }'; then ok_; else not_ok_ 'the prips-impl-* features must have the same version as prips'; fi
