"""Asynchronous Python client for Withings."""

from .const import AUTHORIZATION_URL, TOKEN_URL
from .exceptions import (
    WithingsAuthenticationFailedError,
    WithingsBadStateError,
    WithingsConnectionError,
    WithingsError,
    WithingsErrorOccurredError,
    WithingsInvalidParamsError,
    WithingsTooManyRequestsError,
    WithingsUnauthorizedError,
    WithingsUnknownStatusError,
)
from .helpers import aggregate_measurements
from .models import (
    Activity,
    ActivityDataFields,
    ActivityDataOrigin,
    AuthScope,
    Device,
    DeviceBattery,
    DeviceModel,
    DeviceType,
    Goals,
    Measurement,
    MeasurementAttribution,
    MeasurementGroup,
    MeasurementGroupCategory,
    MeasurementPosition,
    MeasurementType,
    NotificationCategory,
    Services,
    SleepDataFields,
    SleepSeries,
    SleepSeriesTimeData,
    SleepState,
    SleepSummary,
    SleepSummaryDataFields,
    WebhookCall,
    Workout,
    WorkoutCategory,
    WorkoutDataFields,
    get_measurement_type_from_notification_category,
)
from .withings import WithingsClient

__all__ = [
    "AUTHORIZATION_URL",
    "TOKEN_URL",
    "AuthScope",
    "ActivityDataFields",
    "ActivityDataOrigin",
    "Activity",
    "DeviceBattery",
    "Device",
    "DeviceType",
    "DeviceModel",
    "WithingsError",
    "WithingsConnectionError",
    "WithingsAuthenticationFailedError",
    "WithingsInvalidParamsError",
    "WithingsUnauthorizedError",
    "WithingsErrorOccurredError",
    "WithingsBadStateError",
    "WithingsTooManyRequestsError",
    "WithingsUnknownStatusError",
    "WithingsClient",
    "Goals",
    "MeasurementAttribution",
    "MeasurementGroupCategory",
    "MeasurementGroup",
    "MeasurementPosition",
    "MeasurementType",
    "Measurement",
    "get_measurement_type_from_notification_category",
    "aggregate_measurements",
    "NotificationCategory",
    "Services",
    "WebhookCall",
    "SleepSummary",
    "SleepSummaryDataFields",
    "SleepState",
    "SleepSeriesTimeData",
    "SleepSeries",
    "SleepDataFields",
    "WorkoutDataFields",
    "Workout",
    "WorkoutCategory",
]
