# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.batch import BatchManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-batch
# USAGE
    python pool_create_dual_stack_networking.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = BatchManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.pool.create(
        resource_group_name="default-azurebatch",
        account_name="exampleacc",
        pool_name="dualstackpool",
        parameters={
            "properties": {
                "deploymentConfiguration": {
                    "virtualMachineConfiguration": {
                        "imageReference": {"offer": "ubuntu-24_04-lts", "publisher": "Canonical", "sku": "server"},
                        "nodeAgentSkuId": "batch.node.ubuntu 24.04",
                    }
                },
                "networkConfiguration": {
                    "endpointConfiguration": {
                        "inboundNatPools": [
                            {
                                "backendPort": 22,
                                "frontendPortRangeEnd": 40500,
                                "frontendPortRangeStart": 40000,
                                "name": "sshpool",
                                "networkSecurityGroupRules": [
                                    {
                                        "access": "Allow",
                                        "priority": 1000,
                                        "sourceAddressPrefix": "*",
                                        "sourcePortRanges": ["*"],
                                    }
                                ],
                                "protocol": "TCP",
                            }
                        ]
                    },
                    "publicIPAddressConfiguration": {"ipFamilies": ["IPv4", "IPv6"]},
                },
                "scaleSettings": {"fixedScale": {"targetDedicatedNodes": 1, "targetLowPriorityNodes": 0}},
                "vmSize": "Standard_D4ds_v5",
            }
        },
    )
    print(response)


# x-ms-original-file: 2025-06-01/PoolCreate_DualStackNetworking.json
if __name__ == "__main__":
    main()
