# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computebulkactions
# USAGE
    python bulk_actions_list_virtual_machines_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeBulkActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.bulk_actions.list_virtual_machines(
        resource_group_name="rgcomputebulkactions",
        location="eastus2euap",
        name="50352BBD-59F1-4EE2-BA9C-A6E51B0B1B2B",
    )
    for item in response:
        print(item)


# x-ms-original-file: 2026-02-01-preview/BulkActions_ListVirtualMachines_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
