# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeBulkActionsMgmtBulkActionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeBulkActionsMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_get(self, resource_group):
        response = self.client.bulk_actions.get(
            resource_group_name=resource_group.name,
            location="str",
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_get_operation_status(self, resource_group):
        response = self.client.bulk_actions.get_operation_status(
            location="str",
            id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_begin_create_or_update(self, resource_group):
        response = self.client.bulk_actions.begin_create_or_update(
            resource_group_name=resource_group.name,
            location="str",
            name="str",
            resource={
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "plan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str", "version": "str"},
                "properties": {
                    "capacity": 0,
                    "computeProfile": {
                        "virtualMachineProfile": {
                            "additionalCapabilities": {"hibernationEnabled": bool, "ultraSSDEnabled": bool},
                            "applicationProfile": {
                                "galleryApplications": [
                                    {
                                        "packageReferenceId": "str",
                                        "configurationReference": "str",
                                        "enableAutomaticUpgrade": bool,
                                        "order": 0,
                                        "tags": "str",
                                        "treatFailureAsDeploymentFailure": bool,
                                    }
                                ]
                            },
                            "capacityReservation": {"capacityReservationGroup": {"id": "str"}},
                            "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                            "extensionsTimeBudget": "str",
                            "licenseType": "str",
                            "networkProfile": {
                                "networkApiVersion": "str",
                                "networkInterfaceConfigurations": [
                                    {
                                        "name": "str",
                                        "properties": {
                                            "ipConfigurations": [
                                                {
                                                    "name": "str",
                                                    "properties": {
                                                        "applicationGatewayBackendAddressPools": [{"id": "str"}],
                                                        "applicationSecurityGroups": [{"id": "str"}],
                                                        "loadBalancerBackendAddressPools": [{"id": "str"}],
                                                        "primary": bool,
                                                        "privateIPAddressVersion": "str",
                                                        "publicIPAddressConfiguration": {
                                                            "name": "str",
                                                            "properties": {
                                                                "deleteOption": "str",
                                                                "dnsSettings": {
                                                                    "domainNameLabel": "str",
                                                                    "domainNameLabelScope": "str",
                                                                },
                                                                "idleTimeoutInMinutes": 0,
                                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                "publicIPAddressVersion": "str",
                                                                "publicIPAllocationMethod": "str",
                                                                "publicIPPrefix": {"id": "str"},
                                                            },
                                                            "sku": {"name": "str", "tier": "str"},
                                                            "tags": {"str": "str"},
                                                        },
                                                        "subnet": {"id": "str"},
                                                    },
                                                }
                                            ],
                                            "auxiliaryMode": "str",
                                            "auxiliarySku": "str",
                                            "deleteOption": "str",
                                            "disableTcpStateTracking": bool,
                                            "dnsSettings": {"dnsServers": ["str"]},
                                            "dscpConfiguration": {"id": "str"},
                                            "enableAcceleratedNetworking": bool,
                                            "enableFpga": bool,
                                            "enableIPForwarding": bool,
                                            "networkSecurityGroup": {"id": "str"},
                                            "primary": bool,
                                        },
                                        "tags": {"str": "str"},
                                    }
                                ],
                                "networkInterfaces": [
                                    {"id": "str", "properties": {"deleteOption": "str", "primary": bool}}
                                ],
                            },
                            "osProfile": {
                                "adminPassword": "str",
                                "adminUsername": "str",
                                "allowExtensionOperations": bool,
                                "computerName": "str",
                                "customData": "str",
                                "linuxConfiguration": {
                                    "disablePasswordAuthentication": bool,
                                    "enableVMAgentPlatformUpdates": bool,
                                    "patchSettings": {
                                        "assessmentMode": "str",
                                        "automaticByPlatformSettings": {
                                            "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                            "rebootSetting": "str",
                                        },
                                        "patchMode": "str",
                                    },
                                    "provisionVMAgent": bool,
                                    "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                                },
                                "requireGuestProvisionSignal": bool,
                                "secrets": [
                                    {
                                        "sourceVault": {"id": "str"},
                                        "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                                    }
                                ],
                                "windowsConfiguration": {
                                    "additionalUnattendContent": [
                                        {
                                            "componentName": "Microsoft-Windows-Shell-Setup",
                                            "content": "str",
                                            "passName": "OobeSystem",
                                            "settingName": "str",
                                        }
                                    ],
                                    "enableAutomaticUpdates": bool,
                                    "patchSettings": {
                                        "assessmentMode": "str",
                                        "automaticByPlatformSettings": {
                                            "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                            "rebootSetting": "str",
                                        },
                                        "enableHotpatching": bool,
                                        "patchMode": "str",
                                    },
                                    "provisionVMAgent": bool,
                                    "timeZone": "str",
                                    "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                                },
                            },
                            "scheduledEventsPolicy": {
                                "allInstancesDown": {"automaticallyApprove": bool},
                                "scheduledEventsAdditionalPublishingTargets": {
                                    "eventGridAndResourceGraph": {"enable": bool, "scheduledEventsApiVersion": "str"}
                                },
                                "userInitiatedReboot": {"automaticallyApprove": bool},
                                "userInitiatedRedeploy": {"automaticallyApprove": bool},
                            },
                            "scheduledEventsProfile": {
                                "osImageNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                                "terminateNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                            },
                            "securityProfile": {
                                "encryptionAtHost": bool,
                                "encryptionIdentity": {"userAssignedIdentityResourceId": "str"},
                                "proxyAgentSettings": {
                                    "addProxyAgentExtension": bool,
                                    "enabled": bool,
                                    "imds": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                    "keyIncarnationId": 0,
                                    "mode": "str",
                                    "wireServer": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                },
                                "securityType": "str",
                                "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                            },
                            "storageProfile": {
                                "dataDisks": [
                                    {
                                        "createOption": "str",
                                        "lun": 0,
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "detachOption": "str",
                                        "diskSizeGB": 0,
                                        "image": {"uri": "str"},
                                        "managedDisk": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "id": "str",
                                            "securityProfile": {
                                                "diskEncryptionSet": {"id": "str"},
                                                "securityEncryptionType": "str",
                                            },
                                            "storageAccountType": "str",
                                        },
                                        "name": "str",
                                        "sourceResource": {"id": "str"},
                                        "toBeDetached": bool,
                                        "vhd": {"uri": "str"},
                                        "writeAcceleratorEnabled": bool,
                                    }
                                ],
                                "diskControllerType": "str",
                                "imageReference": {
                                    "communityGalleryImageId": "str",
                                    "id": "str",
                                    "offer": "str",
                                    "publisher": "str",
                                    "sharedGalleryImageId": "str",
                                    "sku": "str",
                                    "version": "str",
                                },
                                "osDisk": {
                                    "createOption": "str",
                                    "caching": "str",
                                    "deleteOption": "str",
                                    "diffDiskSettings": {"option": "str", "placement": "str"},
                                    "diskSizeGB": 0,
                                    "encryptionSettings": {
                                        "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                        "enabled": bool,
                                        "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                                    },
                                    "image": {"uri": "str"},
                                    "managedDisk": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "id": "str",
                                        "securityProfile": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "securityEncryptionType": "str",
                                        },
                                        "storageAccountType": "str",
                                    },
                                    "name": "str",
                                    "osType": "str",
                                    "vhd": {"uri": "str"},
                                    "writeAcceleratorEnabled": bool,
                                },
                            },
                            "userData": "str",
                        },
                        "computeApiVersion": "str",
                        "extensions": [
                            {
                                "name": "str",
                                "properties": {
                                    "autoUpgradeMinorVersion": bool,
                                    "enableAutomaticUpgrade": bool,
                                    "forceUpdateTag": "str",
                                    "protectedSettings": {"str": {}},
                                    "protectedSettingsFromKeyVault": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                    "provisionAfterExtensions": ["str"],
                                    "publisher": "str",
                                    "settings": {"str": {}},
                                    "suppressFailures": bool,
                                    "type": "str",
                                    "typeHandlerVersion": "str",
                                },
                            }
                        ],
                    },
                    "priorityProfile": {
                        "allocationStrategy": "str",
                        "evictionPolicy": "str",
                        "maxPricePerVM": 0.0,
                        "type": "str",
                    },
                    "capacityType": "str",
                    "provisioningState": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                    "vmAttributes": {
                        "architectureTypes": ["str"],
                        "memoryInGiB": {"max": 0.0, "min": 0.0},
                        "vCpuCount": {"max": 0, "min": 0},
                        "acceleratorCount": {"max": 0, "min": 0},
                        "acceleratorManufacturers": ["str"],
                        "acceleratorSupport": "str",
                        "acceleratorTypes": ["str"],
                        "allowedVMSizes": ["str"],
                        "burstableSupport": "str",
                        "cpuManufacturers": ["str"],
                        "dataDiskCount": {"max": 0, "min": 0},
                        "excludedVMSizes": ["str"],
                        "hyperVGenerations": ["str"],
                        "localStorageDiskTypes": ["str"],
                        "localStorageInGiB": {"max": 0.0, "min": 0.0},
                        "localStorageSupport": "str",
                        "memoryInGiBPerVCpu": {"max": 0.0, "min": 0.0},
                        "networkBandwidthInMbps": {"max": 0.0, "min": 0.0},
                        "networkInterfaceCount": {"max": 0, "min": 0},
                        "rdmaNetworkInterfaceCount": {"max": 0, "min": 0},
                        "rdmaSupport": "str",
                        "vmCategories": ["str"],
                    },
                    "vmSizesProfile": [{"name": "str", "rank": 0}],
                    "zoneAllocationPolicy": {
                        "distributionStrategy": "str",
                        "zonePreferences": [{"zone": "str", "rank": 0}],
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_begin_delete(self, resource_group):
        response = self.client.bulk_actions.begin_delete(
            resource_group_name=resource_group.name,
            location="str",
            name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_begin_cancel(self, resource_group):
        response = self.client.bulk_actions.begin_cancel(
            resource_group_name=resource_group.name,
            location="str",
            name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_list_by_resource_group(self, resource_group):
        response = self.client.bulk_actions.list_by_resource_group(
            resource_group_name=resource_group.name,
            location="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_list_by_subscription(self, resource_group):
        response = self.client.bulk_actions.list_by_subscription(
            location="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_list_virtual_machines(self, resource_group):
        response = self.client.bulk_actions.list_virtual_machines(
            resource_group_name=resource_group.name,
            location="str",
            name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_execute_deallocate(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_execute_deallocate(
            location="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_execute_hibernate(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_execute_hibernate(
            location="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_execute_start(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_execute_start(
            location="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_execute_create(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_execute_create(
            location="str",
            request_body={
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resourceConfigParameters": {
                    "resourceCount": 0,
                    "baseProfile": {"str": {}},
                    "resourceOverrides": [{"str": {}}],
                    "resourcePrefix": "str",
                },
                "correlationid": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_execute_delete(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_execute_delete(
            location="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "forceDeletion": bool,
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_get_operation_status(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_get_operation_status(
            location="str",
            request_body={"correlationid": "str", "operationIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bulk_actions_virtual_machines_cancel_operations(self, resource_group):
        response = self.client.bulk_actions.virtual_machines_cancel_operations(
            location="str",
            request_body={"correlationid": "str", "operationIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...
