# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from .._utils.utils import FileType
from ._enums import GeometryType, IngestionSourceType, StacModelType

if TYPE_CHECKING:
    from .. import _types, models as _models


class AssetMetadata(_Model):
    """Asset metadata model.

    :ivar key: The key of the asset. Required.
    :vartype key: str
    :ivar type: The type of the asset. Required.
    :vartype type: str
    :ivar roles: The roles of the asset. Required.
    :vartype roles: list[str]
    :ivar title: The title of the asset. Required.
    :vartype title: str
    :ivar description: The description of the asset. Required.
    :vartype description: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key of the asset. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the asset. Required."""
    roles: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The roles of the asset. Required."""
    title: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The title of the asset. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the asset. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        type: str,
        roles: list[str],
        title: str,
        description: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssetStatisticsResponse(_Model):
    """Return dataset's statistics."""


class BandStatistics(_Model):
    """Statistical information about a data band.

    :ivar minimum: Minimum value in the band. Required.
    :vartype minimum: float
    :ivar maximum: Maximum value in the band. Required.
    :vartype maximum: float
    :ivar mean: Mean value of the band. Required.
    :vartype mean: float
    :ivar count: Count of pixels in the band. Required.
    :vartype count: float
    :ivar sum: Sum of all pixel values in the band. Required.
    :vartype sum: float
    :ivar std: Standard deviation of pixel values in the band. Required.
    :vartype std: float
    :ivar median: Median value of the band. Required.
    :vartype median: float
    :ivar majority: Most common value in the band. Required.
    :vartype majority: float
    :ivar minority: Least common value in the band. Required.
    :vartype minority: float
    :ivar unique: Count of unique values in the band. Required.
    :vartype unique: float
    :ivar histogram: Histogram of pixel values in the band. Required.
    :vartype histogram: list[list[float]]
    :ivar valid_percent: Percentage of valid (non-masked) pixels. Required.
    :vartype valid_percent: float
    :ivar masked_pixels: Count of masked pixels in the band. Required.
    :vartype masked_pixels: float
    :ivar valid_pixels: Count of valid (non-masked) pixels in the band. Required.
    :vartype valid_pixels: float
    :ivar percentile2: Percentile 2 The 2nd percentile value. Required.
    :vartype percentile2: float
    :ivar percentile98: Percentile 98 The 98th percentile value. Required.
    :vartype percentile98: float
    """

    minimum: float = rest_field(name="min", visibility=["read", "create", "update", "delete", "query"])
    """Minimum value in the band. Required."""
    maximum: float = rest_field(name="max", visibility=["read", "create", "update", "delete", "query"])
    """Maximum value in the band. Required."""
    mean: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Mean value of the band. Required."""
    count: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of pixels in the band. Required."""
    sum: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sum of all pixel values in the band. Required."""
    std: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Standard deviation of pixel values in the band. Required."""
    median: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Median value of the band. Required."""
    majority: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Most common value in the band. Required."""
    minority: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Least common value in the band. Required."""
    unique: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of unique values in the band. Required."""
    histogram: list[list[float]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Histogram of pixel values in the band. Required."""
    valid_percent: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Percentage of valid (non-masked) pixels. Required."""
    masked_pixels: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of masked pixels in the band. Required."""
    valid_pixels: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of valid (non-masked) pixels in the band. Required."""
    percentile2: float = rest_field(name="percentile_2", visibility=["read", "create", "update", "delete", "query"])
    """Percentile 2 The 2nd percentile value. Required."""
    percentile98: float = rest_field(name="percentile_98", visibility=["read", "create", "update", "delete", "query"])
    """Percentile 98 The 98th percentile value. Required."""

    @overload
    def __init__(
        self,
        *,
        minimum: float,
        maximum: float,
        mean: float,
        count: float,
        sum: float,
        std: float,
        median: float,
        majority: float,
        minority: float,
        unique: float,
        histogram: list[list[float]],
        valid_percent: float,
        masked_pixels: float,
        valid_pixels: float,
        percentile2: float,
        percentile98: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BandStatisticsMap(_Model):
    """Map of band names to their statistics."""


class ClassMapLegendResponse(_Model):
    """ClassMap legend response model."""


class DefaultLocation(_Model):
    """Defines a default geographic location for map visualization.

    :ivar zoom: Default zoom level for the map. Required.
    :vartype zoom: int
    :ivar coordinates: Default center coordinates [latitude, longitude] for the map. Required.
    :vartype coordinates: list[float]
    """

    zoom: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default zoom level for the map. Required."""
    coordinates: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default center coordinates [latitude, longitude] for the map. Required."""

    @overload
    def __init__(
        self,
        *,
        zoom: int,
        coordinates: list[float],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorInfo(_Model):
    """Error information wrapper.

    :ivar error: Error details. Required.
    :vartype error: ~azure.core.ODataV4Format
    """

    error: ODataV4Format = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details. Required."""

    @overload
    def __init__(
        self,
        *,
        error: ODataV4Format,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Feature(_Model):
    """GeoJSON Feature object representing a geographic entity.

    :ivar geometry: Geometry object defining the feature's shape. Required.
    :vartype geometry: ~azure.planetarycomputer.models.Geometry
    :ivar type: GeoJSON type identifier for Feature. Required. "Feature"
    :vartype type: str or ~azure.planetarycomputer.models.FeatureType
    :ivar properties: Feature properties.
    :vartype properties: dict[str, any]
    """

    geometry: "_models.Geometry" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geometry object defining the feature's shape. Required."""
    type: Union[str, "_models.FeatureType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """GeoJSON type identifier for Feature. Required. \"Feature\""""
    properties: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Feature properties."""

    @overload
    def __init__(
        self,
        *,
        geometry: "_models.Geometry",
        type: Union[str, "_models.FeatureType"],
        properties: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Geometry(_Model):
    """Represents a GeoJSON geometry object as defined by RFC 7946.

    Supported geometry types include:

    * **Point**: A single geographic coordinate.
    * **LineString**: A sequence of geographic coordinates forming a line.
    * **Polygon**: A closed shape defined by linear rings.
    * **MultiPoint**: A collection of Points.
    * **MultiLineString**: A collection of LineStrings.
    * **MultiPolygon**: A collection of Polygons.

    Used for spatial filtering in STAC.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon

    :ivar type: Discriminator property for Geometry. Required. Known values are: "Point",
     "LineString", "Polygon", "MultiPoint", "MultiLineString", and "MultiPolygon".
    :vartype type: str or ~azure.planetarycomputer.models.GeometryType
    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type")
    """Discriminator property for Geometry. Required. Known values are: \"Point\", \"LineString\",
     \"Polygon\", \"MultiPoint\", \"MultiLineString\", and \"MultiPolygon\"."""
    bounding_box: Optional[list[float]] = rest_field(
        name="bbox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional bounding box of the geometry."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageParameters(_Model):
    """Parameters for requesting a rendered image from a collection.

    :ivar cql: Cql. Required.
    :vartype cql: dict[str, any]
    :ivar zoom: Zoom.
    :vartype zoom: float
    :ivar geometry: Geometry.
    :vartype geometry: ~azure.planetarycomputer.models.Geometry
    :ivar render_parameters: JSON-encoded visualization parameters. Required.
    :vartype render_parameters: str
    :ivar columns: Width of the output image in pixels. Required.
    :vartype columns: int
    :ivar rows: Height of the output image in pixels. Required.
    :vartype rows: int
    :ivar show_branding: Whether to include branding on the output image.
    :vartype show_branding: bool
    :ivar image_size: Image size.
    :vartype image_size: str
    """

    cql: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Cql. Required."""
    zoom: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Zoom."""
    geometry: Optional["_models.Geometry"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geometry."""
    render_parameters: str = rest_field(
        name="render_params", visibility=["read", "create", "update", "delete", "query"]
    )
    """JSON-encoded visualization parameters. Required."""
    columns: int = rest_field(name="cols", visibility=["read", "create", "update", "delete", "query"])
    """Width of the output image in pixels. Required."""
    rows: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height of the output image in pixels. Required."""
    show_branding: Optional[bool] = rest_field(
        name="showBranding", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include branding on the output image."""
    image_size: Optional[str] = rest_field(name="imageSize", visibility=["read", "create", "update", "delete", "query"])
    """Image size."""

    @overload
    def __init__(
        self,
        *,
        cql: dict[str, Any],
        render_parameters: str,
        columns: int,
        rows: int,
        zoom: Optional[float] = None,
        geometry: Optional["_models.Geometry"] = None,
        show_branding: Optional[bool] = None,
        image_size: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageResponse(_Model):
    """Response model for image exports.

    :ivar url: URL of the exported image. Required.
    :vartype url: str
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL of the exported image. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngestionDefinition(_Model):
    """Microsoft Planetary Computer Pro geo-catalog ingestion creation model.

    :ivar id: Ingestion id. Required.
    :vartype id: str
    :ivar import_type: Ingestion type. Required. "StaticCatalog"
    :vartype import_type: str or ~azure.planetarycomputer.models.IngestionType
    :ivar display_name: Ingestion name.
    :vartype display_name: str
    :ivar source_catalog_url: Source catalog URL. Required for StaticCatalog ingestion type.
    :vartype source_catalog_url: str
    :ivar skip_existing_items: Skip processing existing items in the catalog.
    :vartype skip_existing_items: bool
    :ivar keep_original_assets: Keep original source assets.
    :vartype keep_original_assets: bool
    :ivar creation_time: Ingestion creation time. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar status: Ingestion status. Required. Known values are: "Ready" and "Deleting".
    :vartype status: str or ~azure.planetarycomputer.models.IngestionStatus
    """

    id: str = rest_field(visibility=["read"])
    """Ingestion id. Required."""
    import_type: Union[str, "_models.IngestionType"] = rest_field(
        name="importType", visibility=["read", "create", "update"]
    )
    """Ingestion type. Required. \"StaticCatalog\""""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ingestion name."""
    source_catalog_url: Optional[str] = rest_field(
        name="sourceCatalogUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source catalog URL. Required for StaticCatalog ingestion type."""
    skip_existing_items: Optional[bool] = rest_field(
        name="skipExistingItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """Skip processing existing items in the catalog."""
    keep_original_assets: Optional[bool] = rest_field(
        name="keepOriginalAssets", visibility=["read", "create", "update", "delete", "query"]
    )
    """Keep original source assets."""
    creation_time: datetime.datetime = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """Ingestion creation time. Required."""
    status: Union[str, "_models.IngestionStatus"] = rest_field(visibility=["read"])
    """Ingestion status. Required. Known values are: \"Ready\" and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        import_type: Union[str, "_models.IngestionType"],
        display_name: Optional[str] = None,
        source_catalog_url: Optional[str] = None,
        skip_existing_items: Optional[bool] = None,
        keep_original_assets: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngestionRun(_Model):
    """Microsoft Planetary Computer Pro geo-catalog ingestion run.

    :ivar id: Run id. Required.
    :vartype id: str
    :ivar parent_run_id: Run id which this run is associated to because it has been retried or
     rerun.
    :vartype parent_run_id: str
    :ivar operation: Operation. Required.
    :vartype operation: ~azure.planetarycomputer.models.IngestionRunOperation
    :ivar creation_time: Creation time. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar source_catalog_url: URL of the source catalog.
    :vartype source_catalog_url: str
    :ivar skip_existing_items: Skip any item that already exist in the GeoCatalog.
    :vartype skip_existing_items: bool
    :ivar keep_original_assets: Keep original source assets.
    :vartype keep_original_assets: bool
    """

    id: str = rest_field(visibility=["read", "create", "update"])
    """Run id. Required."""
    parent_run_id: Optional[str] = rest_field(
        name="parentRunId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Run id which this run is associated to because it has been retried or rerun."""
    operation: "_models.IngestionRunOperation" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation. Required."""
    creation_time: datetime.datetime = rest_field(
        name="creationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation time. Required."""
    source_catalog_url: Optional[str] = rest_field(
        name="sourceCatalogUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """URL of the source catalog."""
    skip_existing_items: Optional[bool] = rest_field(
        name="skipExistingItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """Skip any item that already exist in the GeoCatalog."""
    keep_original_assets: Optional[bool] = rest_field(
        name="keepOriginalAssets", visibility=["read", "create", "update", "delete", "query"]
    )
    """Keep original source assets."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        operation: "_models.IngestionRunOperation",
        creation_time: datetime.datetime,
        parent_run_id: Optional[str] = None,
        source_catalog_url: Optional[str] = None,
        skip_existing_items: Optional[bool] = None,
        keep_original_assets: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngestionRunOperation(_Model):
    """Microsoft Planetary Computer Pro geo-catalog ingestion run operation.

    :ivar id: Operation id. Required.
    :vartype id: str
    :ivar status: Operation status. Required. Known values are: "Pending", "Running", "Succeeded",
     "Canceled", "Canceling", and "Failed".
    :vartype status: str or ~azure.planetarycomputer.models.OperationStatus
    :ivar creation_time: The UTC time at which the operation was created. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar status_history: The history of the operation status in time. Required.
    :vartype status_history: list[~azure.planetarycomputer.models.OperationStatusHistoryItem]
    :ivar start_time: The UTC time at which the operation was started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The UTC time at which the operation finished its execution.
    :vartype finish_time: ~datetime.datetime
    :ivar total_items: The number of total items to be processed. Required.
    :vartype total_items: int
    :ivar total_pending_items: The number of items pending to be processed. Required.
    :vartype total_pending_items: int
    :ivar total_successful_items: The number of items successfully processed. Required.
    :vartype total_successful_items: int
    :ivar total_failed_items: The number of items that have failed to be processed. Required.
    :vartype total_failed_items: int
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation id. Required."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation status. Required. Known values are: \"Pending\", \"Running\", \"Succeeded\",
     \"Canceled\", \"Canceling\", and \"Failed\"."""
    creation_time: datetime.datetime = rest_field(
        name="creationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation was created. Required."""
    status_history: list["_models.OperationStatusHistoryItem"] = rest_field(
        name="statusHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The history of the operation status in time. Required."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation was started."""
    finish_time: Optional[datetime.datetime] = rest_field(
        name="finishTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation finished its execution."""
    total_items: int = rest_field(name="totalItems", visibility=["read", "create", "update", "delete", "query"])
    """The number of total items to be processed. Required."""
    total_pending_items: int = rest_field(
        name="totalPendingItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of items pending to be processed. Required."""
    total_successful_items: int = rest_field(
        name="totalSuccessfulItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of items successfully processed. Required."""
    total_failed_items: int = rest_field(
        name="totalFailedItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of items that have failed to be processed. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Union[str, "_models.OperationStatus"],
        creation_time: datetime.datetime,
        status_history: list["_models.OperationStatusHistoryItem"],
        total_items: int,
        total_pending_items: int,
        total_successful_items: int,
        total_failed_items: int,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngestionSource(_Model):
    """Ingestion Source.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ManagedIdentityIngestionSource, SharedAccessSignatureTokenIngestionSource

    :ivar id: Ingestion source id. Required.
    :vartype id: str
    :ivar created: Created time in UTC format.
    :vartype created: ~datetime.datetime
    :ivar kind: Discriminator for the ingestion source. Required. Known values are: "SasToken" and
     "BlobManagedIdentity".
    :vartype kind: str or ~azure.planetarycomputer.models.IngestionSourceType
    """

    __mapping__: dict[str, _Model] = {}
    id: str = rest_field(visibility=["read", "update"])
    """Ingestion source id. Required."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc3339")
    """Created time in UTC format."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Discriminator for the ingestion source. Required. Known values are: \"SasToken\" and
     \"BlobManagedIdentity\"."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngestionSourceSummary(_Model):
    """Ingestion source summary.

    :ivar id: Ingestion source id. Required.
    :vartype id: str
    :ivar kind: Ingestion source type. Required. Known values are: "SasToken" and
     "BlobManagedIdentity".
    :vartype kind: str or ~azure.planetarycomputer.models.IngestionSourceType
    :ivar created: Created time in UTC format.
    :vartype created: ~datetime.datetime
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Ingestion source id. Required."""
    kind: Union[str, "_models.IngestionSourceType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Ingestion source type. Required. Known values are: \"SasToken\" and \"BlobManagedIdentity\"."""
    created: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Created time in UTC format."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        kind: Union[str, "_models.IngestionSourceType"],
        created: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LineString(Geometry, discriminator="LineString"):
    """Represents a LineString.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar type: The type of the linestring. Required. Represents a LineString geometry.
    :vartype type: str or ~azure.planetarycomputer.models.LINE_STRING
    :ivar coordinates: The coordinates of the linestring. Required.
    :vartype coordinates: list[list[float]]
    """

    type: Literal[GeometryType.LINE_STRING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the linestring. Required. Represents a LineString geometry."""
    coordinates: list[list[float]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the linestring. Required."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[list[float]],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.LINE_STRING  # type: ignore


class ManagedIdentityConnection(_Model):
    """Managed Identity connection information.

    :ivar container_uri: Azure Blob Storage container URL. Required.
    :vartype container_uri: str
    :ivar object_id: Azure Managed Identity configured in the Geo-Catalog with access to the
     container. Required.
    :vartype object_id: str
    """

    container_uri: str = rest_field(name="containerUrl", visibility=["read", "create", "update", "delete", "query"])
    """Azure Blob Storage container URL. Required."""
    object_id: str = rest_field(name="objectId", visibility=["read", "create", "update", "delete", "query"])
    """Azure Managed Identity configured in the Geo-Catalog with access to the container. Required."""

    @overload
    def __init__(
        self,
        *,
        container_uri: str,
        object_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedIdentityIngestionSource(IngestionSource, discriminator="BlobManagedIdentity"):
    """Managed Identity ingestion source.

    :ivar id: Ingestion source id. Required.
    :vartype id: str
    :ivar created: Created time in UTC format.
    :vartype created: ~datetime.datetime
    :ivar kind: Required. Azure Blob Managed Identity.
    :vartype kind: str or ~azure.planetarycomputer.models.BLOB_MANAGED_IDENTITY
    :ivar connection_info: Managed identity connection information. Required.
    :vartype connection_info: ~azure.planetarycomputer.models.ManagedIdentityConnection
    """

    kind: Literal[IngestionSourceType.BLOB_MANAGED_IDENTITY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Azure Blob Managed Identity."""
    connection_info: "_models.ManagedIdentityConnection" = rest_field(
        name="connectionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed identity connection information. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        connection_info: "_models.ManagedIdentityConnection",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = IngestionSourceType.BLOB_MANAGED_IDENTITY  # type: ignore


class ManagedIdentityMetadata(_Model):
    """Managed Identity metadata.

    :ivar object_id: Object id of the managed identity. Required.
    :vartype object_id: str
    :ivar resource_id: ARM path or resource id of the managed identity. Required.
    :vartype resource_id: str
    """

    object_id: str = rest_field(name="objectId", visibility=["read", "create", "update", "delete", "query"])
    """Object id of the managed identity. Required."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """ARM path or resource id of the managed identity. Required."""

    @overload
    def __init__(
        self,
        *,
        object_id: str,
        resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MosaicMetadata(_Model):
    """Metadata information for mosaic or search results.

    :ivar type: Type of metadata resource. Known values are: "mosaic" and "search".
    :vartype type: str or ~azure.planetarycomputer.models.MosaicMetadataType
    :ivar bounds: Geographic bounding box in [west, south, east, north] format.
    :vartype bounds: str
    :ivar min_zoom: Minimum zoom level supported.
    :vartype min_zoom: int
    :ivar max_zoom: Maximum zoom level supported.
    :vartype max_zoom: int
    :ivar name: Human-readable name for the resource.
    :vartype name: str
    :ivar assets: List of asset identifiers included in the resource.
    :vartype assets: list[str]
    :ivar defaults: Defaults.
    :vartype defaults: dict[str, str]
    """

    type: Optional[Union[str, "_models.MosaicMetadataType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of metadata resource. Known values are: \"mosaic\" and \"search\"."""
    bounds: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geographic bounding box in [west, south, east, north] format."""
    min_zoom: Optional[int] = rest_field(name="minzoom", visibility=["read", "create", "update", "delete", "query"])
    """Minimum zoom level supported."""
    max_zoom: Optional[int] = rest_field(name="maxzoom", visibility=["read", "create", "update", "delete", "query"])
    """Maximum zoom level supported."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable name for the resource."""
    assets: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of asset identifiers included in the resource."""
    defaults: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Defaults."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.MosaicMetadataType"]] = None,
        bounds: Optional[str] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        name: Optional[str] = None,
        assets: Optional[list[str]] = None,
        defaults: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiLineString(Geometry, discriminator="MultiLineString"):
    """Represents a MultiLineString.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar type: The type of the multilinestring. Required. Represents a MultiLineString geometry.
    :vartype type: str or ~azure.planetarycomputer.models.MULTI_LINE_STRING
    :ivar coordinates: The coordinates of the multilinestring. Required.
    :vartype coordinates: list[list[list[float]]]
    """

    type: Literal[GeometryType.MULTI_LINE_STRING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the multilinestring. Required. Represents a MultiLineString geometry."""
    coordinates: list[list[list[float]]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the multilinestring. Required."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[list[list[float]]],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.MULTI_LINE_STRING  # type: ignore


class MultiPoint(Geometry, discriminator="MultiPoint"):
    """Represents a MultiPoint.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar type: The type of the multipoint. Required. Represents a MultiPoint geometry.
    :vartype type: str or ~azure.planetarycomputer.models.MULTI_POINT
    :ivar coordinates: The coordinates of the multipoint. Required.
    :vartype coordinates: list[list[float]]
    """

    type: Literal[GeometryType.MULTI_POINT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the multipoint. Required. Represents a MultiPoint geometry."""
    coordinates: list[list[float]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the multipoint. Required."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[list[float]],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.MULTI_POINT  # type: ignore


class MultiPolygon(Geometry, discriminator="MultiPolygon"):
    """Represents a MultiPolygon.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar coordinates: The coordinates of the multipolygon. Required.
    :vartype coordinates: list[list[list[list[float]]]]
    :ivar type: The type of the multipolygon. Required. Represents a MultiPolygon geometry.
    :vartype type: str or ~azure.planetarycomputer.models.MULTI_POLYGON
    """

    coordinates: list[list[list[list[float]]]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the multipolygon. Required."""
    type: Literal[GeometryType.MULTI_POLYGON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the multipolygon. Required. Represents a MultiPolygon geometry."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[list[list[list[float]]]],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.MULTI_POLYGON  # type: ignore


class Operation(_Model):
    """Microsoft Planetary Computer Pro geo-catalog operation.

    :ivar id: Operation id. Required.
    :vartype id: str
    :ivar status: Operation status. Required. Known values are: "Pending", "Running", "Succeeded",
     "Canceled", "Canceling", and "Failed".
    :vartype status: str or ~azure.planetarycomputer.models.OperationStatus
    :ivar type: Operation type. Required.
    :vartype type: str
    :ivar creation_time: The UTC time at which the operation was created. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar collection_id: Collection ID.
    :vartype collection_id: str
    :ivar status_history: The history of the operation status in time. Required.
    :vartype status_history: list[~azure.planetarycomputer.models.OperationStatusHistoryItem]
    :ivar start_time: The UTC time at which the operation was started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The UTC time at which the operation finished its execution.
    :vartype finish_time: ~datetime.datetime
    :ivar additional_information: Additional information elements about the particular operation
     type.
    :vartype additional_information: dict[str, str]
    :ivar error: Error information.
    :vartype error: ~azure.planetarycomputer.models.ErrorInfo
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation id. Required."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation status. Required. Known values are: \"Pending\", \"Running\", \"Succeeded\",
     \"Canceled\", \"Canceling\", and \"Failed\"."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation type. Required."""
    creation_time: datetime.datetime = rest_field(
        name="creationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation was created. Required."""
    collection_id: Optional[str] = rest_field(
        name="collectionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Collection ID."""
    status_history: list["_models.OperationStatusHistoryItem"] = rest_field(
        name="statusHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The history of the operation status in time. Required."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation was started."""
    finish_time: Optional[datetime.datetime] = rest_field(
        name="finishTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the operation finished its execution."""
    additional_information: Optional[dict[str, str]] = rest_field(
        name="additionalInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information elements about the particular operation type."""
    error: Optional["_models.ErrorInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error information."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Union[str, "_models.OperationStatus"],
        type: str,
        creation_time: datetime.datetime,
        status_history: list["_models.OperationStatusHistoryItem"],
        collection_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        additional_information: Optional[dict[str, str]] = None,
        error: Optional["_models.ErrorInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationStatusHistoryItem(_Model):
    """Operation status history item.

    :ivar timestamp: The UTC time at which the status was set. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar status: The status of the operation. Required. Known values are: "Pending", "Running",
     "Succeeded", "Canceled", "Canceling", and "Failed".
    :vartype status: str or ~azure.planetarycomputer.models.OperationStatus
    :ivar error_code: If the status is failed, the error code.
    :vartype error_code: str
    :ivar error_message: If the status is failed, the error message.
    :vartype error_message: str
    """

    timestamp: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The UTC time at which the status was set. Required."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation. Required. Known values are: \"Pending\", \"Running\",
     \"Succeeded\", \"Canceled\", \"Canceling\", and \"Failed\"."""
    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """If the status is failed, the error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If the status is failed, the error message."""

    @overload
    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PartitionType(_Model):
    """Defines how data is partitioned for efficient storage and retrieval.

    :ivar scheme: Partitioning scheme to use for data organization. Known values are: "year",
     "month", and "none".
    :vartype scheme: str or ~azure.planetarycomputer.models.PartitionTypeScheme
    """

    scheme: Optional[Union[str, "_models.PartitionTypeScheme"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Partitioning scheme to use for data organization. Known values are: \"year\", \"month\", and
     \"none\"."""

    @overload
    def __init__(
        self,
        *,
        scheme: Optional[Union[str, "_models.PartitionTypeScheme"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Point(Geometry, discriminator="Point"):
    """Represents a GeoJSON Point geometry.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar type: The geometry type, always "Point" for Point geometries. Required. Represents a
     Point geometry.
    :vartype type: str or ~azure.planetarycomputer.models.POINT
    :ivar coordinates: The coordinates of the point as [longitude, latitude]. Required.
    :vartype coordinates: list[float]
    """

    type: Literal[GeometryType.POINT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The geometry type, always \"Point\" for Point geometries. Required. Represents a Point
     geometry."""
    coordinates: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the point as [longitude, latitude]. Required."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[float],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.POINT  # type: ignore


class Polygon(Geometry, discriminator="Polygon"):
    """Represents a Polygon.

    :ivar bounding_box: Optional bounding box of the geometry.
    :vartype bounding_box: list[float]
    :ivar coordinates: The coordinates of the polygon. Required.
    :vartype coordinates: list[list[list[float]]]
    :ivar type: The type of the polygon. Required. Represents a Polygon geometry.
    :vartype type: str or ~azure.planetarycomputer.models.POLYGON
    """

    coordinates: list[list[list[float]]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The coordinates of the polygon. Required."""
    type: Literal[GeometryType.POLYGON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the polygon. Required. Represents a Polygon geometry."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[list[list[float]]],
        bounding_box: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = GeometryType.POLYGON  # type: ignore


class QueryableDefinitionsResponse(_Model):
    """Queryable definitions response."""


class RenderOption(_Model):
    """Defines visualization parameters for rendering data on a map.

    :ivar id: Unique identifier for the render option. Required.
    :vartype id: str
    :ivar name: Short descriptive name for the render option. Required.
    :vartype name: str
    :ivar description: A longer description of the render option that can be used to explain its
     content.
    :vartype description: str
    :ivar type: The type of rendering to apply (raster or vector). Known values are: "raster-tile",
     "vt-polygon", and "vt-line".
    :vartype type: str or ~azure.planetarycomputer.models.RenderOptionType
    :ivar options: A URL query-string encoded string of TiTiler rendering options. Valid only for
     ``raster-tile`` types.

     See `Query Parameters <https://developmentseed.org/titiler/endpoints/cog/#description>`_.
    :vartype options: str
    :ivar vector_options: Options for rendering vector tiles. Valid only for ``vt-polygon``  and
     ``vt-line`` types.
    :vartype vector_options: ~azure.planetarycomputer.models.RenderOptionVectorOptions
    :ivar min_zoom: Minimum zoom level at which to display this layer.
    :vartype min_zoom: int
    :ivar legend: Legend configuration for this render option.
    :vartype legend: ~azure.planetarycomputer.models.RenderOptionLegend
    :ivar conditions: A list of property/value conditions that must be in the active mosaic CQL for
     this render option to be enabled.
    :vartype conditions: list[~azure.planetarycomputer.models.RenderOptionCondition]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the render option. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Short descriptive name for the render option. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A longer description of the render option that can be used to explain its content."""
    type: Optional[Union[str, "_models.RenderOptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of rendering to apply (raster or vector). Known values are: \"raster-tile\",
     \"vt-polygon\", and \"vt-line\"."""
    options: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A URL query-string encoded string of TiTiler rendering options. Valid only for ``raster-tile``
     types.
     
     See `Query Parameters <https://developmentseed.org/titiler/endpoints/cog/#description>`_."""
    vector_options: Optional["_models.RenderOptionVectorOptions"] = rest_field(
        name="vectorOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Options for rendering vector tiles. Valid only for ``vt-polygon``  and ``vt-line`` types."""
    min_zoom: Optional[int] = rest_field(name="minZoom", visibility=["read", "create", "update", "delete", "query"])
    """Minimum zoom level at which to display this layer."""
    legend: Optional["_models.RenderOptionLegend"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Legend configuration for this render option."""
    conditions: Optional[list["_models.RenderOptionCondition"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of property/value conditions that must be in the active mosaic CQL for this render
     option to be enabled."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        description: Optional[str] = None,
        type: Optional[Union[str, "_models.RenderOptionType"]] = None,
        options: Optional[str] = None,
        vector_options: Optional["_models.RenderOptionVectorOptions"] = None,
        min_zoom: Optional[int] = None,
        legend: Optional["_models.RenderOptionLegend"] = None,
        conditions: Optional[list["_models.RenderOptionCondition"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RenderOptionCondition(_Model):
    """Defines a condition for enabling a render option.

    :ivar property: Property name to check in the active CQL filter. Required.
    :vartype property: str
    :ivar value: Value that the property must equal.
    :vartype value: str
    """

    property: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Property name to check in the active CQL filter. Required."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Value that the property must equal."""

    @overload
    def __init__(
        self,
        *,
        property: str,  # pylint: disable=redefined-builtin
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RenderOptionLegend(_Model):
    """Configuration for generating a data legend.

    :ivar type: Legend type to make, one of: ``continuous``, ``classmap``, ``interval`` or ``none``
     (note, ``none`` is a string literal). Known values are: "continuous", "classmap", "interval",
     and "none".
    :vartype type: str or ~azure.planetarycomputer.models.LegendConfigType
    :ivar labels: Text labels to display on the legend.
    :vartype labels: list[str]
    :ivar trim_start: The number of items to trim from the start of the legend definition. Used if
     there are values important for rendering (e.g. nodata) that aren't desirable in the legend.
    :vartype trim_start: int
    :ivar trim_end: Number of items to trim from the end of the legend.
    :vartype trim_end: int
    :ivar scale_factor: A factor to multiply interval legend labels by. Useful for scaled rasters
     whose colormap definitions map to unscaled values, effectively showing legend labels as scaled
     values.
    :vartype scale_factor: float
    """

    type: Optional[Union[str, "_models.LegendConfigType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Legend type to make, one of: ``continuous``, ``classmap``, ``interval`` or ``none`` (note,
     ``none`` is a string literal). Known values are: \"continuous\", \"classmap\", \"interval\",
     and \"none\"."""
    labels: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text labels to display on the legend."""
    trim_start: Optional[int] = rest_field(name="trimStart", visibility=["read", "create", "update", "delete", "query"])
    """The number of items to trim from the start of the legend definition. Used if there are values
     important for rendering (e.g. nodata) that aren't desirable in the legend."""
    trim_end: Optional[int] = rest_field(name="trimEnd", visibility=["read", "create", "update", "delete", "query"])
    """Number of items to trim from the end of the legend."""
    scale_factor: Optional[float] = rest_field(
        name="scaleFactor", visibility=["read", "create", "update", "delete", "query"]
    )
    """A factor to multiply interval legend labels by. Useful for scaled rasters whose colormap
     definitions map to unscaled values, effectively showing legend labels as scaled values."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.LegendConfigType"]] = None,
        labels: Optional[list[str]] = None,
        trim_start: Optional[int] = None,
        trim_end: Optional[int] = None,
        scale_factor: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RenderOptionVectorOptions(_Model):
    """Defines parameters for vector tile rendering.

    :ivar tilejson_key: Asset key containing the TileJSON URL. Required.
    :vartype tilejson_key: str
    :ivar source_layer: Name of the source layer in the vector tiles. Required.
    :vartype source_layer: str
    :ivar fill_color: Fill color for polygon features.
    :vartype fill_color: str
    :ivar stroke_color: Stroke color for line features.
    :vartype stroke_color: str
    :ivar stroke_width: Width of line strokes in pixels.
    :vartype stroke_width: int
    :ivar filter: MapBox GL filter expression to filter features.
    :vartype filter: list[str]
    """

    tilejson_key: str = rest_field(name="tilejsonKey", visibility=["read", "create", "update", "delete", "query"])
    """Asset key containing the TileJSON URL. Required."""
    source_layer: str = rest_field(name="sourceLayer", visibility=["read", "create", "update", "delete", "query"])
    """Name of the source layer in the vector tiles. Required."""
    fill_color: Optional[str] = rest_field(name="fillColor", visibility=["read", "create", "update", "delete", "query"])
    """Fill color for polygon features."""
    stroke_color: Optional[str] = rest_field(
        name="strokeColor", visibility=["read", "create", "update", "delete", "query"]
    )
    """Stroke color for line features."""
    stroke_width: Optional[int] = rest_field(
        name="strokeWidth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Width of line strokes in pixels."""
    filter: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """MapBox GL filter expression to filter features."""

    @overload
    def __init__(
        self,
        *,
        tilejson_key: str,
        source_layer: str,
        fill_color: Optional[str] = None,
        stroke_color: Optional[str] = None,
        stroke_width: Optional[int] = None,
        filter: Optional[list[str]] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchOptionsFields(_Model):
    """FieldsExtension.

    Attributes:
    include: set of fields to include.
    exclude: set of fields to exclude.

    Controls which fields to include or exclude from the response.

    :ivar include: Array of field names to include in the response.
    :vartype include: list[str]
    :ivar exclude: Array of field names to exclude from the response.
    :vartype exclude: list[str]
    """

    include: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of field names to include in the response."""
    exclude: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of field names to exclude from the response."""

    @overload
    def __init__(
        self,
        *,
        include: Optional[list[str]] = None,
        exclude: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedAccessSignatureSignedLink(_Model):
    """UnsignedLink.

    :ivar expires_on: Msft:Expiry.
    :vartype expires_on: ~datetime.datetime
    :ivar href: Href. Required.
    :vartype href: str
    """

    expires_on: Optional[datetime.datetime] = rest_field(
        name="msft:expiry", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Msft:Expiry."""
    href: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Href. Required."""

    @overload
    def __init__(
        self,
        *,
        href: str,
        expires_on: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedAccessSignatureToken(_Model):
    """Managed Storage Shared Access Signature (SAS) Token.

    :ivar expires_on: Msft:Expiry. Required.
    :vartype expires_on: ~datetime.datetime
    :ivar token: Token. Required.
    :vartype token: str
    """

    expires_on: datetime.datetime = rest_field(
        name="msft:expiry", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Msft:Expiry. Required."""
    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Token. Required."""

    @overload
    def __init__(
        self,
        *,
        expires_on: datetime.datetime,
        token: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedAccessSignatureTokenConnection(_Model):
    """SAS Token connection information.

    :ivar container_uri: Azure Blob Storage container URL. Required.
    :vartype container_uri: str
    :ivar shared_access_signature_token: SAS token.
    :vartype shared_access_signature_token: str
    :ivar expiration: Azure Blob Storage SAS token expiration in UTC format.
    :vartype expiration: ~datetime.datetime
    """

    container_uri: str = rest_field(name="containerUrl", visibility=["read", "create", "update", "delete", "query"])
    """Azure Blob Storage container URL. Required."""
    shared_access_signature_token: Optional[str] = rest_field(name="sasToken", visibility=["create", "update"])
    """SAS token."""
    expiration: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc3339")
    """Azure Blob Storage SAS token expiration in UTC format."""

    @overload
    def __init__(
        self,
        *,
        container_uri: str,
        shared_access_signature_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedAccessSignatureTokenIngestionSource(
    IngestionSource, discriminator="SasToken"
):  # pylint: disable=name-too-long
    """SAS Token ingestion source.

    :ivar id: Ingestion source id. Required.
    :vartype id: str
    :ivar created: Created time in UTC format.
    :vartype created: ~datetime.datetime
    :ivar kind: Required. Azure Blob Storage SAS token.
    :vartype kind: str or ~azure.planetarycomputer.models.SHARED_ACCESS_SIGNATURE_TOKEN
    :ivar connection_info: SAS token connection information. Required.
    :vartype connection_info: ~azure.planetarycomputer.models.SharedAccessSignatureTokenConnection
    """

    kind: Literal[IngestionSourceType.SHARED_ACCESS_SIGNATURE_TOKEN] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Azure Blob Storage SAS token."""
    connection_info: "_models.SharedAccessSignatureTokenConnection" = rest_field(
        name="connectionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """SAS token connection information. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        connection_info: "_models.SharedAccessSignatureTokenConnection",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = IngestionSourceType.SHARED_ACCESS_SIGNATURE_TOKEN  # type: ignore


class StacAsset(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/item-spec.md#asset-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/item-spec.md#asset-object>`_

    Represents a STAC asset, which is a file or resource associated with a STAC item.

    :ivar platform: Platform that acquired the data.
    :vartype platform: str
    :ivar instruments: Instruments that acquired the data.
    :vartype instruments: list[str]
    :ivar constellation: Constellation of satellites that acquired the data.
    :vartype constellation: str
    :ivar mission: Mission associated with the data.
    :vartype mission: str
    :ivar providers: Organizations or individuals who provide the data.
    :vartype providers: list[~azure.planetarycomputer.models.StacProvider]
    :ivar gsd: Ground sample distance in meters.
    :vartype gsd: float
    :ivar created: Creation timestamp of the data.
    :vartype created: ~datetime.datetime
    :ivar updated: Last update timestamp of the data.
    :vartype updated: ~datetime.datetime
    :ivar title: Human-readable title for the asset.
    :vartype title: str
    :ivar description: Detailed description of the asset.
    :vartype description: str
    :ivar href: URL to the asset file. Required.
    :vartype href: str
    :ivar type: Media type of the asset.
    :vartype type: str
    :ivar roles: Roles of the asset within the item.
    :vartype roles: list[str]
    """

    platform: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Platform that acquired the data."""
    instruments: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Instruments that acquired the data."""
    constellation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Constellation of satellites that acquired the data."""
    mission: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Mission associated with the data."""
    providers: Optional[list["_models.StacProvider"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Organizations or individuals who provide the data."""
    gsd: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Ground sample distance in meters."""
    created: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation timestamp of the data."""
    updated: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Last update timestamp of the data."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title for the asset."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the asset."""
    href: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to the asset file. Required."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Media type of the asset."""
    roles: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Roles of the asset within the item."""

    @overload
    def __init__(
        self,
        *,
        href: str,
        platform: Optional[str] = None,
        instruments: Optional[list[str]] = None,
        constellation: Optional[str] = None,
        mission: Optional[str] = None,
        providers: Optional[list["_models.StacProvider"]] = None,
        gsd: Optional[float] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        type: Optional[str] = None,
        roles: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacAssetData(_Model):
    """FormContent model for file upload.

    :ivar data: Asset metadata. Required.
    :vartype data: ~azure.planetarycomputer.models.AssetMetadata
    :ivar file: Binary file content to be uploaded. Required.
    :vartype file: ~azure.planetarycomputer._utils.utils.FileType
    """

    data: "_models.AssetMetadata" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Asset metadata. Required."""
    file: FileType = rest_field(
        visibility=["read", "create", "update", "delete", "query"], is_multipart_file_input=True
    )
    """Binary file content to be uploaded. Required."""

    @overload
    def __init__(
        self,
        *,
        data: "_models.AssetMetadata",
        file: FileType,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacCatalogCollections(_Model):
    """`http://docs.opengeospatial.org/is/17-069r3/17-069r3.html#_feature_collections_rootcollections
    <http://docs.opengeospatial.org/is/17-069r3/17-069r3.html#_feature_collections_rootcollections>`_

    Represents a collection of STAC collections with links.

    :ivar links: Links to related resources and endpoints. Required.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar collections: Array of STAC collections available in the catalog. Required.
    :vartype collections: list[~azure.planetarycomputer.models.StacCollection]
    """

    links: list["_models.StacLink"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Links to related resources and endpoints. Required."""
    collections: list["_models.StacCollection"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of STAC collections available in the catalog. Required."""

    @overload
    def __init__(
        self,
        *,
        links: list["_models.StacLink"],
        collections: list["_models.StacCollection"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacCollection(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md>`_

    Represents a STAC collection.

    :ivar created_on: MSFT Created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: MSFT Updated.
    :vartype updated_on: ~datetime.datetime
    :ivar short_description: MSFT Short Description.
    :vartype short_description: str
    :ivar stac_extensions: URLs to STAC extensions implemented by this STAC resource.
    :vartype stac_extensions: list[str]
    :ivar id: Unique identifier for the collection. Required.
    :vartype id: str
    :ivar description: Detailed description of the collection. Required.
    :vartype description: str
    :ivar stac_version: Stac Version.
    :vartype stac_version: str
    :ivar links: Links to related resources and endpoints. Required.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar title: Human-readable title for the collection.
    :vartype title: str
    :ivar type: Type.
    :vartype type: str
    :ivar assets: Assets.
    :vartype assets: dict[str, ~azure.planetarycomputer.models.StacAsset]
    :ivar item_assets: Item Assets

     See the `Item Assets Definition Extension Specification
     <https://github.com/stac-extensions/item-assets>`_.
    :vartype item_assets: dict[str, ~azure.planetarycomputer.models.StacItemAsset]
    :ivar license: License identifier for the collection data. Required.
    :vartype license: str
    :ivar extent: Spatial and temporal extent of the collection. Required.
    :vartype extent: ~azure.planetarycomputer.models.StacExtensionExtent
    :ivar keywords: Keywords describing the collection.
    :vartype keywords: list[str]
    :ivar providers: Organizations or individuals who provide the collection data.
    :vartype providers: list[~azure.planetarycomputer.models.StacProvider]
    :ivar summaries: Summaries

     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_.
    :vartype summaries: dict[str, any]
    """

    created_on: Optional[datetime.datetime] = rest_field(
        name="msft:_created", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Created."""
    updated_on: Optional[datetime.datetime] = rest_field(
        name="msft:_updated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Updated."""
    short_description: Optional[str] = rest_field(
        name="msft:short_description", visibility=["read", "create", "update", "delete", "query"]
    )
    """MSFT Short Description."""
    stac_extensions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URLs to STAC extensions implemented by this STAC resource."""
    id: str = rest_field(visibility=["read", "create", "update"])
    """Unique identifier for the collection. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the collection. Required."""
    stac_version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Stac Version."""
    links: list["_models.StacLink"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Links to related resources and endpoints. Required."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title for the collection."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type."""
    assets: Optional[dict[str, "_models.StacAsset"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Assets."""
    item_assets: Optional[dict[str, "_models.StacItemAsset"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Item Assets
     
     See the `Item Assets Definition Extension Specification
     <https://github.com/stac-extensions/item-assets>`_."""
    license: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """License identifier for the collection data. Required."""
    extent: "_models.StacExtensionExtent" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Spatial and temporal extent of the collection. Required."""
    keywords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Keywords describing the collection."""
    providers: Optional[list["_models.StacProvider"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Organizations or individuals who provide the collection data."""
    summaries: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Summaries
     
     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        description: str,
        links: list["_models.StacLink"],
        license: str,
        extent: "_models.StacExtensionExtent",
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        short_description: Optional[str] = None,
        stac_extensions: Optional[list[str]] = None,
        stac_version: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[str] = None,
        assets: Optional[dict[str, "_models.StacAsset"]] = None,
        item_assets: Optional[dict[str, "_models.StacItemAsset"]] = None,
        keywords: Optional[list[str]] = None,
        providers: Optional[list["_models.StacProvider"]] = None,
        summaries: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacCollectionTemporalExtent(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#temporal-extent-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#temporal-extent-object>`_

    Represents the temporal extent of a STAC collection with time intervals.

    :ivar interval: Array of time intervals in format [[start_datetime, end_datetime]]. Required.
    :vartype interval: list[list[~datetime.datetime]]
    """

    interval: list[list[datetime.datetime]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Array of time intervals in format [[start_datetime, end_datetime]]. Required."""

    @overload
    def __init__(
        self,
        *,
        interval: list[list[datetime.datetime]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacConformanceClasses(_Model):
    """`https://github.com/radiantearth/stac-api-spec/blob/master/api-spec.md#ogc-api---features-endpoints
    <https://github.com/radiantearth/stac-api-spec/blob/master/api-spec.md#ogc-api---features-endpoints>`_

    Represents the OGC API conformance declaration.

    :ivar conforms_to: List of OGC API conformance classes implemented by this API. Required.
    :vartype conforms_to: list[str]
    """

    conforms_to: list[str] = rest_field(name="conformsTo", visibility=["read", "create", "update", "delete", "query"])
    """List of OGC API conformance classes implemented by this API. Required."""

    @overload
    def __init__(
        self,
        *,
        conforms_to: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacContextExtension(_Model):
    """`https://github.com/radiantearth/stac-api-spec/tree/master/extensions/context#context-extension-specification
    <https://github.com/radiantearth/stac-api-spec/tree/master/extensions/context#context-extension-specification>`_

    Context information for a search response including pagination details.

    :ivar returned: Number of items returned in the response. Required.
    :vartype returned: int
    :ivar limit: Maximum number of items requested.
    :vartype limit: int
    :ivar matched: Total number of items matching the query.
    :vartype matched: int
    """

    returned: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of items returned in the response. Required."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of items requested."""
    matched: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total number of items matching the query."""

    @overload
    def __init__(
        self,
        *,
        returned: int,
        limit: Optional[int] = None,
        matched: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacExtensionExtent(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#extent-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#extent-object>`_

    Represents the spatial and temporal extent of a STAC collection.

    :ivar spatial: Spatial extent defined by bounding boxes.

     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_.
     Required.
    :vartype spatial: ~azure.planetarycomputer.models.StacExtensionSpatialExtent
    :ivar temporal: Temporal extent defined by time intervals.

     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_.
     Required.
    :vartype temporal: ~azure.planetarycomputer.models.StacCollectionTemporalExtent
    """

    spatial: "_models.StacExtensionSpatialExtent" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Spatial extent defined by bounding boxes.
     
     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_.
     Required."""
    temporal: "_models.StacCollectionTemporalExtent" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Temporal extent defined by time intervals.
     
     See the `STAC Collection Spec
     <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_.
     Required."""

    @overload
    def __init__(
        self,
        *,
        spatial: "_models.StacExtensionSpatialExtent",
        temporal: "_models.StacCollectionTemporalExtent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacExtensionSpatialExtent(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#spatial-extent-object>`_

    Represents the spatial extent of a STAC collection with bounding boxes.

    :ivar bounding_box: Array of bounding boxes defining the spatial extent, in format [[west,
     south, east, north]].
    :vartype bounding_box: list[list[float]]
    """

    bounding_box: Optional[list[list[float]]] = rest_field(
        name="bbox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of bounding boxes defining the spatial extent, in format [[west, south, east, north]]."""

    @overload
    def __init__(
        self,
        *,
        bounding_box: Optional[list[list[float]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemOrStacItemCollection(_Model):
    """Base type for STAC items and collections with discriminator.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    StacItem, StacItemCollection

    :ivar type: Discriminator property for StacItemOrStacItemCollection. Required. Known values
     are: "Feature" and "FeatureCollection".
    :vartype type: str or ~azure.planetarycomputer.models.StacModelType
    :ivar stac_version: Stac Version.
    :vartype stac_version: str
    :ivar links: Links to related resources and endpoints.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar created_on: MSFT Created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: MSFT Updated.
    :vartype updated_on: ~datetime.datetime
    :ivar short_description: MSFT Short Description.
    :vartype short_description: str
    :ivar stac_extensions: URLs to STAC extensions implemented by this STAC resource.
    :vartype stac_extensions: list[str]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type")
    """Discriminator property for StacItemOrStacItemCollection. Required. Known values are:
     \"Feature\" and \"FeatureCollection\"."""
    stac_version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Stac Version."""
    links: Optional[list["_models.StacLink"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Links to related resources and endpoints."""
    created_on: Optional[datetime.datetime] = rest_field(
        name="msft:_created", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Created."""
    updated_on: Optional[datetime.datetime] = rest_field(
        name="msft:_updated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Updated."""
    short_description: Optional[str] = rest_field(
        name="msft:short_description", visibility=["read", "create", "update", "delete", "query"]
    )
    """MSFT Short Description."""
    stac_extensions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URLs to STAC extensions implemented by this STAC resource."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        stac_version: Optional[str] = None,
        links: Optional[list["_models.StacLink"]] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        short_description: Optional[str] = None,
        stac_extensions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItem(StacItemOrStacItemCollection, discriminator="Feature"):
    """Represents a STAC Item, which is a GeoJSON Feature with additional metadata.

    :ivar stac_version: Stac Version.
    :vartype stac_version: str
    :ivar links: Links to related resources and endpoints.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar created_on: MSFT Created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: MSFT Updated.
    :vartype updated_on: ~datetime.datetime
    :ivar short_description: MSFT Short Description.
    :vartype short_description: str
    :ivar stac_extensions: URLs to STAC extensions implemented by this STAC resource.
    :vartype stac_extensions: list[str]
    :ivar geometry: Geometry object defining the feature's shape. Required.
    :vartype geometry: ~azure.planetarycomputer.models.Geometry
    :ivar id: Unique identifier for the feature. Required.
    :vartype id: str
    :ivar type: GeoJSON type identifier for Feature. Required. GeoJSON Feature type.
    :vartype type: str or ~azure.planetarycomputer.models.FEATURE
    :ivar collection: ID of the STAC collection this item belongs to.
    :vartype collection: str
    :ivar bounding_box: Bounding box coordinates for the feature. Required.
    :vartype bounding_box: list[float]
    :ivar properties: Attributes associated with the feature. Required.
    :vartype properties: ~azure.planetarycomputer.models.StacItemProperties
    :ivar assets: Assets. Required.
    :vartype assets: dict[str, ~azure.planetarycomputer.models.StacAsset]
    :ivar timestamp: MSFT Timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar e_tag: MSFT ETag.
    :vartype e_tag: str
    """

    geometry: "_models.Geometry" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geometry object defining the feature's shape. Required."""
    id: str = rest_field(visibility=["read", "create", "update"])
    """Unique identifier for the feature. Required."""
    type: Literal[StacModelType.FEATURE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """GeoJSON type identifier for Feature. Required. GeoJSON Feature type."""
    collection: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ID of the STAC collection this item belongs to."""
    bounding_box: list[float] = rest_field(name="bbox", visibility=["read", "create", "update", "delete", "query"])
    """Bounding box coordinates for the feature. Required."""
    properties: "_models.StacItemProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Attributes associated with the feature. Required."""
    assets: dict[str, "_models.StacAsset"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Assets. Required."""
    timestamp: Optional[datetime.datetime] = rest_field(
        name="_msft:ts", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Timestamp."""
    e_tag: Optional[str] = rest_field(name="_msft:etag", visibility=["read", "create", "update", "delete", "query"])
    """MSFT ETag."""

    @overload
    def __init__(
        self,
        *,
        geometry: "_models.Geometry",
        id: str,  # pylint: disable=redefined-builtin
        bounding_box: list[float],
        properties: "_models.StacItemProperties",
        assets: dict[str, "_models.StacAsset"],
        stac_version: Optional[str] = None,
        links: Optional[list["_models.StacLink"]] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        short_description: Optional[str] = None,
        stac_extensions: Optional[list[str]] = None,
        collection: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StacModelType.FEATURE  # type: ignore


class StacItemAsset(_Model):
    """`https://github.com/stac-extensions/item-assets
    <https://github.com/stac-extensions/item-assets>`_

    Represents a STAC item asset, which describes the assets available under any item in the
    collection.

    :ivar platform: Platform that acquired the data.
    :vartype platform: str
    :ivar instruments: Instruments that acquired the data.
    :vartype instruments: list[str]
    :ivar constellation: Constellation of satellites that acquired the data.
    :vartype constellation: str
    :ivar mission: Mission associated with the data.
    :vartype mission: str
    :ivar providers: Organizations or individuals who provide the data.
    :vartype providers: list[~azure.planetarycomputer.models.StacProvider]
    :ivar gsd: Ground sample distance in meters.
    :vartype gsd: float
    :ivar created: Creation timestamp of the data.
    :vartype created: ~datetime.datetime
    :ivar updated: Last update timestamp of the data.
    :vartype updated: ~datetime.datetime
    :ivar title: Human-readable title for the asset. Required.
    :vartype title: str
    :ivar description: Detailed description of the asset.
    :vartype description: str
    :ivar href: URL to the asset file.
    :vartype href: str
    :ivar type: Media type of the asset. Required.
    :vartype type: str
    :ivar roles: Roles of the asset within the item.
    :vartype roles: list[str]
    """

    platform: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Platform that acquired the data."""
    instruments: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Instruments that acquired the data."""
    constellation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Constellation of satellites that acquired the data."""
    mission: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Mission associated with the data."""
    providers: Optional[list["_models.StacProvider"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Organizations or individuals who provide the data."""
    gsd: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Ground sample distance in meters."""
    created: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation timestamp of the data."""
    updated: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Last update timestamp of the data."""
    title: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title for the asset. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the asset."""
    href: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to the asset file."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Media type of the asset. Required."""
    roles: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Roles of the asset within the item."""

    @overload
    def __init__(
        self,
        *,
        title: str,
        type: str,
        platform: Optional[str] = None,
        instruments: Optional[list[str]] = None,
        constellation: Optional[str] = None,
        mission: Optional[str] = None,
        providers: Optional[list["_models.StacProvider"]] = None,
        gsd: Optional[float] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        href: Optional[str] = None,
        roles: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemBounds(_Model):
    """Geographic extent of a dataset expressed as a bounding box.

    :ivar bounds: Array of coordinates defining the bounding box [west, south, east, north].
     Required.
    :vartype bounds: list[float]
    """

    bounds: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of coordinates defining the bounding box [west, south, east, north]. Required."""

    @overload
    def __init__(
        self,
        *,
        bounds: list[float],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemCollection(StacItemOrStacItemCollection, discriminator="FeatureCollection"):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/itemcollection-spec.md
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/itemcollection-spec.md>`_

    Represents a collection of STAC Items as a GeoJSON FeatureCollection.

    :ivar stac_version: Stac Version.
    :vartype stac_version: str
    :ivar links: Links to related resources and endpoints.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar created_on: MSFT Created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: MSFT Updated.
    :vartype updated_on: ~datetime.datetime
    :ivar short_description: MSFT Short Description.
    :vartype short_description: str
    :ivar stac_extensions: URLs to STAC extensions implemented by this STAC resource.
    :vartype stac_extensions: list[str]
    :ivar type: GeoJSON FeatureCollection type. Required. GeoJSON FeatureCollection type.
    :vartype type: str or ~azure.planetarycomputer.models.FEATURE_COLLECTION
    :ivar features: Array of STAC Items in the collection. Required.
    :vartype features: list[~azure.planetarycomputer.models.StacItem]
    :ivar bounding_box: Bounding box of all items in format [west, south, east, north].
    :vartype bounding_box: list[float]
    :ivar context: Context information for the search response.
    :vartype context: ~azure.planetarycomputer.models.StacContextExtension
    """

    type: Literal[StacModelType.FEATURE_COLLECTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """GeoJSON FeatureCollection type. Required. GeoJSON FeatureCollection type."""
    features: list["_models.StacItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of STAC Items in the collection. Required."""
    bounding_box: Optional[list[float]] = rest_field(
        name="bbox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Bounding box of all items in format [west, south, east, north]."""
    context: Optional["_models.StacContextExtension"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Context information for the search response."""

    @overload
    def __init__(
        self,
        *,
        features: list["_models.StacItem"],
        stac_version: Optional[str] = None,
        links: Optional[list["_models.StacLink"]] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        short_description: Optional[str] = None,
        stac_extensions: Optional[list[str]] = None,
        bounding_box: Optional[list[float]] = None,
        context: Optional["_models.StacContextExtension"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StacModelType.FEATURE_COLLECTION  # type: ignore


class StacItemPointAsset(_Model):
    """Asset information for the specified point.

    :ivar id: STAC item ID. Required.
    :vartype id: str
    :ivar bounding_box: Bounding box coordinates for the feature. Required.
    :vartype bounding_box: list[float]
    :ivar assets: Asset information for the specified point. Required.
    :vartype assets: dict[str, ~azure.planetarycomputer.models.StacAsset]
    :ivar collection_id: Collection ID. Required.
    :vartype collection_id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """STAC item ID. Required."""
    bounding_box: list[float] = rest_field(name="bbox", visibility=["read", "create", "update", "delete", "query"])
    """Bounding box coordinates for the feature. Required."""
    assets: dict[str, "_models.StacAsset"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Asset information for the specified point. Required."""
    collection_id: str = rest_field(name="collection", visibility=["read", "create", "update", "delete", "query"])
    """Collection ID. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        bounding_box: list[float],
        assets: dict[str, "_models.StacAsset"],
        collection_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemProperties(_Model):
    """Properties of a STAC Item containing metadata about the asset.

    `https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/item-spec.md#properties-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/item-spec/item-spec.md#properties-object>`_.

    :ivar platform: Platform that acquired the data.
    :vartype platform: str
    :ivar instruments: Instruments that acquired the data.
    :vartype instruments: list[str]
    :ivar constellation: Constellation of satellites that acquired the data.
    :vartype constellation: str
    :ivar mission: Mission associated with the data.
    :vartype mission: str
    :ivar providers: Organizations or individuals who provide the data.
    :vartype providers: list[~azure.planetarycomputer.models.StacProvider]
    :ivar gsd: Ground sample distance in meters.
    :vartype gsd: float
    :ivar created: Creation timestamp of the data.
    :vartype created: ~datetime.datetime
    :ivar updated: Last update timestamp of the data.
    :vartype updated: ~datetime.datetime
    :ivar title: Human-readable title for the item.
    :vartype title: str
    :ivar description: Detailed description of the item.
    :vartype description: str
    :ivar date_time: Datetime the asset represents in RFC 3339 format. Required.
    :vartype date_time: str
    :ivar start_datetime: Start time of the item observation period.
    :vartype start_datetime: ~datetime.datetime
    :ivar end_datetime: End time of the item observation period.
    :vartype end_datetime: ~datetime.datetime
    """

    platform: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Platform that acquired the data."""
    instruments: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Instruments that acquired the data."""
    constellation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Constellation of satellites that acquired the data."""
    mission: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Mission associated with the data."""
    providers: Optional[list["_models.StacProvider"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Organizations or individuals who provide the data."""
    gsd: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Ground sample distance in meters."""
    created: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation timestamp of the data."""
    updated: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Last update timestamp of the data."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title for the item."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the item."""
    date_time: str = rest_field(name="datetime", visibility=["read", "create", "update", "delete", "query"])
    """Datetime the asset represents in RFC 3339 format. Required."""
    start_datetime: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the item observation period."""
    end_datetime: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the item observation period."""

    @overload
    def __init__(
        self,
        *,
        date_time: str,
        platform: Optional[str] = None,
        instruments: Optional[list[str]] = None,
        constellation: Optional[str] = None,
        mission: Optional[str] = None,
        providers: Optional[list["_models.StacProvider"]] = None,
        gsd: Optional[float] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        start_datetime: Optional[datetime.datetime] = None,
        end_datetime: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemStatisticsGeoJson(_Model):
    """STAC Item representing a spatiotemporal asset with statistical information.

    :ivar geometry: Geometry object defining the feature's shape. Required.
    :vartype geometry: ~azure.planetarycomputer.models.Geometry
    :ivar type: GeoJSON type identifier for Feature. Required. "Feature"
    :vartype type: str or ~azure.planetarycomputer.models.FeatureType
    :ivar properties: Feature properties.
    :vartype properties: ~azure.planetarycomputer.models.StacItemStatisticsGeoJsonProperties
    """

    geometry: "_models.Geometry" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geometry object defining the feature's shape. Required."""
    type: Union[str, "_models.FeatureType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """GeoJSON type identifier for Feature. Required. \"Feature\""""
    properties: Optional["_models.StacItemStatisticsGeoJsonProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Feature properties."""

    @overload
    def __init__(
        self,
        *,
        geometry: "_models.Geometry",
        type: Union[str, "_models.FeatureType"],
        properties: Optional["_models.StacItemStatisticsGeoJsonProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacItemStatisticsGeoJsonProperties(_Model):
    """Properties for STAC Item statistics GeoJSON Feature.

    :ivar statistics: Statistical information for each band in the asset. Required.
    :vartype statistics: dict[str, ~azure.planetarycomputer.models.BandStatistics]
    """

    statistics: dict[str, "_models.BandStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistical information for each band in the asset. Required."""

    @overload
    def __init__(
        self,
        *,
        statistics: dict[str, "_models.BandStatistics"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacLandingPage(_Model):
    """`https://github.com/radiantearth/stac-api-spec/blob/master/api-spec.md#ogc-api---features-endpoints
    <https://github.com/radiantearth/stac-api-spec/blob/master/api-spec.md#ogc-api---features-endpoints>`_

    Represents the STAC API landing page with links to available resources.

    :ivar created_on: MSFT Created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: MSFT Updated.
    :vartype updated_on: ~datetime.datetime
    :ivar short_description: MSFT Short Description.
    :vartype short_description: str
    :ivar stac_extensions: URLs to STAC extensions implemented by this STAC resource.
    :vartype stac_extensions: list[str]
    :ivar id: Unique identifier for the STAC catalog. Required.
    :vartype id: str
    :ivar description: Detailed description of the STAC catalog. Required.
    :vartype description: str
    :ivar title: Human-readable title for the STAC catalog.
    :vartype title: str
    :ivar stac_version: Stac Version.
    :vartype stac_version: str
    :ivar conforms_to: List of OGC API conformance classes implemented by this API. Required.
    :vartype conforms_to: list[str]
    :ivar links: Links to related resources and endpoints. Required.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    :ivar type: Type.
    :vartype type: str
    """

    created_on: Optional[datetime.datetime] = rest_field(
        name="msft:_created", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Created."""
    updated_on: Optional[datetime.datetime] = rest_field(
        name="msft:_updated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """MSFT Updated."""
    short_description: Optional[str] = rest_field(
        name="msft:short_description", visibility=["read", "create", "update", "delete", "query"]
    )
    """MSFT Short Description."""
    stac_extensions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URLs to STAC extensions implemented by this STAC resource."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the STAC catalog. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the STAC catalog. Required."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title for the STAC catalog."""
    stac_version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Stac Version."""
    conforms_to: list[str] = rest_field(name="conformsTo", visibility=["read", "create", "update", "delete", "query"])
    """List of OGC API conformance classes implemented by this API. Required."""
    links: list["_models.StacLink"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Links to related resources and endpoints. Required."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        description: str,
        conforms_to: list[str],
        links: list["_models.StacLink"],
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        short_description: Optional[str] = None,
        stac_extensions: Optional[list[str]] = None,
        title: Optional[str] = None,
        stac_version: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacLink(_Model):
    """Link model.

    Ref:
    `http://schemas.opengis.net/ogcapi/features/part1/1.0/openapi/schemas/link.yaml
    <http://schemas.opengis.net/ogcapi/features/part1/1.0/openapi/schemas/link.yaml>`_

    Represents a link.

    :ivar rel: The relationship type of the link.
    :vartype rel: str
    :ivar title: The title of the link.
    :vartype title: str
    :ivar type: The MIME type of the linked resource. Known values are: "image/tiff;
     application=geotiff", "image/jp2", "image/png", "image/jpeg", "image/jpg", "image/webp",
     "application/x-binary", "application/xml", "application/json", "application/geo+json",
     "text/html", "text/plain", and "application/x-protobuf".
    :vartype type: str or ~azure.planetarycomputer.models.StacLinkType
    :ivar href: The URL of the link. Required.
    :vartype href: str
    :ivar hreflang: The language of the linked resource.
    :vartype hreflang: str
    :ivar length: The length of the linked resource.
    :vartype length: int
    :ivar method: Specifies the HTTP method that the resource expects. Default: GET. Is one of the
     following types: Literal["GET"], Literal["POST"], str
    :vartype method: str or str or str
    :ivar headers: Object key-value pairs that map to headers. Example: { "Accept":
     "application/json" }.
    :vartype headers: dict[str, str]
    :ivar body: For POST requests, the resource can specify the HTTP body as a JSON object.
    :vartype body: dict[str, any]
    :ivar merge: Indicates whether the client is expected to merge the body value into the current
     request body before following the link. This is only valid when the server is responding to a
     POST request. Default: false.
    :vartype merge: bool
    """

    rel: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The relationship type of the link."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The title of the link."""
    type: Optional[Union[str, "_models.StacLinkType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The MIME type of the linked resource. Known values are: \"image/tiff; application=geotiff\",
     \"image/jp2\", \"image/png\", \"image/jpeg\", \"image/jpg\", \"image/webp\",
     \"application/x-binary\", \"application/xml\", \"application/json\", \"application/geo+json\",
     \"text/html\", \"text/plain\", and \"application/x-protobuf\"."""
    href: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the link. Required."""
    hreflang: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language of the linked resource."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the linked resource."""
    method: Optional[Union[Literal["GET"], Literal["POST"], str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the HTTP method that the resource expects. Default: GET. Is one of the following
     types: Literal[\"GET\"], Literal[\"POST\"], str"""
    headers: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Object key-value pairs that map to headers. Example: { \"Accept\": \"application/json\" }."""
    body: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """For POST requests, the resource can specify the HTTP body as a JSON object."""
    merge: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates whether the client is expected to merge the body value into the current request body
     before following the link. This is only valid when the server is responding to a POST request.
     Default: false."""

    @overload
    def __init__(
        self,
        *,
        href: str,
        rel: Optional[str] = None,
        title: Optional[str] = None,
        type: Optional[Union[str, "_models.StacLinkType"]] = None,
        hreflang: Optional[str] = None,
        length: Optional[int] = None,
        method: Optional[Union[Literal["GET"], Literal["POST"], str]] = None,
        headers: Optional[dict[str, str]] = None,
        body: Optional[dict[str, Any]] = None,
        merge: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacMosaic(_Model):
    """Defines a named mosaic with filtering criteria.

    :ivar id: Unique identifier for the mosaic. Required.
    :vartype id: str
    :ivar name: Short descriptive name for the mosaic. Required.
    :vartype name: str
    :ivar description: Detailed description of the mosaic.
    :vartype description: str
    :ivar cql: A list of valid CQL2-JSON expressions used to filter the collection to moasic.
     Required.
    :vartype cql: list[dict[str, any]]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the mosaic. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Short descriptive name for the mosaic. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed description of the mosaic."""
    cql: list[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of valid CQL2-JSON expressions used to filter the collection to moasic. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        cql: list[dict[str, Any]],
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacMosaicConfiguration(_Model):
    """Configuration for data mosaic visualization.

    :ivar mosaics: Predefined data mosaics available for this collection. Required.
    :vartype mosaics: list[~azure.planetarycomputer.models.StacMosaic]
    :ivar render_options: Available render options for visualizing the data. Required.
    :vartype render_options: list[~azure.planetarycomputer.models.RenderOption]
    :ivar default_location: Default map location when displaying this collection.
    :vartype default_location: ~azure.planetarycomputer.models.DefaultLocation
    :ivar default_custom_query: A list of CQL-JSON expressions to use as the default for  this
     collection.
    :vartype default_custom_query: dict[str, any]
    """

    mosaics: list["_models.StacMosaic"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Predefined data mosaics available for this collection. Required."""
    render_options: list["_models.RenderOption"] = rest_field(
        name="renderOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available render options for visualizing the data. Required."""
    default_location: Optional["_models.DefaultLocation"] = rest_field(
        name="defaultLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default map location when displaying this collection."""
    default_custom_query: Optional[dict[str, Any]] = rest_field(
        name="defaultCustomQuery", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of CQL-JSON expressions to use as the default for  this collection."""

    @overload
    def __init__(
        self,
        *,
        mosaics: list["_models.StacMosaic"],
        render_options: list["_models.RenderOption"],
        default_location: Optional["_models.DefaultLocation"] = None,
        default_custom_query: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacProvider(_Model):
    """`https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#provider-object
    <https://github.com/radiantearth/stac-spec/blob/v1.0.0/collection-spec/collection-spec.md#provider-object>`_

    Represents information about a data provider for STAC collections and items.

    :ivar name: Name of the provider organization or individual. Required.
    :vartype name: str
    :ivar description: Description of the provider.
    :vartype description: str
    :ivar roles: Roles played by the provider (e.g., producer, processor, host).
    :vartype roles: list[str]
    :ivar url: URL to the provider's website.
    :vartype url: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the provider organization or individual. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the provider."""
    roles: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Roles played by the provider (e.g., producer, processor, host)."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to the provider's website."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        roles: Optional[list[str]] = None,
        url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacQueryable(_Model):
    """Definition of a queryable field for STAC API filtering.

    :ivar name: Name of the queryable field. Required.
    :vartype name: str
    :ivar definition: Metadata for the queryable field. Required.
    :vartype definition: dict[str, any]
    :ivar create_index: Whether to create a database index for this field.
    :vartype create_index: bool
    :ivar data_type: Data type of the queryable field. Known values are: "string", "number",
     "boolean", "timestamp", and "date".
    :vartype data_type: str or ~azure.planetarycomputer.models.StacQueryableDefinitionDataType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the queryable field. Required."""
    definition: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata for the queryable field. Required."""
    create_index: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to create a database index for this field."""
    data_type: Optional[Union[str, "_models.StacQueryableDefinitionDataType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Data type of the queryable field. Known values are: \"string\", \"number\", \"boolean\",
     \"timestamp\", and \"date\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        definition: dict[str, Any],
        create_index: Optional[bool] = None,
        data_type: Optional[Union[str, "_models.StacQueryableDefinitionDataType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacSearchParameters(_Model):
    """Search model. * Defines parameters for a STAC search POST request.

    :ivar collections: List of collection IDs to search within.
    :vartype collections: list[str]
    :ivar ids: List of specific item IDs to return.
    :vartype ids: list[str]
    :ivar bounding_box: Bounding box for spatial filtering in format [west, south, east, north].
    :vartype bounding_box: list[float]
    :ivar intersects: GeoJSON geometry for spatial filtering.
    :vartype intersects: ~azure.planetarycomputer.models.Geometry
    :ivar date_time: Temporal filter in RFC 3339 format, can be a single time or range.
    :vartype date_time: str
    :ivar limit: Maximum number of results to return.
    :vartype limit: int
    :ivar conformance_class: Conf

     Overrides datetime validation from the base request model.
    :vartype conformance_class: dict[str, any]
    :ivar query: STAC Query

     See the `STAC Query Extension <https://github.com/stac-api-extensions/query>`_.
    :vartype query: dict[str, any]
    :ivar sort_by: Sort criteria for the search results.

     See the `STAC Sort Extension <https://github.com/stac-api-extensions/sort>`_.
    :vartype sort_by: list[~azure.planetarycomputer.models.StacSortExtension]
    :ivar fields: Specifies which fields to include or exclude in the STAC search results.

     See the `STAC Fields Extension <https://github.com/stac-api-extensions/fields>`_.
    :vartype fields: list[~azure.planetarycomputer.models.SearchOptionsFields]
    :ivar filter: CQL2 Filter

     See the `STAC Filter Extension <https://github.com/stac-api-extensions/filter>`_.
    :vartype filter: dict[str, any]
    :ivar filter_coordinate_reference_system: Coordinate reference system for the filter.
    :vartype filter_coordinate_reference_system: str
    :ivar filter_lang: Filter language to use for the filter expression. Known values are:
     "cql-json", "cql2-json", and "cql2-text".
    :vartype filter_lang: str or ~azure.planetarycomputer.models.FilterLanguage
    :ivar token: Pagination token for fetching the next set of results.
    :vartype token: str
    """

    collections: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of collection IDs to search within."""
    ids: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of specific item IDs to return."""
    bounding_box: Optional[list[float]] = rest_field(
        name="bbox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Bounding box for spatial filtering in format [west, south, east, north]."""
    intersects: Optional["_models.Geometry"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """GeoJSON geometry for spatial filtering."""
    date_time: Optional[str] = rest_field(name="datetime", visibility=["read", "create", "update", "delete", "query"])
    """Temporal filter in RFC 3339 format, can be a single time or range."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of results to return."""
    conformance_class: Optional[dict[str, Any]] = rest_field(
        name="conf", visibility=["read", "create", "update", "delete", "query"]
    )
    """Conf
     
     Overrides datetime validation from the base request model."""
    query: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """STAC Query
     
     See the `STAC Query Extension <https://github.com/stac-api-extensions/query>`_."""
    sort_by: Optional[list["_models.StacSortExtension"]] = rest_field(
        name="sortby", visibility=["read", "create", "update", "delete", "query"]
    )
    """Sort criteria for the search results.
     
     See the `STAC Sort Extension <https://github.com/stac-api-extensions/sort>`_."""
    fields: Optional[list["_models.SearchOptionsFields"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which fields to include or exclude in the STAC search results.
     
     See the `STAC Fields Extension <https://github.com/stac-api-extensions/fields>`_."""
    filter: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CQL2 Filter
     
     See the `STAC Filter Extension <https://github.com/stac-api-extensions/filter>`_."""
    filter_coordinate_reference_system: Optional[str] = rest_field(
        name="filter-crs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Coordinate reference system for the filter."""
    filter_lang: Optional[Union[str, "_models.FilterLanguage"]] = rest_field(
        name="filter-lang", visibility=["read", "create", "update", "delete", "query"]
    )
    """Filter language to use for the filter expression. Known values are: \"cql-json\",
     \"cql2-json\", and \"cql2-text\"."""
    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Pagination token for fetching the next set of results."""

    @overload
    def __init__(
        self,
        *,
        collections: Optional[list[str]] = None,
        ids: Optional[list[str]] = None,
        bounding_box: Optional[list[float]] = None,
        intersects: Optional["_models.Geometry"] = None,
        date_time: Optional[str] = None,
        limit: Optional[int] = None,
        conformance_class: Optional[dict[str, Any]] = None,
        query: Optional[dict[str, Any]] = None,
        sort_by: Optional[list["_models.StacSortExtension"]] = None,
        fields: Optional[list["_models.SearchOptionsFields"]] = None,
        filter: Optional[dict[str, Any]] = None,  # pylint: disable=redefined-builtin
        filter_coordinate_reference_system: Optional[str] = None,
        filter_lang: Optional[Union[str, "_models.FilterLanguage"]] = None,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StacSortExtension(_Model):
    """`https://github.com/radiantearth/stac-api-spec/tree/master/extensions/sort#sort-api-extension
    <https://github.com/radiantearth/stac-api-spec/tree/master/extensions/sort#sort-api-extension>`_

    Represents a sort specification for STAC API queries.

    :ivar field: The field name to sort by. Required.
    :vartype field: str
    :ivar direction: The sort direction (ascending or descending). Required. Known values are:
     "asc" and "desc".
    :vartype direction: str or ~azure.planetarycomputer.models.StacSearchSortingDirection
    """

    field: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The field name to sort by. Required."""
    direction: Union[str, "_models.StacSearchSortingDirection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sort direction (ascending or descending). Required. Known values are: \"asc\" and \"desc\"."""

    @overload
    def __init__(
        self,
        *,
        field: str,
        direction: Union[str, "_models.StacSearchSortingDirection"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TileJsonMetadata(_Model):
    """TileJSON metadata describing a tile set according to the TileJSON specification

    Based on `https://github.com/mapbox/tilejson-spec/tree/master/2.2.0
    <https://github.com/mapbox/tilejson-spec/tree/master/2.2.0>`_.

    :ivar tile_json: TileJson.
    :vartype tile_json: str
    :ivar name: Human-readable name of the tile set.
    :vartype name: str
    :ivar description: Human-readable description of the tile set.
    :vartype description: str
    :ivar version: Version.
    :vartype version: str
    :ivar attribution: Attribution text for the data sources.
    :vartype attribution: str
    :ivar template: URL template for feature info queries.
    :vartype template: str
    :ivar legend: URL to legend content for the tile set.
    :vartype legend: str
    :ivar scheme: Tile addressing scheme (xyz or tms). Known values are: "xyz" and "tms".
    :vartype scheme: str or ~azure.planetarycomputer.models.TileAddressingScheme
    :ivar tiles: Array of tile URL templates. Required.
    :vartype tiles: list[str]
    :ivar grids: Array of UTFGrid URL templates.
    :vartype grids: list[str]
    :ivar data: Array of data file URL templates.
    :vartype data: list[str]
    :ivar min_zoom: Minimum zoom level available in the tile set.
    :vartype min_zoom: int
    :ivar max_zoom: Maximum zoom level available in the tile set.
    :vartype max_zoom: int
    :ivar bounds: Bounds.
    :vartype bounds: list[float]
    :ivar center: Default center point [longitude, latitude, zoom] for the tile set.
    :vartype center: list[float]
    """

    tile_json: Optional[str] = rest_field(name="tilejson", visibility=["read", "create", "update", "delete", "query"])
    """TileJson."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable name of the tile set."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable description of the tile set."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version."""
    attribution: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Attribution text for the data sources."""
    template: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL template for feature info queries."""
    legend: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to legend content for the tile set."""
    scheme: Optional[Union[str, "_models.TileAddressingScheme"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tile addressing scheme (xyz or tms). Known values are: \"xyz\" and \"tms\"."""
    tiles: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of tile URL templates. Required."""
    grids: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of UTFGrid URL templates."""
    data: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of data file URL templates."""
    min_zoom: Optional[int] = rest_field(name="minzoom", visibility=["read", "create", "update", "delete", "query"])
    """Minimum zoom level available in the tile set."""
    max_zoom: Optional[int] = rest_field(name="maxzoom", visibility=["read", "create", "update", "delete", "query"])
    """Maximum zoom level available in the tile set."""
    bounds: Optional[list[float]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bounds."""
    center: Optional[list[float]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default center point [longitude, latitude, zoom] for the tile set."""

    @overload
    def __init__(
        self,
        *,
        tiles: list[str],
        tile_json: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        attribution: Optional[str] = None,
        template: Optional[str] = None,
        legend: Optional[str] = None,
        scheme: Optional[Union[str, "_models.TileAddressingScheme"]] = None,
        grids: Optional[list[str]] = None,
        data: Optional[list[str]] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        bounds: Optional[list[float]] = None,
        center: Optional[list[float]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TileMatrix(_Model):
    """Tile Matrix Definition

    A tile matrix, usually corresponding to a particular zoom level of a
    TileMatrixSet.

    ref:
    `https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/tileMatrix.json
    <https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/tileMatrix.json>`_

    Definition of a tile matrix at a specific zoom level within a tile matrix set.

    :ivar title: Human-readable title of the tile matrix level.
    :vartype title: str
    :ivar description: Human-readable description of this tile matrix level.
    :vartype description: str
    :ivar keywords: Unordered list of one or more commonly used or formalized word(s) or phrase(s)
     used to describe this dataset.
    :vartype keywords: list[str]
    :ivar id: Unique identifier for this tile matrix level, often the zoom level. Required.
    :vartype id: str
    :ivar scale_denominator: Scale denominator representing the scale of this tile matrix level.
     Required.
    :vartype scale_denominator: float
    :ivar cell_size: Size of a pixel in map units at this tile matrix level. Required.
    :vartype cell_size: float
    :ivar corner_of_origin: The corner of the tile matrix (*topLeft* or *bottomLeft*) used as the
     origin for numbering tile rows and columns. This corner is also a corner of the (0, 0) tile.
     Known values are: "topLeft" and "bottomLeft".
    :vartype corner_of_origin: str or ~azure.planetarycomputer.models.TileMatrixCornerOfOrigin
    :ivar point_of_origin: Precise position in CRS coordinates of the corner of origin (e.g. the
     top-left corner) for this tile matrix. This position is also a corner of the (0, 0) tile. In
     previous version, this was 'topLeftCorner' and 'cornerOfOrigin' did not exist. Required.
    :vartype point_of_origin: list[float]
    :ivar tile_width: Pixel width of each tile at this level. Required.
    :vartype tile_width: int
    :ivar tile_height: Pixel height of each tile at this level. Required.
    :vartype tile_height: int
    :ivar matrix_width: Number of tiles horizontally at this matrix level. Required.
    :vartype matrix_width: int
    :ivar matrix_height: Number of tiles vertically at this matrix level. Required.
    :vartype matrix_height: int
    :ivar variable_matrix_widths: Describes the rows that has variable matrix width

     ref:
     `https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/variableMatrixWidth.json
     <https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/variableMatrixWidth.json>`_.
    :vartype variable_matrix_widths: list[~azure.planetarycomputer.models.VariableMatrixWidth]
    """

    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title of the tile matrix level."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable description of this tile matrix level."""
    keywords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe
     this dataset."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for this tile matrix level, often the zoom level. Required."""
    scale_denominator: float = rest_field(
        name="scaleDenominator", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scale denominator representing the scale of this tile matrix level. Required."""
    cell_size: float = rest_field(name="cellSize", visibility=["read", "create", "update", "delete", "query"])
    """Size of a pixel in map units at this tile matrix level. Required."""
    corner_of_origin: Optional[Union[str, "_models.TileMatrixCornerOfOrigin"]] = rest_field(
        name="cornerOfOrigin", visibility=["read", "create", "update", "delete", "query"]
    )
    """The corner of the tile matrix (*topLeft* or *bottomLeft*) used as the origin for numbering tile
     rows and columns. This corner is also a corner of the (0, 0) tile. Known values are:
     \"topLeft\" and \"bottomLeft\"."""
    point_of_origin: list[float] = rest_field(
        name="pointOfOrigin", visibility=["read", "create", "update", "delete", "query"]
    )
    """Precise position in CRS coordinates of the corner of origin (e.g. the top-left corner) for this
     tile matrix. This position is also a corner of the (0, 0) tile. In previous version, this was
     'topLeftCorner' and 'cornerOfOrigin' did not exist. Required."""
    tile_width: int = rest_field(name="tileWidth", visibility=["read", "create", "update", "delete", "query"])
    """Pixel width of each tile at this level. Required."""
    tile_height: int = rest_field(name="tileHeight", visibility=["read", "create", "update", "delete", "query"])
    """Pixel height of each tile at this level. Required."""
    matrix_width: int = rest_field(name="matrixWidth", visibility=["read", "create", "update", "delete", "query"])
    """Number of tiles horizontally at this matrix level. Required."""
    matrix_height: int = rest_field(name="matrixHeight", visibility=["read", "create", "update", "delete", "query"])
    """Number of tiles vertically at this matrix level. Required."""
    variable_matrix_widths: Optional[list["_models.VariableMatrixWidth"]] = rest_field(
        name="variableMatrixWidths", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the rows that has variable matrix width
     
     ref:
     `https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/variableMatrixWidth.json
     <https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/variableMatrixWidth.json>`_."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        scale_denominator: float,
        cell_size: float,
        point_of_origin: list[float],
        tile_width: int,
        tile_height: int,
        matrix_width: int,
        matrix_height: int,
        title: Optional[str] = None,
        description: Optional[str] = None,
        keywords: Optional[list[str]] = None,
        corner_of_origin: Optional[Union[str, "_models.TileMatrixCornerOfOrigin"]] = None,
        variable_matrix_widths: Optional[list["_models.VariableMatrixWidth"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TileMatrixSet(_Model):
    """`https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/tileMatrixSet.json
    <https://github.com/opengeospatial/2D-Tile-Matrix-Set/blob/master/schemas/tms/2.0/json/tileMatrixSet.json>`_

    A definition of a tile matrix set following the Tile Matrix Set standard.
    For tileset metadata, such a description (in ``tileMatrixSet`` property) is only
    required for offline use,
    as an alternative to a link with a
    ``http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme`` relation type.

    :ivar title: Human-readable title of the tile matrix set.
    :vartype title: str
    :ivar description: Brief narrative description of this tile matrix set, normally available for
     display to a human.
    :vartype description: str
    :ivar keywords: Unordered list of one or more commonly used or formalized word(s) or phrase(s)
     used to describe this tile matrix set.
    :vartype keywords: list[str]
    :ivar id: Unique identifier for the tile matrix set.
    :vartype id: str
    :ivar uri: URI reference to the official definition.
    :vartype uri: str
    :ivar ordered_axes: Names of the coordinate axes in order.
    :vartype ordered_axes: list[str]
    :ivar crs: Coordinate reference system identifier. Required.
    :vartype crs: str
    :ivar well_known_scale_set: URL reference to a standardized scale set.
    :vartype well_known_scale_set: str
    :ivar bounding_box: Geographic extent of the tile matrix set.
    :vartype bounding_box: ~azure.planetarycomputer.models.TileMatrixSetBoundingBox
    :ivar tile_matrices: Array of tile matrices at different zoom levels. Required.
    :vartype tile_matrices: list[~azure.planetarycomputer.models.TileMatrix]
    """

    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable title of the tile matrix set."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Brief narrative description of this tile matrix set, normally available for display to a human."""
    keywords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe
     this tile matrix set."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the tile matrix set."""
    uri: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URI reference to the official definition."""
    ordered_axes: Optional[list[str]] = rest_field(
        name="orderedAxes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Names of the coordinate axes in order."""
    crs: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Coordinate reference system identifier. Required."""
    well_known_scale_set: Optional[str] = rest_field(
        name="wellKnownScaleSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """URL reference to a standardized scale set."""
    bounding_box: Optional["_models.TileMatrixSetBoundingBox"] = rest_field(
        name="boundingBox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Geographic extent of the tile matrix set."""
    tile_matrices: list["_models.TileMatrix"] = rest_field(
        name="tileMatrices", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of tile matrices at different zoom levels. Required."""

    @overload
    def __init__(
        self,
        *,
        crs: str,
        tile_matrices: list["_models.TileMatrix"],
        title: Optional[str] = None,
        description: Optional[str] = None,
        keywords: Optional[list[str]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        uri: Optional[str] = None,
        ordered_axes: Optional[list[str]] = None,
        well_known_scale_set: Optional[str] = None,
        bounding_box: Optional["_models.TileMatrixSetBoundingBox"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TileMatrixSetBoundingBox(_Model):
    """Geographic extent of the tile matrix set expressed in the specified coordinate reference
    system.

    :ivar lower_left: Lower-left corner coordinates [x, y] of bounding box. Required.
    :vartype lower_left: list[str]
    :ivar upper_right: Upper-right corner coordinates [x, y] of bounding box. Required.
    :vartype upper_right: list[str]
    :ivar crs: Coordinate reference system identifier.
    :vartype crs: str
    :ivar ordered_axes: Explicit axis order for the CRS coordinates (e.g., ['x', 'y']).
    :vartype ordered_axes: list[str]
    """

    lower_left: list[str] = rest_field(name="lowerLeft", visibility=["read", "create", "update", "delete", "query"])
    """Lower-left corner coordinates [x, y] of bounding box. Required."""
    upper_right: list[str] = rest_field(name="upperRight", visibility=["read", "create", "update", "delete", "query"])
    """Upper-right corner coordinates [x, y] of bounding box. Required."""
    crs: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Coordinate reference system identifier."""
    ordered_axes: Optional[list[str]] = rest_field(
        name="orderedAxes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Explicit axis order for the CRS coordinates (e.g., ['x', 'y'])."""

    @overload
    def __init__(
        self,
        *,
        lower_left: list[str],
        upper_right: list[str],
        crs: Optional[str] = None,
        ordered_axes: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerAssetGeoJson(_Model):
    """Represents GeoJSON with feature with an asset property.

    :ivar id: Unique identifier for the feature. Required.
    :vartype id: str
    :ivar collection: ID of the STAC collection this item belongs to.
    :vartype collection: str
    :ivar bounding_box: Bounding box coordinates for the feature. Required.
    :vartype bounding_box: list[float]
    :ivar assets: Assets. Required.
    :vartype assets: dict[str, ~azure.planetarycomputer.models.StacAsset]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the feature. Required."""
    collection: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ID of the STAC collection this item belongs to."""
    bounding_box: list[float] = rest_field(name="bbox", visibility=["read", "create", "update", "delete", "query"])
    """Bounding box coordinates for the feature. Required."""
    assets: dict[str, "_models.StacAsset"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Assets. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        bounding_box: list[float],
        assets: dict[str, "_models.StacAsset"],
        collection: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerCoreModelsResponsesPoint(_Model):
    """Response model for point query operations providing values at a specific location.

    :ivar coordinates: Geographic coordinates [longitude, latitude] of the queried point. Required.
    :vartype coordinates: list[float]
    :ivar values_property: Array of pixel values at the queried point for each band. Required.
    :vartype values_property: list[float]
    :ivar band_names: Names of each band in the raster data. Required.
    :vartype band_names: list[str]
    """

    coordinates: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geographic coordinates [longitude, latitude] of the queried point. Required."""
    values_property: list[float] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """Array of pixel values at the queried point for each band. Required."""
    band_names: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Names of each band in the raster data. Required."""

    @overload
    def __init__(
        self,
        *,
        coordinates: list[float],
        values_property: list[float],
        band_names: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerInfo(_Model):
    """TilerInfo.

    :ivar bounds: Bounds. Required.
    :vartype bounds: list[float]
    :ivar band_metadata: Band Metadata.
    :vartype band_metadata: list[list[str or dict[str, str]]]
    :ivar band_descriptions: Band Descriptions.
    :vartype band_descriptions: list[list[str]]
    :ivar dtype: Dtype. Required.
    :vartype dtype: str
    :ivar no_data_type: Nodata Type. Known values are: "Alpha", "Mask", "Internal", "Nodata", and
     "None".
    :vartype no_data_type: str or ~azure.planetarycomputer.models.NoDataType
    :ivar color_interpretation: Color interpretation.
    :vartype color_interpretation: list[str]
    :ivar driver: Driver.
    :vartype driver: str
    :ivar count: Count.
    :vartype count: int
    :ivar width: Width.
    :vartype width: int
    :ivar height: Height.
    :vartype height: int
    :ivar overviews: Overviews.
    :vartype overviews: list[int]
    :ivar scales: Scales.
    :vartype scales: list[int]
    :ivar offsets: Offsets.
    :vartype offsets: list[int]
    :ivar colormap: Colormap.
    :vartype colormap: dict[str, list[str]]
    :ivar min_zoom: Minzoom.
    :vartype min_zoom: int
    :ivar max_zoom: Maxzoom.
    :vartype max_zoom: int
    :ivar coordinate_reference_system: Coordinate Reference System.
    :vartype coordinate_reference_system: str
    """

    bounds: list[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bounds. Required."""
    band_metadata: Optional[list[list["_types.BandMetadataElement"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Band Metadata."""
    band_descriptions: Optional[list[list[str]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Band Descriptions."""
    dtype: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Dtype. Required."""
    no_data_type: Optional[Union[str, "_models.NoDataType"]] = rest_field(
        name="nodata_type", visibility=["read", "create", "update", "delete", "query"]
    )
    """Nodata Type. Known values are: \"Alpha\", \"Mask\", \"Internal\", \"Nodata\", and \"None\"."""
    color_interpretation: Optional[list[str]] = rest_field(
        name="colorinterp", visibility=["read", "create", "update", "delete", "query"]
    )
    """Color interpretation."""
    driver: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Driver."""
    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count."""
    width: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Width."""
    height: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height."""
    overviews: Optional[list[int]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Overviews."""
    scales: Optional[list[int]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Scales."""
    offsets: Optional[list[int]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Offsets."""
    colormap: Optional[dict[str, list[str]]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Colormap."""
    min_zoom: Optional[int] = rest_field(name="minzoom", visibility=["read", "create", "update", "delete", "query"])
    """Minzoom."""
    max_zoom: Optional[int] = rest_field(name="maxzoom", visibility=["read", "create", "update", "delete", "query"])
    """Maxzoom."""
    coordinate_reference_system: Optional[str] = rest_field(
        name="crs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Coordinate Reference System."""

    @overload
    def __init__(
        self,
        *,
        bounds: list[float],
        dtype: str,
        band_metadata: Optional[list[list["_types.BandMetadataElement"]]] = None,
        band_descriptions: Optional[list[list[str]]] = None,
        no_data_type: Optional[Union[str, "_models.NoDataType"]] = None,
        color_interpretation: Optional[list[str]] = None,
        driver: Optional[str] = None,
        count: Optional[int] = None,
        width: Optional[int] = None,
        height: Optional[int] = None,
        overviews: Optional[list[int]] = None,
        scales: Optional[list[int]] = None,
        offsets: Optional[list[int]] = None,
        colormap: Optional[dict[str, list[str]]] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        coordinate_reference_system: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerInfoGeoJsonFeature(_Model):
    """GeoJSON Feature object containing rio-tiler model information.

    :ivar type: GeoJSON type identifier. Required. "Feature"
    :vartype type: str or ~azure.planetarycomputer.models.FeatureType
    :ivar geometry: Geometry object defining the feature's shape. Required.
    :vartype geometry: ~azure.planetarycomputer.models.Geometry
    :ivar properties: Properties. Required.
    :vartype properties: dict[str, ~azure.planetarycomputer.models.TilerInfo]
    :ivar id: Unique identifier for the feature.
    :vartype id: str
    :ivar bounding_box: Bounding box coordinates for the feature.
    :vartype bounding_box: float
    """

    type: Union[str, "_models.FeatureType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """GeoJSON type identifier. Required. \"Feature\""""
    geometry: "_models.Geometry" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geometry object defining the feature's shape. Required."""
    properties: dict[str, "_models.TilerInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties. Required."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the feature."""
    bounding_box: Optional[float] = rest_field(name="bbox", visibility=["read", "create", "update", "delete", "query"])
    """Bounding box coordinates for the feature."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.FeatureType"],
        geometry: "_models.Geometry",
        properties: dict[str, "_models.TilerInfo"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        bounding_box: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerInfoMapResponse(_Model):
    """Return dataset's basic info."""


class TilerMosaicSearchRegistrationResponse(_Model):
    """Response from a successful mosaic registration with search ID and related links.

    :ivar search_id: Unique identifier for the registered search. Required.
    :vartype search_id: str
    :ivar links: Related links for the registered mosaic.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    """

    search_id: str = rest_field(name="searchid", visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the registered search. Required."""
    links: Optional[list["_models.StacLink"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Related links for the registered mosaic."""

    @overload
    def __init__(
        self,
        *,
        search_id: str,
        links: Optional[list["_models.StacLink"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerStacItemStatistics(_Model):
    """Return dataset's statistics."""


class TilerStacSearchDefinition(_Model):
    """Stored search query

    See:
    `https://github.com/stac-utils/pgstac/blob/3499daa2bfa700ae7bb07503795c169bf2ebafc7/sql/004_search.sql#L907-L915
    <https://github.com/stac-utils/pgstac/blob/3499daa2bfa700ae7bb07503795c169bf2ebafc7/sql/004_search.sql#L907-L915>`_.

    :ivar hash: Unique hash identifier for the search query. Required.
    :vartype hash: str
    :ivar search: Search. Required.
    :vartype search: dict[str, any]
    :ivar where: SQL WHERE clause representing the search filters. Required.
    :vartype where: str
    :ivar order_by: SQL ORDER BY clause for sorting results. Required.
    :vartype order_by: str
    :ivar last_used: Timestamp when the search was last accessed. Required.
    :vartype last_used: ~datetime.datetime
    :ivar use_count: Number of times the search has been accessed. Required.
    :vartype use_count: int
    :ivar metadata: Additional metadata associated with the search. Required.
    :vartype metadata: ~azure.planetarycomputer.models.MosaicMetadata
    """

    hash: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique hash identifier for the search query. Required."""
    search: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Search. Required."""
    where: str = rest_field(name="_where", visibility=["read", "create", "update", "delete", "query"])
    """SQL WHERE clause representing the search filters. Required."""
    order_by: str = rest_field(name="orderby", visibility=["read", "create", "update", "delete", "query"])
    """SQL ORDER BY clause for sorting results. Required."""
    last_used: datetime.datetime = rest_field(
        name="lastused", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Timestamp when the search was last accessed. Required."""
    use_count: int = rest_field(name="usecount", visibility=["read", "create", "update", "delete", "query"])
    """Number of times the search has been accessed. Required."""
    metadata: "_models.MosaicMetadata" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional metadata associated with the search. Required."""

    @overload
    def __init__(
        self,
        *,
        hash: str,
        search: dict[str, Any],
        where: str,
        order_by: str,
        last_used: datetime.datetime,
        use_count: int,
        metadata: "_models.MosaicMetadata",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TilerStacSearchRegistration(_Model):
    """Information about a registered STAC search query.

    :ivar search: Details of the saved search query

     See the `PgSTAC Search table definition
     <https://github.com/stac-utils/pgstac/blob/3499daa2bfa700ae7bb07503795c169bf2ebafc7/sql/004_search.sql#L907-L915>`_.
     Required.
    :vartype search: ~azure.planetarycomputer.models.TilerStacSearchDefinition
    :ivar links: Related links for the search query.
    :vartype links: list[~azure.planetarycomputer.models.StacLink]
    """

    search: "_models.TilerStacSearchDefinition" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the saved search query
     
     See the `PgSTAC Search table definition
     <https://github.com/stac-utils/pgstac/blob/3499daa2bfa700ae7bb07503795c169bf2ebafc7/sql/004_search.sql#L907-L915>`_.
     Required."""
    links: Optional[list["_models.StacLink"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Related links for the search query."""

    @overload
    def __init__(
        self,
        *,
        search: "_models.TilerStacSearchDefinition",
        links: Optional[list["_models.StacLink"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TileSettings(_Model):
    """Configuration for map tile visualization.

    :ivar min_zoom: The minimum zoom level that can be requested for this collection. Provides a
     hard limit for the tile servers to ensure they don't get requests for low zoom levels, which
     would cause many files to be fetched and the tile servers to hang. Required.
    :vartype min_zoom: int
    :ivar max_items_per_tile: Maximum number of items to include in a single tile. Required.
    :vartype max_items_per_tile: int
    :ivar default_location: Default map location when displaying this collection.
    :vartype default_location: ~azure.planetarycomputer.models.DefaultLocation
    """

    min_zoom: int = rest_field(name="minZoom", visibility=["read", "create", "update", "delete", "query"])
    """The minimum zoom level that can be requested for this collection. Provides a hard limit for the
     tile servers to ensure they don't get requests for low zoom levels, which would cause many
     files to be fetched and the tile servers to hang. Required."""
    max_items_per_tile: int = rest_field(
        name="maxItemsPerTile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of items to include in a single tile. Required."""
    default_location: Optional["_models.DefaultLocation"] = rest_field(
        name="defaultLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default map location when displaying this collection."""

    @overload
    def __init__(
        self,
        *,
        min_zoom: int,
        max_items_per_tile: int,
        default_location: Optional["_models.DefaultLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserCollectionSettings(_Model):
    """User-specific collection settings for visualization.

    :ivar tile_settings: Settings for map tile visualization. Required.
    :vartype tile_settings: ~azure.planetarycomputer.models.TileSettings
    :ivar mosaic_configuration: Settings for data mosaic visualization. Required.
    :vartype mosaic_configuration: ~azure.planetarycomputer.models.StacMosaicConfiguration
    """

    tile_settings: "_models.TileSettings" = rest_field(
        name="tileSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for map tile visualization. Required."""
    mosaic_configuration: "_models.StacMosaicConfiguration" = rest_field(
        name="mosaicInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for data mosaic visualization. Required."""

    @overload
    def __init__(
        self,
        *,
        tile_settings: "_models.TileSettings",
        mosaic_configuration: "_models.StacMosaicConfiguration",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VariableMatrixWidth(_Model):
    """Model for variableMatrixWidth.

    :ivar coalesce: Number of tiles in width that coalesce in a single tile for these rows.
     Required.
    :vartype coalesce: int
    :ivar min_tile_row: First tile row where the coalescence factor applies for this tilematrix.
     Required.
    :vartype min_tile_row: int
    :ivar max_tile_row: Last tile row where the coalescence factor applies for this tilematrix.
     Required.
    :vartype max_tile_row: int
    """

    coalesce: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of tiles in width that coalesce in a single tile for these rows. Required."""
    min_tile_row: int = rest_field(name="minTileRow", visibility=["read", "create", "update", "delete", "query"])
    """First tile row where the coalescence factor applies for this tilematrix. Required."""
    max_tile_row: int = rest_field(name="maxTileRow", visibility=["read", "create", "update", "delete", "query"])
    """Last tile row where the coalescence factor applies for this tilematrix. Required."""

    @overload
    def __init__(
        self,
        *,
        coalesce: int,
        min_tile_row: int,
        max_tile_row: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
