# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationRecoveryServicesProvidersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_list_by_replication_fabrics(self, resource_group):
        response = self.client.replication_recovery_services_providers.list_by_replication_fabrics(
            fabric_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_get(self, resource_group):
        response = self.client.replication_recovery_services_providers.get(
            fabric_name="str",
            provider_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_begin_create(self, resource_group):
        response = self.client.replication_recovery_services_providers.begin_create(
            fabric_name="str",
            provider_name="str",
            add_provider_input={
                "properties": {
                    "authenticationIdentityInput": {
                        "aadAuthority": "str",
                        "applicationId": "str",
                        "audience": "str",
                        "objectId": "str",
                        "tenantId": "str",
                    },
                    "machineName": "str",
                    "resourceAccessIdentityInput": {
                        "aadAuthority": "str",
                        "applicationId": "str",
                        "audience": "str",
                        "objectId": "str",
                        "tenantId": "str",
                    },
                    "biosId": "str",
                    "dataPlaneAuthenticationIdentityInput": {
                        "aadAuthority": "str",
                        "applicationId": "str",
                        "audience": "str",
                        "objectId": "str",
                        "tenantId": "str",
                    },
                    "machineId": "str",
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_begin_purge(self, resource_group):
        response = self.client.replication_recovery_services_providers.begin_purge(
            fabric_name="str",
            provider_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_begin_refresh_provider(self, resource_group):
        response = self.client.replication_recovery_services_providers.begin_refresh_provider(
            fabric_name="str",
            provider_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_begin_delete(self, resource_group):
        response = self.client.replication_recovery_services_providers.begin_delete(
            fabric_name="str",
            provider_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_recovery_services_providers_list(self, resource_group):
        response = self.client.replication_recovery_services_providers.list(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
