# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
import azure.mgmt.logic as az_logic
from azure.mgmt.resource.changes.aio import ChangesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestChangesChangesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ChangesClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_changes_list_for_workflow(self, resource_group):
        # use sync logic management client from async test
        logic_client = self.create_mgmt_client(az_logic.LogicManagementClient)

        workflow_name = self.get_resource_name("workflow")
        workflow = az_logic.models.Workflow(
            location=AZURE_LOCATION,
            definition={
                "$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
                "contentVersion": "1.0.0.0",
                "parameters": {},
                "triggers": {},
                "actions": {},
                "outputs": {},
            },
        )

        logic_client.workflows.create_or_update(resource_group.name, workflow_name, workflow)

        try:
            response = self.client.changes.list(
                resource_group_name=resource_group.name,
                resource_provider_namespace="Microsoft.Logic",
                resource_type="workflows",
                resource_name=workflow_name,
            )
            _ = [r async for r in response]
        finally:
            logic_client.workflows.delete(resource_group.name, workflow_name)
