# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class KubernetesMaintenanceWindow(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'day_of_the_week': 'str',

        'time': 'str',
    }

    attribute_map = {

        'day_of_the_week': 'dayOfTheWeek',

        'time': 'time',
    }

    def __init__(self, day_of_the_week=None, time=None, local_vars_configuration=None):  # noqa: E501
        """KubernetesMaintenanceWindow - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._day_of_the_week = None
        self._time = None
        self.discriminator = None

        self.day_of_the_week = day_of_the_week
        self.time = time


    @property
    def day_of_the_week(self):
        """Gets the day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501

        The weekday for a maintenance window.  # noqa: E501

        :return: The day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501
        :rtype: str
        """
        return self._day_of_the_week

    @day_of_the_week.setter
    def day_of_the_week(self, day_of_the_week):
        """Sets the day_of_the_week of this KubernetesMaintenanceWindow.

        The weekday for a maintenance window.  # noqa: E501

        :param day_of_the_week: The day_of_the_week of this KubernetesMaintenanceWindow.  # noqa: E501
        :type day_of_the_week: str
        """
        if self.local_vars_configuration.client_side_validation and day_of_the_week is None:  # noqa: E501
            raise ValueError("Invalid value for `day_of_the_week`, must not be `None`")  # noqa: E501
        allowed_values = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and day_of_the_week not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `day_of_the_week` ({0}), must be one of {1}"  # noqa: E501
                .format(day_of_the_week, allowed_values)
            )

        self._day_of_the_week = day_of_the_week

    @property
    def time(self):
        """Gets the time of this KubernetesMaintenanceWindow.  # noqa: E501

        The time to use for a maintenance window. Accepted formats are: HH:mm:ss; HH:mm:ss\"Z\"; HH:mm:ssZ. This time may vary by 15 minutes.  # noqa: E501

        :return: The time of this KubernetesMaintenanceWindow.  # noqa: E501
        :rtype: str
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this KubernetesMaintenanceWindow.

        The time to use for a maintenance window. Accepted formats are: HH:mm:ss; HH:mm:ss\"Z\"; HH:mm:ssZ. This time may vary by 15 minutes.  # noqa: E501

        :param time: The time of this KubernetesMaintenanceWindow.  # noqa: E501
        :type time: str
        """
        if self.local_vars_configuration.client_side_validation and time is None:  # noqa: E501
            raise ValueError("Invalid value for `time`, must not be `None`")  # noqa: E501

        self._time = time
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KubernetesMaintenanceWindow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KubernetesMaintenanceWindow):
            return True

        return self.to_dict() != other.to_dict()
