
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Storage_HeaderData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <FSD_Base64.hxx>
#include <FSD_BinaryFile.hxx>
#include <FSD_BStream.hxx>
#include <FSD_CmpFile.hxx>
#include <FSD_File.hxx>
#include <FSD_FileHeader.hxx>
#include <FSD_FStream.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_FSD(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("FSD"));
py::object klass;

//Python trampoline classes

// classes

    // Class FSD_Base64 from ./opencascade/FSD_Base64.hxx
    klass = m.attr("FSD_Base64");

    // default constructor
    register_default_constructor<FSD_Base64 , shared_ptr<FSD_Base64>>(m,"FSD_Base64");

    // nested enums

    static_cast<py::class_<FSD_Base64 , shared_ptr<FSD_Base64>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Encode_s",
                    (Standard_Size (*)( char * ,   const Standard_Size ,   const Standard_Byte * ,   const Standard_Size  ) ) static_cast<Standard_Size (*)( char * ,   const Standard_Size ,   const Standard_Byte * ,   const Standard_Size  ) >(&FSD_Base64::Encode),
                    R"#(Function encoding a buffer to base64 string.)#"  , py::arg("theEncodedStr"),  py::arg("theStrLen"),  py::arg("theData"),  py::arg("theDataLen")
          )
        .def_static("Encode_s",
                    (TCollection_AsciiString (*)(  const Standard_Byte * ,   const Standard_Size  ) ) static_cast<TCollection_AsciiString (*)(  const Standard_Byte * ,   const Standard_Size  ) >(&FSD_Base64::Encode),
                    R"#(Function encoding a buffer to base64 string.)#"  , py::arg("theData"),  py::arg("theDataLen")
          )
        .def_static("Decode_s",
                    (Standard_Size (*)( Standard_Byte * ,   const Standard_Size ,  Standard_CString ,   const Standard_Size  ) ) static_cast<Standard_Size (*)( Standard_Byte * ,   const Standard_Size ,  Standard_CString ,   const Standard_Size  ) >(&FSD_Base64::Decode),
                    R"#(Function decoding base64 string.)#"  , py::arg("theDecodedData"),  py::arg("theDataLen"),  py::arg("theEncodedStr"),  py::arg("theStrLen")
          )
        .def_static("Decode_s",
                    (handle<NCollection_Buffer> (*)( Standard_CString ,   const Standard_Size  ) ) static_cast<handle<NCollection_Buffer> (*)( Standard_CString ,   const Standard_Size  ) >(&FSD_Base64::Decode),
                    R"#(Function decoding base64 string.)#"  , py::arg("theStr"),  py::arg("theLen")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class FSD_BinaryFile from ./opencascade/FSD_BinaryFile.hxx
    klass = m.attr("FSD_BinaryFile");


    // nested enums

    static_cast<py::class_<FSD_BinaryFile ,opencascade::handle<FSD_BinaryFile>  , Storage_BaseDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Open",
             (Storage_Error (FSD_BinaryFile::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) ) static_cast<Storage_Error (FSD_BinaryFile::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) >(&FSD_BinaryFile::Open),
             R"#()#"  , py::arg("aName"),  py::arg("aMode")
          )
        .def("IsEnd",
             (Standard_Boolean (FSD_BinaryFile::*)() ) static_cast<Standard_Boolean (FSD_BinaryFile::*)() >(&FSD_BinaryFile::IsEnd),
             R"#()#" 
          )
        .def("Tell",
             (Storage_Position (FSD_BinaryFile::*)() ) static_cast<Storage_Position (FSD_BinaryFile::*)() >(&FSD_BinaryFile::Tell),
             R"#(return position in the file. Return -1 upon error.)#" 
          )
        .def("BeginWriteInfoSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteInfoSection),
             R"#()#" 
          )
        .def("WriteInfo",
             (void (FSD_BinaryFile::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString &  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString &  ) >(&FSD_BinaryFile::WriteInfo),
             R"#()#"  , py::arg("nbObj"),  py::arg("dbVersion"),  py::arg("date"),  py::arg("schemaName"),  py::arg("schemaVersion"),  py::arg("appName"),  py::arg("appVersion"),  py::arg("objectType"),  py::arg("userInfo")
          )
        .def("EndWriteInfoSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteInfoSection),
             R"#()#" 
          )
        .def("EndWriteInfoSection",
             (Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) ) static_cast<Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) >(&FSD_BinaryFile::EndWriteInfoSection),
             R"#()#"  , py::arg("theOStream")
          )
        .def("BeginReadInfoSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadInfoSection),
             R"#()#" 
          )
        .def("EndReadInfoSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadInfoSection),
             R"#()#" 
          )
        .def("BeginWriteCommentSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteCommentSection),
             R"#()#" 
          )
        .def("BeginWriteCommentSection",
             (Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) ) static_cast<Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) >(&FSD_BinaryFile::BeginWriteCommentSection),
             R"#()#"  , py::arg("theOStream")
          )
        .def("WriteComment",
             (void (FSD_BinaryFile::*)(  const TColStd_SequenceOfExtendedString &  ) ) static_cast<void (FSD_BinaryFile::*)(  const TColStd_SequenceOfExtendedString &  ) >(&FSD_BinaryFile::WriteComment),
             R"#()#"  , py::arg("userComments")
          )
        .def("EndWriteCommentSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteCommentSection),
             R"#()#" 
          )
        .def("EndWriteCommentSection",
             (Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) ) static_cast<Storage_Error (FSD_BinaryFile::*)( Standard_OStream &  ) >(&FSD_BinaryFile::EndWriteCommentSection),
             R"#()#"  , py::arg("theOStream")
          )
        .def("BeginReadCommentSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadCommentSection),
             R"#()#" 
          )
        .def("ReadComment",
             (void (FSD_BinaryFile::*)( TColStd_SequenceOfExtendedString &  ) ) static_cast<void (FSD_BinaryFile::*)( TColStd_SequenceOfExtendedString &  ) >(&FSD_BinaryFile::ReadComment),
             R"#()#"  , py::arg("userComments")
          )
        .def("EndReadCommentSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadCommentSection),
             R"#()#" 
          )
        .def("BeginWriteTypeSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteTypeSection),
             R"#()#" 
          )
        .def("SetTypeSectionSize",
             (void (FSD_BinaryFile::*)(  const Standard_Integer  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer  ) >(&FSD_BinaryFile::SetTypeSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteTypeInformations",
             (void (FSD_BinaryFile::*)(  const Standard_Integer ,   const TCollection_AsciiString &  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer ,   const TCollection_AsciiString &  ) >(&FSD_BinaryFile::WriteTypeInformations),
             R"#()#"  , py::arg("typeNum"),  py::arg("typeName")
          )
        .def("EndWriteTypeSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteTypeSection),
             R"#()#" 
          )
        .def("BeginReadTypeSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadTypeSection),
             R"#()#" 
          )
        .def("TypeSectionSize",
             (Standard_Integer (FSD_BinaryFile::*)() ) static_cast<Standard_Integer (FSD_BinaryFile::*)() >(&FSD_BinaryFile::TypeSectionSize),
             R"#()#" 
          )
        .def("EndReadTypeSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadTypeSection),
             R"#()#" 
          )
        .def("BeginWriteRootSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteRootSection),
             R"#()#" 
          )
        .def("SetRootSectionSize",
             (void (FSD_BinaryFile::*)(  const Standard_Integer  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer  ) >(&FSD_BinaryFile::SetRootSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteRoot",
             (void (FSD_BinaryFile::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) ) static_cast<void (FSD_BinaryFile::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) >(&FSD_BinaryFile::WriteRoot),
             R"#()#"  , py::arg("rootName"),  py::arg("aRef"),  py::arg("aType")
          )
        .def("EndWriteRootSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteRootSection),
             R"#()#" 
          )
        .def("BeginReadRootSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadRootSection),
             R"#()#" 
          )
        .def("RootSectionSize",
             (Standard_Integer (FSD_BinaryFile::*)() ) static_cast<Standard_Integer (FSD_BinaryFile::*)() >(&FSD_BinaryFile::RootSectionSize),
             R"#()#" 
          )
        .def("EndReadRootSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadRootSection),
             R"#()#" 
          )
        .def("BeginWriteRefSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteRefSection),
             R"#()#" 
          )
        .def("SetRefSectionSize",
             (void (FSD_BinaryFile::*)(  const Standard_Integer  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer  ) >(&FSD_BinaryFile::SetRefSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteReferenceType",
             (void (FSD_BinaryFile::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&FSD_BinaryFile::WriteReferenceType),
             R"#()#"  , py::arg("reference"),  py::arg("typeNum")
          )
        .def("EndWriteRefSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteRefSection),
             R"#()#" 
          )
        .def("BeginReadRefSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadRefSection),
             R"#()#" 
          )
        .def("RefSectionSize",
             (Standard_Integer (FSD_BinaryFile::*)() ) static_cast<Standard_Integer (FSD_BinaryFile::*)() >(&FSD_BinaryFile::RefSectionSize),
             R"#()#" 
          )
        .def("EndReadRefSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadRefSection),
             R"#()#" 
          )
        .def("BeginWriteDataSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteDataSection),
             R"#()#" 
          )
        .def("WritePersistentObjectHeader",
             (void (FSD_BinaryFile::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (FSD_BinaryFile::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&FSD_BinaryFile::WritePersistentObjectHeader),
             R"#()#"  , py::arg("aRef"),  py::arg("aType")
          )
        .def("BeginWritePersistentObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWritePersistentObjectData),
             R"#()#" 
          )
        .def("BeginWriteObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginWriteObjectData),
             R"#()#" 
          )
        .def("EndWriteObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteObjectData),
             R"#()#" 
          )
        .def("EndWritePersistentObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWritePersistentObjectData),
             R"#()#" 
          )
        .def("EndWriteDataSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndWriteDataSection),
             R"#()#" 
          )
        .def("BeginReadDataSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadDataSection),
             R"#()#" 
          )
        .def("BeginReadPersistentObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadPersistentObjectData),
             R"#()#" 
          )
        .def("BeginReadObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::BeginReadObjectData),
             R"#()#" 
          )
        .def("EndReadObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadObjectData),
             R"#()#" 
          )
        .def("EndReadPersistentObjectData",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadPersistentObjectData),
             R"#()#" 
          )
        .def("EndReadDataSection",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::EndReadDataSection),
             R"#()#" 
          )
        .def("SkipObject",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::SkipObject),
             R"#()#" 
          )
        .def("PutReference",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Integer  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Integer  ) >(&FSD_BinaryFile::PutReference),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutCharacter",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Character  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Character  ) >(&FSD_BinaryFile::PutCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutExtCharacter",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_ExtCharacter  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_ExtCharacter  ) >(&FSD_BinaryFile::PutExtCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutInteger",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Integer  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Integer  ) >(&FSD_BinaryFile::PutInteger),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutBoolean",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Boolean  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Boolean  ) >(&FSD_BinaryFile::PutBoolean),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutReal",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Real  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_Real  ) >(&FSD_BinaryFile::PutReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutShortReal",
             (Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_ShortReal  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)(  const Standard_ShortReal  ) >(&FSD_BinaryFile::PutShortReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetReference",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Integer &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Integer &  ) >(&FSD_BinaryFile::GetReference),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetCharacter",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Character &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Character &  ) >(&FSD_BinaryFile::GetCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetExtCharacter",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_ExtCharacter &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_ExtCharacter &  ) >(&FSD_BinaryFile::GetExtCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetInteger",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Integer &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Integer &  ) >(&FSD_BinaryFile::GetInteger),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetBoolean",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Boolean &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Boolean &  ) >(&FSD_BinaryFile::GetBoolean),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetReal",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Real &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_Real &  ) >(&FSD_BinaryFile::GetReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetShortReal",
             (Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_ShortReal &  ) ) static_cast<Storage_BaseDriver & (FSD_BinaryFile::*)( Standard_ShortReal &  ) >(&FSD_BinaryFile::GetShortReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("Close",
             (Storage_Error (FSD_BinaryFile::*)() ) static_cast<Storage_Error (FSD_BinaryFile::*)() >(&FSD_BinaryFile::Close),
             R"#()#" 
          )
        .def("Destroy",
             (void (FSD_BinaryFile::*)() ) static_cast<void (FSD_BinaryFile::*)() >(&FSD_BinaryFile::Destroy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("ReadInfo",
             []( FSD_BinaryFile &self , TCollection_AsciiString & dbVersion,TCollection_AsciiString & date,TCollection_AsciiString & schemaName,TCollection_AsciiString & schemaVersion,TCollection_ExtendedString & appName,TCollection_AsciiString & appVersion,TCollection_ExtendedString & objectType,TColStd_SequenceOfAsciiString & userInfo ){
                 Standard_Integer  nbObj;

                 self.ReadInfo(nbObj,dbVersion,date,schemaName,schemaVersion,appName,appVersion,objectType,userInfo);
                 
                 return std::make_tuple(nbObj); },
             R"#()#"  , py::arg("dbVersion"),  py::arg("date"),  py::arg("schemaName"),  py::arg("schemaVersion"),  py::arg("appName"),  py::arg("appVersion"),  py::arg("objectType"),  py::arg("userInfo")
          )
        .def("ReadCompleteInfo",
             []( FSD_BinaryFile &self , Standard_IStream & theIStream,Storage_Data& theData ){
                 handle<Storage_Data>  theData_ptr; theData_ptr = &theData;

                 self.ReadCompleteInfo(theIStream,theData_ptr);
                 if ( theData_ptr.get() != &theData ) copy_if_copy_constructible(theData, *theData_ptr);

                 return std::make_tuple(); },
             R"#()#"  , py::arg("theIStream"),  py::arg("theData")
          )
        .def("ReadTypeInformations",
             []( FSD_BinaryFile &self , TCollection_AsciiString & typeName ){
                 Standard_Integer  typeNum;

                 self.ReadTypeInformations(typeNum,typeName);
                 
                 return std::make_tuple(typeNum); },
             R"#()#"  , py::arg("typeName")
          )
        .def("ReadRoot",
             []( FSD_BinaryFile &self , TCollection_AsciiString & rootName,TCollection_AsciiString & aType ){
                 Standard_Integer  aRef;

                 self.ReadRoot(rootName,aRef,aType);
                 
                 return std::make_tuple(aRef); },
             R"#()#"  , py::arg("rootName"),  py::arg("aType")
          )
        .def("ReadReferenceType",
             []( FSD_BinaryFile &self   ){
                 Standard_Integer  reference;
                Standard_Integer  typeNum;

                 self.ReadReferenceType(reference,typeNum);
                 
                 return std::make_tuple(reference,typeNum); },
             R"#()#" 
          )
        .def("ReadPersistentObjectHeader",
             []( FSD_BinaryFile &self   ){
                 Standard_Integer  aRef;
                Standard_Integer  aType;

                 self.ReadPersistentObjectHeader(aRef,aType);
                 
                 return std::make_tuple(aRef,aType); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&FSD_BinaryFile::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&FSD_BinaryFile::get_type_descriptor),
                    R"#()#" 
          )
        .def_static("IsGoodFileType_s",
                    (Storage_Error (*)(  const TCollection_AsciiString &  ) ) static_cast<Storage_Error (*)(  const TCollection_AsciiString &  ) >(&FSD_BinaryFile::IsGoodFileType),
                    R"#()#"  , py::arg("aName")
          )
        .def_static("WriteInfo_s",
                    (Standard_Integer (*)( Standard_OStream & ,   const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( Standard_OStream & ,   const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString & ,   const Standard_Boolean  ) >(&FSD_BinaryFile::WriteInfo),
                    R"#()#"  , py::arg("theOStream"),  py::arg("nbObj"),  py::arg("dbVersion"),  py::arg("date"),  py::arg("schemaName"),  py::arg("schemaVersion"),  py::arg("appName"),  py::arg("appVersion"),  py::arg("objectType"),  py::arg("userInfo"),  py::arg("theOnlyCount")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("WriteComment_s",
                    (Standard_Integer (*)( Standard_OStream & ,   const TColStd_SequenceOfExtendedString & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( Standard_OStream & ,   const TColStd_SequenceOfExtendedString & ,   const Standard_Boolean  ) >(&FSD_BinaryFile::WriteComment),
                    R"#()#"  , py::arg("theOStream"),  py::arg("theComments"),  py::arg("theOnlyCount")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("ReadComment_s",
                    (void (*)( Standard_IStream & ,  TColStd_SequenceOfExtendedString &  ) ) static_cast<void (*)( Standard_IStream & ,  TColStd_SequenceOfExtendedString &  ) >(&FSD_BinaryFile::ReadComment),
                    R"#()#"  , py::arg("theIStream"),  py::arg("userComments")
          )
        .def_static("TypeSectionSize_s",
                    (Standard_Integer (*)( Standard_IStream &  ) ) static_cast<Standard_Integer (*)( Standard_IStream &  ) >(&FSD_BinaryFile::TypeSectionSize),
                    R"#()#"  , py::arg("theIStream")
          )
        .def_static("RootSectionSize_s",
                    (Standard_Integer (*)( Standard_IStream &  ) ) static_cast<Standard_Integer (*)( Standard_IStream &  ) >(&FSD_BinaryFile::RootSectionSize),
                    R"#()#"  , py::arg("theIStream")
          )
        .def_static("RefSectionSize_s",
                    (Standard_Integer (*)( Standard_IStream &  ) ) static_cast<Standard_Integer (*)( Standard_IStream &  ) >(&FSD_BinaryFile::RefSectionSize),
                    R"#()#"  , py::arg("theIStream")
          )
        .def_static("PutInteger_s",
                    (Standard_Integer (*)( Standard_OStream & ,   const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( Standard_OStream & ,   const Standard_Integer ,   const Standard_Boolean  ) >(&FSD_BinaryFile::PutInteger),
                    R"#()#"  , py::arg("theOStream"),  py::arg("aValue"),  py::arg("theOnlyCount")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("InverseInt_s",
                    (Standard_Integer (*)(  const Standard_Integer  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer  ) >(&FSD_BinaryFile::InverseInt),
                    R"#(Inverse bytes in integer value)#"  , py::arg("theValue")
          )
        .def_static("InverseExtChar_s",
                    (Standard_ExtCharacter (*)(  const Standard_ExtCharacter  ) ) static_cast<Standard_ExtCharacter (*)(  const Standard_ExtCharacter  ) >(&FSD_BinaryFile::InverseExtChar),
                    R"#(Inverse bytes in extended character value)#"  , py::arg("theValue")
          )
        .def_static("InverseReal_s",
                    (Standard_Real (*)(  const Standard_Real  ) ) static_cast<Standard_Real (*)(  const Standard_Real  ) >(&FSD_BinaryFile::InverseReal),
                    R"#(Inverse bytes in real value)#"  , py::arg("theValue")
          )
        .def_static("InverseShortReal_s",
                    (Standard_ShortReal (*)(  const Standard_ShortReal  ) ) static_cast<Standard_ShortReal (*)(  const Standard_ShortReal  ) >(&FSD_BinaryFile::InverseShortReal),
                    R"#(Inverse bytes in short real value)#"  , py::arg("theValue")
          )
        .def_static("InverseSize_s",
                    (Standard_Size (*)(  const Standard_Size  ) ) static_cast<Standard_Size (*)(  const Standard_Size  ) >(&FSD_BinaryFile::InverseSize),
                    R"#(Inverse bytes in size value)#"  , py::arg("theValue")
          )
        .def_static("InverseUint64_s",
                    (uint64_t (*)(  const uint64_t  ) ) static_cast<uint64_t (*)(  const uint64_t  ) >(&FSD_BinaryFile::InverseUint64),
                    R"#(Inverse bytes in 64bit unsigned int value)#"  , py::arg("theValue")
          )
        .def_static("ReadHeader_s",
                    (void (*)( Standard_IStream & ,  FSD_FileHeader &  ) ) static_cast<void (*)( Standard_IStream & ,  FSD_FileHeader &  ) >(&FSD_BinaryFile::ReadHeader),
                    R"#()#"  , py::arg("theIStream"),  py::arg("theFileHeader")
          )
        .def_static("ReadHeaderData_s",
                    (void (*)( Standard_IStream & ,   const handle<Storage_HeaderData> &  ) ) static_cast<void (*)( Standard_IStream & ,   const handle<Storage_HeaderData> &  ) >(&FSD_BinaryFile::ReadHeaderData),
                    R"#()#"  , py::arg("theIStream"),  py::arg("theHeaderData")
          )
        .def_static("ReadString_s",
                    (void (*)( Standard_IStream & ,  TCollection_AsciiString &  ) ) static_cast<void (*)( Standard_IStream & ,  TCollection_AsciiString &  ) >(&FSD_BinaryFile::ReadString),
                    R"#()#"  , py::arg("theIStream"),  py::arg("buffer")
          )
        .def_static("ReadExtendedString_s",
                    (void (*)( Standard_IStream & ,  TCollection_ExtendedString &  ) ) static_cast<void (*)( Standard_IStream & ,  TCollection_ExtendedString &  ) >(&FSD_BinaryFile::ReadExtendedString),
                    R"#()#"  , py::arg("theIStream"),  py::arg("buffer")
          )
        .def_static("WriteHeader_s",
                    (Standard_Integer (*)( Standard_OStream & ,   const FSD_FileHeader & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( Standard_OStream & ,   const FSD_FileHeader & ,   const Standard_Boolean  ) >(&FSD_BinaryFile::WriteHeader),
                    R"#()#"  , py::arg("theOStream"),  py::arg("theHeader"),  py::arg("theOnlyCount")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("MagicNumber_s",
                    (Standard_CString (*)() ) static_cast<Standard_CString (*)() >(&FSD_BinaryFile::MagicNumber),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
        .def_static("ReadTypeInformations_s",
            [](Standard_IStream & theIStream,TCollection_AsciiString & typeName ){
                Standard_Integer  typeNum;

                FSD_BinaryFile::ReadTypeInformations(theIStream,typeNum,typeName);
                
return std::make_tuple(typeNum); },
            R"#()#"  , py::arg("theIStream"),  py::arg("typeName")
          )
        .def_static("ReadRoot_s",
            [](Standard_IStream & theIStream,TCollection_AsciiString & rootName,TCollection_AsciiString & aType ){
                Standard_Integer  aRef;

                FSD_BinaryFile::ReadRoot(theIStream,rootName,aRef,aType);
                
return std::make_tuple(aRef); },
            R"#()#"  , py::arg("theIStream"),  py::arg("rootName"),  py::arg("aType")
          )
        .def_static("ReadReferenceType_s",
            [](Standard_IStream & theIStream ){
                Standard_Integer  reference;
                Standard_Integer  typeNum;

                FSD_BinaryFile::ReadReferenceType(theIStream,reference,typeNum);
                
return std::make_tuple(reference,typeNum); },
            R"#()#"  , py::arg("theIStream")
          )
        .def_static("GetReference_s",
            [](Standard_IStream & theIStream ){
                Standard_Integer  aValue;

                FSD_BinaryFile::GetReference(theIStream,aValue);
                
return std::make_tuple(aValue); },
            R"#()#"  , py::arg("theIStream")
          )
        .def_static("GetInteger_s",
            [](Standard_IStream & theIStream ){
                Standard_Integer  aValue;

                FSD_BinaryFile::GetInteger(theIStream,aValue);
                
return std::make_tuple(aValue); },
            R"#()#"  , py::arg("theIStream")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (FSD_BinaryFile::*)() const) static_cast< const handle<Standard_Type> & (FSD_BinaryFile::*)() const>(&FSD_BinaryFile::DynamicType),
             R"#()#"
             
         )
;

    // Class FSD_File from ./opencascade/FSD_File.hxx
    klass = m.attr("FSD_File");


    // nested enums

    static_cast<py::class_<FSD_File ,opencascade::handle<FSD_File>  , Storage_BaseDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Open",
             (Storage_Error (FSD_File::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) ) static_cast<Storage_Error (FSD_File::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) >(&FSD_File::Open),
             R"#(Assigns as aName the name of the file to be driven by this driver. aMode precises if the file is opened in read or write mode. The function returns Storage_VSOk if the file is opened correctly, or any other value of the Storage_Error enumeration which specifies the problem encountered.)#"  , py::arg("aName"),  py::arg("aMode")
          )
        .def("IsEnd",
             (Standard_Boolean (FSD_File::*)() ) static_cast<Standard_Boolean (FSD_File::*)() >(&FSD_File::IsEnd),
             R"#()#" 
          )
        .def("Tell",
             (Storage_Position (FSD_File::*)() ) static_cast<Storage_Position (FSD_File::*)() >(&FSD_File::Tell),
             R"#(return position in the file. Return -1 upon error.)#" 
          )
        .def("BeginWriteInfoSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteInfoSection),
             R"#()#" 
          )
        .def("WriteInfo",
             (void (FSD_File::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString &  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TCollection_AsciiString & ,   const TCollection_ExtendedString & ,   const TColStd_SequenceOfAsciiString &  ) >(&FSD_File::WriteInfo),
             R"#()#"  , py::arg("nbObj"),  py::arg("dbVersion"),  py::arg("date"),  py::arg("schemaName"),  py::arg("schemaVersion"),  py::arg("appName"),  py::arg("appVersion"),  py::arg("objectType"),  py::arg("userInfo")
          )
        .def("EndWriteInfoSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteInfoSection),
             R"#()#" 
          )
        .def("BeginReadInfoSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadInfoSection),
             R"#()#" 
          )
        .def("EndReadInfoSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadInfoSection),
             R"#()#" 
          )
        .def("BeginWriteCommentSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteCommentSection),
             R"#()#" 
          )
        .def("WriteComment",
             (void (FSD_File::*)(  const TColStd_SequenceOfExtendedString &  ) ) static_cast<void (FSD_File::*)(  const TColStd_SequenceOfExtendedString &  ) >(&FSD_File::WriteComment),
             R"#()#"  , py::arg("userComments")
          )
        .def("EndWriteCommentSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteCommentSection),
             R"#()#" 
          )
        .def("BeginReadCommentSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadCommentSection),
             R"#()#" 
          )
        .def("ReadComment",
             (void (FSD_File::*)( TColStd_SequenceOfExtendedString &  ) ) static_cast<void (FSD_File::*)( TColStd_SequenceOfExtendedString &  ) >(&FSD_File::ReadComment),
             R"#()#"  , py::arg("userComments")
          )
        .def("EndReadCommentSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadCommentSection),
             R"#()#" 
          )
        .def("BeginWriteTypeSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteTypeSection),
             R"#()#" 
          )
        .def("SetTypeSectionSize",
             (void (FSD_File::*)(  const Standard_Integer  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer  ) >(&FSD_File::SetTypeSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteTypeInformations",
             (void (FSD_File::*)(  const Standard_Integer ,   const TCollection_AsciiString &  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer ,   const TCollection_AsciiString &  ) >(&FSD_File::WriteTypeInformations),
             R"#()#"  , py::arg("typeNum"),  py::arg("typeName")
          )
        .def("EndWriteTypeSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteTypeSection),
             R"#()#" 
          )
        .def("BeginReadTypeSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadTypeSection),
             R"#()#" 
          )
        .def("TypeSectionSize",
             (Standard_Integer (FSD_File::*)() ) static_cast<Standard_Integer (FSD_File::*)() >(&FSD_File::TypeSectionSize),
             R"#()#" 
          )
        .def("EndReadTypeSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadTypeSection),
             R"#()#" 
          )
        .def("BeginWriteRootSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteRootSection),
             R"#()#" 
          )
        .def("SetRootSectionSize",
             (void (FSD_File::*)(  const Standard_Integer  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer  ) >(&FSD_File::SetRootSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteRoot",
             (void (FSD_File::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) ) static_cast<void (FSD_File::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) >(&FSD_File::WriteRoot),
             R"#()#"  , py::arg("rootName"),  py::arg("aRef"),  py::arg("aType")
          )
        .def("EndWriteRootSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteRootSection),
             R"#()#" 
          )
        .def("BeginReadRootSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadRootSection),
             R"#()#" 
          )
        .def("RootSectionSize",
             (Standard_Integer (FSD_File::*)() ) static_cast<Standard_Integer (FSD_File::*)() >(&FSD_File::RootSectionSize),
             R"#()#" 
          )
        .def("EndReadRootSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadRootSection),
             R"#()#" 
          )
        .def("BeginWriteRefSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteRefSection),
             R"#()#" 
          )
        .def("SetRefSectionSize",
             (void (FSD_File::*)(  const Standard_Integer  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer  ) >(&FSD_File::SetRefSectionSize),
             R"#()#"  , py::arg("aSize")
          )
        .def("WriteReferenceType",
             (void (FSD_File::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&FSD_File::WriteReferenceType),
             R"#()#"  , py::arg("reference"),  py::arg("typeNum")
          )
        .def("EndWriteRefSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteRefSection),
             R"#()#" 
          )
        .def("BeginReadRefSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadRefSection),
             R"#()#" 
          )
        .def("RefSectionSize",
             (Standard_Integer (FSD_File::*)() ) static_cast<Standard_Integer (FSD_File::*)() >(&FSD_File::RefSectionSize),
             R"#()#" 
          )
        .def("EndReadRefSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadRefSection),
             R"#()#" 
          )
        .def("BeginWriteDataSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginWriteDataSection),
             R"#()#" 
          )
        .def("WritePersistentObjectHeader",
             (void (FSD_File::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (FSD_File::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&FSD_File::WritePersistentObjectHeader),
             R"#()#"  , py::arg("aRef"),  py::arg("aType")
          )
        .def("BeginWritePersistentObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::BeginWritePersistentObjectData),
             R"#()#" 
          )
        .def("BeginWriteObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::BeginWriteObjectData),
             R"#()#" 
          )
        .def("EndWriteObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::EndWriteObjectData),
             R"#()#" 
          )
        .def("EndWritePersistentObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::EndWritePersistentObjectData),
             R"#()#" 
          )
        .def("EndWriteDataSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndWriteDataSection),
             R"#()#" 
          )
        .def("BeginReadDataSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::BeginReadDataSection),
             R"#()#" 
          )
        .def("BeginReadPersistentObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::BeginReadPersistentObjectData),
             R"#()#" 
          )
        .def("BeginReadObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::BeginReadObjectData),
             R"#()#" 
          )
        .def("EndReadObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::EndReadObjectData),
             R"#()#" 
          )
        .def("EndReadPersistentObjectData",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::EndReadPersistentObjectData),
             R"#()#" 
          )
        .def("EndReadDataSection",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::EndReadDataSection),
             R"#()#" 
          )
        .def("SkipObject",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::SkipObject),
             R"#()#" 
          )
        .def("PutReference",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_Integer  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_Integer  ) >(&FSD_File::PutReference),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutCharacter",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_Character  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_Character  ) >(&FSD_File::PutCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutExtCharacter",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_ExtCharacter  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_ExtCharacter  ) >(&FSD_File::PutExtCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutInteger",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_Integer  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_Integer  ) >(&FSD_File::PutInteger),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutBoolean",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_Boolean  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_Boolean  ) >(&FSD_File::PutBoolean),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutReal",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_Real  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_Real  ) >(&FSD_File::PutReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("PutShortReal",
             (Storage_BaseDriver & (FSD_File::*)(  const Standard_ShortReal  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)(  const Standard_ShortReal  ) >(&FSD_File::PutShortReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetReference",
             (Storage_BaseDriver & (FSD_File::*)( Standard_Integer &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_Integer &  ) >(&FSD_File::GetReference),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetCharacter",
             (Storage_BaseDriver & (FSD_File::*)( Standard_Character &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_Character &  ) >(&FSD_File::GetCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetExtCharacter",
             (Storage_BaseDriver & (FSD_File::*)( Standard_ExtCharacter &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_ExtCharacter &  ) >(&FSD_File::GetExtCharacter),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetInteger",
             (Storage_BaseDriver & (FSD_File::*)( Standard_Integer &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_Integer &  ) >(&FSD_File::GetInteger),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetBoolean",
             (Storage_BaseDriver & (FSD_File::*)( Standard_Boolean &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_Boolean &  ) >(&FSD_File::GetBoolean),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetReal",
             (Storage_BaseDriver & (FSD_File::*)( Standard_Real &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_Real &  ) >(&FSD_File::GetReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("GetShortReal",
             (Storage_BaseDriver & (FSD_File::*)( Standard_ShortReal &  ) ) static_cast<Storage_BaseDriver & (FSD_File::*)( Standard_ShortReal &  ) >(&FSD_File::GetShortReal),
             R"#()#"  , py::arg("aValue")
          )
        .def("Close",
             (Storage_Error (FSD_File::*)() ) static_cast<Storage_Error (FSD_File::*)() >(&FSD_File::Close),
             R"#(Closes the file driven by this driver. This file was opened by the last call to the function Open. The function returns Storage_VSOk if the closure is correctly done, or any other value of the Storage_Error enumeration which specifies the problem encountered.)#" 
          )
        .def("Destroy",
             (void (FSD_File::*)() ) static_cast<void (FSD_File::*)() >(&FSD_File::Destroy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("ReadInfo",
             []( FSD_File &self , TCollection_AsciiString & dbVersion,TCollection_AsciiString & date,TCollection_AsciiString & schemaName,TCollection_AsciiString & schemaVersion,TCollection_ExtendedString & appName,TCollection_AsciiString & appVersion,TCollection_ExtendedString & objectType,TColStd_SequenceOfAsciiString & userInfo ){
                 Standard_Integer  nbObj;

                 self.ReadInfo(nbObj,dbVersion,date,schemaName,schemaVersion,appName,appVersion,objectType,userInfo);
                 
                 return std::make_tuple(nbObj); },
             R"#()#"  , py::arg("dbVersion"),  py::arg("date"),  py::arg("schemaName"),  py::arg("schemaVersion"),  py::arg("appName"),  py::arg("appVersion"),  py::arg("objectType"),  py::arg("userInfo")
          )
        .def("ReadCompleteInfo",
             []( FSD_File &self , Standard_IStream & theIStream,Storage_Data& theData ){
                 handle<Storage_Data>  theData_ptr; theData_ptr = &theData;

                 self.ReadCompleteInfo(theIStream,theData_ptr);
                 if ( theData_ptr.get() != &theData ) copy_if_copy_constructible(theData, *theData_ptr);

                 return std::make_tuple(); },
             R"#()#"  , py::arg("theIStream"),  py::arg("theData")
          )
        .def("ReadTypeInformations",
             []( FSD_File &self , TCollection_AsciiString & typeName ){
                 Standard_Integer  typeNum;

                 self.ReadTypeInformations(typeNum,typeName);
                 
                 return std::make_tuple(typeNum); },
             R"#()#"  , py::arg("typeName")
          )
        .def("ReadRoot",
             []( FSD_File &self , TCollection_AsciiString & rootName,TCollection_AsciiString & aType ){
                 Standard_Integer  aRef;

                 self.ReadRoot(rootName,aRef,aType);
                 
                 return std::make_tuple(aRef); },
             R"#()#"  , py::arg("rootName"),  py::arg("aType")
          )
        .def("ReadReferenceType",
             []( FSD_File &self   ){
                 Standard_Integer  reference;
                Standard_Integer  typeNum;

                 self.ReadReferenceType(reference,typeNum);
                 
                 return std::make_tuple(reference,typeNum); },
             R"#()#" 
          )
        .def("ReadPersistentObjectHeader",
             []( FSD_File &self   ){
                 Standard_Integer  aRef;
                Standard_Integer  aType;

                 self.ReadPersistentObjectHeader(aRef,aType);
                 
                 return std::make_tuple(aRef,aType); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&FSD_File::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&FSD_File::get_type_descriptor),
                    R"#()#" 
          )
        .def_static("IsGoodFileType_s",
                    (Storage_Error (*)(  const TCollection_AsciiString &  ) ) static_cast<Storage_Error (*)(  const TCollection_AsciiString &  ) >(&FSD_File::IsGoodFileType),
                    R"#()#"  , py::arg("aName")
          )
        .def_static("MagicNumber_s",
                    (Standard_CString (*)() ) static_cast<Standard_CString (*)() >(&FSD_File::MagicNumber),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (FSD_File::*)() const) static_cast< const handle<Standard_Type> & (FSD_File::*)() const>(&FSD_File::DynamicType),
             R"#()#"
             
         )
;

    // Class FSD_FileHeader from ./opencascade/FSD_FileHeader.hxx
    klass = m.attr("FSD_FileHeader");

    // default constructor
    register_default_constructor<FSD_FileHeader , shared_ptr<FSD_FileHeader>>(m,"FSD_FileHeader");

    // nested enums

    static_cast<py::class_<FSD_FileHeader , shared_ptr<FSD_FileHeader>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("testindian", &FSD_FileHeader::testindian)
        .def_readwrite("binfo", &FSD_FileHeader::binfo)
        .def_readwrite("einfo", &FSD_FileHeader::einfo)
        .def_readwrite("bcomment", &FSD_FileHeader::bcomment)
        .def_readwrite("ecomment", &FSD_FileHeader::ecomment)
        .def_readwrite("btype", &FSD_FileHeader::btype)
        .def_readwrite("etype", &FSD_FileHeader::etype)
        .def_readwrite("broot", &FSD_FileHeader::broot)
        .def_readwrite("eroot", &FSD_FileHeader::eroot)
        .def_readwrite("bref", &FSD_FileHeader::bref)
        .def_readwrite("eref", &FSD_FileHeader::eref)
        .def_readwrite("bdata", &FSD_FileHeader::bdata)
        .def_readwrite("edata", &FSD_FileHeader::edata)
    // methods returning by ref wrapped as properties
;

    // Class FSD_CmpFile from ./opencascade/FSD_CmpFile.hxx
    klass = m.attr("FSD_CmpFile");


    // nested enums

    static_cast<py::class_<FSD_CmpFile ,opencascade::handle<FSD_CmpFile>  , FSD_File >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Open",
             (Storage_Error (FSD_CmpFile::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) ) static_cast<Storage_Error (FSD_CmpFile::*)(  const TCollection_AsciiString & ,   const Storage_OpenMode  ) >(&FSD_CmpFile::Open),
             R"#()#"  , py::arg("aName"),  py::arg("aMode")
          )
        .def("BeginWriteInfoSection",
             (Storage_Error (FSD_CmpFile::*)() ) static_cast<Storage_Error (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginWriteInfoSection),
             R"#()#" 
          )
        .def("BeginReadInfoSection",
             (Storage_Error (FSD_CmpFile::*)() ) static_cast<Storage_Error (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginReadInfoSection),
             R"#()#" 
          )
        .def("WritePersistentObjectHeader",
             (void (FSD_CmpFile::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (FSD_CmpFile::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&FSD_CmpFile::WritePersistentObjectHeader),
             R"#()#"  , py::arg("aRef"),  py::arg("aType")
          )
        .def("BeginWritePersistentObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginWritePersistentObjectData),
             R"#()#" 
          )
        .def("BeginWriteObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginWriteObjectData),
             R"#()#" 
          )
        .def("EndWriteObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::EndWriteObjectData),
             R"#()#" 
          )
        .def("EndWritePersistentObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::EndWritePersistentObjectData),
             R"#()#" 
          )
        .def("BeginReadPersistentObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginReadPersistentObjectData),
             R"#()#" 
          )
        .def("BeginReadObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::BeginReadObjectData),
             R"#()#" 
          )
        .def("EndReadObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::EndReadObjectData),
             R"#()#" 
          )
        .def("EndReadPersistentObjectData",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::EndReadPersistentObjectData),
             R"#()#" 
          )
        .def("Destroy",
             (void (FSD_CmpFile::*)() ) static_cast<void (FSD_CmpFile::*)() >(&FSD_CmpFile::Destroy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("ReadPersistentObjectHeader",
             []( FSD_CmpFile &self   ){
                 Standard_Integer  aRef;
                Standard_Integer  aType;

                 self.ReadPersistentObjectHeader(aRef,aType);
                 
                 return std::make_tuple(aRef,aType); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&FSD_CmpFile::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&FSD_CmpFile::get_type_descriptor),
                    R"#()#" 
          )
        .def_static("IsGoodFileType_s",
                    (Storage_Error (*)(  const TCollection_AsciiString &  ) ) static_cast<Storage_Error (*)(  const TCollection_AsciiString &  ) >(&FSD_CmpFile::IsGoodFileType),
                    R"#()#"  , py::arg("aName")
          )
        .def_static("MagicNumber_s",
                    (Standard_CString (*)() ) static_cast<Standard_CString (*)() >(&FSD_CmpFile::MagicNumber),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (FSD_CmpFile::*)() const) static_cast< const handle<Standard_Type> & (FSD_CmpFile::*)() const>(&FSD_CmpFile::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/FSD_BStream.hxx
// ./opencascade/FSD_Base64.hxx
// ./opencascade/FSD_BinaryFile.hxx
// ./opencascade/FSD_CmpFile.hxx
// ./opencascade/FSD_FStream.hxx
// ./opencascade/FSD_File.hxx
// ./opencascade/FSD_FileHeader.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
