
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_BasicElt.hxx>
#include <MAT_Node.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_Arc.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_Edge.hxx>
#include <MAT_ListOfBisector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_Bisector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_ListOfBisector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_TListNodeOfListOfBisector.hxx>
#include <MAT_Bisector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_TListNodeOfListOfEdge.hxx>
#include <MAT_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_Bisector.hxx>
#include <MAT_ListOfBisector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_Edge.hxx>
#include <MAT_ListOfEdge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <MAT_BasicElt.hxx>
#include <MAT_Node.hxx>

// module includes
#include <MAT_Arc.hxx>
#include <MAT_BasicElt.hxx>
#include <MAT_Bisector.hxx>
#include <MAT_DataMapIteratorOfDataMapOfIntegerArc.hxx>
#include <MAT_DataMapIteratorOfDataMapOfIntegerBasicElt.hxx>
#include <MAT_DataMapIteratorOfDataMapOfIntegerBisector.hxx>
#include <MAT_DataMapIteratorOfDataMapOfIntegerNode.hxx>
#include <MAT_DataMapOfIntegerArc.hxx>
#include <MAT_DataMapOfIntegerBasicElt.hxx>
#include <MAT_DataMapOfIntegerBisector.hxx>
#include <MAT_DataMapOfIntegerNode.hxx>
#include <MAT_Edge.hxx>
#include <MAT_Graph.hxx>
#include <MAT_ListOfBisector.hxx>
#include <MAT_ListOfEdge.hxx>
#include <MAT_Node.hxx>
#include <MAT_SequenceOfArc.hxx>
#include <MAT_SequenceOfBasicElt.hxx>
#include <MAT_Side.hxx>
#include <MAT_TListNodeOfListOfBisector.hxx>
#include <MAT_TListNodeOfListOfEdge.hxx>
#include <MAT_Zone.hxx>

// template related includes

// ./opencascade/MAT_DataMapOfIntegerArc.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/MAT_DataMapOfIntegerBasicElt.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/MAT_DataMapOfIntegerBisector.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/MAT_DataMapOfIntegerNode.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/MAT_SequenceOfArc.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/MAT_SequenceOfBasicElt.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_MAT(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("MAT"));
py::object klass;

//Python trampoline classes

// classes

    // Class MAT_Arc from ./opencascade/MAT_Arc.hxx
    klass = m.attr("MAT_Arc");


    // nested enums

    static_cast<py::class_<MAT_Arc ,opencascade::handle<MAT_Arc>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer, const Standard_Integer, const handle<MAT_BasicElt> &, const handle<MAT_BasicElt> & >()  , py::arg("ArcIndex"),  py::arg("GeomIndex"),  py::arg("FirstElement"),  py::arg("SecondElement") )
    // custom constructors
    // methods
        .def("Index",
             (Standard_Integer (MAT_Arc::*)() const) static_cast<Standard_Integer (MAT_Arc::*)() const>(&MAT_Arc::Index),
             R"#(Returns the index of <me> in Graph.theArcs.)#" 
          )
        .def("GeomIndex",
             (Standard_Integer (MAT_Arc::*)() const) static_cast<Standard_Integer (MAT_Arc::*)() const>(&MAT_Arc::GeomIndex),
             R"#(Returns the index associated of the geometric representation of <me>.)#" 
          )
        .def("FirstElement",
             (handle<MAT_BasicElt> (MAT_Arc::*)() const) static_cast<handle<MAT_BasicElt> (MAT_Arc::*)() const>(&MAT_Arc::FirstElement),
             R"#(Returns one of the BasicElt equidistant from <me>.)#" 
          )
        .def("SecondElement",
             (handle<MAT_BasicElt> (MAT_Arc::*)() const) static_cast<handle<MAT_BasicElt> (MAT_Arc::*)() const>(&MAT_Arc::SecondElement),
             R"#(Returns the other BasicElt equidistant from <me>.)#" 
          )
        .def("FirstNode",
             (handle<MAT_Node> (MAT_Arc::*)() const) static_cast<handle<MAT_Node> (MAT_Arc::*)() const>(&MAT_Arc::FirstNode),
             R"#(Returns one Node extremity of <me>.)#" 
          )
        .def("SecondNode",
             (handle<MAT_Node> (MAT_Arc::*)() const) static_cast<handle<MAT_Node> (MAT_Arc::*)() const>(&MAT_Arc::SecondNode),
             R"#(Returns the other Node extremity of <me>.)#" 
          )
        .def("TheOtherNode",
             (handle<MAT_Node> (MAT_Arc::*)(  const handle<MAT_Node> &  ) const) static_cast<handle<MAT_Node> (MAT_Arc::*)(  const handle<MAT_Node> &  ) const>(&MAT_Arc::TheOtherNode),
             R"#(An Arc has two Node, if <aNode> equals one Returns the other.)#"  , py::arg("aNode")
          )
        .def("HasNeighbour",
             (Standard_Boolean (MAT_Arc::*)(  const handle<MAT_Node> & ,   const MAT_Side  ) const) static_cast<Standard_Boolean (MAT_Arc::*)(  const handle<MAT_Node> & ,   const MAT_Side  ) const>(&MAT_Arc::HasNeighbour),
             R"#(Returns True if there is an arc linked to the Node <aNode> located on the side <aSide> of <me>; if <aNode> is not on <me>)#"  , py::arg("aNode"),  py::arg("aSide")
          )
        .def("Neighbour",
             (handle<MAT_Arc> (MAT_Arc::*)(  const handle<MAT_Node> & ,   const MAT_Side  ) const) static_cast<handle<MAT_Arc> (MAT_Arc::*)(  const handle<MAT_Node> & ,   const MAT_Side  ) const>(&MAT_Arc::Neighbour),
             R"#(Returns the first arc linked to the Node <aNode> located on the side <aSide> of <me>; if HasNeighbour() returns FALSE.)#"  , py::arg("aNode"),  py::arg("aSide")
          )
        .def("SetIndex",
             (void (MAT_Arc::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Arc::*)(  const Standard_Integer  ) >(&MAT_Arc::SetIndex),
             R"#()#"  , py::arg("anInteger")
          )
        .def("SetGeomIndex",
             (void (MAT_Arc::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Arc::*)(  const Standard_Integer  ) >(&MAT_Arc::SetGeomIndex),
             R"#()#"  , py::arg("anInteger")
          )
        .def("SetFirstElement",
             (void (MAT_Arc::*)(  const handle<MAT_BasicElt> &  ) ) static_cast<void (MAT_Arc::*)(  const handle<MAT_BasicElt> &  ) >(&MAT_Arc::SetFirstElement),
             R"#()#"  , py::arg("aBasicElt")
          )
        .def("SetSecondElement",
             (void (MAT_Arc::*)(  const handle<MAT_BasicElt> &  ) ) static_cast<void (MAT_Arc::*)(  const handle<MAT_BasicElt> &  ) >(&MAT_Arc::SetSecondElement),
             R"#()#"  , py::arg("aBasicElt")
          )
        .def("SetFirstNode",
             (void (MAT_Arc::*)(  const handle<MAT_Node> &  ) ) static_cast<void (MAT_Arc::*)(  const handle<MAT_Node> &  ) >(&MAT_Arc::SetFirstNode),
             R"#()#"  , py::arg("aNode")
          )
        .def("SetSecondNode",
             (void (MAT_Arc::*)(  const handle<MAT_Node> &  ) ) static_cast<void (MAT_Arc::*)(  const handle<MAT_Node> &  ) >(&MAT_Arc::SetSecondNode),
             R"#()#"  , py::arg("aNode")
          )
        .def("SetFirstArc",
             (void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Arc> &  ) ) static_cast<void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Arc> &  ) >(&MAT_Arc::SetFirstArc),
             R"#()#"  , py::arg("aSide"),  py::arg("anArc")
          )
        .def("SetSecondArc",
             (void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Arc> &  ) ) static_cast<void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Arc> &  ) >(&MAT_Arc::SetSecondArc),
             R"#()#"  , py::arg("aSide"),  py::arg("anArc")
          )
        .def("SetNeighbour",
             (void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Node> & ,   const handle<MAT_Arc> &  ) ) static_cast<void (MAT_Arc::*)(  const MAT_Side ,   const handle<MAT_Node> & ,   const handle<MAT_Arc> &  ) >(&MAT_Arc::SetNeighbour),
             R"#()#"  , py::arg("aSide"),  py::arg("aNode"),  py::arg("anArc")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Arc::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Arc::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Arc::*)() const) static_cast< const handle<Standard_Type> & (MAT_Arc::*)() const>(&MAT_Arc::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_BasicElt from ./opencascade/MAT_BasicElt.hxx
    klass = m.attr("MAT_BasicElt");


    // nested enums

    static_cast<py::class_<MAT_BasicElt ,opencascade::handle<MAT_BasicElt>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer >()  , py::arg("anInteger") )
    // custom constructors
    // methods
        .def("StartArc",
             (handle<MAT_Arc> (MAT_BasicElt::*)() const) static_cast<handle<MAT_Arc> (MAT_BasicElt::*)() const>(&MAT_BasicElt::StartArc),
             R"#(Return <startArcLeft> or <startArcRight> corresponding to <aSide>.)#" 
          )
        .def("EndArc",
             (handle<MAT_Arc> (MAT_BasicElt::*)() const) static_cast<handle<MAT_Arc> (MAT_BasicElt::*)() const>(&MAT_BasicElt::EndArc),
             R"#(Return <endArcLeft> or <endArcRight> corresponding to <aSide>.)#" 
          )
        .def("Index",
             (Standard_Integer (MAT_BasicElt::*)() const) static_cast<Standard_Integer (MAT_BasicElt::*)() const>(&MAT_BasicElt::Index),
             R"#(Return the <index> of <me> in Graph.TheBasicElts.)#" 
          )
        .def("GeomIndex",
             (Standard_Integer (MAT_BasicElt::*)() const) static_cast<Standard_Integer (MAT_BasicElt::*)() const>(&MAT_BasicElt::GeomIndex),
             R"#(Return the <GeomIndex> of <me>.)#" 
          )
        .def("SetStartArc",
             (void (MAT_BasicElt::*)(  const handle<MAT_Arc> &  ) ) static_cast<void (MAT_BasicElt::*)(  const handle<MAT_Arc> &  ) >(&MAT_BasicElt::SetStartArc),
             R"#()#"  , py::arg("anArc")
          )
        .def("SetEndArc",
             (void (MAT_BasicElt::*)(  const handle<MAT_Arc> &  ) ) static_cast<void (MAT_BasicElt::*)(  const handle<MAT_Arc> &  ) >(&MAT_BasicElt::SetEndArc),
             R"#()#"  , py::arg("anArc")
          )
        .def("SetIndex",
             (void (MAT_BasicElt::*)(  const Standard_Integer  ) ) static_cast<void (MAT_BasicElt::*)(  const Standard_Integer  ) >(&MAT_BasicElt::SetIndex),
             R"#()#"  , py::arg("anInteger")
          )
        .def("SetGeomIndex",
             (void (MAT_BasicElt::*)(  const Standard_Integer  ) ) static_cast<void (MAT_BasicElt::*)(  const Standard_Integer  ) >(&MAT_BasicElt::SetGeomIndex),
             R"#()#"  , py::arg("anInteger")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_BasicElt::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_BasicElt::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_BasicElt::*)() const) static_cast< const handle<Standard_Type> & (MAT_BasicElt::*)() const>(&MAT_BasicElt::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_Bisector from ./opencascade/MAT_Bisector.hxx
    klass = m.attr("MAT_Bisector");


    // nested enums

    static_cast<py::class_<MAT_Bisector ,opencascade::handle<MAT_Bisector>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AddBisector",
             (void (MAT_Bisector::*)(  const handle<MAT_Bisector> &  ) const) static_cast<void (MAT_Bisector::*)(  const handle<MAT_Bisector> &  ) const>(&MAT_Bisector::AddBisector),
             R"#()#"  , py::arg("abisector")
          )
        .def("List",
             (handle<MAT_ListOfBisector> (MAT_Bisector::*)() const) static_cast<handle<MAT_ListOfBisector> (MAT_Bisector::*)() const>(&MAT_Bisector::List),
             R"#()#" 
          )
        .def("FirstBisector",
             (handle<MAT_Bisector> (MAT_Bisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_Bisector::*)() const>(&MAT_Bisector::FirstBisector),
             R"#()#" 
          )
        .def("LastBisector",
             (handle<MAT_Bisector> (MAT_Bisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_Bisector::*)() const>(&MAT_Bisector::LastBisector),
             R"#()#" 
          )
        .def("BisectorNumber",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::BisectorNumber),
             R"#()#"  , py::arg("anumber")
          )
        .def("IndexNumber",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::IndexNumber),
             R"#()#"  , py::arg("anumber")
          )
        .def("FirstEdge",
             (void (MAT_Bisector::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_Bisector::*)(  const handle<MAT_Edge> &  ) >(&MAT_Bisector::FirstEdge),
             R"#()#"  , py::arg("anedge")
          )
        .def("SecondEdge",
             (void (MAT_Bisector::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_Bisector::*)(  const handle<MAT_Edge> &  ) >(&MAT_Bisector::SecondEdge),
             R"#()#"  , py::arg("anedge")
          )
        .def("IssuePoint",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::IssuePoint),
             R"#()#"  , py::arg("apoint")
          )
        .def("EndPoint",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::EndPoint),
             R"#()#"  , py::arg("apoint")
          )
        .def("DistIssuePoint",
             (void (MAT_Bisector::*)(  const Standard_Real  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Real  ) >(&MAT_Bisector::DistIssuePoint),
             R"#()#"  , py::arg("areal")
          )
        .def("FirstVector",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::FirstVector),
             R"#()#"  , py::arg("avector")
          )
        .def("SecondVector",
             (void (MAT_Bisector::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Integer  ) >(&MAT_Bisector::SecondVector),
             R"#()#"  , py::arg("avector")
          )
        .def("Sense",
             (void (MAT_Bisector::*)(  const Standard_Real  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Real  ) >(&MAT_Bisector::Sense),
             R"#()#"  , py::arg("asense")
          )
        .def("FirstParameter",
             (void (MAT_Bisector::*)(  const Standard_Real  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Real  ) >(&MAT_Bisector::FirstParameter),
             R"#()#"  , py::arg("aparameter")
          )
        .def("SecondParameter",
             (void (MAT_Bisector::*)(  const Standard_Real  ) ) static_cast<void (MAT_Bisector::*)(  const Standard_Real  ) >(&MAT_Bisector::SecondParameter),
             R"#()#"  , py::arg("aparameter")
          )
        .def("BisectorNumber",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::BisectorNumber),
             R"#()#" 
          )
        .def("IndexNumber",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::IndexNumber),
             R"#()#" 
          )
        .def("FirstEdge",
             (handle<MAT_Edge> (MAT_Bisector::*)() const) static_cast<handle<MAT_Edge> (MAT_Bisector::*)() const>(&MAT_Bisector::FirstEdge),
             R"#()#" 
          )
        .def("SecondEdge",
             (handle<MAT_Edge> (MAT_Bisector::*)() const) static_cast<handle<MAT_Edge> (MAT_Bisector::*)() const>(&MAT_Bisector::SecondEdge),
             R"#()#" 
          )
        .def("IssuePoint",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::IssuePoint),
             R"#()#" 
          )
        .def("EndPoint",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::EndPoint),
             R"#()#" 
          )
        .def("DistIssuePoint",
             (Standard_Real (MAT_Bisector::*)() const) static_cast<Standard_Real (MAT_Bisector::*)() const>(&MAT_Bisector::DistIssuePoint),
             R"#()#" 
          )
        .def("FirstVector",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::FirstVector),
             R"#()#" 
          )
        .def("SecondVector",
             (Standard_Integer (MAT_Bisector::*)() const) static_cast<Standard_Integer (MAT_Bisector::*)() const>(&MAT_Bisector::SecondVector),
             R"#()#" 
          )
        .def("Sense",
             (Standard_Real (MAT_Bisector::*)() const) static_cast<Standard_Real (MAT_Bisector::*)() const>(&MAT_Bisector::Sense),
             R"#()#" 
          )
        .def("FirstParameter",
             (Standard_Real (MAT_Bisector::*)() const) static_cast<Standard_Real (MAT_Bisector::*)() const>(&MAT_Bisector::FirstParameter),
             R"#()#" 
          )
        .def("SecondParameter",
             (Standard_Real (MAT_Bisector::*)() const) static_cast<Standard_Real (MAT_Bisector::*)() const>(&MAT_Bisector::SecondParameter),
             R"#()#" 
          )
        .def("Dump",
             (void (MAT_Bisector::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<void (MAT_Bisector::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&MAT_Bisector::Dump),
             R"#()#"  , py::arg("ashift"),  py::arg("alevel")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Bisector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Bisector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Bisector::*)() const) static_cast< const handle<Standard_Type> & (MAT_Bisector::*)() const>(&MAT_Bisector::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_Edge from ./opencascade/MAT_Edge.hxx
    klass = m.attr("MAT_Edge");


    // nested enums

    static_cast<py::class_<MAT_Edge ,opencascade::handle<MAT_Edge>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("EdgeNumber",
             (void (MAT_Edge::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Edge::*)(  const Standard_Integer  ) >(&MAT_Edge::EdgeNumber),
             R"#()#"  , py::arg("anumber")
          )
        .def("FirstBisector",
             (void (MAT_Edge::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_Edge::*)(  const handle<MAT_Bisector> &  ) >(&MAT_Edge::FirstBisector),
             R"#()#"  , py::arg("abisector")
          )
        .def("SecondBisector",
             (void (MAT_Edge::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_Edge::*)(  const handle<MAT_Bisector> &  ) >(&MAT_Edge::SecondBisector),
             R"#()#"  , py::arg("abisector")
          )
        .def("Distance",
             (void (MAT_Edge::*)(  const Standard_Real  ) ) static_cast<void (MAT_Edge::*)(  const Standard_Real  ) >(&MAT_Edge::Distance),
             R"#()#"  , py::arg("adistance")
          )
        .def("IntersectionPoint",
             (void (MAT_Edge::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Edge::*)(  const Standard_Integer  ) >(&MAT_Edge::IntersectionPoint),
             R"#()#"  , py::arg("apoint")
          )
        .def("EdgeNumber",
             (Standard_Integer (MAT_Edge::*)() const) static_cast<Standard_Integer (MAT_Edge::*)() const>(&MAT_Edge::EdgeNumber),
             R"#()#" 
          )
        .def("FirstBisector",
             (handle<MAT_Bisector> (MAT_Edge::*)() const) static_cast<handle<MAT_Bisector> (MAT_Edge::*)() const>(&MAT_Edge::FirstBisector),
             R"#()#" 
          )
        .def("SecondBisector",
             (handle<MAT_Bisector> (MAT_Edge::*)() const) static_cast<handle<MAT_Bisector> (MAT_Edge::*)() const>(&MAT_Edge::SecondBisector),
             R"#()#" 
          )
        .def("Distance",
             (Standard_Real (MAT_Edge::*)() const) static_cast<Standard_Real (MAT_Edge::*)() const>(&MAT_Edge::Distance),
             R"#()#" 
          )
        .def("IntersectionPoint",
             (Standard_Integer (MAT_Edge::*)() const) static_cast<Standard_Integer (MAT_Edge::*)() const>(&MAT_Edge::IntersectionPoint),
             R"#()#" 
          )
        .def("Dump",
             (void (MAT_Edge::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<void (MAT_Edge::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&MAT_Edge::Dump),
             R"#()#"  , py::arg("ashift"),  py::arg("alevel")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Edge::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Edge::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Edge::*)() const) static_cast< const handle<Standard_Type> & (MAT_Edge::*)() const>(&MAT_Edge::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_Graph from ./opencascade/MAT_Graph.hxx
    klass = m.attr("MAT_Graph");


    // nested enums

    static_cast<py::class_<MAT_Graph ,opencascade::handle<MAT_Graph>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Perform",
             (void (MAT_Graph::*)(  const Standard_Boolean ,   const handle<MAT_ListOfBisector> & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (MAT_Graph::*)(  const Standard_Boolean ,   const handle<MAT_ListOfBisector> & ,   const Standard_Integer ,   const Standard_Integer  ) >(&MAT_Graph::Perform),
             R"#(Construct <me> from the result of the method <CreateMat> of the class <MAT> from <MAT>.)#"  , py::arg("SemiInfinite"),  py::arg("TheRoots"),  py::arg("NbBasicElts"),  py::arg("NbArcs")
          )
        .def("Arc",
             (handle<MAT_Arc> (MAT_Graph::*)(  const Standard_Integer  ) const) static_cast<handle<MAT_Arc> (MAT_Graph::*)(  const Standard_Integer  ) const>(&MAT_Graph::Arc),
             R"#(Return the Arc of index <Index> in <theArcs>.)#"  , py::arg("Index")
          )
        .def("BasicElt",
             (handle<MAT_BasicElt> (MAT_Graph::*)(  const Standard_Integer  ) const) static_cast<handle<MAT_BasicElt> (MAT_Graph::*)(  const Standard_Integer  ) const>(&MAT_Graph::BasicElt),
             R"#(Return the BasicElt of index <Index> in <theBasicElts>.)#"  , py::arg("Index")
          )
        .def("Node",
             (handle<MAT_Node> (MAT_Graph::*)(  const Standard_Integer  ) const) static_cast<handle<MAT_Node> (MAT_Graph::*)(  const Standard_Integer  ) const>(&MAT_Graph::Node),
             R"#(Return the Node of index <Index> in <theNodes>.)#"  , py::arg("Index")
          )
        .def("NumberOfArcs",
             (Standard_Integer (MAT_Graph::*)() const) static_cast<Standard_Integer (MAT_Graph::*)() const>(&MAT_Graph::NumberOfArcs),
             R"#(Return the number of arcs of <me>.)#" 
          )
        .def("NumberOfNodes",
             (Standard_Integer (MAT_Graph::*)() const) static_cast<Standard_Integer (MAT_Graph::*)() const>(&MAT_Graph::NumberOfNodes),
             R"#(Return the number of nodes of <me>.)#" 
          )
        .def("NumberOfBasicElts",
             (Standard_Integer (MAT_Graph::*)() const) static_cast<Standard_Integer (MAT_Graph::*)() const>(&MAT_Graph::NumberOfBasicElts),
             R"#(Return the number of basic elements of <me>.)#" 
          )
        .def("NumberOfInfiniteNodes",
             (Standard_Integer (MAT_Graph::*)() const) static_cast<Standard_Integer (MAT_Graph::*)() const>(&MAT_Graph::NumberOfInfiniteNodes),
             R"#(Return the number of infinites nodes of <me>.)#" 
          )
        .def("CompactArcs",
             (void (MAT_Graph::*)() ) static_cast<void (MAT_Graph::*)() >(&MAT_Graph::CompactArcs),
             R"#()#" 
          )
        .def("CompactNodes",
             (void (MAT_Graph::*)() ) static_cast<void (MAT_Graph::*)() >(&MAT_Graph::CompactNodes),
             R"#()#" 
          )
        .def("ChangeBasicElts",
             (void (MAT_Graph::*)(  const MAT_DataMapOfIntegerBasicElt &  ) ) static_cast<void (MAT_Graph::*)(  const MAT_DataMapOfIntegerBasicElt &  ) >(&MAT_Graph::ChangeBasicElts),
             R"#()#"  , py::arg("NewMap")
          )
        .def("ChangeBasicElt",
             (handle<MAT_BasicElt> (MAT_Graph::*)(  const Standard_Integer  ) ) static_cast<handle<MAT_BasicElt> (MAT_Graph::*)(  const Standard_Integer  ) >(&MAT_Graph::ChangeBasicElt),
             R"#()#"  , py::arg("Index")
          )
    // methods using call by reference i.s.o. return
        .def("FusionOfBasicElts",
             []( MAT_Graph &self ,  const Standard_Integer IndexElt1, const Standard_Integer IndexElt2 ){
                 Standard_Boolean  MergeArc1;
                Standard_Integer  GeomIndexArc1;
                Standard_Integer  GeomIndexArc2;
                Standard_Boolean  MergeArc2;
                Standard_Integer  GeomIndexArc3;
                Standard_Integer  GeomIndexArc4;

                 self.FusionOfBasicElts(IndexElt1,IndexElt2,MergeArc1,GeomIndexArc1,GeomIndexArc2,MergeArc2,GeomIndexArc3,GeomIndexArc4);
                 
                 return std::make_tuple(MergeArc1,GeomIndexArc1,GeomIndexArc2,MergeArc2,GeomIndexArc3,GeomIndexArc4); },
             R"#(Merge two BasicElts. The End of the BasicElt Elt1 of IndexElt1 becomes The End of the BasicElt Elt2 of IndexElt2. Elt2 is replaced in the arcs by Elt1, Elt2 is eliminated.)#"  , py::arg("IndexElt1"),  py::arg("IndexElt2")
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Graph::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Graph::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Graph::*)() const) static_cast< const handle<Standard_Type> & (MAT_Graph::*)() const>(&MAT_Graph::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_ListOfBisector from ./opencascade/MAT_ListOfBisector.hxx
    klass = m.attr("MAT_ListOfBisector");


    // nested enums

    static_cast<py::class_<MAT_ListOfBisector ,opencascade::handle<MAT_ListOfBisector>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("First",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::First),
             R"#()#" 
          )
        .def("Last",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::Last),
             R"#()#" 
          )
        .def("Init",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_ListOfBisector::Init),
             R"#()#"  , py::arg("aniten")
          )
        .def("Next",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::Next),
             R"#()#" 
          )
        .def("Previous",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::Previous),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (MAT_ListOfBisector::*)() const) static_cast<Standard_Boolean (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::More),
             R"#()#" 
          )
        .def("Current",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::Current),
             R"#()#" 
          )
        .def("Current",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) const) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) const>(&MAT_ListOfBisector::Current),
             R"#()#"  , py::arg("anitem")
          )
        .def("FirstItem",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::FirstItem),
             R"#()#" 
          )
        .def("LastItem",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::LastItem),
             R"#()#" 
          )
        .def("PreviousItem",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::PreviousItem),
             R"#()#" 
          )
        .def("NextItem",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::NextItem),
             R"#()#" 
          )
        .def("Number",
             (Standard_Integer (MAT_ListOfBisector::*)() const) static_cast<Standard_Integer (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::Number),
             R"#()#" 
          )
        .def("Index",
             (Standard_Integer (MAT_ListOfBisector::*)() const) static_cast<Standard_Integer (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::Index),
             R"#()#" 
          )
        .def("Brackets",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)(  const Standard_Integer  ) ) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)(  const Standard_Integer  ) >(&MAT_ListOfBisector::Brackets),
             R"#()#"  , py::arg("anindex")
          )
        .def("Unlink",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::Unlink),
             R"#()#" 
          )
        .def("LinkBefore",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_ListOfBisector::LinkBefore),
             R"#()#"  , py::arg("anitem")
          )
        .def("LinkAfter",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_ListOfBisector::LinkAfter),
             R"#()#"  , py::arg("anitem")
          )
        .def("FrontAdd",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_ListOfBisector::FrontAdd),
             R"#()#"  , py::arg("anitem")
          )
        .def("BackAdd",
             (void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_ListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_ListOfBisector::BackAdd),
             R"#()#"  , py::arg("anitem")
          )
        .def("Permute",
             (void (MAT_ListOfBisector::*)() ) static_cast<void (MAT_ListOfBisector::*)() >(&MAT_ListOfBisector::Permute),
             R"#()#" 
          )
        .def("Loop",
             (void (MAT_ListOfBisector::*)() const) static_cast<void (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::Loop),
             R"#()#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (MAT_ListOfBisector::*)() const) static_cast<Standard_Boolean (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::IsEmpty),
             R"#()#" 
          )
        .def("Dump",
             (void (MAT_ListOfBisector::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (MAT_ListOfBisector::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&MAT_ListOfBisector::Dump),
             R"#()#"  , py::arg("ashift"),  py::arg("alevel")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_ListOfBisector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_ListOfBisector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (handle<MAT_Bisector> (MAT_ListOfBisector::*)(  const Standard_Integer  ) ) static_cast<handle<MAT_Bisector> (MAT_ListOfBisector::*)(  const Standard_Integer  ) >(&MAT_ListOfBisector::operator()),
             py::is_operator(),
             R"#()#"  , py::arg("anindex")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_ListOfBisector::*)() const) static_cast< const handle<Standard_Type> & (MAT_ListOfBisector::*)() const>(&MAT_ListOfBisector::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_ListOfEdge from ./opencascade/MAT_ListOfEdge.hxx
    klass = m.attr("MAT_ListOfEdge");


    // nested enums

    static_cast<py::class_<MAT_ListOfEdge ,opencascade::handle<MAT_ListOfEdge>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("First",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::First),
             R"#()#" 
          )
        .def("Last",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::Last),
             R"#()#" 
          )
        .def("Init",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_ListOfEdge::Init),
             R"#()#"  , py::arg("aniten")
          )
        .def("Next",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::Next),
             R"#()#" 
          )
        .def("Previous",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::Previous),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (MAT_ListOfEdge::*)() const) static_cast<Standard_Boolean (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::More),
             R"#()#" 
          )
        .def("Current",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::Current),
             R"#()#" 
          )
        .def("Current",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) const) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) const>(&MAT_ListOfEdge::Current),
             R"#()#"  , py::arg("anitem")
          )
        .def("FirstItem",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::FirstItem),
             R"#()#" 
          )
        .def("LastItem",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::LastItem),
             R"#()#" 
          )
        .def("PreviousItem",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::PreviousItem),
             R"#()#" 
          )
        .def("NextItem",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::NextItem),
             R"#()#" 
          )
        .def("Number",
             (Standard_Integer (MAT_ListOfEdge::*)() const) static_cast<Standard_Integer (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::Number),
             R"#()#" 
          )
        .def("Index",
             (Standard_Integer (MAT_ListOfEdge::*)() const) static_cast<Standard_Integer (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::Index),
             R"#()#" 
          )
        .def("Brackets",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)(  const Standard_Integer  ) ) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)(  const Standard_Integer  ) >(&MAT_ListOfEdge::Brackets),
             R"#()#"  , py::arg("anindex")
          )
        .def("Unlink",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::Unlink),
             R"#()#" 
          )
        .def("LinkBefore",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_ListOfEdge::LinkBefore),
             R"#()#"  , py::arg("anitem")
          )
        .def("LinkAfter",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_ListOfEdge::LinkAfter),
             R"#()#"  , py::arg("anitem")
          )
        .def("FrontAdd",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_ListOfEdge::FrontAdd),
             R"#()#"  , py::arg("anitem")
          )
        .def("BackAdd",
             (void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_ListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_ListOfEdge::BackAdd),
             R"#()#"  , py::arg("anitem")
          )
        .def("Permute",
             (void (MAT_ListOfEdge::*)() ) static_cast<void (MAT_ListOfEdge::*)() >(&MAT_ListOfEdge::Permute),
             R"#()#" 
          )
        .def("Loop",
             (void (MAT_ListOfEdge::*)() const) static_cast<void (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::Loop),
             R"#()#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (MAT_ListOfEdge::*)() const) static_cast<Standard_Boolean (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::IsEmpty),
             R"#()#" 
          )
        .def("Dump",
             (void (MAT_ListOfEdge::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (MAT_ListOfEdge::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&MAT_ListOfEdge::Dump),
             R"#()#"  , py::arg("ashift"),  py::arg("alevel")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_ListOfEdge::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_ListOfEdge::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (handle<MAT_Edge> (MAT_ListOfEdge::*)(  const Standard_Integer  ) ) static_cast<handle<MAT_Edge> (MAT_ListOfEdge::*)(  const Standard_Integer  ) >(&MAT_ListOfEdge::operator()),
             py::is_operator(),
             R"#()#"  , py::arg("anindex")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_ListOfEdge::*)() const) static_cast< const handle<Standard_Type> & (MAT_ListOfEdge::*)() const>(&MAT_ListOfEdge::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_Node from ./opencascade/MAT_Node.hxx
    klass = m.attr("MAT_Node");


    // nested enums

    static_cast<py::class_<MAT_Node ,opencascade::handle<MAT_Node>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer, const handle<MAT_Arc> &, const Standard_Real >()  , py::arg("GeomIndex"),  py::arg("LinkedArc"),  py::arg("Distance") )
    // custom constructors
    // methods
        .def("GeomIndex",
             (Standard_Integer (MAT_Node::*)() const) static_cast<Standard_Integer (MAT_Node::*)() const>(&MAT_Node::GeomIndex),
             R"#(Returns the index associated of the geometric representation of <me>.)#" 
          )
        .def("Index",
             (Standard_Integer (MAT_Node::*)() const) static_cast<Standard_Integer (MAT_Node::*)() const>(&MAT_Node::Index),
             R"#(Returns the index associated of the node)#" 
          )
        .def("LinkedArcs",
             (void (MAT_Node::*)( MAT_SequenceOfArc &  ) const) static_cast<void (MAT_Node::*)( MAT_SequenceOfArc &  ) const>(&MAT_Node::LinkedArcs),
             R"#(Returns in <S> the Arcs linked to <me>.)#"  , py::arg("S")
          )
        .def("NearElts",
             (void (MAT_Node::*)( MAT_SequenceOfBasicElt &  ) const) static_cast<void (MAT_Node::*)( MAT_SequenceOfBasicElt &  ) const>(&MAT_Node::NearElts),
             R"#(Returns in <S> the BasicElts equidistant to <me>.)#"  , py::arg("S")
          )
        .def("Distance",
             (Standard_Real (MAT_Node::*)() const) static_cast<Standard_Real (MAT_Node::*)() const>(&MAT_Node::Distance),
             R"#()#" 
          )
        .def("PendingNode",
             (Standard_Boolean (MAT_Node::*)() const) static_cast<Standard_Boolean (MAT_Node::*)() const>(&MAT_Node::PendingNode),
             R"#(Returns True if <me> is a pending Node. (ie : the number of Arc Linked = 1))#" 
          )
        .def("OnBasicElt",
             (Standard_Boolean (MAT_Node::*)() const) static_cast<Standard_Boolean (MAT_Node::*)() const>(&MAT_Node::OnBasicElt),
             R"#(Returns True if <me> belongs to the figure.)#" 
          )
        .def("Infinite",
             (Standard_Boolean (MAT_Node::*)() const) static_cast<Standard_Boolean (MAT_Node::*)() const>(&MAT_Node::Infinite),
             R"#(Returns True if the distance of <me> is Infinite)#" 
          )
        .def("SetIndex",
             (void (MAT_Node::*)(  const Standard_Integer  ) ) static_cast<void (MAT_Node::*)(  const Standard_Integer  ) >(&MAT_Node::SetIndex),
             R"#(Set the index associated of the node)#"  , py::arg("anIndex")
          )
        .def("SetLinkedArc",
             (void (MAT_Node::*)(  const handle<MAT_Arc> &  ) ) static_cast<void (MAT_Node::*)(  const handle<MAT_Arc> &  ) >(&MAT_Node::SetLinkedArc),
             R"#()#"  , py::arg("anArc")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Node::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Node::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Node::*)() const) static_cast< const handle<Standard_Type> & (MAT_Node::*)() const>(&MAT_Node::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_TListNodeOfListOfBisector from ./opencascade/MAT_TListNodeOfListOfBisector.hxx
    klass = m.attr("MAT_TListNodeOfListOfBisector");


    // nested enums

    static_cast<py::class_<MAT_TListNodeOfListOfBisector ,opencascade::handle<MAT_TListNodeOfListOfBisector>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<MAT_Bisector> & >()  , py::arg("anitem") )
    // custom constructors
    // methods
        .def("GetItem",
             (handle<MAT_Bisector> (MAT_TListNodeOfListOfBisector::*)() const) static_cast<handle<MAT_Bisector> (MAT_TListNodeOfListOfBisector::*)() const>(&MAT_TListNodeOfListOfBisector::GetItem),
             R"#()#" 
          )
        .def("Next",
             (handle<MAT_TListNodeOfListOfBisector> (MAT_TListNodeOfListOfBisector::*)() const) static_cast<handle<MAT_TListNodeOfListOfBisector> (MAT_TListNodeOfListOfBisector::*)() const>(&MAT_TListNodeOfListOfBisector::Next),
             R"#()#" 
          )
        .def("Previous",
             (handle<MAT_TListNodeOfListOfBisector> (MAT_TListNodeOfListOfBisector::*)() const) static_cast<handle<MAT_TListNodeOfListOfBisector> (MAT_TListNodeOfListOfBisector::*)() const>(&MAT_TListNodeOfListOfBisector::Previous),
             R"#()#" 
          )
        .def("SetItem",
             (void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_Bisector> &  ) ) static_cast<void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_Bisector> &  ) >(&MAT_TListNodeOfListOfBisector::SetItem),
             R"#()#"  , py::arg("anitem")
          )
        .def("Next",
             (void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_TListNodeOfListOfBisector> &  ) ) static_cast<void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_TListNodeOfListOfBisector> &  ) >(&MAT_TListNodeOfListOfBisector::Next),
             R"#()#"  , py::arg("atlistnode")
          )
        .def("Previous",
             (void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_TListNodeOfListOfBisector> &  ) ) static_cast<void (MAT_TListNodeOfListOfBisector::*)(  const handle<MAT_TListNodeOfListOfBisector> &  ) >(&MAT_TListNodeOfListOfBisector::Previous),
             R"#()#"  , py::arg("atlistnode")
          )
        .def("Dummy",
             (void (MAT_TListNodeOfListOfBisector::*)() const) static_cast<void (MAT_TListNodeOfListOfBisector::*)() const>(&MAT_TListNodeOfListOfBisector::Dummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_TListNodeOfListOfBisector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_TListNodeOfListOfBisector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_TListNodeOfListOfBisector::*)() const) static_cast< const handle<Standard_Type> & (MAT_TListNodeOfListOfBisector::*)() const>(&MAT_TListNodeOfListOfBisector::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_TListNodeOfListOfEdge from ./opencascade/MAT_TListNodeOfListOfEdge.hxx
    klass = m.attr("MAT_TListNodeOfListOfEdge");


    // nested enums

    static_cast<py::class_<MAT_TListNodeOfListOfEdge ,opencascade::handle<MAT_TListNodeOfListOfEdge>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<MAT_Edge> & >()  , py::arg("anitem") )
    // custom constructors
    // methods
        .def("GetItem",
             (handle<MAT_Edge> (MAT_TListNodeOfListOfEdge::*)() const) static_cast<handle<MAT_Edge> (MAT_TListNodeOfListOfEdge::*)() const>(&MAT_TListNodeOfListOfEdge::GetItem),
             R"#()#" 
          )
        .def("Next",
             (handle<MAT_TListNodeOfListOfEdge> (MAT_TListNodeOfListOfEdge::*)() const) static_cast<handle<MAT_TListNodeOfListOfEdge> (MAT_TListNodeOfListOfEdge::*)() const>(&MAT_TListNodeOfListOfEdge::Next),
             R"#()#" 
          )
        .def("Previous",
             (handle<MAT_TListNodeOfListOfEdge> (MAT_TListNodeOfListOfEdge::*)() const) static_cast<handle<MAT_TListNodeOfListOfEdge> (MAT_TListNodeOfListOfEdge::*)() const>(&MAT_TListNodeOfListOfEdge::Previous),
             R"#()#" 
          )
        .def("SetItem",
             (void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_Edge> &  ) ) static_cast<void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_Edge> &  ) >(&MAT_TListNodeOfListOfEdge::SetItem),
             R"#()#"  , py::arg("anitem")
          )
        .def("Next",
             (void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_TListNodeOfListOfEdge> &  ) ) static_cast<void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_TListNodeOfListOfEdge> &  ) >(&MAT_TListNodeOfListOfEdge::Next),
             R"#()#"  , py::arg("atlistnode")
          )
        .def("Previous",
             (void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_TListNodeOfListOfEdge> &  ) ) static_cast<void (MAT_TListNodeOfListOfEdge::*)(  const handle<MAT_TListNodeOfListOfEdge> &  ) >(&MAT_TListNodeOfListOfEdge::Previous),
             R"#()#"  , py::arg("atlistnode")
          )
        .def("Dummy",
             (void (MAT_TListNodeOfListOfEdge::*)() const) static_cast<void (MAT_TListNodeOfListOfEdge::*)() const>(&MAT_TListNodeOfListOfEdge::Dummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_TListNodeOfListOfEdge::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_TListNodeOfListOfEdge::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_TListNodeOfListOfEdge::*)() const) static_cast< const handle<Standard_Type> & (MAT_TListNodeOfListOfEdge::*)() const>(&MAT_TListNodeOfListOfEdge::DynamicType),
             R"#()#"
             
         )
;

    // Class MAT_Zone from ./opencascade/MAT_Zone.hxx
    klass = m.attr("MAT_Zone");


    // nested enums

    static_cast<py::class_<MAT_Zone ,opencascade::handle<MAT_Zone>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<MAT_BasicElt> & >()  , py::arg("aBasicElt") )
    // custom constructors
    // methods
        .def("Perform",
             (void (MAT_Zone::*)(  const handle<MAT_BasicElt> &  ) ) static_cast<void (MAT_Zone::*)(  const handle<MAT_BasicElt> &  ) >(&MAT_Zone::Perform),
             R"#(Compute the frontier of the Zone of proximity.)#"  , py::arg("aBasicElt")
          )
        .def("NumberOfArcs",
             (Standard_Integer (MAT_Zone::*)() const) static_cast<Standard_Integer (MAT_Zone::*)() const>(&MAT_Zone::NumberOfArcs),
             R"#(Return the number Of Arcs On the frontier of <me>.)#" 
          )
        .def("ArcOnFrontier",
             (handle<MAT_Arc> (MAT_Zone::*)(  const Standard_Integer  ) const) static_cast<handle<MAT_Arc> (MAT_Zone::*)(  const Standard_Integer  ) const>(&MAT_Zone::ArcOnFrontier),
             R"#(Return the Arc number <Index> on the frontier. of <me>.)#"  , py::arg("Index")
          )
        .def("NoEmptyZone",
             (Standard_Boolean (MAT_Zone::*)() const) static_cast<Standard_Boolean (MAT_Zone::*)() const>(&MAT_Zone::NoEmptyZone),
             R"#(Return TRUE if <me> is not empty .)#" 
          )
        .def("Limited",
             (Standard_Boolean (MAT_Zone::*)() const) static_cast<Standard_Boolean (MAT_Zone::*)() const>(&MAT_Zone::Limited),
             R"#(Return TRUE if <me> is Limited.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&MAT_Zone::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&MAT_Zone::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (MAT_Zone::*)() const) static_cast< const handle<Standard_Type> & (MAT_Zone::*)() const>(&MAT_Zone::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/MAT_Arc.hxx
// ./opencascade/MAT_BasicElt.hxx
// ./opencascade/MAT_Bisector.hxx
// ./opencascade/MAT_DataMapIteratorOfDataMapOfIntegerArc.hxx
// ./opencascade/MAT_DataMapIteratorOfDataMapOfIntegerBasicElt.hxx
// ./opencascade/MAT_DataMapIteratorOfDataMapOfIntegerBisector.hxx
// ./opencascade/MAT_DataMapIteratorOfDataMapOfIntegerNode.hxx
// ./opencascade/MAT_DataMapOfIntegerArc.hxx
// ./opencascade/MAT_DataMapOfIntegerBasicElt.hxx
// ./opencascade/MAT_DataMapOfIntegerBisector.hxx
// ./opencascade/MAT_DataMapOfIntegerNode.hxx
// ./opencascade/MAT_Edge.hxx
// ./opencascade/MAT_Graph.hxx
// ./opencascade/MAT_ListOfBisector.hxx
// ./opencascade/MAT_ListOfEdge.hxx
// ./opencascade/MAT_Node.hxx
// ./opencascade/MAT_SequenceOfArc.hxx
// ./opencascade/MAT_SequenceOfBasicElt.hxx
// ./opencascade/MAT_Side.hxx
// ./opencascade/MAT_TListNodeOfListOfBisector.hxx
// ./opencascade/MAT_TListNodeOfListOfEdge.hxx
// ./opencascade/MAT_Zone.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_Sequence<opencascade::handle<MAT_Arc>>(m,"MAT_SequenceOfArc");
    register_template_NCollection_Sequence<opencascade::handle<MAT_BasicElt>>(m,"MAT_SequenceOfBasicElt");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
