
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <StdFail_InfiniteSolutions.hxx>
#include <StdFail_NotDone.hxx>
#include <StdFail_Undefined.hxx>
#include <StdFail_UndefinedDerivative.hxx>
#include <StdFail_UndefinedValue.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StdFail(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StdFail"));
py::object klass;

//Python trampoline classes

// classes

// functions

// ./opencascade/StdFail_InfiniteSolutions.hxx
// ./opencascade/StdFail_NotDone.hxx
// ./opencascade/StdFail_Undefined.hxx
// ./opencascade/StdFail_UndefinedDerivative.hxx
// ./opencascade/StdFail_UndefinedValue.hxx

// Additional functions


// operators

// register typdefs


// exceptions
register_occ_exception<StdFail_InfiniteSolutions>(m, "StdFail_InfiniteSolutions");
register_occ_exception<StdFail_NotDone>(m, "StdFail_NotDone");
register_occ_exception<StdFail_Undefined>(m, "StdFail_Undefined");
register_occ_exception<StdFail_UndefinedDerivative>(m, "StdFail_UndefinedDerivative");
register_occ_exception<StdFail_UndefinedValue>(m, "StdFail_UndefinedValue");

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
