% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScater.R
\name{plotScater}
\alias{plotScater}
\title{Plot an overview of expression for each cell}
\usage{
plotScater(
  x,
  nfeatures = 500,
  exprs_values = "counts",
  colour_by = color_by,
  by_exprs_values = exprs_values,
  block1 = NULL,
  block2 = NULL,
  ncol = 3,
  line_width = 1.5,
  theme_size = 10,
  color_by = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object.}

\item{nfeatures}{Numeric scalar indicating the number of top-expressed features to show n the plot.}

\item{exprs_values}{String or integer scalar indicating which assay of \code{object} should be used to obtain the expression values for this plot.}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values. 
The curve for each cell will be coloured according to this specification.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in point aesthetics - see the \code{exprs_values} argument in \code{?\link{retrieveCellInfo}}.}

\item{block1}{String specifying the column-level metadata field by which to separate the cells into separate panels in the plot. 
Alternatively, an \link{AsIs} vector or data.frame, see \code{?\link{retrieveCellInfo}}.
Default is \code{NULL}, in which case there is no blocking.}

\item{block2}{Same as \code{block1}, providing another level of blocking.}

\item{ncol}{Number of columns to use for \code{\link{facet_wrap}} if only one block is defined.}

\item{line_width}{Numeric scalar specifying the line width.}

\item{theme_size}{Numeric scalar specifying the font size to use for the plotting theme.}

\item{color_by}{Alias to \code{colour_by}.}
}
\value{
A \link{ggplot} object.
}
\description{
Plot the relative proportion of the library size that is accounted for by the most highly expressed features for each cell in a SingleCellExperiment object.
}
\details{
For each cell, the features are ordered from most-expressed to least-expressed.
The cumulative proportion of the total expression for the cell is computed across the top \code{nfeatures} features. 
These plots can flag cells with a very high proportion of the library coming from a small number of features; such cells are likely to be problematic for downstream analyses.

Using the colour and blocking arguments can flag overall differences in cells under different experimental conditions or affected by different batch and other variables.
If only one of \code{block1} and \code{block2} are specified, each panel corresponds to a separate level of the specified blocking factor.
If both are specified, each panel corresponds to a combination of levels.
}
\examples{
example_sce <- mockSCE()
plotScater(example_sce)
plotScater(example_sce, exprs_values = "counts", colour_by = "Cell_Cycle")
plotScater(example_sce, block1 = "Treatment", colour_by = "Cell_Cycle")

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
