% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{pred.density}
\alias{pred.density}
\alias{pred.density-class}
\alias{print.pred.density}
\title{Predictive Densities for bma Objects}
\usage{
pred.density(object, newdata = NULL, n = 300, hnbsteps = 30, ...)
}
\arguments{
\item{object}{a bma object - see \code{\link{bms}}, alternativel a
\code{\link{zlm}} object}

\item{newdata}{A data.frame, matrix or vector containing variables with
which to predict.}

\item{n}{The integer number of equally spaced points at which the density is
to be estimated.}

\item{hnbsteps}{The number of numerical integration steps to be used in case
of a hyper-g prior (cf. argument \code{g} in \code{\link{bms}}). Increase
this number to increase accuracy. Must be an even integer.}

\item{\dots}{arguments to be passed on to \code{\link{plot.density}}.}
}
\value{
\code{pred.density} returns a list of class \code{pred.density} with
the following elements \item{densities()}{a list whose elements each contain
the estimated density for each forecasted observation} \item{fit}{a vector
with the expected values of the predictions (the 'point forecasts')}
\item{std.err}{a vector with the standard deviations of the predictions (the
'standard errors')} \item{dyf(realized.y, predict_index=NULL)}{Returns the
densities of realized response variables provided in \code{realized.y}. \cr
If \code{realized.y} is a matrix, then each row corresponds to a forecast
observation in \code{newdata}\cr if not left empty, \code{predict.index}
specifies to which observations in newdata the realized.y should apply}
\item{lps(realized.y, predict_index=NULL)}{Computes the log predictive score
for the response varaible provided in \code{realized.y} (cf.
\code{\link{lps.bma}}) -\cr Note that the LPS equals minus the mean of the
logarithmized results from \code{dyf}) } \item{plot((x, predict_index =
NULL, addons = "eslz", realized.y = NULL, addons.lwd = 1.5, ...)}{the same
as \code{plot.pred.density}} \item{n}{The number of equally spaced
points for which the density (under \code{densities()} was computed.}
\item{nmodel}{The number of best models predictive densities are based
upon.} \item{call}{the call that created this \code{pred.density} object}
}
\description{
Predictive densities for conditional forecasts
}
\details{
The predictive density is a mixture density based on the \code{nmodels} best
models in a \code{bma} object (cf. \code{nmodel} in \code{\link{bms}}).\cr
The number of 'best models' to retain is therefore vital and should be set
quite high for accuracy.
}
\note{
In BMS version 0.3.0, \code{pred.density} may only cope with built-in
\code{gprior}s, not with any user-defined priors.
}
\examples{

 data(datafls)
 mm=bms(datafls,user.int=FALSE)
 
 #predictive densityfor two 'new' data points
 pd=pred.density(mm,newdata=datafls[1:2,]) 
 
 
 #fitted values based on best models, same as predict(mm, exact=TRUE)
 pd$fit
 
 #plot the density for the first forecast observation
 plot(pd,1)  
 
 # the same plot ' naked'
 plot(pd$densities()[[1]])
 
 
 #predict density for the first forecast observation if the dep. variable is 0
 pd$dyf(0,1) 
 
 #predict densities for both forecasts for the realizations 0 and 0.5
 pd$dyf(rbind(c(0,.5),c(0,.5)))
 
 # calc. Log Predictive Score if both forecasts are realized at 0:
 lps.bma(pd,c(0,0))
 
 
}
\seealso{
\code{\link{predict.bma}} for simple point forecasts,
\code{plot.pred.density} for plotting predictive densities,
\code{\link{lps.bma}} for calculating the log predictive score
independently, \code{\link{quantile.pred.density}} for extracting quantiles

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
