% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable in knitr documents}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{unused.}
}
\description{
This function is called automatically by knitr to display
a flextable in R Markdown and Quarto documents. You do not need to call
it directly.

Supported output formats: HTML, Word (docx), PDF and PowerPoint (pptx).
For other formats (e.g., \code{github_document}, \code{beamer_presentation}),
the table is rendered as a PNG image.
}
\section{Getting started}{


No special setup is needed: place a flextable object in a code chunk
and it will be rendered in the output document.

Add a caption with \code{\link[=set_caption]{set_caption()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ft <- set_caption(ft, caption = "My table caption")
}\if{html}{\out{</div>}}

In Quarto documents, use chunk options \code{tbl-cap} and \code{label} instead:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r\}
#| label: tbl-mytable
#| tbl-cap: "My table caption"
ft
```
}\if{html}{\out{</div>}}
}

\section{Captions}{


\strong{Recommended method:} use \code{\link[=set_caption]{set_caption()}} to define the caption
directly on the flextable object. When \code{set_caption()} is used,
chunk options related to captions are ignored.

\strong{Alternative (R Markdown only):} use knitr chunk options \code{tab.cap}
and \code{tab.id}:\tabular{lcc}{
   \strong{Description} \tab \strong{Chunk option} \tab \strong{Default} \cr
   Caption text \tab tab.cap \tab NULL \cr
   Caption id/bookmark \tab tab.id \tab NULL \cr
   Caption on top of the table \tab tab.topcaption \tab TRUE \cr
   Caption sequence identifier \tab tab.lp \tab "tab:" \cr
   Word style for captions \tab tab.cap.style \tab NULL \cr
}


\strong{Bookdown:} cross-references use the pattern
\verb{\\@ref(tab:chunk_label)}. The usual bookdown numbering applies.

\strong{Quarto:} cross-references use \verb{@tbl-chunk_label}. To embed
cross-references or other Quarto markdown inside flextable cells,
use \code{\link[=as_qmd]{as_qmd()}} with the \code{flextable-qmd} extension
(see \code{\link[=use_flextable_qmd]{use_flextable_qmd()}}).
}

\section{Chunk options}{


Use \code{knitr::opts_chunk$set(...)} to set defaults for the whole document.

\strong{All formats:}
\itemize{
\item \code{ft.align}: table alignment, one of \code{'left'}, \code{'center'} (default)
or \code{'right'}.
}

\strong{HTML:}
\itemize{
\item \code{ft.htmlscroll}: \code{TRUE} or \code{FALSE} (default) to enable horizontal
scrolling. See \code{\link[=set_table_properties]{set_table_properties()}} for finer control.
}

\strong{Word:}
\itemize{
\item \code{ft.split}: allow rows to break across pages (\code{TRUE} by default).
}

\strong{PDF:}
\itemize{
\item \code{ft.tabcolsep}: space between text and cell borders (default 0 pt).
\item \code{ft.arraystretch}: row height multiplier (default 1.5).
\item \code{ft.latex.float}: floating placement. One of \code{'none'} (default),
\code{'float'}, \code{'wrap-r'}, \code{'wrap-l'}, \code{'wrap-i'}, \code{'wrap-o'}.
}

\strong{PowerPoint:}
\itemize{
\item \code{ft.left}, \code{ft.top}: top-left coordinates of the table placeholder
in inches (defaults: 1 and 2).
}
}

\section{Word with officedown}{


When using \code{officedown::rdocx_document()}, additional caption options
are available:\tabular{lcc}{
   \strong{Description} \tab \strong{Chunk option} \tab \strong{Default} \cr
   Numbering prefix \tab tab.cap.pre \tab "Table " \cr
   Numbering suffix \tab tab.cap.sep \tab ": " \cr
   Title number depth \tab tab.cap.tnd \tab 0 \cr
   Caption prefix formatting \tab tab.cap.fp_text \tab \code{fp_text_lite(bold=TRUE)} \cr
   Title number / table number separator \tab tab.cap.tns \tab "-" \cr
}
}

\section{Quarto}{


flextable works natively in Quarto documents for HTML, PDF and Word.

The \code{flextable-qmd} Lua filter extension enables Quarto markdown
inside flextable cells: cross-references (\verb{@tbl-xxx}, \verb{@fig-xxx}),
bold/italic, links, math, inline code and shortcodes.
See \code{\link[=as_qmd]{as_qmd()}} and \code{\link[=use_flextable_qmd]{use_flextable_qmd()}} for setup instructions.
}

\section{PDF limitations}{


The following properties are not supported in PDF output:
padding, \code{line_spacing} and row \code{height}. Justified text is
converted to left-aligned.

To use system fonts, set \code{latex_engine: xelatex} in the YAML
header (the default \code{pdflatex} engine does not support them).

See \code{\link[=add_latex_dep]{add_latex_dep()}} when caching flextable results.
}

\section{PowerPoint limitations}{


PowerPoint only supports fixed table layout. Use \code{\link[=autofit]{autofit()}} to
adjust column widths. Images inside table cells are not supported
(this is a PowerPoint limitation).
}

\section{HTML note}{


HTML output uses Shadow DOM to isolate table styles from the rest
of the page.
}

\examples{
\dontrun{
library(rmarkdown)
if (pandoc_available() &&
  pandoc_version() > numeric_version("2")) {
  demo_loop <- system.file(
    package = "flextable",
    "examples/rmd",
    "demo.Rmd"
  )
  rmd_file <- tempfile(fileext = ".Rmd")
  file.copy(demo_loop, to = rmd_file, overwrite = TRUE)
  render(
    input = rmd_file, output_format = "html_document",
    output_file = "demo.html"
  )
}
}
}
\seealso{
\code{\link[=set_caption]{set_caption()}}, \code{\link[=as_qmd]{as_qmd()}}, \code{\link[=use_flextable_qmd]{use_flextable_qmd()}},
\code{\link[=paginate]{paginate()}}

Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()},
\code{\link{wrap_flextable}()}
}
\concept{flextable print function}
