% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{linters_with_tags}
\alias{linters_with_tags}
\title{Create a tag-based linter configuration}
\usage{
linters_with_tags(tags, ..., packages = "lintr", exclude_tags = "deprecated")
}
\arguments{
\item{tags}{Optional character vector of tags to search. Only linters with at least one matching tag will be
returned. If \code{tags} is \code{NULL}, all linters will be returned.}

\item{...}{Arguments of elements to change. If unnamed, the argument is automatically named.
If the named argument already exists in the list of linters, it is replaced by the new element.
If it does not exist, it is added. If the value is \code{NULL}, the linter is removed.}

\item{packages}{A character vector of packages to search for linters.}

\item{exclude_tags}{Tags to exclude from the results. Linters with at least one matching tag will not be returned.
If \code{except_tags} is \code{NULL}, no linters will be excluded.}
}
\value{
A modified list of linters.
}
\description{
Make a new list based on all linters provided by \code{packages} and tagged with \code{tags}.
The result of this function is meant to be passed to the \code{linters} argument of \code{lint()},
or to be put in your configuration file.
}
\examples{
# `linters_with_defaults()` and `linters_with_tags("default")` are the same:
all.equal(linters_with_defaults(), linters_with_tags("default"))

# Get all linters useful for package development
linters_with_tags(tags = "package_development")

# Get all linters provided by lintr
linters_with_tags(tags = NULL)

# Get all linters tagged as "default" from lintr and mypkg
\dontrun{linters_with_tags("default", packages = c("lintr", "mypkg"))}
}
\seealso{
\link{linters_with_defaults} for basing off lintr's set of default linters.
\link{available_linters} to get a data frame of available linters.
\link{linters} for a complete list of linters available in lintr.
}
