% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer_anova.R
\name{show_tests.anova}
\alias{show_tests.anova}
\title{Show Hypothesis Tests in ANOVA Tables}
\usage{
\method{show_tests}{anova}(object, fractions = FALSE, names = TRUE, ...)
}
\arguments{
\item{object}{an anova table with a \code{"hypotheses"} attribute.}

\item{fractions}{display entries in the hypothesis matrices as fractions?}

\item{names}{if \code{FALSE} column and row names of the hypothesis matrices
are suppressed.}

\item{...}{currently not used.}
}
\value{
a list of hypothesis matrices.
}
\description{
Extracts hypothesis matrices for terms in ANOVA tables detailing exactly which
functions of the parameters are being tested in anova tables.
}
\examples{

# Fit basic model to the 'cake' data:
data("cake", package="lme4")
fm1 <- lmer(angle ~ recipe * temp + (1|recipe:replicate), cake)

# Type 3 anova table:
(an <- anova(fm1, type="3"))

# Display tests/hypotheses for type 1, 2, and 3 ANOVA tables:
# (and illustrate effects of 'fractions' and 'names' arguments)
show_tests(anova(fm1, type="1"))
show_tests(anova(fm1, type="2"), fractions=TRUE, names=FALSE)
show_tests(an, fractions=TRUE)

}
\seealso{
\code{\link[=show_tests.ls_means]{show_tests}} for \code{ls_means}
objects.
}
\author{
Rune Haubo B. Christensen
}
