% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleDimPlot}
\alias{SingleDimPlot}
\title{Plot a single dimension}
\usage{
SingleDimPlot(
  data,
  dims,
  col.by = NULL,
  cols = NULL,
  pt.size = NULL,
  shape.by = NULL,
  alpha = 1,
  alpha.by = NULL,
  stroke.size = NULL,
  order = NULL,
  label = FALSE,
  repel = FALSE,
  label.size = 4,
  cells.highlight = NULL,
  cols.highlight = "#DE2D26",
  sizes.highlight = 1,
  na.value = "grey50",
  raster = NULL,
  raster.dpi = NULL
)
}
\arguments{
\item{data}{Data to plot}

\item{dims}{A two-length numeric vector with dimensions to use}

\item{col.by}{...}

\item{cols}{Vector of colors, each color corresponds to an identity class.
This may also be a single character or numeric value corresponding to a
palette as specified by \code{\link[RColorBrewer]{brewer.pal.info}}.By
default, ggplot2 assigns colors}

\item{pt.size}{Adjust point size for plotting}

\item{shape.by}{If NULL, all points are circles (default). You can specify
any cell attribute (that can be pulled with \code{\link{FetchData}})
allowing for both different colors and different shapes on cells.}

\item{alpha}{Alpha value for plotting (default is 1)}

\item{alpha.by}{Mapping variable for the point alpha value}

\item{stroke.size}{Adjust stroke (outline) size of points}

\item{order}{Specify the order of plotting for the idents. This can be
useful for crowded plots if points of interest are being buried. Provide
either a full list of valid idents or a subset to be plotted last (on top).}

\item{label}{Whether to label the clusters}

\item{repel}{Repel labels}

\item{label.size}{Sets size of labels}

\item{cells.highlight}{A list of character or numeric vectors of cells to
highlight. If only one group of cells desired, can simply
pass a vector instead of a list. If set, colors selected cells to the color(s)
in \code{cols.highlight} and other cells black (white if dark.theme = TRUE);
will also resize to the size(s) passed to \code{sizes.highlight}}

\item{cols.highlight}{A vector of colors to highlight the cells as; will
repeat to the length groups in cells.highlight}

\item{sizes.highlight}{Size of highlighted cells; will repeat to the length
groups in cells.highlight}

\item{na.value}{Color value for NA points when using custom scale.}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is
greater than 100,000}

\item{raster.dpi}{the pixel resolution for rastered plots, passed to geom_scattermore().
Default is c(512, 512)}
}
\value{
A ggplot2 object
}
\description{
Plot a single dimension
}
\keyword{internal}
