% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGroves.R
\name{plotGrovesD3}
\alias{plotGrovesD3}
\title{Scatterplot of groups of trees using \code{scatterD3}}
\usage{
plotGrovesD3(x, groups = NULL, xax = 1, yax = 2, treeNames = NULL,
  symbol_var = NULL, xlab = paste0("Axis ", xax), ylab = paste0("Axis ",
  yax), ...)
}
\arguments{
\item{x}{a list returned by \code{\link{findGroves}} or a MDS with class \code{dudi}}

\item{groups}{a factor defining groups of trees. If x is a list returned by \code{\link{findGroves}} these will be detected automatically.}

\item{xax}{a number indicating which principal component to be used as 'x' axis}

\item{yax}{a number indicating which principal component to be used as 'y' axis}

\item{treeNames}{if a list of tree names or labels are given, these will be plotted alongside the points. Their size can be altered using \code{labels_size} - see \code{?scatterD3} for more information.}

\item{symbol_var}{a factor by which to vary the symbols in the plot}

\item{xlab}{the label for the 'x' axis. Defaults to use the value of 'xax'}

\item{ylab}{the label for the 'y' axis. Defaults to use the value of 'yax'}

\item{...}{further arguments passed to \code{\link{scatterD3}}}
}
\value{
A \code{scatterD3} plot
}
\description{
This function displays the scatterplot of the Multidimensional
Scaling (MDS) output by treescape, superimposing group information
(derived by \code{\link{findGroves}}) using colors.
\code{scatterD3} enables interactive plotting based on d3.js, including zooming, panning and fading effects in the legend.
}
\examples{

\dontrun{
if(require("adegenet") && require("scatterD3")){
## load data
data(woodmiceTrees)

## run findGroves: treescape+clustering
res <- findGroves(woodmiceTrees, nf=5, nclust=6)

## basic plot
plotGrovesD3(res)

## adding tree labels
plotGrovesD3(res, treeNames=1:201)

## customizing: vary the colour and the symbol by group
plotGrovesD3(res, symbol_var=res$groups)

## example with no group information
plotGrovesD3(res$treescape$pco)
}
}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
\seealso{
\code{\link{findGroves}} to find any clusters in the tree landscape
}

