# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop-ast` gem.
# Please instead update this file by running `bin/tapioca gem rubocop-ast`.


class Parser::Source::Range
  include ::RuboCop::AST::Ext::Range
end

# source://rubocop-ast//lib/rubocop/ast/ext/range.rb#3
module RuboCop; end

# ...
#
# source://rubocop-ast//lib/rubocop/ast/ext/range.rb#4
module RuboCop::AST
  extend ::RuboCop::AST::RuboCopCompatibility
end

# A node extension for `alias` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `alias` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/alias_node.rb#8
class RuboCop::AST::AliasNode < ::RuboCop::AST::Node
  # Returns the new identifier as specified by the `alias`.
  #
  # @return [SymbolNode] the new identifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/alias_node.rb#19
  def new_identifier; end

  # Returns the old identifier as specified by the `alias`.
  #
  # @return [SymbolNode] the old identifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/alias_node.rb#12
  def old_identifier; end
end

# A node extension for `op_asgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/and_asgn_node.rb#8
class RuboCop::AST::AndAsgnNode < ::RuboCop::AST::OpAsgnNode
  # The operator being used for assignment as a symbol.
  #
  # @return [Symbol] the assignment operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/and_asgn_node.rb#12
  def operator; end
end

# A node extension for `until` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `until` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/and_node.rb#8
class RuboCop::AST::AndNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BinaryOperatorNode
  include ::RuboCop::AST::PredicateOperatorNode

  # Returns the alternate operator of the `and` as a string.
  # Returns `and` for `&&` and vice versa.
  #
  # @return [String] the alternate of the `and` operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/and_node.rb#16
  def alternate_operator; end

  # Returns the inverse keyword of the `and` node as a string.
  # Returns `||` for `&&` and `or` for `and`.
  #
  # @return [String] the inverse of the `and` operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/and_node.rb#24
  def inverse_operator; end
end

# A node extension for `arg`, `optarg`, `restarg`, `kwarg`, `kwoptarg`,
# `kwrestarg`, `blockarg`, `shadowarg` and `forward_arg` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all `arg` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/arg_node.rb#9
class RuboCop::AST::ArgNode < ::RuboCop::AST::Node
  # Checks whether the argument has a default value
  #
  # @return [Boolean] whether the argument has a default value
  #
  # source://rubocop-ast//lib/rubocop/ast/node/arg_node.rb#29
  def default?; end

  # Returns the default value of the argument, if any.
  #
  # @return [Node, nil] the default value of the argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/arg_node.rb#20
  def default_value; end

  # Returns the name of an argument.
  #
  # @return [Symbol, nil] the name of the argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/arg_node.rb#13
  def name; end
end

# A node extension for `args` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `args` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/args_node.rb#8
class RuboCop::AST::ArgsNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::CollectionNode

  # Yield each argument from the collection.
  # Arguments can be inside `mlhs` nodes in the case of destructuring, so this
  # flattens the collection to just `arg`, `optarg`, `restarg`, `kwarg`,
  # `kwoptarg`, `kwrestarg`, `blockarg`, `forward_arg` and `shadowarg`.
  #
  # @return [Array<Node>] array of argument nodes.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/args_node.rb#34
  def argument_list; end

  # It returns true if arguments are empty and delimiters do not exist.
  # @example:
  #   # true
  #   def x; end
  #   x { }
  #   -> {}
  #
  #   # false
  #   def x(); end
  #   def x a; end
  #   x { || }
  #   -> () {}
  #   -> a {}
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/args_node.rb#24
  def empty_and_without_delimiters?; end
end

# A node extension for `array` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `array` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#8
class RuboCop::AST::ArrayNode < ::RuboCop::AST::Node
  # Checks whether the `array` literal is delimited by either percent or
  # square brackets
  #
  # brackets
  #
  # @return [Boolean] whether the array is enclosed in percent or square
  #
  # source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#64
  def bracketed?; end

  # Calls the given block for each `value` node in the `array` literal.
  # If no block is given, an `Enumerator` is returned.
  #
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  #
  # source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#25
  def each_value(&block); end

  # Checks whether the `array` literal is delimited by percent brackets.
  #
  # @overload percent_literal?
  # @overload percent_literal?
  # @return [Boolean] whether the array is enclosed in percent brackets
  #
  # source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#51
  def percent_literal?(type = T.unsafe(nil)); end

  # Checks whether the `array` literal is delimited by square brackets.
  #
  # @return [Boolean] whether the array is enclosed in square brackets
  #
  # source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#36
  def square_brackets?; end

  # Returns an array of all value nodes in the `array` literal.
  #
  # @return [Array<Node>] an array of value nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#18
  def values; end
end

# source://rubocop-ast//lib/rubocop/ast/node/array_node.rb#9
RuboCop::AST::ArrayNode::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Hash)

# A node extension for `lvasgn`, `ivasgn`, `cvasgn`, and `gvasgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/asgn_node.rb#8
class RuboCop::AST::AsgnNode < ::RuboCop::AST::Node
  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/asgn_node.rb#20
  def expression; end

  # The name of the variable being assigned as a symbol.
  #
  # @return [Symbol] the name of the variable being assigned
  #
  # source://rubocop-ast//lib/rubocop/ast/node/asgn_node.rb#15
  def lhs; end

  # The name of the variable being assigned as a symbol.
  #
  # @return [Symbol] the name of the variable being assigned
  #
  # source://rubocop-ast//lib/rubocop/ast/node/asgn_node.rb#12
  def name; end

  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/asgn_node.rb#23
  def rhs; end
end

# Common functionality for primitive literal nodes: `sym`, `str`,
# `int`, `float`, `rational`, `complex`...
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/basic_literal_node.rb#7
module RuboCop::AST::BasicLiteralNode
  # Returns the value of the literal.
  #
  # @return [mixed] the value of the literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/basic_literal_node.rb#11
  def value; end
end

# Common functionality for nodes that are binary operations:
# `or`, `and` ...
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/binary_operator_node.rb#7
module RuboCop::AST::BinaryOperatorNode
  # Returns all of the conditions, including nested conditions,
  # of the binary operation.
  #
  # operation and the let and right hand side of any nested binary
  # operators
  #
  # @return [Array<Node>] the left and right hand side of the binary
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/binary_operator_node.rb#28
  def conditions; end

  # Returns the left hand side node of the binary operation.
  #
  # @return [Node] the left hand side of the binary operation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/binary_operator_node.rb#11
  def lhs; end

  # Returns the right hand side node of the binary operation.
  #
  # @return [Node] the right hand side of the binary operation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/binary_operator_node.rb#18
  def rhs; end
end

# A node extension for `block` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `send` nodes within RuboCop.
#
# A `block` node is essentially a method send with a block. Parser nests
# the `send` node inside the `block` node.
#
# source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#11
class RuboCop::AST::BlockNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::MethodIdentifierPredicates

  # Returns a collection of all descendants of this node that are
  # argument type nodes. See `ArgsNode#argument_list` for details.
  #
  # @return [Array<Node>]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#62
  def argument_list; end

  # The arguments of this block.
  # Note that if the block has destructured arguments, `arguments` will
  # return a `mlhs` node, whereas `argument_list` will return only
  # actual argument nodes.
  #
  # @return [Array<Node>]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#50
  def arguments; end

  # Checks whether this block takes any arguments.
  #
  # @return [Boolean] whether this `block` node takes any arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#89
  def arguments?; end

  # The body of this block.
  #
  # @return [Node, nil] the body of the `block` node or `nil`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#75
  def body; end

  # Checks whether the `block` literal is delimited by curly braces.
  #
  # @return [Boolean] whether the `block` literal is enclosed in braces
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#96
  def braces?; end

  # The closing delimiter for this `block` literal.
  #
  # @return [String] the closing delimiter for the `block` literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#124
  def closing_delimiter; end

  # The delimiters for this `block` literal.
  #
  # @return [Array<String>] the delimiters for the `block` literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#110
  def delimiters; end

  # A shorthand for getting the first argument of this block.
  # Equivalent to `arguments.first`.
  #
  # @return [Node, nil] the first argument of this block,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#31
  def first_argument; end

  # Checks whether the `block` literal is delimited by `do`-`end` keywords.
  #
  # @return [Boolean] whether the `block` literal is enclosed in `do`-`end`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#103
  def keywords?; end

  # Checks whether this `block` literal belongs to a lambda.
  #
  # @return [Boolean] whether the `block` literal belongs to a lambda
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#147
  def lambda?; end

  # A shorthand for getting the last argument of this block.
  # Equivalent to `arguments.last`.
  #
  # @return [Node, nil] the last argument of this block,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#40
  def last_argument; end

  # The name of the dispatched method as a symbol.
  #
  # @return [Symbol] the name of the dispatched method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#82
  def method_name; end

  # Checks whether this is a multiline block. This is overridden here
  # because the general version in `Node` does not work for `block` nodes.
  #
  # @return [Boolean] whether the `block` literal is on a several lines
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#140
  def multiline?; end

  # The opening delimiter for this `block` literal.
  #
  # @return [String] the opening delimiter for the `block` literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#117
  def opening_delimiter; end

  # The `send` node associated with this block.
  #
  # @return [SendNode] the `send` node associated with the `block` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#22
  def send_node; end

  # Checks whether this is a single line block. This is overridden here
  # because the general version in `Node` does not work for `block` nodes.
  #
  # @return [Boolean] whether the `block` literal is on a single line
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#132
  def single_line?; end

  # Checks whether this node body is a void context.
  #
  # @return [Boolean] whether the `block` node body is a void context
  #
  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#154
  def void_context?; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#160
  def numbered_arguments; end
end

# source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#14
RuboCop::AST::BlockNode::IT_BLOCK_ARGUMENT = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node/block_node.rb#16
RuboCop::AST::BlockNode::VOID_CONTEXT_METHODS = T.let(T.unsafe(nil), Array)

# A node extension for `break` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `break` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/break_node.rb#8
class RuboCop::AST::BreakNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::WrappedArguments
end

# `RuboCop::AST::Builder` is an AST builder that is utilized to let `Parser`
# generate ASTs with {RuboCop::AST::Node}.
#
# @example
#   buffer = Parser::Source::Buffer.new('(string)')
#   buffer.source = 'puts :foo'
#
#   builder = RuboCop::AST::Builder.new
#   require 'parser/ruby25'
#   parser = Parser::Ruby25.new(builder)
#   root_node = parser.parse(buffer)
#
# source://rubocop-ast//lib/rubocop/ast/builder.rb#129
class RuboCop::AST::Builder < ::Parser::Builders::Default
  include ::RuboCop::AST::BuilderExtensions
end

# Common functionality between the parser and prism builder
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/builder.rb#7
module RuboCop::AST::BuilderExtensions
  # Generates {Node} from the given information.
  #
  # @api private
  # @return [Node] the generated node
  #
  # source://rubocop-ast//lib/rubocop/ast/builder.rb#101
  def n(type, children, source_map); end

  # Overwrite the base method to allow strings with invalid encoding
  # More details here https://github.com/whitequark/parser/issues/283
  #
  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/builder.rb#107
  def string_value(token); end

  private

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/builder.rb#113
  def node_klass(type); end

  class << self
    # @api private
    # @private
    #
    # source://rubocop-ast//lib/rubocop/ast/builder.rb#8
    def included(base); end
  end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/builder.rb#14
RuboCop::AST::BuilderExtensions::NODE_MAP = T.let(T.unsafe(nil), Hash)

# A parser builder, based on the one provided by prism,
# which is capable of emitting AST for more recent Rubies.
#
# source://rubocop-ast//lib/rubocop/ast/builder_prism.rb#7
class RuboCop::AST::BuilderPrism < ::Prism::Translation::Parser::Builder
  include ::RuboCop::AST::BuilderExtensions
end

# A node extension for `case_match` nodes. This will be used in place of
# a plain node when the builder constructs the AST, making its methods
# available to all `case_match` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#8
class RuboCop::AST::CaseMatchNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConditionalNode

  # Returns an array of all the when branches in the `case` statement.
  #
  # and the `else` (if any). Note that these bodies could be nil.
  #
  # @return [Array<Node, nil>] an array of the bodies of the `in` branches
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#38
  def branches; end

  # @deprecated Use `in_pattern_branches.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#19
  def each_in_pattern(&block); end

  # Checks whether this case statement has an `else` branch.
  #
  # @return [Boolean] whether the `case` statement has an `else` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#59
  def else?; end

  # Returns the else branch of the `case` statement, if any.
  #
  # @return [Node] the else branch node of the `case` statement
  # @return [EmptyElse] the empty else branch node of the `case` statement
  # @return [nil] if the case statement does not have an else branch.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#52
  def else_branch; end

  # Returns an array of all the `in` pattern branches in the `case` statement.
  #
  # @return [Array<InPatternNode>] an array of `in_pattern` nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#30
  def in_pattern_branches; end

  # Returns the keyword of the `case` statement as a string.
  #
  # @return [String] the keyword of the `case` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_match_node.rb#14
  def keyword; end
end

# A node extension for `case` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `case` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#8
class RuboCop::AST::CaseNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConditionalNode

  # Returns an array of all the when branches in the `case` statement.
  #
  # and the else (if any). Note that these bodies could be nil.
  #
  # @return [Array<Node, nil>] an array of the bodies of the when branches
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#38
  def branches; end

  # @deprecated Use `when_branches.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#19
  def each_when(&block); end

  # Checks whether this case statement has an `else` branch.
  #
  # @return [Boolean] whether the `case` statement has an `else` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#55
  def else?; end

  # Returns the else branch of the `case` statement, if any.
  #
  # @return [Node] the else branch node of the `case` statement
  # @return [nil] if the case statement does not have an else branch.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#48
  def else_branch; end

  # Returns the keyword of the `case` statement as a string.
  #
  # @return [String] the keyword of the `case` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#14
  def keyword; end

  # Returns an array of all the when branches in the `case` statement.
  #
  # @return [Array<WhenNode>] an array of `when` nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/case_node.rb#30
  def when_branches; end
end

# A node extension for `casgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/casgn_node.rb#8
class RuboCop::AST::CasgnNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConstantNode

  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/casgn_node.rb#17
  def expression; end

  # source://rubocop-ast//lib/rubocop/ast/node/casgn_node.rb#12
  def lhs; end

  # source://rubocop-ast//lib/rubocop/ast/node/casgn_node.rb#11
  def name; end

  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/casgn_node.rb#20
  def rhs; end
end

# A node extension for `class` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `class` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/class_node.rb#8
class RuboCop::AST::ClassNode < ::RuboCop::AST::Node
  # The body of this `class` node.
  #
  # @return [Node, nil] the body of the class
  #
  # source://rubocop-ast//lib/rubocop/ast/node/class_node.rb#26
  def body; end

  # The identifier for this `class` node.
  #
  # @return [Node] the identifier of the class
  #
  # source://rubocop-ast//lib/rubocop/ast/node/class_node.rb#12
  def identifier; end

  # The parent class for this `class` node.
  #
  # @return [Node, nil] the parent class of the class
  #
  # source://rubocop-ast//lib/rubocop/ast/node/class_node.rb#19
  def parent_class; end
end

# A mixin that helps give collection nodes array polymorphism.
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#6
module RuboCop::AST::CollectionNode
  extend ::RuboCop::SimpleForwardable

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def &(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def *(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def +(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def -(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def <<(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def [](*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def []=(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def all?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def any?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def append(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def assoc(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def at(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def bsearch(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def bsearch_index(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def chain(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def chunk(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def chunk_while(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def clear(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def collect(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def collect!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def collect_concat(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def combination(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def compact(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def compact!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def concat(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def count(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def cycle(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def deconstruct(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def delete(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def delete_at(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def delete_if(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def detect(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def difference(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def dig(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def drop(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def drop_while(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_cons(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_entry(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_index(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_slice(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_with_index(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def each_with_object(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def empty?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def entries(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def fetch(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def fetch_values(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def fill(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def filter(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def filter!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def filter_map(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def find(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def find_all(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def find_index(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def first(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def flat_map(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def flatten(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def flatten!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def grep(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def grep_v(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def group_by(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def include?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def index(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def inject(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def insert(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def intersect?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def intersection(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def join(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def keep_if(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def last(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def lazy(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def length(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def map(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def map!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def max(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def max_by(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def member?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def min(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def min_by(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def minmax(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def minmax_by(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def none?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def one?(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def pack(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def partition(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def permutation(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def place(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def pop(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def prepend(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def product(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def push(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def rassoc(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reduce(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reject(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reject!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def repeated_combination(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def repeated_permutation(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def replace(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reverse(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reverse!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def reverse_each(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def rfind(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def rindex(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def rotate(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def rotate!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sample(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def select(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def select!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def shelljoin(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def shift(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def shuffle(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def shuffle!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def size(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def slice(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def slice!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def slice_after(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def slice_before(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def slice_when(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sort(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sort!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sort_by(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sort_by!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def sum(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def take(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def take_while(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def tally(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def to_ary(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def to_h(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def to_set(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def transpose(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def union(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def uniq(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def uniq!(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def unshift(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def values_at(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def zip(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#13
  def |(*_arg0, **_arg1, &_arg2); end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/collection_node.rb#9
RuboCop::AST::CollectionNode::ARRAY_METHODS = T.let(T.unsafe(nil), Array)

# A node extension for `complex` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available to
# all `complex` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/complex_node.rb#8
class RuboCop::AST::ComplexNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode
  include ::RuboCop::AST::NumericNode
end

# Common functionality for nodes that have conditions:
# `if`, `while`, `until`, `case`.
# This currently doesn't include `when` nodes, because they have multiple
# conditions, and need to be checked for that.
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/conditional_node.rb#9
module RuboCop::AST::ConditionalNode
  # Returns the body associated with the condition. This works together with
  # each node's custom destructuring method to select the correct part of
  # the node.
  #
  # @note For `if` nodes, this is the truthy branch.
  # @return [Node, nil] the body of the node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/conditional_node.rb#40
  def body; end

  # Returns the condition of the node. This works together with each node's
  # custom destructuring method to select the correct part of the node.
  #
  # @return [Node, nil] the condition of the node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/conditional_node.rb#29
  def condition; end

  # Checks whether the condition of the node is written on more than
  # one line.
  #
  # @return [Boolean] whether the condition is on more than one line
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/conditional_node.rb#21
  def multiline_condition?; end

  # Checks whether the condition of the node is written on a single line.
  #
  # @return [Boolean] whether the condition is on a single line
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/conditional_node.rb#13
  def single_line_condition?; end
end

# A node extension for `const` nodes.
#
# source://rubocop-ast//lib/rubocop/ast/node/const_node.rb#6
class RuboCop::AST::ConstNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConstantNode
end

# Common functionality for nodes that deal with constants:
# `const`, `casgn`.
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#7
module RuboCop::AST::ConstantNode
  # @return [Boolean] if the constant starts with `::` (aka s(:cbase))
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#27
  def absolute?; end

  # @return [Boolean] if the constant is a Module / Class, according to the standard convention.
  #   Note: some classes might have uppercase in which case this method
  #   returns false
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#24
  def class_name?; end

  # Yield nodes for the namespace
  #
  #   For `::Foo::Bar::BAZ` => yields:
  #      s(:cbase), then
  #      s(:const, :Foo), then
  #      s(:const, s(:const, :Foo), :Bar)
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#44
  def each_path(&block); end

  # @return [Boolean] if the constant is a Module / Class, according to the standard convention.
  #   Note: some classes might have uppercase in which case this method
  #   returns false
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#21
  def module_name?; end

  # @return [Node, nil] the node associated with the scope (e.g. cbase, const, ...)
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#9
  def namespace; end

  # @return [Boolean] if the constant does not start with `::` (aka s(:cbase))
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#34
  def relative?; end

  # @return [Symbol] the demodulized name of the constant: "::Foo::Bar" => :Bar
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/constant_node.rb#14
  def short_name; end
end

# A node extension for `csend` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `csend` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/csend_node.rb#8
class RuboCop::AST::CsendNode < ::RuboCop::AST::SendNode
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/csend_node.rb#9
  def send_type?; end
end

# A node extension for `def` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `def` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#8
class RuboCop::AST::DefNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::MethodIdentifierPredicates

  # Checks whether this method definition node forwards its arguments
  # as per the feature added in Ruby 2.7.
  #
  # @note This is written in a way that may support lead arguments
  #   which are rumored to be added in a later version of Ruby.
  # @return [Boolean] whether the `def` node uses argument forwarding
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#26
  def argument_forwarding?; end

  # An array containing the arguments of the method definition.
  #
  # @return [Array<Node>] the arguments of the method definition
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#40
  def arguments; end

  # The body of the method definition.
  #
  # @note this can be either a `begin` node, if the method body contains
  #   multiple expressions, or any other node, if it contains a single
  #   expression.
  # @return [Node] the body of the method definition
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#51
  def body; end

  # @return [Boolean] if the definition is without an `end` or not.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#63
  def endless?; end

  # The name of the defined method as a symbol.
  #
  # @return [Symbol] the name of the defined method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#33
  def method_name; end

  # The receiver of the method definition, if any.
  #
  # @return [Node, nil] the receiver of the method definition, or `nil`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#58
  def receiver; end

  # Checks whether this node body is a void context.
  #
  # @return [Boolean] whether the `def` node body is a void context
  #
  # source://rubocop-ast//lib/rubocop/ast/node/def_node.rb#15
  def void_context?; end
end

# A node extension for `defined?` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `send` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/defined_node.rb#8
class RuboCop::AST::DefinedNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # source://rubocop-ast//lib/rubocop/ast/node/defined_node.rb#16
  def arguments; end

  # source://rubocop-ast//lib/rubocop/ast/node/defined_node.rb#12
  def node_parts; end
end

# Common functionality for primitive literal nodes: `sym`, `str`,
# `int`, `float`, ...
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#7
module RuboCop::AST::Descendence
  # Returns an array of child nodes.
  # This is a shorthand for `node.each_child_node.to_a`.
  #
  # @return [Array<Node>] an array of child nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#38
  def child_nodes; end

  # Returns an array of descendant nodes.
  # This is a shorthand for `node.each_descendant.to_a`.
  #
  # @return [Array<Node>] an array of descendant nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#72
  def descendants; end

  # Calls the given block for each child node.
  # If no block is given, an `Enumerator` is returned.
  #
  # Note that this is different from `node.children.each { |child| ... }`
  # which yields all children including non-node elements.
  #
  # @overload each_child_node
  # @overload each_child_node
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  # @yieldparam node [Node] each child node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#22
  def each_child_node(*types); end

  # Calls the given block for each descendant node with depth first order.
  # If no block is given, an `Enumerator` is returned.
  #
  # @overload each_descendant
  # @overload each_descendant
  # @overload each_descendant
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  # @yieldparam node [Node] each descendant node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#60
  def each_descendant(*types, &block); end

  # Calls the given block for the receiver and each descendant node in
  # depth-first order.
  # If no block is given, an `Enumerator` is returned.
  #
  # This method would be useful when you treat the receiver node as the root
  # of a tree and want to iterate over all nodes in the tree.
  #
  # @overload each_node
  # @overload each_node
  # @overload each_node
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  # @yieldparam node [Node] each node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#95
  def each_node(*types, &block); end

  protected

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/descendence.rb#107
  def visit_descendants(types, &block); end
end

# A node extension for `dstr` nodes. This will be used
# in place of a plain node when the builder constructs the AST, making
# its methods available to all `dstr` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/dstr_node.rb#8
class RuboCop::AST::DstrNode < ::RuboCop::AST::StrNode
  # source://rubocop-ast//lib/rubocop/ast/node/dstr_node.rb#9
  def value; end
end

# A node extension for `ensure` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `ensure` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#8
class RuboCop::AST::EnsureNode < ::RuboCop::AST::Node
  # Returns the body of the `ensure` clause.
  #
  # @deprecated Use `EnsureNode#branch`
  # @return [Node, nil] The body of the `ensure`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#16
  def body; end

  # Returns an the ensure branch in the exception handling statement.
  #
  # @return [Node, nil] the body of the ensure branch.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#33
  def branch; end

  # Returns the `rescue` node of the `ensure`, if present.
  #
  # @return [Node, nil] The `rescue` node.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#40
  def rescue_node; end

  # Checks whether this node body is a void context.
  # Always `true` for `ensure`.
  #
  # @return [true] whether the `ensure` node body is a void context
  #
  # source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#48
  def void_context?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/ensure_node.rb#9
RuboCop::AST::EnsureNode::DEPRECATION_WARNING_LOCATION_CACHE = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/ext/range.rb#5
module RuboCop::AST::Ext; end

# Extensions to Parser::AST::Range
#
# source://rubocop-ast//lib/rubocop/ast/ext/range.rb#7
module RuboCop::AST::Ext::Range
  # If `exclude_end` is `true`, then the range will be exclusive.
  #
  # Assume that `node` corresponds to the following array literal:
  #
  #   [
  #     :foo,
  #     :bar
  #   ]
  #
  #   node.loc.begin.line_span                       # => 1..1
  #   node.source_range.line_span(exclude_end: true) # => 1...4
  #
  # @return [Range] the range of line numbers for the node
  #
  # source://rubocop-ast//lib/rubocop/ast/ext/range.rb#20
  def line_span(exclude_end: T.unsafe(nil)); end
end

# A node extension for `float` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available to
# all `float` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/float_node.rb#8
class RuboCop::AST::FloatNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode
  include ::RuboCop::AST::NumericNode
end

# A node extension for `for` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `for` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#8
class RuboCop::AST::ForNode < ::RuboCop::AST::Node
  # Returns the body of the `for` loop.
  #
  # @return [Node, nil] The body of the `for` loop.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#48
  def body; end

  # Returns the collection the `for` loop is iterating over.
  #
  # @return [Node] The collection the `for` loop is iterating over
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#41
  def collection; end

  # Checks whether the `for` node has a `do` keyword.
  #
  # @return [Boolean] whether the `for` node has a `do` keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#19
  def do?; end

  # Returns the keyword of the `for` statement as a string.
  #
  # @return [String] the keyword of the `until` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#12
  def keyword; end

  # Returns the iteration variable of the `for` loop.
  #
  # @return [Node] The iteration variable of the `for` loop
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#34
  def variable; end

  # Checks whether this node body is a void context.
  # Always `true` for `for`.
  #
  # @return [true] whether the `for` node body is a void context
  #
  # source://rubocop-ast//lib/rubocop/ast/node/for_node.rb#27
  def void_context?; end
end

# A node extension for `forward-args` nodes. This will be used in place
# of a plain node when the builder constructs the AST, making its methods
# available to all `forward-args` nodes within RuboCop.
#
# Not used with modern emitters:
#
#   $ ruby-parse -e "def foo(...); end"
#   (def :foo
#     (args
#       (forward-arg)) nil)
#   $ ruby-parse --legacy -e "->(foo) { bar }"
#   (def :foo
#     (forward-args) nil)
#
# Note the extra 's' with legacy form.
#
# The main RuboCop runs in legacy mode; this node is only used
# if user `AST::Builder.modernize` or `AST::Builder.emit_lambda=true`
#
# source://rubocop-ast//lib/rubocop/ast/node/forward_args_node.rb#23
class RuboCop::AST::ForwardArgsNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::CollectionNode

  # Node wraps itself in an array to be compatible with other
  # enumerable argument types.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/forward_args_node.rb#28
  def to_a; end
end

# Common functionality for nodes that can be used as hash elements:
# `pair`, `kwsplat`
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#7
module RuboCop::AST::HashElementNode
  # Returns the delta between this element's delimiter and the argument's.
  #
  # @note Pairs with different delimiter styles return a delta of 0
  # @return [Integer] the delta between the two delimiters
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#61
  def delimiter_delta(other); end

  # Returns the key of this `hash` element.
  #
  # @note For keyword splats, this returns the whole node
  # @return [Node] the key of the hash element
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#13
  def key; end

  # Returns the delta between this pair's key and the argument pair's.
  #
  # @note Keys on the same line always return a delta of 0
  # @note Keyword splats always return a delta of 0 for right alignment
  # @param alignment [Symbol] whether to check the left or right side
  # @return [Integer] the delta between the two keys
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#43
  def key_delta(other, alignment = T.unsafe(nil)); end

  # Checks whether this `hash` element is on the same line as `other`.
  #
  # @note A multiline element is considered to be on the same line if it
  #   shares any of its lines with `other`
  # @return [Boolean] whether this element is on the same line as `other`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#32
  def same_line?(other); end

  # Returns the value of this `hash` element.
  #
  # @note For keyword splats, this returns the whole node
  # @return [Node] the value of the hash element
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#22
  def value; end

  # Returns the delta between this element's value and the argument's.
  #
  # @note Keyword splats always return a delta of 0
  # @return [Integer] the delta between the two values
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#52
  def value_delta(other); end
end

# A helper class for comparing the positions of different parts of a
# `pair` node.
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#67
class RuboCop::AST::HashElementNode::HashElementDelta
  # @raise [ArgumentError]
  # @return [HashElementDelta] a new instance of HashElementDelta
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#68
  def initialize(first, second); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#89
  def delimiter_delta; end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#75
  def key_delta(alignment = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#82
  def value_delta; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#108
  def delta(first, second, alignment = T.unsafe(nil)); end

  # Returns the value of attribute first.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#98
  def first; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#119
  def keyword_splat?; end

  # Returns the value of attribute second.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#98
  def second; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/hash_element_node.rb#100
  def valid_argument_types?; end
end

# A node extension for `hash` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `hash` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#8
class RuboCop::AST::HashNode < ::RuboCop::AST::Node
  # Checks whether the `hash` literal is delimited by curly braces.
  #
  # @return [Boolean] whether the `hash` literal is enclosed in braces
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#117
  def braces?; end

  # Calls the given block for each `key` node in the `hash` literal.
  # If no block is given, an `Enumerator` is returned.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#59
  def each_key(&block); end

  # Calls the given block for each `pair` node in the `hash` literal.
  # If no block is given, an `Enumerator` is returned.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#33
  def each_pair; end

  # Calls the given block for each `value` node in the `hash` literal.
  # If no block is given, an `Enumerator` is returned.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#83
  def each_value(&block); end

  # Checks whether the `hash` node contains any `pair`- or `kwsplat` nodes.
  #
  # @return[Boolean] whether the `hash` is empty
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#22
  def empty?; end

  # Returns an array of all the keys in the `hash` literal.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [Array<Node>] an array of keys in the `hash` literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#48
  def keys; end

  # Checks whether this `hash` uses a mix of hash rocket and colon
  # delimiters for its pairs.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [Boolean] whether the `hash` uses mixed delimiters
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#110
  def mixed_delimiters?; end

  # Returns an array of all the key value pairs in the `hash` literal.
  #
  # ignored.
  #
  # @note this may be different from children as `kwsplat` nodes are
  # @return [Array<PairNode>] an array of `pair` nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#15
  def pairs; end

  # Checks whether any of the key value pairs in the `hash` literal are on
  # the same line.
  #
  # @note A multiline `pair` is considered to be on the same line if it
  #   shares any of its lines with another `pair`
  # @note `kwsplat` nodes are ignored.
  # @return [Boolean] whether any `pair` nodes are on the same line
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#100
  def pairs_on_same_line?; end

  # Returns an array of all the values in the `hash` literal.
  #
  # @note `kwsplat` nodes are ignored.
  # @return [Array<Node>] an array of values in the `hash` literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/hash_node.rb#72
  def values; end
end

# A node extension for `if` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `if` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#8
class RuboCop::AST::IfNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConditionalNode
  include ::RuboCop::AST::ModifierNode

  # Returns an array of all the branches in the conditional statement.
  #
  # @return [Array<Node>] an array of branch nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#154
  def branches; end

  # @deprecated Use `branches.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#171
  def each_branch(&block); end

  # Checks whether the `if` node has an `else` clause.
  #
  # @note This returns `true` for nodes containing an `elsif` clause.
  #   This is legacy behavior, and many cops rely on it.
  # @return [Boolean] whether the node has an `else` clause
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#49
  def else?; end

  # Returns the branch of the `if` node that gets evaluated when its
  # condition is falsey.
  #
  # @note This is normalized for `unless` nodes.
  # @return [Node] the falsey branch node of the `if` node
  # @return [nil] when there is no else branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#133
  def else_branch; end

  # Checks whether the `if` is an `elsif`. Parser handles these by nesting
  # `if` nodes in the `else` branch.
  #
  # @return [Boolean] whether the node is an `elsif`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#39
  def elsif?; end

  # Checks whether the `if` node has at least one `elsif` branch. Returns
  # true if this `if` node itself is an `elsif`.
  #
  # @return [Boolean] whether the `if` node has at least one `elsif` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#111
  def elsif_conditional?; end

  # Checks whether this node is an `if` statement. (This is not true of
  # ternary operators and `unless` statements.)
  #
  # @return [Boolean] whether the node is an `if` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#16
  def if?; end

  # Returns the branch of the `if` node that gets evaluated when its
  # condition is truthy.
  #
  # @note This is normalized for `unless` nodes.
  # @return [Node] the truthy branch node of the `if` node
  # @return [nil] if the truthy branch is empty
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#122
  def if_branch; end

  # Returns the inverse keyword of the `if` node as a string. Returns `if`
  # for `unless` nodes and vice versa. Returns an empty string for ternary
  # operators.
  #
  # @return [String] the inverse keyword of the `if` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#73
  def inverse_keyword; end

  # Returns the keyword of the `if` statement as a string. Returns an empty
  # string for ternary operators.
  #
  # @return [String] the keyword of the `if` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#64
  def keyword; end

  # Checks whether the `if` node is in a modifier form, i.e. a condition
  # trailing behind an expression. Only `if` and `unless` nodes without
  # other branches can be modifiers.
  #
  # @return [Boolean] whether the `if` node is a modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#87
  def modifier_form?; end

  # Checks whether the `if` node has nested `if` nodes in any of its
  # branches.
  #
  # @note This performs a shallow search.
  # @return [Boolean] whether the `if` node contains nested conditionals
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#97
  def nested_conditional?; end

  # Custom destructuring method. This is used to normalize the branches
  # for `if` and `unless` nodes, to aid comparisons and conversions.
  #
  # @return [Array<Node>] the different parts of the `if` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#141
  def node_parts; end

  # Checks whether the `if` node is a ternary operator.
  #
  # @return [Boolean] whether the `if` node is a ternary operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#56
  def ternary?; end

  # Checks whether the `if` node has an `then` clause.
  #
  # @return [Boolean] whether the node has an `then` clause
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#31
  def then?; end

  # Checks whether this node is an `unless` statement. (This is not true
  # of ternary operators and `if` statements.)
  #
  # @return [Boolean] whether the node is an `unless` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/if_node.rb#24
  def unless?; end
end

# A node extension for `in` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `in` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/in_pattern_node.rb#8
class RuboCop::AST::InPatternNode < ::RuboCop::AST::Node
  # Returns the body of the `in` node.
  #
  # @return [Node, nil] the body of the `in` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/in_pattern_node.rb#33
  def body; end

  # Returns the index of the `in` branch within the `case` statement.
  #
  # @return [Integer] the index of the `in` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/in_pattern_node.rb#19
  def branch_index; end

  # Returns a node of the pattern in the `in` branch.
  #
  # @return [Node] a pattern node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/in_pattern_node.rb#12
  def pattern; end

  # Checks whether the `in` node has a `then` keyword.
  #
  # @return [Boolean] whether the `in` node has a `then` keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/in_pattern_node.rb#26
  def then?; end
end

# Used for modern support only!
# Not as thoroughly tested as legacy equivalent
#
#   $ ruby-parse -e "foo[:bar]"
#   (index
#     (send nil :foo)
#     (sym :bar))
#   $ ruby-parse --legacy -e "foo[:bar]"
#   (send
#     (send nil :foo) :[]
#     (sym :bar))
#
# The main RuboCop runs in legacy mode; this node is only used
# if user `AST::Builder.modernize` or `AST::Builder.emit_index=true`
#
# source://rubocop-ast//lib/rubocop/ast/node/index_node.rb#19
class RuboCop::AST::IndexNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::RestArguments
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/index_node.rb#29
  def assignment_method?; end

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/index_node.rb#24
  def attribute_accessor?; end

  # For similarity with legacy mode
  #
  # source://rubocop-ast//lib/rubocop/ast/node/index_node.rb#34
  def method_name; end

  private

  # An array containing the arguments of the dispatched method.
  #
  # @return [Array<Node>] the arguments of the dispatched method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/index_node.rb#43
  def first_argument_index; end
end

# Used for modern support only!
# Not as thoroughly tested as legacy equivalent
#
#   $ ruby-parse -e "foo[:bar] = :baz"
#   (indexasgn
#     (send nil :foo)
#     (sym :bar)
#     (sym :baz))
#   $ ruby-parse --legacy -e "foo[:bar] = :baz"
#   (send
#     (send nil :foo) :[]=
#     (sym :bar)
#     (sym :baz))
#
# The main RuboCop runs in legacy mode; this node is only used
# if user `AST::Builder.modernize` or `AST::Builder.emit_index=true`
#
# source://rubocop-ast//lib/rubocop/ast/node/indexasgn_node.rb#21
class RuboCop::AST::IndexasgnNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::RestArguments
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/indexasgn_node.rb#31
  def assignment_method?; end

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/indexasgn_node.rb#26
  def attribute_accessor?; end

  # For similarity with legacy mode
  #
  # source://rubocop-ast//lib/rubocop/ast/node/indexasgn_node.rb#36
  def method_name; end

  private

  # An array containing the arguments of the dispatched method.
  #
  # @return [Array<Node>] the arguments of the dispatched method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/indexasgn_node.rb#45
  def first_argument_index; end
end

# A node extension for `int` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available to
# all `int` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/int_node.rb#8
class RuboCop::AST::IntNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode
  include ::RuboCop::AST::NumericNode
end

# A node extension for `kwbegin` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `kwbegin` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/keyword_begin_node.rb#8
class RuboCop::AST::KeywordBeginNode < ::RuboCop::AST::Node
  # Returns the body of the `kwbegin` block. Returns `self` if the `kwbegin` contains
  # multiple nodes.
  #
  # @return [Node, nil] The body of the `kwbegin`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_begin_node.rb#13
  def body; end

  # Returns the `rescue` node of the `kwbegin` block, if one is present.
  #
  # @return [Node, nil] The `rescue` node within `kwbegin`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_begin_node.rb#30
  def ensure_node; end

  # Returns the `rescue` node of the `kwbegin` block, if one is present.
  #
  # @return [Node, nil] The `rescue` node within `kwbegin`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_begin_node.rb#37
  def rescue_node; end
end

# A node extension for `kwsplat` and `forwarded_kwrestarg` nodes. This will be used in
# place of a plain node when the builder constructs the AST, making its methods available to
# all `kwsplat` and `forwarded_kwrestarg` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#8
class RuboCop::AST::KeywordSplatNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::HashElementNode

  # This is used for duck typing with `pair` nodes which also appear as
  # `hash` elements.
  #
  # @return [false]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#26
  def colon?; end

  # This is used for duck typing with `pair` nodes which also appear as
  # `hash` elements.
  #
  # @return [false]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#18
  def hash_rocket?; end

  # This provides `forwarded_kwrestarg` node to return true to be compatible with `kwsplat` node.
  #
  # @return [true]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#48
  def kwsplat_type?; end

  # Custom destructuring method. This is used to normalize the branches
  # for `pair` and `kwsplat` nodes, to add duck typing to `hash` elements.
  #
  # @return [Array<KeywordSplatNode>] the different parts of the `kwsplat`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#41
  def node_parts; end

  # Returns the operator for the `kwsplat` as a string.
  #
  # @return [String] the double splat operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#33
  def operator; end
end

# source://rubocop-ast//lib/rubocop/ast/node/keyword_splat_node.rb#11
RuboCop::AST::KeywordSplatNode::DOUBLE_SPLAT = T.let(T.unsafe(nil), String)

# Used for modern support only:
# Not as thoroughly tested as legacy equivalent
#
#   $ ruby-parse -e "->(foo) { bar }"
#   (block
#     (lambda)
#     (args
#       (arg :foo))
#     (send nil :bar))
#   $ ruby-parse --legacy -e "->(foo) { bar }"
#   (block
#     (send nil :lambda)
#     (args
#       (arg :foo))
#     (send nil :bar))
#
# The main RuboCop runs in legacy mode; this node is only used
# if user `AST::Builder.modernize` or `AST::Builder.emit_lambda=true`
#
# source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#23
class RuboCop::AST::LambdaNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::RestArguments
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#43
  def assignment_method?; end

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#38
  def attribute_accessor?; end

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#28
  def lambda?; end

  # For similarity with legacy mode
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#33
  def lambda_literal?; end

  # For similarity with legacy mode
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#53
  def method_name; end

  # For similarity with legacy mode
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#48
  def receiver; end

  private

  # For similarity with legacy mode
  #
  # source://rubocop-ast//lib/rubocop/ast/node/lambda_node.rb#60
  def first_argument_index; end
end

# A node extension for `masgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#8
class RuboCop::AST::MasgnNode < ::RuboCop::AST::Node
  # @return [Array<Node>] the assignment nodes of the multiple assignment
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#16
  def assignments; end

  # The RHS (right hand side) of the multiple assignment. This returns
  # the nodes as parsed: either a single node if the RHS has a single value,
  # or an `array` node containing multiple nodes.
  #
  # NOTE: Due to how parsing works, `expression` will return the same for
  # `a, b = x, y` and `a, b = [x, y]`.
  #
  # @return [Node] the right hand side of a multiple assignment.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#39
  def expression; end

  # @return [MlhsNode] the `mlhs` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#10
  def lhs; end

  # @return [Array<Symbol>] names of all the variables being assigned
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#21
  def names; end

  # The RHS (right hand side) of the multiple assignment. This returns
  # the nodes as parsed: either a single node if the RHS has a single value,
  # or an `array` node containing multiple nodes.
  #
  # NOTE: Due to how parsing works, `expression` will return the same for
  # `a, b = x, y` and `a, b = [x, y]`.
  #
  # @return [Node] the right hand side of a multiple assignment.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#42
  def rhs; end

  # In contrast to `expression`, `values` always returns a Ruby array
  # containing all the nodes being assigned on the RHS.
  #
  # Literal arrays are considered a singular value; but unlike `expression`,
  # implied `array` nodes from assigning multiple values on the RHS are treated
  # as separate.
  #
  # @return [Array<Node>] individual values being assigned on the RHS of the multiple assignment
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#52
  def values; end

  private

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/masgn_node.rb#58
  def multiple_rhs?; end
end

# Common functionality for nodes that are a kind of method dispatch:
# `send`, `csend`, `super`, `zsuper`, `yield`, `defined?`,
# and (modern only): `index`, `indexasgn`, `lambda`
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#8
module RuboCop::AST::MethodDispatchNode
  include ::RuboCop::AST::MethodIdentifierPredicates
  extend ::RuboCop::AST::NodePattern::Macros

  # Checks whether the dispatched method is an access modifier.
  #
  # @return [Boolean] whether the dispatched method is an access modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#64
  def access_modifier?; end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#272
  def adjacent_def_modifier?(param0 = T.unsafe(nil)); end

  # Checks whether this node is an arithmetic operation
  #
  # @return [Boolean] whether the dispatched method is an arithmetic
  #   operation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#175
  def arithmetic_operation?; end

  # Checks whether the dispatched method is a setter method.
  #
  # @return [Boolean] whether the dispatched method is a setter
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#110
  def assignment?; end

  # Checks whether the dispatched method is a bare access modifier that
  # affects all methods defined after the macro.
  #
  # @return [Boolean] whether the dispatched method is a bare
  #   access modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#73
  def bare_access_modifier?; end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#277
  def bare_access_modifier_declaration?(param0 = T.unsafe(nil)); end

  # Checks whether this is a binary operation.
  #
  # @example
  #
  #   foo + bar
  # @return [Boolean] whether this method is a binary operation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#247
  def binary_operation?; end

  # Whether this method dispatch has an explicit block.
  #
  # @return [Boolean] whether the dispatched method has a block
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#167
  def block_literal?; end

  # The `block`, `numblock`, or `itblock` node associated with this method dispatch, if any.
  #
  # @return [BlockNode, nil] the `block`, `numblock`, or `itblock` node associated with this
  #   method call or `nil`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#46
  def block_node; end

  # Checks whether the name of the dispatched method matches the argument
  # and has an implicit receiver.
  #
  # @param name [Symbol, String] the method name to check for
  # @return [Boolean] whether the method name matches the argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#100
  def command?(name); end

  # Checks whether the *explicit* receiver of this method dispatch is a
  # `const` node.
  #
  # @return [Boolean] whether the receiver of this method dispatch
  #   is a `const` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#152
  def const_receiver?; end

  # Checks if this node is part of a chain of `def` or `defs` modifiers.
  #
  # or `nil` if it isn't a def modifier
  #
  # @example
  #
  #   private def foo; end
  # @return [Node | nil] returns the `def|defs` node this is a modifier for,
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#199
  def def_modifier(node = T.unsafe(nil)); end

  # Checks if this node is part of a chain of `def` or `defs` modifiers.
  #
  # See also `def_modifier` that returns the node or `nil`
  #
  # @example
  #
  #   private def foo; end
  # @return [Boolean] whether the `def|defs` node is a modifier or not.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#187
  def def_modifier?(node = T.unsafe(nil)); end

  # Checks whether the dispatched method uses a dot to connect the
  # receiver and the method name.
  #
  # This is useful for comparison operators, which can be called either
  # with or without a dot, i.e. `foo == bar` or `foo.== bar`.
  #
  # @return [Boolean] whether the method was called with a connecting dot
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#119
  def dot?; end

  # Checks whether the dispatched method uses a double colon to connect the
  # receiver and the method name.
  #
  # @return [Boolean] whether the method was called with a connecting dot
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#127
  def double_colon?; end

  # Checks whether the method dispatch is the implicit form of `#call`,
  # e.g. `foo.(bar)`.
  #
  # @return [Boolean] whether the method is the implicit form of `#call`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#160
  def implicit_call?; end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#256
  def in_macro_scope?(param0 = T.unsafe(nil)); end

  # Checks whether this is a lambda. Some versions of parser parses
  # non-literal lambdas as a method send.
  #
  # @return [Boolean] whether this method is a lambda
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#212
  def lambda?; end

  # Checks whether this is a lambda literal (stabby lambda.)
  #
  # @example
  #
  #   -> (foo) { bar }
  # @return [Boolean] whether this method is a lambda literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#223
  def lambda_literal?; end

  # Checks whether the dispatched method is a macro method. A macro method
  # is defined as a method that sits in a class, module, or block body and
  # has an implicit receiver.
  #
  # @note This does not include DSLs that use nested blocks, like RSpec
  # @return [Boolean] whether the dispatched method is a macro method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#57
  def macro?; end

  # The name of the dispatched method as a symbol.
  #
  # @return [Symbol] the name of the dispatched method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#27
  def method_name; end

  # Checks whether the dispatched method is a non-bare access modifier that
  # affects only the method it receives.
  #
  # @return [Boolean] whether the dispatched method is a non-bare
  #   access modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#82
  def non_bare_access_modifier?; end

  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#282
  def non_bare_access_modifier_declaration?(param0 = T.unsafe(nil)); end

  # The receiving node of the method dispatch.
  #
  # @return [Node, nil] the receiver of the dispatched method or `nil`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#20
  def receiver; end

  # Checks whether the dispatched method uses a safe navigation operator to
  # connect the receiver and the method name.
  #
  # @return [Boolean] whether the method was called with a connecting dot
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#135
  def safe_navigation?; end

  # The source range for the method name or keyword that dispatches this call.
  #
  # @return [Parser::Source::Range] the source range for the method name or keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#34
  def selector; end

  # Checks whether the *explicit* receiver of this method dispatch is
  # `self`.
  #
  # @return [Boolean] whether the receiver of this method dispatch is `self`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#143
  def self_receiver?; end

  # Checks whether the dispatched method is a setter method.
  #
  # @return [Boolean] whether the dispatched method is a setter
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#107
  def setter_method?; end

  # Checks whether the dispatched method is a bare `private` or `protected`
  # access modifier that affects all methods defined after the macro.
  #
  # @return [Boolean] whether the dispatched method is a bare
  #   `private` or `protected` access modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#91
  def special_modifier?; end

  # Checks whether this is a unary operation.
  #
  # @example
  #
  #   -foo
  # @return [Boolean] whether this method is a unary operation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#234
  def unary_operation?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#12
RuboCop::AST::MethodDispatchNode::ARITHMETIC_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_dispatch_node.rb#14
RuboCop::AST::MethodDispatchNode::SPECIAL_MODIFIERS = T.let(T.unsafe(nil), Array)

# Common predicates for nodes that reference method identifiers:
# `send`, `csend`, `def`, `defs`, `super`, `zsuper`
#
# @note this mixin expects `#method_name` and `#receiver` to be implemented
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#9
module RuboCop::AST::MethodIdentifierPredicates
  # Checks whether the method is an assignment method.
  #
  # @return [Boolean] whether the method is an assignment
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#142
  def assignment_method?; end

  # Checks whether the method is a bang method.
  #
  # @return [Boolean] whether the method is a bang method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#171
  def bang_method?; end

  # Checks whether the method is a camel case method,
  # e.g. `Integer()`.
  #
  # @return [Boolean] whether the method is a camel case method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#179
  def camel_case_method?; end

  # Checks whether the method is a comparison method.
  #
  # @return [Boolean] whether the method is a comparison
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#135
  def comparison_method?; end

  # Checks whether the *explicit* receiver of node is a `const` node.
  #
  # @return [Boolean] whether the receiver of this node is a `const` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#193
  def const_receiver?; end

  # Checks whether the method is an Enumerable method.
  #
  # @return [Boolean] whether the method is an Enumerable method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#157
  def enumerable_method?; end

  # Checks whether the method is an enumerator method.
  #
  # @return [Boolean] whether the method is an enumerator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#149
  def enumerator_method?; end

  # Checks whether the method name matches the argument.
  #
  # @param name [Symbol, String] the method name to check for
  # @return [Boolean] whether the method name matches the argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#79
  def method?(name); end

  # Checks whether this is a negation method, i.e. `!` or keyword `not`.
  #
  # @return [Boolean] whether this method is a negation method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#200
  def negation_method?; end

  # Checks whether the method is a nonmutating Array method.
  #
  # @return [Boolean] whether the method is a nonmutating Array method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#114
  def nonmutating_array_method?; end

  # Checks whether the method is a nonmutating binary operator method.
  #
  # @return [Boolean] whether the method is a nonmutating binary operator method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#93
  def nonmutating_binary_operator_method?; end

  # Checks whether the method is a nonmutating Hash method.
  #
  # @return [Boolean] whether the method is a nonmutating Hash method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#121
  def nonmutating_hash_method?; end

  # Checks whether the method is a nonmutating operator method.
  #
  # @return [Boolean] whether the method is a nonmutating operator method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#107
  def nonmutating_operator_method?; end

  # Checks whether the method is a nonmutating String method.
  #
  # @return [Boolean] whether the method is a nonmutating String method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#128
  def nonmutating_string_method?; end

  # Checks whether the method is a nonmutating unary operator method.
  #
  # @return [Boolean] whether the method is a nonmutating unary operator method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#100
  def nonmutating_unary_operator_method?; end

  # Checks whether the method is an operator method.
  #
  # @return [Boolean] whether the method is an operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#86
  def operator_method?; end

  # Checks whether the method is a predicate method.
  #
  # @return [Boolean] whether the method is a predicate method
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#164
  def predicate_method?; end

  # Checks whether this is a prefix bang method, e.g. `!foo`.
  #
  # @return [Boolean] whether this method is a prefix bang
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#214
  def prefix_bang?; end

  # Checks whether this is a prefix not method, e.g. `not foo`.
  #
  # @return [Boolean] whether this method is a prefix not
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#207
  def prefix_not?; end

  # Checks whether the *explicit* receiver of this node is `self`.
  #
  # @return [Boolean] whether the receiver of this node is `self`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#186
  def self_receiver?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#16
RuboCop::AST::MethodIdentifierPredicates::ENUMERABLE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#10
RuboCop::AST::MethodIdentifierPredicates::ENUMERATOR_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#32
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_ARRAY_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#24
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_BINARY_OPERATOR_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#48
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_HASH_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#28
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_OPERATOR_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#59
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_STRING_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#26
RuboCop::AST::MethodIdentifierPredicates::NONMUTATING_UNARY_OPERATOR_METHODS = T.let(T.unsafe(nil), Set)

# http://phrogz.net/programmingruby/language.html#table_18.4
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/method_identifier_predicates.rb#20
RuboCop::AST::MethodIdentifierPredicates::OPERATOR_METHODS = T.let(T.unsafe(nil), Set)

# A node extension for `mlhs` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/mlhs_node.rb#8
class RuboCop::AST::MlhsNode < ::RuboCop::AST::Node
  # Returns all the assignment nodes on the left hand side (LHS) of a multiple assignment.
  # These are generally assignment nodes (`lvasgn`, `ivasgn`, `cvasgn`, `gvasgn`, `casgn`)
  # but can also be `send` nodes in case of `foo.bar, ... =` or `foo[:bar], ... =`,
  # or a `splat` node for `*, ... =`.
  #
  # @return [Array<Node>] the assignment nodes of the multiple assignment LHS
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mlhs_node.rb#15
  def assignments; end
end

# Common functionality for nodes that can be used as modifiers:
# `if`, `while`, `until`
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/modifier_node.rb#7
module RuboCop::AST::ModifierNode
  # Checks whether the node is in a modifier form, i.e. a condition
  # trailing behind an expression.
  #
  # @return [Boolean] whether the node is a modifier
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/modifier_node.rb#12
  def modifier_form?; end
end

# A node extension for `module` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `module` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/module_node.rb#8
class RuboCop::AST::ModuleNode < ::RuboCop::AST::Node
  # The body of this `module` node.
  #
  # @return [Node, nil] the body of the module
  #
  # source://rubocop-ast//lib/rubocop/ast/node/module_node.rb#19
  def body; end

  # The identifier for this `module` node.
  #
  # @return [Node] the identifier of the module
  #
  # source://rubocop-ast//lib/rubocop/ast/node/module_node.rb#12
  def identifier; end
end

# A node extension for `next` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `next` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/next_node.rb#8
class RuboCop::AST::NextNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::WrappedArguments
end

# `RuboCop::AST::Node` is a subclass of `Parser::AST::Node`. It provides
# access to parent nodes and an object-oriented way to traverse an AST with
# the power of `Enumerable`.
#
# It has predicate methods for every node type, like this:
#
# @example
#   node.send_type?    # Equivalent to: `node.type == :send`
#   node.op_asgn_type? # Equivalent to: `node.type == :op_asgn`
#
#   # Non-word characters (other than a-zA-Z0-9_) in type names are omitted.
#   node.defined_type? # Equivalent to: `node.type == :defined?`
#
#   # Find the first lvar node under the receiver node.
#   lvar_node = node.each_descendant.find(&:lvar_type?)
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#21
class RuboCop::AST::Node < ::Parser::AST::Node
  include ::RuboCop::AST::Sexp
  include ::RuboCop::AST::Descendence
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [Node] a new instance of Node
  # @see https://www.rubydoc.info/gems/ast/AST/Node:initialize
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#148
  def initialize(type, children = T.unsafe(nil), properties = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def __ENCODING___type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def __FILE___type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def __LINE___type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def alias_type?; end

  # Returns an array of ancestor nodes.
  # This is a shorthand for `node.each_ancestor.to_a`.
  #
  # @return [Array<Node>] an array of ancestor nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#313
  def ancestors; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def and_asgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def and_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#542
  def any_block_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#522
  def any_def_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#546
  def any_match_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def arg_expr_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def arg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def args_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#518
  def argument?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#526
  def argument_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def array_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def array_pattern_with_tail_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def array_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#470
  def assignment?; end

  # Some cops treat the shovel operator as a kind of assignment.
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#420
  def assignment_or_similar?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def back_ref_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#474
  def basic_conditional?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#428
  def basic_literal?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def begin_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def block_pass_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def block_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def blockarg_expr_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def blockarg_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#530
  def boolean_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def break_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#510
  def call_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def case_match_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def case_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def casgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def cbase_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#514
  def chained?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#594
  def class_constructor?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#612
  def class_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def class_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#210
  def complete!; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#215
  def complete?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def complex_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#478
  def conditional?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#359
  def const_name; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def const_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def const_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def csend_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def cvar_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def cvasgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def def_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#379
  def defined_module; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#384
  def defined_module_name; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def defined_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def defs_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def dstr_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def dsym_type?; end

  # Calls the given block for each ancestor node from parent to root.
  # If no block is given, an `Enumerator` is returned.
  #
  # @overload each_ancestor
  # @overload each_ancestor
  # @overload each_ancestor
  # @return [self] if a block is given
  # @return [Enumerator] if no block is given
  # @yieldparam node [Node] each ancestor node
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#301
  def each_ancestor(*types, &block); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def eflipflop_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def empty_else_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#414
  def empty_source?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def ensure_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#462
  def equals_asgn?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def erange_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def false_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#436
  def falsey_literal?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def find_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#327
  def first_line; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def float_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def for_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def forward_arg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def forward_args_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def forwarded_args_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def forwarded_kwrestarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def forwarded_restarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#591
  def global_const?(param0 = T.unsafe(nil), param1); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#550
  def guard_clause?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def gvar_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def gvasgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def hash_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def hash_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def ident_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def if_guard_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def if_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def iflipflop_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#444
  def immutable_literal?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def in_match_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def in_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def index_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def indexasgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def int_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def irange_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def itarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def itblock_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def ivar_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def ivasgn_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#491
  def keyword?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwargs_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwbegin_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwnilarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwoptarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwrestarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def kwsplat_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#585
  def lambda?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#588
  def lambda_or_proc?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def lambda_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#331
  def last_line; end

  # Use is discouraged, this is a potentially slow method and can lead
  # to even slower algorithms
  #
  # @return [Node, nil] the left (aka previous) sibling
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#253
  def left_sibling; end

  # Use is discouraged, this is a potentially slow method and can lead
  # to even slower algorithms
  #
  # @return [Array<Node>] the left (aka previous) siblings
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#263
  def left_siblings; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#335
  def line_count; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#424
  def literal?; end

  # Shortcut to safely check if a location is present
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#558
  def loc?(which_loc); end

  # Shortcut to safely test a particular location, even if
  # this location does not exist or is `nil`
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#566
  def loc_is?(which_loc, str); end

  # NOTE: `loop { }` is a normal method call and thus not a loop keyword.
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#487
  def loop_keyword?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def lvar_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def lvasgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def masgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_alt_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_as_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_current_line_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#573
  def match_guard_clause?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_nil_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_pattern_p_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_pattern_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_rest_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_var_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_with_lvasgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def match_with_trailing_comma_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def mlhs_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#619
  def module_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def module_type?; end

  # Predicates
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#406
  def multiline?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#440
  def mutable_literal?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#750
  def new_class_or_module_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def next_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def nil_type?; end

  # Common destructuring method. This can be used to normalize
  # destructuring for different variations of the node.
  # Some node types override this with their own custom
  # destructuring method.
  #
  # @return [Array<Node>] the different parts of the ndde
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#284
  def node_parts; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#341
  def nonempty_line_count; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def not_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def nth_ref_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def numargs_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def numblock_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#534
  def numeric_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def objc_kwarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def objc_restarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def objc_varargs_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def op_asgn_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#502
  def operator_keyword?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def optarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def or_asgn_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def or_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def pair_type?; end

  # Returns the parent node, or `nil` if the receiver is a root node.
  #
  # @return [Node, nil] the parent node or `nil`
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#192
  def parent; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#201
  def parent?; end

  # Searching the AST
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#390
  def parent_module_name; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#506
  def parenthesized_call?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def pin_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#482
  def post_condition_loop?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def postexe_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def preexe_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#578
  def proc?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def procarg0_type?; end

  # Some expressions are evaluated for their value, some for their side
  # effects, and some for both.
  # If we know that expressions are useful only for their return values,
  # and have no side effects, that means we can reorder them, change the
  # number of times they are evaluated, or replace them with other
  # expressions which are equivalent in value.
  # So, is evaluation of this node free of side effects?
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#662
  def pure?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#538
  def range_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def rational_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#352
  def receiver(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#131
  def recursive_basic_literal?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#131
  def recursive_literal?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def redo_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#458
  def reference?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def regexp_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def regopt_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def resbody_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def rescue_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def restarg_expr_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def restarg_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def retry_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def return_type?; end

  # Use is discouraged, this is a potentially slow method and can lead
  # to even slower algorithms
  #
  # @return [Node, nil] the right (aka next) sibling
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#244
  def right_sibling; end

  # Use is discouraged, this is a potentially slow method and can lead
  # to even slower algorithms
  #
  # @return [Array<Node>] the right (aka next) siblings
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#272
  def right_siblings; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#206
  def root?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def sclass_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def self_type?; end

  # Most nodes are of 'send' type, so this method is defined
  # separately to make this check as fast as possible.
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#185
  def send_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def shadowarg_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#466
  def shorthand_asgn?; end

  # Returns the index of the receiver node in its siblings. (Sibling index
  # uses zero based numbering.)
  # Use is discouraged, this is a potentially slow method.
  #
  # @return [Integer, nil] the index of the receiver node in its siblings
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#237
  def sibling_index; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#410
  def single_line?; end

  # NOTE: Some rare nodes may have no source, like `s(:args)` in `foo {}`
  #
  # @return [String, nil]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#319
  def source; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#345
  def source_length; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#323
  def source_range; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#498
  def special_keyword?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def splat_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#357
  def str_content(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def str_type?; end

  # @deprecated Use `:class_constructor?`
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#607
  def struct_constructor?(param0 = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def super_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def sym_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def true_type?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#432
  def truthy_literal?; end

  # Determine if the node is one of several node types in a single query
  # Allows specific single node types, as well as "grouped" types
  # (e.g. `:boolean` for `:true` or `:false`)
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#167
  def type?(*types); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def undef_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def unless_guard_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def until_post_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def until_type?; end

  # Override `AST::Node#updated` so that `AST::Processor` does not try to
  # mutate our ASTs. Since we keep references from children to parents and
  # not just the other way around, we cannot update an AST and share
  # identical subtrees. Rather, the entire AST must be copied any time any
  # part of it is changed.
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#226
  def updated(type = T.unsafe(nil), children = T.unsafe(nil), properties = T.unsafe(nil)); end

  # Some expressions are evaluated for their value, some for their side
  # effects, and some for both
  # If we know that an expression is useful only for its side effects, that
  # means we can transform it in ways which preserve the side effects, but
  # change the return value
  # So, does the return value of this node matter? If we changed it to
  # `(...; nil)`, might that affect anything?
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#632
  def value_used?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#454
  def variable?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def when_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def while_post_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def while_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def xstr_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def yield_type?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#176
  def zsuper_type?; end

  protected

  # source://rubocop-ast//lib/rubocop/ast/node.rb#196
  def parent=(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#689
  def begin_value_used?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#700
  def case_if_value_used?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#370
  def defined_module0(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#694
  def for_value_used?; end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#736
  def parent_module_name_for_block(ancestor); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#724
  def parent_module_name_for_sclass(sclass_node); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#711
  def parent_module_name_part(node); end

  # source://rubocop-ast//lib/rubocop/ast/node.rb#680
  def visit_ancestors(types); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node.rb#706
  def while_until_value_used?; end

  class << self
    private

    # source://rubocop-ast//lib/rubocop/ast/node.rb#127
    def def_recursive_literal_predicate(kind); end
  end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#55
RuboCop::AST::Node::ASSIGNMENTS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#58
RuboCop::AST::Node::BASIC_CONDITIONALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#42
RuboCop::AST::Node::BASIC_LITERALS = T.let(T.unsafe(nil), Set)

# <=> isn't included here, because it doesn't return a boolean.
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#28
RuboCop::AST::Node::COMPARISON_OPERATORS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#39
RuboCop::AST::Node::COMPOSITE_LITERALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#60
RuboCop::AST::Node::CONDITIONALS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node.rb#84
RuboCop::AST::Node::EMPTY_CHILDREN = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node.rb#85
RuboCop::AST::Node::EMPTY_PROPERTIES = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#50
RuboCop::AST::Node::EQUALS_ASSIGNMENTS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#35
RuboCop::AST::Node::FALSEY_LITERALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#89
RuboCop::AST::Node::GROUP_FOR_TYPE = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#47
RuboCop::AST::Node::IMMUTABLE_LITERALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#70
RuboCop::AST::Node::KEYWORDS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#37
RuboCop::AST::Node::LITERALS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node.rb#80
RuboCop::AST::Node::LITERAL_RECURSIVE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node.rb#81
RuboCop::AST::Node::LITERAL_RECURSIVE_TYPES = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#64
RuboCop::AST::Node::LOOP_TYPES = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#44
RuboCop::AST::Node::MUTABLE_LITERALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#76
RuboCop::AST::Node::OPERATOR_KEYWORDS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#62
RuboCop::AST::Node::POST_CONDITION_LOOP_TYPES = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#68
RuboCop::AST::Node::REFERENCES = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#53
RuboCop::AST::Node::SHORTHAND_ASSIGNMENTS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#78
RuboCop::AST::Node::SPECIAL_KEYWORDS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#31
RuboCop::AST::Node::TRUTHY_LITERALS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node.rb#66
RuboCop::AST::Node::VARIABLES = T.let(T.unsafe(nil), Set)

# This class performs a pattern-matching operation on an AST node.
#
# Detailed syntax: /docs/modules/ROOT/pages/node_pattern.adoc
#
# Initialize a new `NodePattern` with `NodePattern.new(pattern_string)`, then
# pass an AST node to `NodePattern#match`. Alternatively, use one of the class
# macros in `NodePattern::Macros` to define your own pattern-matching method.
#
# If the match fails, `nil` will be returned. If the match succeeds, the
# return value depends on whether a block was provided to `#match`, and
# whether the pattern contained any "captures" (values which are extracted
# from a matching AST.)
#
# - With block: #match yields the captures (if any) and passes the return
#               value of the block through.
# - With no block, but one capture: the capture is returned.
# - With no block, but multiple captures: captures are returned as an array.
# - With no block and no captures: #match returns `true`.
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#5
class RuboCop::AST::NodePattern
  include ::RuboCop::AST::NodePattern::MethodDefiner
  extend ::RuboCop::SimpleForwardable

  # @return [NodePattern] a new instance of NodePattern
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#77
  def initialize(str, compiler: T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#90
  def ==(other); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#107
  def as_json(_options = T.unsafe(nil)); end

  # Returns the value of attribute ast.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#73
  def ast; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#75
  def captures(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#111
  def encode_with(coder); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#93
  def eql?(other); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#119
  def freeze; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#115
  def init_with(coder); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#103
  def marshal_dump; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#99
  def marshal_load(pattern); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#85
  def match(*args, **rest, &block); end

  # Returns the value of attribute match_code.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#73
  def match_code; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#75
  def named_parameters(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute pattern.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#73
  def pattern; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#75
  def positional_parameters(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#95
  def to_s; end

  class << self
    # Yields its argument and any descendants, depth-first.
    #
    # @yield [element]
    #
    # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#59
    def descend(element, &block); end
  end
end

# Responsible to build the AST nodes for `NodePattern`
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#10
class RuboCop::AST::NodePattern::Builder
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#17
  def emit_atom(type, value); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#29
  def emit_call(type, selector, args = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#11
  def emit_capture(capture_token, node); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#25
  def emit_list(type, _begin, children, _end); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#41
  def emit_subsequence(node_list); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#21
  def emit_unary_op(type, _operator = T.unsafe(nil), *children); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#34
  def emit_union(begin_t, pattern_lists, end_t); end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#53
  def n(type, *args); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#49
  def optimizable_as_set?(children); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/builder.rb#57
  def union_children(pattern_lists); end
end

# A NodePattern comment, simplified version of ::Parser::Source::Comment
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#7
class RuboCop::AST::NodePattern::Comment
  # @param range [Parser::Source::Range]
  # @return [Comment] a new instance of Comment
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#14
  def initialize(range); end

  # Compares comments. Two comments are equal if they
  # correspond to the same source range.
  #
  # @param other [Object]
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#31
  def ==(other); end

  # @return [String] a human-readable representation of this comment
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#39
  def inspect; end

  # Returns the value of attribute location.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#9
  def loc; end

  # Returns the value of attribute location.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#8
  def location; end

  # @return [String]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/comment.rb#20
  def text; end
end

# The top-level compiler holding the global state
# Defers work to its subcompilers
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#11
class RuboCop::AST::NodePattern::Compiler
  extend ::RuboCop::SimpleForwardable

  # @return [Compiler] a new instance of Compiler
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#15
  def initialize; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#24
  def bind(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute binding.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#13
  def binding; end

  # Returns the value of attribute captures.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#13
  def captures; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#42
  def compile_as_atom(node); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#46
  def compile_as_node_pattern(node, **options); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#50
  def compile_sequence(sequence, var:); end

  # Enumerates `enum` while keeping track of state across
  # union branches (captures and unification).
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#38
  def each_union(enum, &block); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#74
  def freeze; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#31
  def named_parameter(name); end

  # Returns the value of attribute named_parameters.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#13
  def named_parameters; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#70
  def next_capture; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#54
  def parser; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#26
  def positional_parameter(number); end

  # Returns the value of attribute positional_parameters.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#13
  def positional_parameters; end

  # Utilities
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#60
  def with_temp_variables(*names, &block); end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#81
  def enforce_same_captures(enum); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler.rb#96
  def new_capture; end
end

# Generates code that evaluates to a value (Ruby object)
# This value responds to `===`.
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#12
class RuboCop::AST::NodePattern::Compiler::AtomSubcompiler < ::RuboCop::AST::NodePattern::Compiler::Subcompiler
  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#28
  def visit_const; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#32
  def visit_named_parameter; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#24
  def visit_number; end

  # Assumes other types are node patterns.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#46
  def visit_other_type; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#36
  def visit_positional_parameter; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#26
  def visit_regexp; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#40
  def visit_set; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#25
  def visit_string; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#21
  def visit_symbol; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/atom_subcompiler.rb#15
  def visit_unify; end
end

# Holds the list of bound variable names
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/binding.rb#8
class RuboCop::AST::NodePattern::Compiler::Binding
  # @return [Binding] a new instance of Binding
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/binding.rb#9
  def initialize; end

  # Yields the first time a given name is bound
  #
  # @return [String] bound variable name
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/binding.rb#16
  def bind(name); end

  # Yields for each branch of the given union, forbidding unification of
  # bindings which only appear in a subset of the union.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/binding.rb#31
  def union_bind(enum); end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/binding.rb#69
  def forbid(names); end
end

# Variant of the Compiler with tracing information for nodes
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#10
class RuboCop::AST::NodePattern::Compiler::Debug < ::RuboCop::AST::NodePattern::Compiler
  # @return [Debug] a new instance of Debug
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#118
  def initialize; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#131
  def comments(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#123
  def named_parameters; end

  # Returns the value of attribute node_ids.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#35
  def node_ids; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#127
  def parser; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#131
  def tokens(*_arg0, **_arg1, &_arg2); end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#38
class RuboCop::AST::NodePattern::Compiler::Debug::Colorizer
  # @api private
  # @return [Colorizer] a new instance of Colorizer
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#98
  def initialize(pattern, compiler: T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#96
  def compiler; end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#96
  def node_pattern; end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#96
  def pattern; end

  # @api private
  # @return [Node] the Ruby AST
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#105
  def test(ruby, trace: T.unsafe(nil)); end

  private

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#113
  def ruby_ast(ruby); end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#39
RuboCop::AST::NodePattern::Compiler::Debug::Colorizer::COLOR_SCHEME = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#94
RuboCop::AST::NodePattern::Compiler::Debug::Colorizer::Compiler = RuboCop::AST::NodePattern::Compiler::Debug

# Result of a NodePattern run against a particular AST
# Consider constructor is private
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
class RuboCop::AST::NodePattern::Compiler::Debug::Colorizer::Result < ::Struct
  # @api private
  # @return [Hash] a map for {character_position => color}
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#58
  def color_map(color_scheme = T.unsafe(nil)); end

  # @api private
  # @return [String] a Rainbow colorized version of ruby
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#50
  def colorize(color_scheme = T.unsafe(nil)); end

  # Returns the value of attribute colorizer
  #
  # @return [Object] the current value of colorizer
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def colorizer; end

  # Sets the attribute colorizer
  #
  # @param value [Object] the value to set the attribute colorizer to.
  # @return [Object] the newly set value
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def colorizer=(_); end

  # @api private
  # @return [Hash] a map for {node => matched?}, depth-first
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#68
  def match_map; end

  # @api private
  # @return [Boolean] a value of `Trace#matched?` or `:not_visitable`
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#76
  def matched?(node); end

  # Returns the value of attribute returned
  #
  # @return [Object] the current value of returned
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def returned; end

  # Sets the attribute returned
  #
  # @param value [Object] the value to set the attribute returned to.
  # @return [Object] the newly set value
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def returned=(_); end

  # Returns the value of attribute ruby_ast
  #
  # @return [Object] the current value of ruby_ast
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def ruby_ast; end

  # Sets the attribute ruby_ast
  #
  # @param value [Object] the value to set the attribute ruby_ast to.
  # @return [Object] the newly set value
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def ruby_ast=(_); end

  # Returns the value of attribute trace
  #
  # @return [Object] the current value of trace
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def trace; end

  # Sets the attribute trace
  #
  # @param value [Object] the value to set the attribute trace to.
  # @return [Object] the newly set value
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
  def trace=(_); end

  private

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#89
  def ast; end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#83
  def color_map_for(node, color); end

  class << self
    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
    def [](*_arg0); end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
    def inspect; end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
    def keyword_init?; end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
    def members; end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#48
    def new(*_arg0); end
  end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#134
module RuboCop::AST::NodePattern::Compiler::Debug::InstrumentationSubcompiler
  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#135
  def do_compile; end

  private

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#145
  def node_id; end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#141
  def tracer(kind); end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#151
class RuboCop::AST::NodePattern::Compiler::Debug::NodePatternSubcompiler < ::RuboCop::AST::NodePattern::Compiler::NodePatternSubcompiler
  include ::RuboCop::AST::NodePattern::Compiler::Debug::InstrumentationSubcompiler
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#156
class RuboCop::AST::NodePattern::Compiler::Debug::SequenceSubcompiler < ::RuboCop::AST::NodePattern::Compiler::SequenceSubcompiler
  include ::RuboCop::AST::NodePattern::Compiler::Debug::InstrumentationSubcompiler
end

# Compiled node pattern requires a named parameter `trace`,
# which should be an instance of this class
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#13
class RuboCop::AST::NodePattern::Compiler::Debug::Trace
  # @return [Trace] a new instance of Trace
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#14
  def initialize; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#19
  def enter(node_id); end

  # return nil (not visited), false (not matched) or true (matched)
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#30
  def matched?(node_id); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/debug.rb#25
  def success(node_id); end
end

# Compiles code that evalues to true or false
# for a given value `var` (typically a RuboCop::AST::Node)
# or it's `node.type` if `seq_head` is true
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#13
class RuboCop::AST::NodePattern::Compiler::NodePatternSubcompiler < ::RuboCop::AST::NodePattern::Compiler::Subcompiler
  # @return [NodePatternSubcompiler] a new instance of NodePatternSubcompiler
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#16
  def initialize(compiler, var: T.unsafe(nil), access: T.unsafe(nil), seq_head: T.unsafe(nil)); end

  # Returns the value of attribute access.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#14
  def access; end

  # Returns the value of attribute seq_head.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#14
  def seq_head; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#119
  def access_element; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#123
  def access_node; end

  # @param [Array<Node>, nil]
  # @return [String, nil]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#113
  def compile_args(arg_list, first: T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#129
  def compile_guard_clause; end

  # Compiling helpers
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#107
  def compile_value_match(value); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#133
  def multiple_access(kind); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#30
  def visit_ascend; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#58
  def visit_capture; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#37
  def visit_descend; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#84
  def visit_function_call; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#73
  def visit_intersection; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#25
  def visit_negation; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#88
  def visit_node_type; end

  # Assumes other types are atoms.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#100
  def visit_other_type; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#80
  def visit_predicate; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#92
  def visit_sequence; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#49
  def visit_unify; end

  # Lists
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#64
  def visit_union; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/node_pattern_subcompiler.rb#45
  def visit_wildcard; end
end

# Compiles terms within a sequence to code that evalues to true or false.
# Compilation of the nodes that can match only a single term is deferred to
# `NodePatternSubcompiler`; only nodes that can match multiple terms are
# compiled here.
# Assumes the given `var` is a `::RuboCop::AST::Node`
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#17
class RuboCop::AST::NodePattern::Compiler::SequenceSubcompiler < ::RuboCop::AST::NodePattern::Compiler::Subcompiler
  # Calls `compile_sequence`; the actual `compile` method
  # will be used for the different terms of the sequence.
  # The only case of re-entrant call to `compile` is `visit_capture`
  #
  # @return [SequenceSubcompiler] a new instance of SequenceSubcompiler
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#25
  def initialize(compiler, sequence:, var:); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#31
  def compile_sequence; end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#251
  def in_sync; end

  protected

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#226
  def compile_terms(children = T.unsafe(nil), last_arity = T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#251
  def cur_index; end

  # yield `sync_code` iff not already in sync
  #
  # @yield [code]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#242
  def sync; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#59
  def compile(node); end

  # Compilation helpers
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#165
  def compile_and_advance(term); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#128
  def compile_any_order_branches(matched_var); end

  # @return [Array<String>] Else code, and init code (if any)
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#137
  def compile_any_order_else; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#180
  def compile_captured_repetition(child_code, child_captures); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#119
  def compile_case(when_branches, else_code); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#361
  def compile_child_nb_guard(arity_range); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#319
  def compile_cur_index; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#325
  def compile_index(cur = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#353
  def compile_loop(term); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#347
  def compile_loop_advance(to = T.unsafe(nil)); end

  # Assumes `@cur_index` is already updated
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#198
  def compile_matched(kind); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#304
  def compile_max_matched; end

  # @return [String] code that evaluates to `false` if the matched arity is too small
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#270
  def compile_min_check; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#285
  def compile_remaining; end

  # @return [Hash] of {subcompiler => code}
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#373
  def compile_union_forks; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#313
  def empty_loop; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#214
  def handle_prev; end

  # Modifies in place `forks`
  # Syncs our state
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#400
  def merge_forks!(forks); end

  # Modifies in place `forks` to insure that `cur_{child|index}_var` are ok
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#384
  def preserve_union_start(forks); end

  # E.g. For sequence `(_  _? <_ _>)`, arities are: 1, 0..1, 2
  # and remaining arities are: 3..4, 2..3, 2..2, 0..0
  #
  # @return [Array<Range>] total arities (as Ranges) of remaining children nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#259
  def remaining_arities(children, last_arity); end

  # returns truthy iff `@cur_index` switched to relative from end mode (i.e. < 0)
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#341
  def use_index_from_end; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#88
  def visit_any_order; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#150
  def visit_capture; end

  # Single node patterns are all handled here
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#62
  def visit_other_type; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#78
  def visit_repetition; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#159
  def visit_rest; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#104
  def visit_union; end

  # NOTE: assumes `@cur_index != :seq_head`. Node types using `within_loop` must
  # have `def in_sequence_head; :raise; end`
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#333
  def within_loop; end
end

# Shift of 1 from standard Ruby indices
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#18
RuboCop::AST::NodePattern::Compiler::SequenceSubcompiler::DELTA = T.let(T.unsafe(nil), Integer)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/sequence_subcompiler.rb#19
RuboCop::AST::NodePattern::Compiler::SequenceSubcompiler::POSITIVE = T.let(T.unsafe(nil), Proc)

# Base class for subcompilers
# Implements visitor pattern
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#12
class RuboCop::AST::NodePattern::Compiler::Subcompiler
  # @return [Subcompiler] a new instance of Subcompiler
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#15
  def initialize(compiler); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#20
  def compile(node); end

  # Returns the value of attribute compiler.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#13
  def compiler; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#34
  def do_compile; end

  # Returns the value of attribute node.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#32
  def node; end

  class << self
    # @private
    #
    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#47
    def inherited(base); end

    # @private
    #
    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#42
    def method_added(method); end

    # Returns the value of attribute registry.
    #
    # source://rubocop-ast//lib/rubocop/ast/node_pattern/compiler/subcompiler.rb#40
    def registry; end
  end
end

class RuboCop::AST::NodePattern::Invalid < ::StandardError; end

# Lexer class for `NodePattern`
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#18
class RuboCop::AST::NodePattern::Lexer < ::RuboCop::AST::NodePattern::LexerRex
  # @return [Lexer] a new instance of Lexer
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#31
  def initialize(source); end

  # Returns the value of attribute comments.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#29
  def comments; end

  # Returns the value of attribute source_buffer.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#29
  def source_buffer; end

  # Returns the value of attribute tokens.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#29
  def tokens; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#60
  def do_parse; end

  # @return [token]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#40
  def emit(type); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#48
  def emit_comment; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#52
  def emit_regexp; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#64
  def token(type, value); end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#19
RuboCop::AST::NodePattern::Lexer::Error = RuboCop::AST::NodePattern::LexerRex::ScanError

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rb#21
RuboCop::AST::NodePattern::Lexer::REGEXP_OPTIONS = T.let(T.unsafe(nil), Hash)

# The generated lexer RuboCop::AST::NodePattern::LexerRex
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#23
class RuboCop::AST::NodePattern::LexerRex
  # Yields on the current action.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#69
  def action; end

  # The file name / path
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#43
  def filename; end

  # The file name / path
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#43
  def filename=(_arg0); end

  # The current location in the parse.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#103
  def location; end

  # The StringScanner for this lexer.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#55
  def match; end

  # The match groups for the current scan.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#60
  def matches; end

  # Lex the next token.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#112
  def next_token; end

  # Parse the given string.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#83
  def parse(str); end

  # Read in and parse the file at +path+.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#93
  def parse_file(path); end

  # The current scanner class. Must be overridden in subclasses.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#76
  def scanner_class; end

  # The StringScanner for this lexer.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#48
  def ss; end

  # The StringScanner for this lexer.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#48
  def ss=(_arg0); end

  # The current lexical state.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#53
  def state; end

  # The current lexical state.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#53
  def state=(_arg0); end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#31
RuboCop::AST::NodePattern::LexerRex::CALL = T.let(T.unsafe(nil), Regexp)

# :stopdoc:
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#27
RuboCop::AST::NodePattern::LexerRex::CONST_NAME = T.let(T.unsafe(nil), Regexp)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#29
RuboCop::AST::NodePattern::LexerRex::IDENTIFIER = T.let(T.unsafe(nil), Regexp)

# :startdoc:
# :stopdoc:
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#36
class RuboCop::AST::NodePattern::LexerRex::LexerError < ::StandardError; end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#30
RuboCop::AST::NodePattern::LexerRex::NODE_TYPE = T.let(T.unsafe(nil), Regexp)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#33
RuboCop::AST::NodePattern::LexerRex::REGEXP = T.let(T.unsafe(nil), Regexp)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#32
RuboCop::AST::NodePattern::LexerRex::REGEXP_BODY = T.let(T.unsafe(nil), Regexp)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#28
RuboCop::AST::NodePattern::LexerRex::SYMBOL_NAME = T.let(T.unsafe(nil), Regexp)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/lexer.rex.rb#37
class RuboCop::AST::NodePattern::LexerRex::ScanError < ::RuboCop::AST::NodePattern::LexerRex::LexerError; end

# Helpers for defining methods based on a pattern string
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#28
module RuboCop::AST::NodePattern::Macros
  # Define a method which applies a pattern to an AST node
  #
  # The new method will return nil if the node does not match.
  # If the node matches, and a block is provided, the new method will
  # yield to the block (passing any captures as block arguments).
  # If the node matches, and no block is provided, the new method will
  # return the captures, or `true` if there were none.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#36
  def def_node_matcher(method_name, pattern_str, **keyword_defaults); end

  # Define a method which recurses over the descendants of an AST node,
  # checking whether any of them match the provided pattern
  #
  # If the method name ends with '?', the new method will return `true`
  # as soon as it finds a descendant which matches. Otherwise, it will
  # yield all descendants which match.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#46
  def def_node_search(method_name, pattern_str, **keyword_defaults); end
end

# Functionality to turn `match_code` into methods/lambda
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#7
module RuboCop::AST::NodePattern::MethodDefiner
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#37
  def as_lambda; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#27
  def compile_as_lambda; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#8
  def def_node_matcher(base, method_name, **defaults); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#21
  def def_node_search(base, method_name, **defaults); end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#139
  def compile_init; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#50
  def def_helper(base, method_name, **defaults); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#114
  def emit_keyword_list(forwarding: T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#132
  def emit_lambda_code; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#125
  def emit_method_code; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#63
  def emit_node_search(method_name); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#74
  def emit_node_search_body(method_name, prelude:, on_match:); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#110
  def emit_param_list; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#119
  def emit_params(*first, forwarding: T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#100
  def emit_retval; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#89
  def emit_yield_capture(when_no_capture = T.unsafe(nil), yield_with: T.unsafe(nil)); end

  # This method minimizes the closure for our method
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/method_definer.rb#44
  def wrapping_block(method_name, **defaults); end
end

# Base class for AST Nodes of a `NodePattern`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#7
class RuboCop::AST::NodePattern::Node < ::Parser::AST::Node
  include ::RuboCop::AST::Descendence
  extend ::RuboCop::SimpleForwardable

  # Note: `arity.end` may be `Float::INFINITY`
  #
  # @return [Integer, Range] An Integer for fixed length terms, otherwise a Range.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#28
  def arity; end

  # @return [Range] arity as a Range
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#68
  def arity_range; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#22
  def capture?; end

  # @return [Node] most nodes have only one child
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#47
  def child; end

  # @return [Array<Node>]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#42
  def children_nodes; end

  # @return [Array<Node>, nil] replace node with result, or `nil` if no change requested.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#33
  def in_sequence_head; end

  # that matches within a Set (e.g. `42`, `:sym` but not `/regexp/`)
  #
  # @return [Boolean] returns true for nodes having a Ruby literal equivalent
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#63
  def matches_within_set?; end

  # @return [Integer] nb of captures that this node will emit
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#52
  def nb_captures; end

  # To be overridden by subclasses
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#18
  def rest?; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#77
  def source_range; end

  # @return [Boolean] returns whether it matches a variable number of elements
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#57
  def variadic?; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#73
  def with(type: T.unsafe(nil), children: T.unsafe(nil), location: T.unsafe(nil)); end
end

# Node class for `<int str ...>`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#179
class RuboCop::AST::NodePattern::Node::AnyOrder < ::RuboCop::AST::NodePattern::Node
  include ::RuboCop::AST::NodePattern::Node::ForbidInSeqHead

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#197
  def arity; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#189
  def ends_with_rest?; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#193
  def rest_node; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#185
  def term_nodes; end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#182
RuboCop::AST::NodePattern::Node::AnyOrder::ARITIES = T.let(T.unsafe(nil), Hash)

# Node class for `$something`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#96
class RuboCop::AST::NodePattern::Node::Capture < ::RuboCop::AST::NodePattern::Node
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#98
  def arity(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#100
  def capture?; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#108
  def in_sequence_head; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#104
  def nb_captures; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#98
  def rest?(*_arg0, **_arg1, &_arg2); end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#85
module RuboCop::AST::NodePattern::Node::ForbidInSeqHead
  # @raise [NodePattern::Invalid]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#86
  def in_sequence_head; end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#139
RuboCop::AST::NodePattern::Node::FunctionCall = RuboCop::AST::NodePattern::Node::Predicate

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#81
RuboCop::AST::NodePattern::Node::INT_TO_RANGE = T.let(T.unsafe(nil), Hash)

# Registry
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#255
RuboCop::AST::NodePattern::Node::MAP = T.let(T.unsafe(nil), Hash)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#11
RuboCop::AST::NodePattern::Node::MATCHES_WITHIN_SET = T.let(T.unsafe(nil), Set)

# Node class for `predicate?(:arg, :list)`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#130
class RuboCop::AST::NodePattern::Node::Predicate < ::RuboCop::AST::NodePattern::Node
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#135
  def arg_list; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#131
  def method_name; end
end

# Node class for `int+`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#142
class RuboCop::AST::NodePattern::Node::Repetition < ::RuboCop::AST::NodePattern::Node
  include ::RuboCop::AST::NodePattern::Node::ForbidInSeqHead

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#155
  def arity; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#145
  def operator; end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#149
RuboCop::AST::NodePattern::Node::Repetition::ARITIES = T.let(T.unsafe(nil), Hash)

# Node class for `...`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#161
class RuboCop::AST::NodePattern::Node::Rest < ::RuboCop::AST::NodePattern::Node
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#169
  def arity; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#173
  def in_sequence_head; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#165
  def rest?; end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#162
RuboCop::AST::NodePattern::Node::Rest::ARITY = T.let(T.unsafe(nil), Range)

# Node class for `(type first second ...)`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#117
class RuboCop::AST::NodePattern::Node::Sequence < ::RuboCop::AST::NodePattern::Node
  include ::RuboCop::AST::NodePattern::Node::ForbidInSeqHead

  # @return [Sequence] a new instance of Sequence
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#120
  def initialize(type, children = T.unsafe(nil), properties = T.unsafe(nil)); end
end

# A list (potentially empty) of nodes; part of a Union
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#205
class RuboCop::AST::NodePattern::Node::Subsequence < ::RuboCop::AST::NodePattern::Node
  include ::RuboCop::AST::NodePattern::Node::ForbidInSeqHead

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#208
  def arity; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#213
  def in_sequence_head; end
end

# Node class for `{ ... }`
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#223
class RuboCop::AST::NodePattern::Node::Union < ::RuboCop::AST::NodePattern::Node
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#224
  def arity; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#231
  def in_sequence_head; end

  # Each child in a union must contain the same number
  # of captures. Only one branch ends up capturing.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/node.rb#249
  def nb_captures; end
end

# Parser for NodePattern
# Note: class reopened in `parser.racc`
#
# Doc on how this fits in the compiling process:
#   /docs/modules/ROOT/pages/node_pattern.adoc
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#12
class RuboCop::AST::NodePattern::Parser < ::Racc::Parser
  extend ::RuboCop::SimpleForwardable

  # @return [Parser] a new instance of Parser
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#19
  def initialize(builder = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#335
  def _reduce_10(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#339
  def _reduce_11(val, _values); end

  # reduce 12 omitted
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#345
  def _reduce_13(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#349
  def _reduce_14(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#353
  def _reduce_15(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#357
  def _reduce_16(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#361
  def _reduce_17(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#365
  def _reduce_18(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#369
  def _reduce_19(val, _values); end

  # reduce 1 omitted
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#303
  def _reduce_2(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#373
  def _reduce_20(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#377
  def _reduce_21(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#381
  def _reduce_22(val, _values); end

  # reduce 24 omitted
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#389
  def _reduce_25(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#395
  def _reduce_26(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#307
  def _reduce_3(val, _values); end

  # reduce 32 omitted
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#415
  def _reduce_33(val, _values); end

  # reduce 36 omitted
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#425
  def _reduce_37(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#429
  def _reduce_38(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#433
  def _reduce_39(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#311
  def _reduce_4(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#437
  def _reduce_40(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#441
  def _reduce_41(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#445
  def _reduce_42(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#449
  def _reduce_43(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#453
  def _reduce_44(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#457
  def _reduce_45(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#461
  def _reduce_46(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#315
  def _reduce_5(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#319
  def _reduce_6(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#323
  def _reduce_7(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#327
  def _reduce_8(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#331
  def _reduce_9(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#465
  def _reduce_none(val, _values); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_atom(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_call(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_capture(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_list(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_unary_op(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#46
  def emit_union(*_arg0, **_arg1, &_arg2); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#40
  def inspect; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#48
  def next_token(*_arg0, **_arg1, &_arg2); end

  # (Similar API to `parser` gem)
  # Parses a source and returns the AST.
  #
  # @param source_buffer [Parser::Source::Buffer, String] The source buffer to parse.
  # @return [NodePattern::Node]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#31
  def parse(source); end

  private

  # @raise [NodePattern::Invalid]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#50
  def enforce_unary(node); end

  # Overrides Racc::Parser's method:
  #
  # @raise [NodePattern::Invalid]
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#59
  def on_error(token, val, _vstack); end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#16
RuboCop::AST::NodePattern::Parser::Builder = RuboCop::AST::NodePattern::Builder

# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.rb#17
RuboCop::AST::NodePattern::Parser::Lexer = RuboCop::AST::NodePattern::Lexer

# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#227
RuboCop::AST::NodePattern::Parser::Racc_arg = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#295
RuboCop::AST::NodePattern::Parser::Racc_debug_parser = T.let(T.unsafe(nil), FalseClass)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/parser.racc.rb#244
RuboCop::AST::NodePattern::Parser::Racc_token_to_s_table = T.let(T.unsafe(nil), Array)

# Overrides Parser to use `WithMeta` variants and provide additional methods
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#8
class RuboCop::AST::NodePattern::Parser::WithMeta < ::RuboCop::AST::NodePattern::Parser
  # Returns the value of attribute comments.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#98
  def comments; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#100
  def do_parse; end

  # Returns the value of attribute tokens.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#98
  def tokens; end
end

# Overrides Builder to emit nodes with locations
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#39
class RuboCop::AST::NodePattern::Parser::WithMeta::Builder < ::RuboCop::AST::NodePattern::Builder
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#40
  def emit_atom(type, token); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#61
  def emit_call(type, selector_t, args = T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#55
  def emit_list(type, begin_t, children, end_t); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#49
  def emit_unary_op(type, operator_t = T.unsafe(nil), *children); end

  private

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#81
  def join_exprs(left_expr, right_expr); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#75
  def loc(token_or_range); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#71
  def n(type, children, source_map); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#85
  def source_map(token_or_range, begin_t: T.unsafe(nil), end_t: T.unsafe(nil), operator_t: T.unsafe(nil), selector_t: T.unsafe(nil)); end
end

# Overrides Lexer to token locations and comments
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#10
class RuboCop::AST::NodePattern::Parser::WithMeta::Lexer < ::RuboCop::AST::NodePattern::Lexer
  # @return [Lexer] a new instance of Lexer
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#13
  def initialize(str_or_buffer); end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#27
  def emit_comment; end

  # @return [::Parser::Source::Range] last match's position
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#33
  def pos; end

  # Returns the value of attribute source_buffer.
  #
  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#11
  def source_buffer; end

  # source://rubocop-ast//lib/rubocop/ast/node_pattern/with_meta.rb#23
  def token(type, value); end
end

# Utility to assign a set of values to a constant
#
# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#7
module RuboCop::AST::NodePattern::Sets
  class << self
    # source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#31
    def [](set); end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#15
    def name(set); end

    # source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#22
    def uniq(name); end
  end
end

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#14
RuboCop::AST::NodePattern::Sets::MAX = T.let(T.unsafe(nil), Integer)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#8
RuboCop::AST::NodePattern::Sets::REGISTRY = T.let(T.unsafe(nil), Hash)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_0_1 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_10_10 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_1_1 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ADD_DEPENDENCY_ADD_RUNTIME_DEPENDENCY_ADD_DEVELOPMENT_DEPENDENCY = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ALL_ANY_CLASS_OF_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ANY_EMPTY_NONE_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ARRAY_HASH = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ATTR_READER_ATTR_WRITER_ATTR_ACCESSOR = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ATTR_READER_ATTR_WRITER_ATTR_ACCESSOR_ATTR = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_BRANCH_REF_TAG = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CAPTURE2_CAPTURE2E_CAPTURE3_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CIPHER_DIGEST = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CLASS_EVAL_INSTANCE_EVAL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CLASS_EVAL_MODULE_EVAL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CLASS_MODULE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CLASS_MODULE_STRUCT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_CLONE_DUP_FREEZE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_COUNT_LENGTH_SIZE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_DEFINE_METHOD_DEFINE_SINGLETON_METHOD = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_EACH_WITH_INDEX_WITH_INDEX = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_EACH_WITH_OBJECT_WITH_OBJECT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ESCAPE_ENCODE_UNESCAPE_DECODE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_EXIST_EXISTS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FILETEST_FILE_DIR_SHELL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FILE_DIR = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FILE_FILETEST = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FILE_TEMPFILE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FILE_TEMPFILE_STRINGIO = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FIRST_LAST__ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FIXNUM_BIGNUM = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_FORMAT_SPRINTF_PRINTF = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_GETHOSTBYADDR_GETHOSTBYNAME = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_GSUB_GSUB = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_IF_UNLESS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_INCLUDE_EXTEND_PREPEND = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_INCLUDE_PREPEND = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_INSTANCE_EVAL_CLASS_EVAL_MODULE_EVAL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_INSTANCE_EXEC_CLASS_EXEC_MODULE_EXEC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_INTEGER_BIGDECIMAL_COMPLEX_RATIONAL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_KEYS_VALUES = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_KEY_HAS_KEY_FETCH_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_LAMBDA_PROC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_LAST_FIRST = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_LENGTH_SIZE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_LOAD_RESTORE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_MAP_COLLECT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_MAP_FILTER_MAP = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_MATCH_MATCH_ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_MODULE_FUNCTION_RUBY2_KEYWORDS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_NEW_ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_NEW_COMPILE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_NEW_OPEN = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_NIL_ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PIPELINE_PIPELINE_R_PIPELINE_RW_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PRIVATE_PROTECTED_PRIVATE_CLASS_METHOD = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PRIVATE_PROTECTED_PUBLIC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PROP_CONST = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PUBLIC_CONSTANT_PRIVATE_CONSTANT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_PUBLIC_PROTECTED_PRIVATE_MODULE_FUNCTION = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_RAISE_FAIL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_RAISE_FAIL_THROW_ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_READ_BINREAD = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_REDUCE_INJECT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_REJECT_REJECT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_REQUIRE_REQUIRE_RELATIVE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SELECT_FILTER_FIND_ALL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SELECT_SELECT_FILTER_FILTER = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SEND_PUBLIC_SEND___SEND__ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SET_SORTEDSET = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SIG_HELPERS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SORT_BY_SORT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SPAWN_SYSTEM = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SPRINTF_FORMAT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_STRUCT_CLASS = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_STRUCT_IMMUTABLESTRUCT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_STRUCT_IMMUTABLESTRUCT_INEXACTSTRUCT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_SUCC_PRED_NEXT = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_TASK_NAMESPACE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_TO_ENUM_ENUM_FOR = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_TO_H_TO_HASH = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_TO_I_TO_F_TO_C_TO_R = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_TRUE_FALSE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_ZERO_POSITIVE_NEGATIVE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__AT_SLICE = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__EQUAL_EQL = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__FETCH = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__GLOB = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET__PUSH_APPEND = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___2 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___3 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___4 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___5 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___6 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___7 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___8 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET___METHOD_____CALLEE__ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____ = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____2 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____ETC = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____ETC_2 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____ETC_3 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET____ETC_4 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern/sets.rb#10
RuboCop::AST::NodePattern::Sets::SET_____2 = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/node_pattern.rb#55
RuboCop::AST::NodePattern::VAR = T.let(T.unsafe(nil), String)

# Common functionality for primitive numeric nodes: `int`, `float`, `rational`, `complex`...
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/numeric_node.rb#6
module RuboCop::AST::NumericNode
  # Checks whether this is literal has a sign.
  #
  # @example
  #
  #   +42
  # @return [Boolean] whether this literal has a sign.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/numeric_node.rb#17
  def sign?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/numeric_node.rb#7
RuboCop::AST::NumericNode::SIGN_REGEX = T.let(T.unsafe(nil), Regexp)

# A node extension for `op_asgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#8
class RuboCop::AST::OpAsgnNode < ::RuboCop::AST::Node
  # @return [AsgnNode] the assignment node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#10
  def assignment_node; end

  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#32
  def expression; end

  # @return [AsgnNode] the assignment node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#13
  def lhs; end

  # The name of the variable being assigned as a symbol.
  #
  # @return [Symbol] the name of the variable being assigned
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#18
  def name; end

  # The operator being used for assignment as a symbol.
  #
  # @return [Symbol] the assignment operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#25
  def operator; end

  # The expression being assigned to the variable.
  #
  # @return [Node] the expression being assigned.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/op_asgn_node.rb#35
  def rhs; end
end

# A node extension for `op_asgn` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/or_asgn_node.rb#8
class RuboCop::AST::OrAsgnNode < ::RuboCop::AST::OpAsgnNode
  # The operator being used for assignment as a symbol.
  #
  # @return [Symbol] the assignment operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/or_asgn_node.rb#12
  def operator; end
end

# A node extension for `or` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `or` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/or_node.rb#8
class RuboCop::AST::OrNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BinaryOperatorNode
  include ::RuboCop::AST::PredicateOperatorNode

  # Returns the alternate operator of the `or` as a string.
  # Returns `or` for `||` and vice versa.
  #
  # @return [String] the alternate of the `or` operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/or_node.rb#16
  def alternate_operator; end

  # Returns the inverse keyword of the `or` node as a string.
  # Returns `and` for `or` and `&&` for `||`.
  #
  # @return [String] the inverse of the `or` operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/or_node.rb#24
  def inverse_operator; end
end

# A node extension for `pair` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `pair` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#8
class RuboCop::AST::PairNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::HashElementNode

  # Checks whether the `pair` uses a colon delimiter.
  #
  # @return [Boolean] whether this `pair` uses a colon delimiter
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#30
  def colon?; end

  # Returns the delimiter of the `pair` as a string. Returns `=>` for a
  # colon delimited `pair` and `:` for a hash rocket delimited `pair`.
  #
  # @param with_spacing [Boolean] whether to include spacing
  # @return [String] the delimiter of the `pair`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#39
  def delimiter(*deprecated, with_spacing: T.unsafe(nil)); end

  # Checks whether the `pair` uses a hash rocket delimiter.
  #
  # @return [Boolean] whether this `pair` uses a hash rocket delimiter
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#23
  def hash_rocket?; end

  # Returns the inverse delimiter of the `pair` as a string.
  #
  # @param with_spacing [Boolean] whether to include spacing
  # @return [String] the inverse delimiter of the `pair`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#51
  def inverse_delimiter(*deprecated, with_spacing: T.unsafe(nil)); end

  # Checks whether the `pair` uses hash value omission.
  #
  # @return [Boolean] whether this `pair` uses hash value omission
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#69
  def value_omission?; end

  # Checks whether the value starts on its own line.
  #
  # @return [Boolean] whether the value in the `pair` starts its own line
  #
  # source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#62
  def value_on_new_line?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#15
RuboCop::AST::PairNode::COLON = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#11
RuboCop::AST::PairNode::HASH_ROCKET = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#17
RuboCop::AST::PairNode::SPACED_COLON = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/pair_node.rb#13
RuboCop::AST::PairNode::SPACED_HASH_ROCKET = T.let(T.unsafe(nil), String)

# Requires implementing `arguments`.
#
# Common functionality for nodes that are parameterized:
# `send`, `super`, `zsuper`, `def`, `defs`
# and (modern only): `index`, `indexasgn`, `lambda`
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#10
module RuboCop::AST::ParameterizedNode
  # Checks whether this node has any arguments.
  #
  # @return [Boolean] whether this node has any arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#40
  def arguments?; end

  # Whether the last argument of the node is a block pass,
  # i.e. `&block`.
  #
  # @return [Boolean] whether the last argument of the node is a block pass
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#58
  def block_argument?; end

  # A shorthand for getting the first argument of the node.
  # Equivalent to `arguments.first`.
  #
  # @return [Node, nil] the first argument of the node,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#24
  def first_argument; end

  # A shorthand for getting the last argument of the node.
  # Equivalent to `arguments.last`.
  #
  # @return [Node, nil] the last argument of the node,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#33
  def last_argument; end

  # Checks whether this node's arguments are wrapped in parentheses.
  #
  # @return [Boolean] whether this node's arguments are
  #   wrapped in parentheses
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#15
  def parenthesized?; end

  # Checks whether any argument of the node is a splat
  # argument, i.e. `*splat`.
  #
  # @return [Boolean] whether the node is a splat argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#52
  def rest_argument?; end

  # Checks whether any argument of the node is a splat
  # argument, i.e. `*splat`.
  #
  # @return [Boolean] whether the node is a splat argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#48
  def splat_argument?; end
end

# A specialized `ParameterizedNode`.
# Requires implementing `first_argument_index`
# Implements `arguments` as `children[first_argument_index..-1]`
# and optimizes other calls
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#83
module RuboCop::AST::ParameterizedNode::RestArguments
  include ::RuboCop::AST::ParameterizedNode

  # @return [Array<Node>] arguments, if any
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#89
  def arguments; end

  # Checks whether this node has any arguments.
  #
  # @return [Boolean] whether this node has any arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#119
  def arguments?; end

  # A shorthand for getting the first argument of the node.
  # Equivalent to `arguments.first`.
  #
  # @return [Node, nil] the first argument of the node,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#103
  def first_argument; end

  # A shorthand for getting the last argument of the node.
  # Equivalent to `arguments.last`.
  #
  # @return [Node, nil] the last argument of the node,
  #   or `nil` if there are no arguments
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#112
  def last_argument; end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#86
RuboCop::AST::ParameterizedNode::RestArguments::EMPTY_ARGUMENTS = T.let(T.unsafe(nil), Array)

# A specialized `ParameterizedNode` for node that have a single child
# containing either `nil`, an argument, or a `begin` node with all the
# arguments
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#66
module RuboCop::AST::ParameterizedNode::WrappedArguments
  include ::RuboCop::AST::ParameterizedNode

  # @return [Array] The arguments of the node.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/parameterized_node.rb#69
  def arguments; end
end

# Common functionality for nodes that are predicates:
# `or`, `and` ...
#
# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#7
module RuboCop::AST::PredicateOperatorNode
  # Checks whether this is a logical operator.
  #
  # @return [Boolean] whether this is a logical operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#32
  def logical_operator?; end

  # Returns the operator as a string.
  #
  # @return [String] the operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#25
  def operator; end

  # Checks whether this is a semantic operator.
  #
  # @return [Boolean] whether this is a semantic operator
  #
  # source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#39
  def semantic_operator?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#8
RuboCop::AST::PredicateOperatorNode::LOGICAL_AND = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#17
RuboCop::AST::PredicateOperatorNode::LOGICAL_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#12
RuboCop::AST::PredicateOperatorNode::LOGICAL_OR = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#10
RuboCop::AST::PredicateOperatorNode::SEMANTIC_AND = T.let(T.unsafe(nil), String)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#19
RuboCop::AST::PredicateOperatorNode::SEMANTIC_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/node/mixin/predicate_operator_node.rb#14
RuboCop::AST::PredicateOperatorNode::SEMANTIC_OR = T.let(T.unsafe(nil), String)

# A `Prism` interface's class that provides a fixed `Prism::ParseLexResult` instead of parsing.
#
# This class implements the `parse_lex` method to return a preparsed `Prism::ParseLexResult`
# rather than parsing the source code.  When the parse result is already available externally,
# such as in Ruby LSP, the Prism parsing process can be bypassed.
#
# source://rubocop-ast//lib/rubocop/ast/processed_source.rb#12
class RuboCop::AST::PrismPreparsed
  # @return [PrismPreparsed] a new instance of PrismPreparsed
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#13
  def initialize(prism_result); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#23
  def parse_lex(_source, **_prism_options); end
end

# A node extension for `procarg0` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all `arg` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/procarg0_node.rb#8
class RuboCop::AST::Procarg0Node < ::RuboCop::AST::ArgNode
  # Returns the name of an argument.
  #
  # @return [Symbol, nil] the name of the argument
  #
  # source://rubocop-ast//lib/rubocop/ast/node/procarg0_node.rb#12
  def name; end
end

# ProcessedSource contains objects which are generated by Parser
# and other information such as disabled lines for cops.
# It also provides a convenient way to access source lines.
#
# source://rubocop-ast//lib/rubocop/ast/processed_source.rb#31
class RuboCop::AST::ProcessedSource
  # @return [ProcessedSource] a new instance of ProcessedSource
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#49
  def initialize(source, ruby_version, path = T.unsafe(nil), parser_engine: T.unsafe(nil), prism_result: T.unsafe(nil)); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#91
  def [](*args); end

  # Returns the value of attribute ast.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def ast; end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#69
  def ast_with_comments; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#130
  def blank?; end

  # Returns the value of attribute buffer.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def buffer; end

  # Raw source checksum for tracking infinite loops.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#102
  def checksum; end

  # @return [Comment, nil] the comment at that line, if any.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#135
  def comment_at_line(line); end

  # Consider using `each_comment_in_lines` instead
  #
  # @deprecated use contains_comment?
  # @return [Boolean] if any of the lines in the given `source_range` has a comment.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#161
  def commented?(source_range); end

  # Returns the value of attribute comments.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def comments; end

  # Should have been called `comments_before_or_at_line`. Doubtful it has of any valid use.
  #
  # @deprecated Use `each_comment_in_lines`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#165
  def comments_before_line(line); end

  # Consider using `each_comment_in_lines` instead
  #
  # @return [Boolean] if any of the lines in the given `source_range` has a comment.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#157
  def contains_comment?(source_range); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#179
  def current_line(token); end

  # Returns the value of attribute diagnostics.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def diagnostics; end

  # @deprecated Use `comments.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#107
  def each_comment(&block); end

  # Enumerates on the comments contained with the given `line_range`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#145
  def each_comment_in_lines(line_range); end

  # @deprecated Use `tokens.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#117
  def each_token(&block); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#126
  def file_path; end

  # @deprecated Use `comment_at_line`, `each_comment_in_lines`, or `comments.find`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#112
  def find_comment(&block); end

  # @deprecated Use `tokens.find`
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#122
  def find_token(&block); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#200
  def first_token_of(range_or_node); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#183
  def following_line(token); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#204
  def last_token_of(range_or_node); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#187
  def line_indentation(line_number); end

  # @return [Boolean] if the given line number has a comment.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#140
  def line_with_comment?(line); end

  # Returns the source lines, line break characters removed, excluding a
  # possible __END__ and everything that comes after.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#77
  def lines; end

  # Returns the value of attribute parser_engine.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def parser_engine; end

  # Returns the value of attribute parser_error.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def parser_error; end

  # Returns the value of attribute path.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def path; end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#175
  def preceding_line(token); end

  # Returns the value of attribute raw_source.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def raw_source; end

  # Returns the value of attribute ruby_version.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def ruby_version; end

  # The tokens list is always sorted by token position, except for cases when heredoc
  # is passed as a method argument. In this case tokens are interleaved by
  # heredoc contents' tokens.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#211
  def sorted_tokens; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#169
  def start_with?(string); end

  # Returns the value of attribute tokens.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#41
  def tokens; end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#194
  def tokens_within(range_or_node); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#95
  def valid_syntax?; end

  private

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#329
  def builder_class(parser_engine); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#218
  def comment_index; end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#339
  def create_parser(ruby_version, parser_engine, prism_result); end

  # The Parser gem does not support Ruby 3.5 or later.
  # It is also not fully compatible with Ruby 3.4 but for
  # now respects using parser for backwards compatibility.
  #
  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#385
  def default_parser_engine(ruby_version); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#393
  def first_token_index(range_or_node); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#398
  def last_token_index(range_or_node); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#368
  def normalize_parser_engine(parser_engine, ruby_version); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#224
  def parse(source, ruby_version, parser_engine, prism_result); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#260
  def parser_class(ruby_version, parser_engine); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#403
  def source_range(range_or_node); end

  # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#243
  def tokenize(parser); end

  class << self
    # source://rubocop-ast//lib/rubocop/ast/processed_source.rb#44
    def from_file(path, ruby_version, parser_engine: T.unsafe(nil)); end
  end
end

# source://rubocop-ast//lib/rubocop/ast/processed_source.rb#35
RuboCop::AST::ProcessedSource::INVALID_LEVELS = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/processed_source.rb#38
RuboCop::AST::ProcessedSource::PARSER_ENGINES = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/processed_source.rb#33
RuboCop::AST::ProcessedSource::STRING_SOURCE_NAME = T.let(T.unsafe(nil), String)

# A node extension for `irange` and `erange` nodes. This will be used in
# place of a plain node when the builder constructs the AST, making its
# methods available to all `irange` and `erange` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/range_node.rb#8
class RuboCop::AST::RangeNode < ::RuboCop::AST::Node
  # source://rubocop-ast//lib/rubocop/ast/node/range_node.rb#9
  def begin; end

  # source://rubocop-ast//lib/rubocop/ast/node/range_node.rb#13
  def end; end
end

# A node extension for `rational` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available to
# all `rational` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/rational_node.rb#8
class RuboCop::AST::RationalNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode
  include ::RuboCop::AST::NumericNode
end

# A node extension for `regexp` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `regexp` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#8
class RuboCop::AST::RegexpNode < ::RuboCop::AST::Node
  # @return [String] a string of regexp content
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#37
  def content; end

  # @return [Bool] if char is one of the delimiters
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#57
  def delimiter?(char); end

  # @return [String] the regexp delimiters (without %r)
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#52
  def delimiters; end

  # @return [Bool] if regexp uses the extended regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#72
  def extended?; end

  # @return [Bool] if regexp uses the fixed-encoding regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#92
  def fixed_encoding?; end

  # @return [Bool] if regexp uses the ignore-case regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#77
  def ignore_case?; end

  # @return [Bool] if regexp contains interpolation
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#62
  def interpolation?; end

  # @return [Bool] if regexp uses the multiline regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#67
  def multiline_mode?; end

  # @return [Bool] if regexp uses the no-encoding regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#87
  def no_encoding?; end

  # NOTE: The 'o' option is ignored.
  #
  # @return [Integer] the Regexp option bits as returned by Regexp#options
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#32
  def options; end

  # @return [Bool] if the regexp is a %r{...} literal (using any delimiters)
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#47
  def percent_r_literal?; end

  # @return [RuboCop::AST::Node] a regopt node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#25
  def regopt; end

  # @return [Bool] if regexp uses the single-interpolation regopt
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#82
  def single_interpolation?; end

  # @return [Bool] if the regexp is a /.../ literal
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#42
  def slash_literal?; end

  # @return [Regexp] a regexp of this node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#20
  def to_regexp; end

  private

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#98
  def regopt_include?(option); end
end

# source://rubocop-ast//lib/rubocop/ast/node/regexp_node.rb#9
RuboCop::AST::RegexpNode::OPTIONS = T.let(T.unsafe(nil), Hash)

# A node extension for `resbody` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `resbody` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/resbody_node.rb#8
class RuboCop::AST::ResbodyNode < ::RuboCop::AST::Node
  # Returns the body of the `rescue` clause.
  #
  # @return [Node, nil] The body of the `resbody`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/resbody_node.rb#12
  def body; end

  # Returns the index of the `resbody` branch within the exception handling statement.
  #
  # @return [Integer] the index of the `resbody` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/resbody_node.rb#40
  def branch_index; end

  # Returns the exception variable of the `rescue` clause.
  #
  # @return [Node, nil] The exception variable of the `resbody`.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/resbody_node.rb#33
  def exception_variable; end

  # Returns an array of all the exceptions in the `rescue` clause.
  #
  # @return [Array<Node>] an array of exception nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/resbody_node.rb#19
  def exceptions; end
end

# A node extension for `rescue` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `rescue` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#8
class RuboCop::AST::RescueNode < ::RuboCop::AST::Node
  # Returns the body of the rescue node.
  #
  # @return [Node, nil] The body of the rescue node.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#12
  def body; end

  # Returns an array of all the rescue branches in the exception handling statement.
  #
  # and the else (if any). Note that these bodies could be nil.
  #
  # @return [Array<Node, nil>] an array of the bodies of the rescue branches
  #
  # source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#27
  def branches; end

  # Checks whether this exception handling statement has an `else` branch.
  #
  # @return [Boolean] whether the exception handling statement has an `else` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#44
  def else?; end

  # Returns the else branch of the exception handling statement, if any.
  #
  # @return [Node] the else branch node of the exception handling statement
  # @return [nil] if the exception handling statement does not have an else branch.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#37
  def else_branch; end

  # Returns an array of all the rescue branches in the exception handling statement.
  #
  # @return [Array<ResbodyNode>] an array of `resbody` nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/rescue_node.rb#19
  def resbody_branches; end
end

# A node extension for `return` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `return` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/return_node.rb#8
class RuboCop::AST::ReturnNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::WrappedArguments
end

# Responsible for compatibility with main gem
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/rubocop_compatibility.rb#8
module RuboCop::AST::RuboCopCompatibility
  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/rubocop_compatibility.rb#13
  def rubocop_loaded; end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/rubocop_compatibility.rb#9
RuboCop::AST::RuboCopCompatibility::INCOMPATIBLE_COPS = T.let(T.unsafe(nil), Hash)

# A node extension for `sclass` nodes. This will be used in place of a
# plain node when the builder constructs the AST, making its methods
# available to all `sclass` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/self_class_node.rb#8
class RuboCop::AST::SelfClassNode < ::RuboCop::AST::Node
  # The body of this `sclass` node.
  #
  # @return [Node, nil] the body of the class
  #
  # source://rubocop-ast//lib/rubocop/ast/node/self_class_node.rb#19
  def body; end

  # The identifier for this `sclass` node. (Always `self`.)
  #
  # @return [Node] the identifier of the class
  #
  # source://rubocop-ast//lib/rubocop/ast/node/self_class_node.rb#12
  def identifier; end
end

# A node extension for `send` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `send` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/send_node.rb#8
class RuboCop::AST::SendNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::ParameterizedNode::RestArguments
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # source://rubocop-ast//lib/rubocop/ast/node/send_node.rb#13
  def attribute_accessor?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/send_node.rb#18
  def send_type?; end

  private

  # source://rubocop-ast//lib/rubocop/ast/node/send_node.rb#24
  def first_argument_index; end
end

# This module provides a shorthand method to create a {Node} like
# `Parser::AST::Sexp`.
#
# @see https://www.rubydoc.info/gems/ast/AST/Sexp
#
# source://rubocop-ast//lib/rubocop/ast/sexp.rb#9
module RuboCop::AST::Sexp
  # Creates a {Node} with type `type` and children `children`.
  #
  # source://rubocop-ast//lib/rubocop/ast/sexp.rb#11
  def s(type, *children); end
end

# A node extension for `str`, `dstr`, and `xstr` nodes. This will be used
# in place of a plain node when the builder constructs the AST, making
# its methods available to all `str` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#8
class RuboCop::AST::StrNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#26
  def character_literal?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#22
  def double_quoted?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#30
  def heredoc?; end

  # Checks whether the string literal is delimited by percent brackets.
  #
  # @overload percent_literal?
  # @overload percent_literal?
  # @param type [Symbol] an optional percent literal type
  # @return [Boolean] whether the string is enclosed in percent brackets
  #
  # source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#45
  def percent_literal?(type = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#18
  def single_quoted?; end
end

# source://rubocop-ast//lib/rubocop/ast/node/str_node.rb#11
RuboCop::AST::StrNode::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Hash)

# A node extension for `super`- and `zsuper` nodes. This will be used in
# place of a plain node when the builder constructs the AST, making its
# methods available to all `super`- and `zsuper` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/super_node.rb#8
class RuboCop::AST::SuperNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # source://rubocop-ast//lib/rubocop/ast/node/super_node.rb#20
  def arguments; end

  # Custom destructuring method. This can be used to normalize
  # destructuring for different variations of the node.
  #
  # @return [Array] the different parts of the `super` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/super_node.rb#16
  def node_parts; end
end

# A node extension for `sym` nodes. This will be used in  place of a
# plain node when the builder constructs the AST, making its methods
# available to all `sym` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/symbol_node.rb#8
class RuboCop::AST::SymbolNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::BasicLiteralNode
end

# A basic wrapper around Parser's tokens.
#
# source://rubocop-ast//lib/rubocop/ast/token.rb#6
class RuboCop::AST::Token
  # @return [Token] a new instance of Token
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#18
  def initialize(pos, type, text); end

  # source://rubocop-ast//lib/rubocop/ast/token.rb#33
  def begin_pos; end

  # source://rubocop-ast//lib/rubocop/ast/token.rb#29
  def column; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#102
  def comma?; end

  # Type Predicates
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#58
  def comment?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#106
  def dot?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#118
  def end?; end

  # source://rubocop-ast//lib/rubocop/ast/token.rb#37
  def end_pos; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#122
  def equal_sign?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#66
  def left_array_bracket?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#82
  def left_brace?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#74
  def left_bracket?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#86
  def left_curly_brace?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#94
  def left_parens?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#70
  def left_ref_bracket?; end

  # source://rubocop-ast//lib/rubocop/ast/token.rb#25
  def line; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#126
  def new_line?; end

  # Returns the value of attribute pos.
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#10
  def pos; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#110
  def regexp_dots?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#114
  def rescue_modifier?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#78
  def right_bracket?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#90
  def right_curly_brace?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#98
  def right_parens?; end

  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#62
  def semicolon?; end

  # Checks if there is whitespace after token
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#46
  def space_after?; end

  # Checks if there is whitespace before token
  #
  # @return [Boolean]
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#51
  def space_before?; end

  # Returns the value of attribute text.
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#10
  def text; end

  # source://rubocop-ast//lib/rubocop/ast/token.rb#41
  def to_s; end

  # Returns the value of attribute type.
  #
  # source://rubocop-ast//lib/rubocop/ast/token.rb#10
  def type; end

  class << self
    # source://rubocop-ast//lib/rubocop/ast/token.rb#12
    def from_parser_token(parser_token); end
  end
end

# source://rubocop-ast//lib/rubocop/ast/token.rb#8
RuboCop::AST::Token::LEFT_CURLY_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop-ast//lib/rubocop/ast/token.rb#7
RuboCop::AST::Token::LEFT_PAREN_TYPES = T.let(T.unsafe(nil), Array)

# Provides methods for traversing an AST.
# Does not transform an AST; for that, use Parser::AST::Processor.
# Override methods to perform custom processing. Remember to call `super`
# if you want to recursively process descendant nodes.
#
# source://rubocop-ast//lib/rubocop/ast/traversal.rb#9
module RuboCop::AST::Traversal
  extend ::RuboCop::AST::Traversal::CallbackCompiler

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on___ENCODING__(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on___FILE__(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on___LINE__(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_alias(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_and(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_and_asgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_arg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_arg_expr(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_args(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_array(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_array_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_array_pattern_with_tail(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_back_ref(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_begin(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_block(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_block_pass(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_blockarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_break(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_case(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_case_match(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_casgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_cbase(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_class(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_complex(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_const(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_const_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_csend(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_cvar(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_cvasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_def(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_defined?(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_defs(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_dstr(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_dsym(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_eflipflop(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_empty_else(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_ensure(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_erange(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_false(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_find_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_float(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_for(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_forward_arg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_forward_args(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_forwarded_args(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_forwarded_kwrestarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_forwarded_restarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_gvar(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_gvasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_hash(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_hash_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_if(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_if_guard(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_iflipflop(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_in_match(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_in_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_index(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_indexasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_int(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_irange(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_itblock(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_ivar(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_ivasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwargs(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwbegin(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwnilarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwoptarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwrestarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_kwsplat(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_lambda(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_lvar(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_lvasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_masgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_alt(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_as(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_current_line(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_nil_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_pattern(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_pattern_p(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_rest(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_var(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_with_lvasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_match_with_trailing_comma(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_mlhs(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_module(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_mrasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_next(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_nil(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_not(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_nth_ref(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_numblock(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_op_asgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_optarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_or(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_or_asgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_pair(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_pin(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_postexe(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_preexe(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_procarg0(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_rasgn(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_rational(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_redo(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_regexp(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_regopt(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_resbody(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_rescue(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_restarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_retry(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_return(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_sclass(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_self(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_send(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_shadowarg(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_splat(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_str(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_super(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_sym(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_true(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_undef(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_unless_guard(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_until(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_until_post(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_when(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#43
  def on_while(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_while_post(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_xstr(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_yield(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#50
  def on_zsuper(node); end

  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#17
  def walk(node); end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/traversal.rb#25
module RuboCop::AST::Traversal::CallbackCompiler
  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#54
  def body(child_node_types, expected_children_count); end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#68
  def children_count_check_code(range); end

  # @api private
  #
  # source://rubocop-ast//lib/rubocop/ast/traversal.rb#38
  def def_callback(type, *child_node_types, expected_children_count: T.unsafe(nil), body: T.unsafe(nil)); end
end

# @api private
#
# source://rubocop-ast//lib/rubocop/ast/traversal.rb#26
RuboCop::AST::Traversal::CallbackCompiler::SEND = T.let(T.unsafe(nil), String)

# How a particular child node should be visited. For example, if a child node
# can be nil it should be guarded behind a nil check. Or, if a child node is a literal
# (like a symbol) then the literal itself should not be visited.
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/traversal.rb#32
RuboCop::AST::Traversal::CallbackCompiler::TEMPLATE = T.let(T.unsafe(nil), Hash)

# Only for debugging.
#
# @api private
#
# source://rubocop-ast//lib/rubocop/ast/traversal.rb#12
class RuboCop::AST::Traversal::DebugError < ::RuntimeError; end

# source://rubocop-ast//lib/rubocop/ast/traversal.rb#109
RuboCop::AST::Traversal::NO_CHILD_NODES = T.let(T.unsafe(nil), Set)

# source://rubocop-ast//lib/rubocop/ast/traversal.rb#15
RuboCop::AST::Traversal::TYPE_TO_METHOD = T.let(T.unsafe(nil), Hash)

# A node extension for `until` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `until` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/until_node.rb#8
class RuboCop::AST::UntilNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConditionalNode
  include ::RuboCop::AST::ModifierNode

  # Checks whether the `until` node has a `do` keyword.
  #
  # @return [Boolean] whether the `until` node has a `do` keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/until_node.rb#30
  def do?; end

  # Returns the inverse keyword of the `until` node as a string.
  # Returns `while` for `until` nodes and vice versa.
  #
  # @return [String] the inverse keyword of the `until` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/until_node.rb#23
  def inverse_keyword; end

  # Returns the keyword of the `until` statement as a string.
  #
  # @return [String] the keyword of the `until` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/until_node.rb#15
  def keyword; end
end

# A node extension for `lvar`, `ivar`, `cvar` and `gvar` nodes.
# This will be used in place of a plain node when the builder constructs
# the AST, making its methods available to all assignment nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/var_node.rb#8
class RuboCop::AST::VarNode < ::RuboCop::AST::Node
  # @return [Symbol] The name of the variable.
  #
  # source://rubocop-ast//lib/rubocop/ast/node/var_node.rb#10
  def name; end
end

# source://rubocop-ast//lib/rubocop/ast/version.rb#5
module RuboCop::AST::Version; end

# source://rubocop-ast//lib/rubocop/ast/version.rb#6
RuboCop::AST::Version::STRING = T.let(T.unsafe(nil), String)

# A node extension for `when` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `when` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#8
class RuboCop::AST::WhenNode < ::RuboCop::AST::Node
  # Returns the body of the `when` node.
  #
  # @return [Node, nil] the body of the `when` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#42
  def body; end

  # Returns the index of the `when` branch within the `case` statement.
  #
  # @return [Integer] the index of the `when` branch
  #
  # source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#28
  def branch_index; end

  # Returns an array of all the conditions in the `when` branch.
  #
  # @return [Array<Node>] an array of condition nodes
  #
  # source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#12
  def conditions; end

  # @deprecated Use `conditions.each`
  #
  # source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#17
  def each_condition(&block); end

  # Checks whether the `when` node has a `then` keyword.
  #
  # @return [Boolean] whether the `when` node has a `then` keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/when_node.rb#35
  def then?; end
end

# A node extension for `while` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `while` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/while_node.rb#8
class RuboCop::AST::WhileNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ConditionalNode
  include ::RuboCop::AST::ModifierNode

  # Checks whether the `until` node has a `do` keyword.
  #
  # @return [Boolean] whether the `until` node has a `do` keyword
  #
  # source://rubocop-ast//lib/rubocop/ast/node/while_node.rb#30
  def do?; end

  # Returns the inverse keyword of the `while` node as a string.
  # Returns `until` for `while` nodes and vice versa.
  #
  # @return [String] the inverse keyword of the `while` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/while_node.rb#23
  def inverse_keyword; end

  # Returns the keyword of the `while` statement as a string.
  #
  # @return [String] the keyword of the `while` statement
  #
  # source://rubocop-ast//lib/rubocop/ast/node/while_node.rb#15
  def keyword; end
end

# A node extension for `yield` nodes. This will be used in place of a plain
# node when the builder constructs the AST, making its methods available
# to all `yield` nodes within RuboCop.
#
# source://rubocop-ast//lib/rubocop/ast/node/yield_node.rb#8
class RuboCop::AST::YieldNode < ::RuboCop::AST::Node
  include ::RuboCop::AST::ParameterizedNode
  include ::RuboCop::AST::MethodIdentifierPredicates
  include ::RuboCop::AST::MethodDispatchNode

  # source://rubocop-ast//lib/rubocop/ast/node/yield_node.rb#20
  def arguments; end

  # Custom destructuring method. This can be used to normalize
  # destructuring for different variations of the node.
  #
  # @return [Array] the different parts of the `send` node
  #
  # source://rubocop-ast//lib/rubocop/ast/node/yield_node.rb#16
  def node_parts; end
end

class RuboCop::CommentConfig; end
class RuboCop::Config; end
class RuboCop::ConfigValidator; end

# Similar to `Forwardable#def_delegators`, but simpler & faster
#
# source://rubocop-ast//lib/rubocop/ast/utilities/simple_forwardable.rb#5
module RuboCop::SimpleForwardable
  # source://rubocop-ast//lib/rubocop/ast/utilities/simple_forwardable.rb#6
  def def_delegators(accessor, *methods); end
end
