# 2025-06-02 Triage Log

A fairly busy week, with lots of changes to performance. Most of the changes
(at least in quantity of benchmarks) are attributable to an update of our PGO
collection to newer benchmarks as part of the 2025 refresh.

Triage done by **@simulacrum**.
Revision range: [2805e1dc..2fc3deed](https://perf.rust-lang.org/?start=2805e1dc4c18ed4c84d161502c48da870c56f68a&end=2fc3deed9fcb8762ad57191e0195f06f7543e4a5&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.1%, 6.7%]    | 56    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 1.3%]    | 69    |
| Improvements ✅ <br /> (primary)   | -1.2% | [-8.9%, -0.1%]  | 133   |
| Improvements ✅ <br /> (secondary) | -2.7% | [-20.2%, -0.1%] | 115   |
| All ❌✅ (primary)                 | -0.6% | [-8.9%, 6.7%]   | 189   |

2 Regressions, 6 Improvements, 13 Mixed; 9 of them in rollups
40 artifact comparisons made in total

#### Regressions

Add some track_caller info to precondition panics [#129658](https://github.com/rust-lang/rust/pull/129658) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=45f256d9d7cffb66185c0bf1b8a864cba79db90c&end=be422939446d7c5b27ba98debb6b4b8d6a261f1a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.1%, 6.2%]   | 14    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.4%, 1.2%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.9%  | [-0.5%, 6.2%]  | 15    |

Expected regressions to performance for better user experience. No further follow-up warranted.

Rollup of 8 pull requests [#141753](https://github.com/rust-lang/rust/pull/141753) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c0849d8bae6f1af08a8b64a011b2ffa7c24f136&end=6de3a733122a82d9b3c3427c7ee16a1e1a022718&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 1.4%]   | 78    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.6%]   | 46    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 3     |
| All ❌✅ (primary)                 | 0.4%  | [0.1%, 1.4%]   | 78    |

[#141407](https://github.com/rust-lang/rust/pull/141407) seems to be the
primary cause of the impact. This is (in part) a correctness fix so marking the
regression as triaged.

#### Improvements

Rollup of 8 pull requests [#141662](https://github.com/rust-lang/rust/pull/141662) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c583fa6d8425dbb38fe5d1dbd007f9ca8e4aa128&end=45f256d9d7cffb66185c0bf1b8a864cba79db90c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-4.3%, -0.0%] | 56    |
| All ❌✅ (primary)                 | -     | -              | 0     |

Unclear cause. Probably not worth digging deeper as solely improvements and only in secondary benchmarks.

Rollup of 8 pull requests [#141668](https://github.com/rust-lang/rust/pull/141668) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=be422939446d7c5b27ba98debb6b4b8d6a261f1a&end=04a67d5a0587ed98632f82c404ae20f9f0a51a1d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 34    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.0%] | 19    |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 34    |

Unclear cause. Probably not worth digging deeper as solely improvements and only in secondary benchmarks.
Started a [PR build](https://github.com/rust-lang/rust/pull/141252#issuecomment-2930408560) to check one potential root cause.

rustdoc: cleanups relating to allocations [#141573](https://github.com/rust-lang/rust/pull/141573) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6de3a733122a82d9b3c3427c7ee16a1e1a022718&end=e6152cdf5b31bd844a4cc1049433859d54863602&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.6%, -0.6%] | 1     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 8     |


Add fast path for maybe-initializedness in liveness [#141667](https://github.com/rust-lang/rust/pull/141667) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7a7bcbbcdbf2845164a94377d0e0efebb737ffd3&end=ec28ae9454139023117270985f114823d6570657&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.5%, 0.5%]    | 1     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-10.6%, -0.2%] | 67    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.2%, -0.2%]  | 59    |
| All ❌✅ (primary)                 | -1.0% | [-10.6%, -0.2%] | 67    |


cstore: Use IndexSet as backing store for postorder dependencies [#141730](https://github.com/rust-lang/rust/pull/141730) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13a4540908d25642c0fa0ab726095cf57bbe6824&end=ba55b7ce3cd931af7123e334647584f6fbdb3c20&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-5.2%, -0.4%] | 11    |
| All ❌✅ (primary)                 | -     | -              | 0     |

Tweak fast path trait handling [#141731](https://github.com/rust-lang/rust/pull/141731) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ba55b7ce3cd931af7123e334647584f6fbdb3c20&end=9b0268a43b0a5b58f50c96ded25364037c019a61&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.4%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |

#### Mixed

add additional `TypeFlags` fast paths [#141581](https://github.com/rust-lang/rust/pull/141581) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebe9b0060240953d721508ceb4d02a745efda88f&end=5f025f363df11c65bd31ade9fe6f48fd4f4239af&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.2%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 20    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-5.7%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -0.0% | [-0.4%, 0.2%]  | 13    |

Mostly no significant delta (averaging out to 0% change) but worth it in more pathological cases, so makes sense to land the change.

Rollup of 16 pull requests [#141716](https://github.com/rust-lang/rust/pull/141716) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5f025f363df11c65bd31ade9fe6f48fd4f4239af&end=38081f22c2d7380f272aa1d7fa9b935637701c2d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 3     |

Correctness fix in wfcheck ([#136429](https://github.com/rust-lang/rust/pull/136429)). No further investigation needed.

Bump rustc-perf and update PGO crates [#141490](https://github.com/rust-lang/rust/pull/141490) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13718eb788622ef8c998650451174570230d2971&end=1bbd62e547ba5cc08ccb44c27def3d33195d2dd5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 2.0%]   | 46    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.1%, 3.2%]   | 110   |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.1%] | 72    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-4.8%, -0.2%] | 62    |
| All ❌✅ (primary)                 | -0.1% | [-0.9%, 2.0%]  | 118   |

Broad changes due to many benchmark crates getting updated, no particular outcome expected.

Rollup of 11 pull requests [#141739](https://github.com/rust-lang/rust/pull/141739) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1bbd62e547ba5cc08ccb44c27def3d33195d2dd5&end=1ac1950c337039add1a83113ed6d1bd64bcb1142&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.4%, 0.6%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.4%] | 2     |
| All ❌✅ (primary)                 | 0.1%  | [0.1%, 0.1%]   | 4     |

Nothing obvious in one cachegrind diff, not worth digging deeper.

Make some assertions in solver into debug assertions [#141651](https://github.com/rust-lang/rust/pull/141651) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1ac1950c337039add1a83113ed6d1bd64bcb1142&end=1c0849d8bae6f1af08a8b64a011b2ffa7c24f136&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.1%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 2     |

Rollup of 5 pull requests [#141765](https://github.com/rust-lang/rust/pull/141765) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e6152cdf5b31bd844a4cc1049433859d54863602&end=aa5832b142a2bfd322659d60f5d57e25d2a1bd5d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.3%, 0.3%]   | 6     |

rustc_codegen_llvm: use `threadlocal.address` intrinsic to access TLS [#139385](https://github.com/rust-lang/rust/pull/139385) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aa5832b142a2bfd322659d60f5d57e25d2a1bd5d&end=15825b7161f8bd6a3482211fbf6727a52aa1166b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.0%, -0.2%] | 22    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.5%, -1.4%] | 3     |
| All ❌✅ (primary)                 | -0.7% | [-2.0%, -0.2%] | 22    |

Expected speed up to thread local access.

Rollup of 8 pull requests [#141791](https://github.com/rust-lang/rust/pull/141791) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=70b3f4666e24ce22fc32f5e357dbcf85d3254e63&end=0b00e6847b576656d80d7d1e845100fe1663ce0e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.9%  | [2.9%, 2.9%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.6% | [-1.6%, -1.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.7%  | [-1.6%, 2.9%]  | 2     |

https://github.com/rust-lang/rust/pull/141765#issuecomment-2930545642

Revert "increase perf of charsearcher for single ascii characters" [#141678](https://github.com/rust-lang/rust/pull/141678) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ec28ae9454139023117270985f114823d6570657&end=e0d014a3dffbb3f0575cfbeb0f480c5080c4d018&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.9%  | [1.6%, 2.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-7.3%, -0.2%] | 36    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-4.2%, -0.3%] | 25    |
| All ❌✅ (primary)                 | -1.2% | [-7.3%, 2.2%]  | 38    |

This fixes a perf regression from a previous week.

PGO new solver [#141453](https://github.com/rust-lang/rust/pull/141453) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e0d014a3dffbb3f0575cfbeb0f480c5080c4d018&end=738c08b63c4f9e3ebdaec5eece7b6fbc354f6467&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]    | 10    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.3%]    | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%]  | 1     |
| Improvements ✅ <br /> (secondary) | -8.1% | [-15.0%, -3.3%] | 14    |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 0.4%]   | 11    |

Expected improvements primarily to new solver benchmarks as we now collect PGO
data. Some regressions are expected due to less precise PGO data for old solver
patterns.

`slice.get(i)` should use a slice projection in MIR, like `slice[i]` does [#139118](https://github.com/rust-lang/rust/pull/139118) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4d08223c054cf5a56d9761ca925fd46ffebe7115&end=f0999ffdc4818e498949d3b1f2a0ce6be02a0436&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-1.3%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.2% | [-1.3%, -1.1%] | 2     |

Within noise threshold for (new) regressed benchmark, otherwise see [#139118 (comment)](https://github.com/rust-lang/rust/pull/139118#issuecomment-2925635519).

Merge coroutine obligation checking into borrowck parallel loop [#141773](https://github.com/rust-lang/rust/pull/141773) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2fc3deed9fcb8762ad57191e0195f06f7543e4a5&end=91fad92585b2dafc52a074e502b2a6c1f093ca35&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |

Not really measurable on (at least) perf, new -Zthreads=4 benchmark doesn't see
any meaningful improvement from this.
