// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Sylvain GENIN
// Copyright (C) 2021 - Samuel GOUGEON
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================
// <-- NO CHECK REF -->
// <-- CLI SHELL MODE -->

s = %s;

empty = [];

r = 2;
R = [1,2;3,4];
R3(:,:,1) = R;
R3(:,:,2) = R';
c = 1 + 2*%i;
C = [1+2*%i,2+4*%i;3+6*%i,4+8*%i];
C3(:,:,1) = C;
C3(:,:,2) = C';

e = eye();
ec = (5+%i) * eye();

p = 1 + %s - %s**2;
pc = 1 + %s - %s**2 + ( 2 - 3 * %s + 4 * %s**2 ) * %i;
P = [2*p, 2;4*p,-5*p];
PC = [2*pc, 2;4*pc,-5*pc];

SP = sparse([1,2;4,5;3,10],[1,2,3]);
SPC = sparse([1,2;4,5;3,10],[1,2,3]) * ( 1 + 4*%i);
SPB = sparse([1,2;2,1],[%t;%t],[2,2]);
SP1 = sparse([1,1],[10]);
SPC1 = sparse([1,1],[1]) * ( 2 + 6*%i);

i8 = int8(-8);
ui8 = uint8(8);
I8 = int8([-8 2 ; -24 -32]);
UI8 = uint8([8 2 ; 24 32]);

I16 = int16([-16 2 ; -48 -64]);
UI16 = uint16([16 2 ; 48 64]);
i16 = int16(-16);
ui16 = uint16(16);

i32 = int32(-32);
ui32 = uint32(32);
I32 = int32([-32 2 ; -96 -128]);
UI32 = uint32([32 2 ; 96 128]);

str = "string";
STR = ["string1" "string2";"string3" "string4"];

b = %f;
B = [%t %f;%f %t];

assert_checkequal(empty == empty, %t);
assert_checkequal(empty == r, %f);
assert_checkequal(empty == c, %f);
assert_checkequal(empty == R, %f);
assert_checkequal(empty == C, %f);
assert_checkequal(empty == e, %f);
assert_checkequal(empty == ec, %f);
assert_checkequal(empty == p, %f);
assert_checkequal(empty == pc, %f);
assert_checkequal(empty == P, %f);
assert_checkequal(empty == PC, %f);
assert_checkequal(empty == SP, %f);
assert_checkequal(empty == SPC, %f);
assert_checkequal(empty == SP1, %f);
assert_checkequal(empty == SPC1, %f);
assert_checkequal(empty == i8, %f);
assert_checkequal(empty == I8, %f);
assert_checkequal(empty == ui8, %f);
assert_checkequal(empty == UI8, %f);
assert_checkequal(empty == i16, %f);
assert_checkequal(empty == I16, %f);
assert_checkequal(empty == ui16, %f);
assert_checkequal(empty == UI16, %f);
assert_checkequal(empty == i32, %f);
assert_checkequal(empty == I32, %f);
assert_checkequal(empty == ui32, %f);
assert_checkequal(empty == UI32, %f);
assert_checkequal(empty == str, %f);
assert_checkequal(empty == STR, %f);
assert_checkequal(empty == b, %f);
assert_checkequal(empty == B, %f);
assert_checkequal(empty == SPB, %f);

assert_checkequal(r == empty, %f);
assert_checkequal(r == r, %t);
assert_checkequal(r == c, %f);
assert_checkequal(r == R, [%f,%t;%f,%f]);
assert_checkequal(r == C, [%f,%f;%f,%f]);
assert_checkequal(r == e, %f);
assert_checkequal(r == ec, %f);
assert_checkequal(r == p, %f);
assert_checkequal(r == pc, %f);
assert_checkequal(r == P, [%f,%t;%f,%f]);
assert_checkequal(r == PC, [%f,%t;%f,%f]);
assert_checkequal(r == SP, sparse([4,5],%t,[4,10]));
assert_checkequal(r == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(r == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(r == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(r == i8, %f);
assert_checkequal(r == I8, [%f,%t;%f,%f]);
assert_checkequal(r == ui8, %f);
assert_checkequal(r == UI8, [%f,%t;%f,%f]);
assert_checkequal(r == i16, %f);
assert_checkequal(r == I16, [%f,%t;%f,%f]);
assert_checkequal(r == ui16, %f);
assert_checkequal(r == UI16, [%f,%t;%f,%f]);
assert_checkequal(r == i32, %f);
assert_checkequal(r == I32, [%f,%t;%f,%f]);
assert_checkequal(r == ui32, %f);
assert_checkequal(r == UI32, [%f,%t;%f,%f]);
assert_checkequal(r == str, %f);
assert_checkequal(r == STR, %f);
assert_checkequal(r == b, %f);
assert_checkequal(r == B, %f);
assert_checkequal(r == SPB, %f);

assert_checkequal(c == empty, %f);
assert_checkequal(c == r, %f);
assert_checkequal(c == c, %t);
assert_checkequal(c == R, [%f,%f;%f,%f]);
assert_checkequal(c == C, [%t,%f;%f,%f]);
assert_checkequal(c == e, %f);
assert_checkequal(c == ec, %f);
assert_checkequal(c == p, %f);
assert_checkequal(c == pc, %f);
assert_checkequal(c == P, [%f,%f;%f,%f]);
assert_checkequal(c == PC, [%f,%f;%f,%f]);
assert_checkequal(c == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(c == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(c == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(c == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(c == i8, %f);
assert_checkequal(c == I8, [%f,%f;%f,%f]);
assert_checkequal(c == ui8, %f);
assert_checkequal(c == UI8, [%f,%f;%f,%f]);
assert_checkequal(c == i16, %f);
assert_checkequal(c == I16, [%f,%f;%f,%f]);
assert_checkequal(c == ui16, %f);
assert_checkequal(c == UI16, [%f,%f;%f,%f]);
assert_checkequal(c == i32, %f);
assert_checkequal(c == I32, [%f,%f;%f,%f]);
assert_checkequal(c == ui32, %f);
assert_checkequal(c == UI32, [%f,%f;%f,%f]);
assert_checkequal(c == str, %f);
assert_checkequal(c == STR, %f);
assert_checkequal(c == b, %f);
assert_checkequal(c == B, %f);
assert_checkequal(c == SPB, %f);

assert_checkequal(R == empty, %f);
assert_checkequal(R == r, [%f,%t;%f,%f]);
assert_checkequal(R == c, [%f,%f;%f,%f]);
assert_checkequal(R == R, [%t,%t;%t,%t]);
assert_checkequal(R == C, [%f,%f;%f,%f]);
assert_checkequal(R == e, [%t,%f;%f,%f]);
assert_checkequal(R == ec, [%f,%f;%f,%f]);
assert_checkequal(R == p, [%f,%f;%f,%f]);
assert_checkequal(R == pc, [%f,%f;%f,%f]);
assert_checkequal(R == P, [%f,%t;%f,%f]);
assert_checkequal(R == PC, [%f,%t;%f,%f]);
assert_checkequal(R == SP, %f);
assert_checkequal(R == SPC, %f);
assert_checkequal(R == SP1, %f);
assert_checkequal(R == SPC1, %f);
assert_checkequal(R == i8, [%f,%f;%f,%f]);
assert_checkequal(R == I8, [%f,%t;%f,%f]);
assert_checkequal(R == ui8, [%f,%f;%f,%f]);
assert_checkequal(R == UI8, [%f,%t;%f,%f]);
assert_checkequal(R == i16, [%f,%f;%f,%f]);
assert_checkequal(R == I16, [%f,%t;%f,%f]);
assert_checkequal(R == ui16, [%f,%f;%f,%f]);
assert_checkequal(R == UI16, [%f,%t;%f,%f]);
assert_checkequal(R == i32, [%f,%f;%f,%f]);
assert_checkequal(R == I32, [%f,%t;%f,%f]);
assert_checkequal(R == ui32, [%f,%f;%f,%f]);
assert_checkequal(R == UI32, [%f,%t;%f,%f]);
assert_checkequal(R == str, %f);
assert_checkequal(R == STR, %f);
assert_checkequal(R == b, %f);
assert_checkequal(R == B, %f);
assert_checkequal(R == SPB, %f);

assert_checkequal(C == empty, %f);
assert_checkequal(C == r, [%f,%f;%f,%f]);
assert_checkequal(C == c, [%t,%f;%f,%f]);
assert_checkequal(C == R, [%f,%f;%f,%f]);
assert_checkequal(C == C, [%t,%t;%t,%t]);
assert_checkequal(C == e, [%f,%f;%f,%f]);
assert_checkequal(C == ec, [%f,%f;%f,%f]);
assert_checkequal(C == p, [%f,%f;%f,%f]);
assert_checkequal(C == pc, [%f,%f;%f,%f]);
assert_checkequal(C == P, [%f,%f;%f,%f]);
assert_checkequal(C == PC, [%f,%f;%f,%f]);
assert_checkequal(C == SP, %f);
assert_checkequal(C == SPC, %f);
assert_checkequal(C == SP1, %f);
assert_checkequal(C == SPC1, %f);
assert_checkequal(C == i8, [%f,%f;%f,%f]);
assert_checkequal(C == I8, [%f,%f;%f,%f]);
assert_checkequal(C == ui8, [%f,%f;%f,%f]);
assert_checkequal(C == UI8, [%f,%f;%f,%f]);
assert_checkequal(C == i16, [%f,%f;%f,%f]);
assert_checkequal(C == I16, [%f,%f;%f,%f]);
assert_checkequal(C == ui16, [%f,%f;%f,%f]);
assert_checkequal(C == UI16, [%f,%f;%f,%f]);
assert_checkequal(C == i32, [%f,%f;%f,%f]);
assert_checkequal(C == I32, [%f,%f;%f,%f]);
assert_checkequal(C == ui32, [%f,%f;%f,%f]);
assert_checkequal(C == UI32, [%f,%f;%f,%f]);
assert_checkequal(C == str, %f);
assert_checkequal(C == STR, %f);
assert_checkequal(C == b, %f);
assert_checkequal(C == B, %f);
assert_checkequal(C == SPB, %f);

assert_checkequal(e == empty, %f);
assert_checkequal(e == r, %f);
assert_checkequal(e == c, %f);
assert_checkequal(e == R, [%t,%f;%f,%f]);
assert_checkequal(e == C, [%f,%f;%f,%f]);
assert_checkequal(e == e, %t);
assert_checkequal(e == ec, %f);
assert_checkequal(e == p, %f);
assert_checkequal(e == pc, %f);
assert_checkequal(e == P, [%f,%f;%f,%f]);
assert_checkequal(e == PC, [%f,%f;%f,%f]);
assert_checkequal(e == SP, %f);
assert_checkequal(e == SPC, %f);
assert_checkequal(e == SP1, %f);
assert_checkequal(e == SPC1, %f);
assert_checkequal(e == i8, %f);
assert_checkequal(e == I8, [%f,%f;%f,%f]);
assert_checkequal(e == ui8, %f);
assert_checkequal(e == UI8, [%f,%f;%f,%f]);
assert_checkequal(e == i16, %f);
assert_checkequal(e == I16, [%f,%f;%f,%f]);
assert_checkequal(e == ui16, %f);
assert_checkequal(e == UI16, [%f,%f;%f,%f]);
assert_checkequal(e == i32, %f);
assert_checkequal(e == I32, [%f,%f;%f,%f]);
assert_checkequal(e == ui32, %f);
assert_checkequal(e == UI32, [%f,%f;%f,%f]);
assert_checkequal(e == str, %f);
assert_checkequal(e == STR, %f);
assert_checkequal(e == b, %f);
assert_checkequal(e == B, %f);
assert_checkequal(e == SPB, %f);

assert_checkequal(ec == empty, %f);
assert_checkequal(ec == r, %f);
assert_checkequal(ec == c, %f);
assert_checkequal(ec == R, [%f,%f;%f,%f]);
assert_checkequal(ec == C, [%f,%f;%f,%f]);
assert_checkequal(ec == e, %f);
assert_checkequal(ec == ec, %t);
assert_checkequal(ec == p, %f);
assert_checkequal(ec == pc, %f);
assert_checkequal(ec == P, [%f,%f;%f,%f]);
assert_checkequal(ec == PC, [%f,%f;%f,%f]);
assert_checkequal(ec == SP, %f);
assert_checkequal(ec == SPC, %f);
assert_checkequal(ec == SP1, %f);
assert_checkequal(ec == SPC1, %f);
assert_checkequal(ec == i8, %f);
assert_checkequal(ec == I8, [%f,%f;%f,%f]);
assert_checkequal(ec == ui8, %f);
assert_checkequal(ec == UI8, [%f,%f;%f,%f]);
assert_checkequal(ec == i16, %f);
assert_checkequal(ec == I16, [%f,%f;%f,%f]);
assert_checkequal(ec == ui16, %f);
assert_checkequal(ec == UI16, [%f,%f;%f,%f]);
assert_checkequal(ec == i32, %f);
assert_checkequal(ec == I32, [%f,%f;%f,%f]);
assert_checkequal(ec == ui32, %f);
assert_checkequal(ec == UI32, [%f,%f;%f,%f]);
assert_checkequal(ec == str, %f);
assert_checkequal(ec == STR, %f);
assert_checkequal(ec == b, %f);
assert_checkequal(ec == B, %f);
assert_checkequal(ec == SPB, %f);

assert_checkequal(p == empty, %f);
assert_checkequal(p == r, %f);
assert_checkequal(p == c, %f);
assert_checkequal(p == R, [%f,%f;%f,%f]);
assert_checkequal(p == C, [%f,%f;%f,%f]);
assert_checkequal(p == e, %f);
assert_checkequal(p == ec, %f);
assert_checkequal(p == p, %t);
assert_checkequal(p == pc, %f);
assert_checkequal(p == P, [%f,%f;%f,%f]);
assert_checkequal(p == PC, [%f,%f;%f,%f]);
assert_checkequal(p == i8, %f);
assert_checkequal(p == I8, [%f,%f;%f,%f]);
assert_checkequal(p == ui8, %f);
assert_checkequal(p == UI8, [%f,%f;%f,%f]);
assert_checkequal(p == i16, %f);
assert_checkequal(p == I16, [%f,%f;%f,%f]);
assert_checkequal(p == ui16, %f);
assert_checkequal(p == UI16, [%f,%f;%f,%f]);
assert_checkequal(p == i32, %f);
assert_checkequal(p == I32, [%f,%f;%f,%f]);
assert_checkequal(p == ui32, %f);
assert_checkequal(p == UI32, [%f,%f;%f,%f]);
assert_checkequal(p == str, %f);
assert_checkequal(p == STR, %f);
assert_checkequal(p == b, %f);
assert_checkequal(p == B, %f);

assert_checkequal(pc == empty, %f);
assert_checkequal(pc == r, %f);
assert_checkequal(pc == c, %f);
assert_checkequal(pc == R, [%f,%f;%f,%f]);
assert_checkequal(pc == C, [%f,%f;%f,%f]);
assert_checkequal(pc == e, %f);
assert_checkequal(pc == ec, %f);
assert_checkequal(pc == p, %f);
assert_checkequal(pc == pc, %t);
assert_checkequal(pc == P, [%f,%f;%f,%f]);
assert_checkequal(pc == PC, [%f,%f;%f,%f]);
assert_checkequal(pc == i8, %f);
assert_checkequal(pc == I8, [%f,%f;%f,%f]);
assert_checkequal(pc == ui8, %f);
assert_checkequal(pc == UI8, [%f,%f;%f,%f]);
assert_checkequal(pc == i16, %f);
assert_checkequal(pc == I16, [%f,%f;%f,%f]);
assert_checkequal(pc == ui16, %f);
assert_checkequal(pc == UI16, [%f,%f;%f,%f]);
assert_checkequal(pc == i32, %f);
assert_checkequal(pc == I32, [%f,%f;%f,%f]);
assert_checkequal(pc == ui32, %f);
assert_checkequal(pc == UI32, [%f,%f;%f,%f]);
assert_checkequal(pc == str, %f);
assert_checkequal(pc == STR, %f);
assert_checkequal(pc == b, %f);
assert_checkequal(pc == B, %f);

assert_checkequal(P == empty, %f);
assert_checkequal(P == r, [%f,%t;%f,%f]);
assert_checkequal(P == c, [%f,%f;%f,%f]);
assert_checkequal(P == R, [%f,%t;%f,%f]);
assert_checkequal(P == C, [%f,%f;%f,%f]);
assert_checkequal(P == e, [%f,%f;%f,%f]);
assert_checkequal(P == ec, [%f,%f;%f,%f]);
assert_checkequal(P == p, [%f,%f;%f,%f]);
assert_checkequal(P == pc, [%f,%f;%f,%f]);
assert_checkequal(P == P, [%t,%t;%t,%t]);
assert_checkequal(P == PC, [%f,%t;%f,%f]);
assert_checkequal(P == i8, [%f,%f;%f,%f]);
assert_checkequal(P == I8, [%f,%t;%f,%f]);
assert_checkequal(P == ui8, [%f,%f;%f,%f]);
assert_checkequal(P == UI8, [%f,%t;%f,%f]);
assert_checkequal(P == i16, [%f,%f;%f,%f]);
assert_checkequal(P == I16, [%f,%t;%f,%f]);
assert_checkequal(P == ui16, [%f,%f;%f,%f]);
assert_checkequal(P == UI16, [%f,%t;%f,%f]);
assert_checkequal(P == i32, [%f,%f;%f,%f]);
assert_checkequal(P == I32, [%f,%t;%f,%f]);
assert_checkequal(P == ui32, [%f,%f;%f,%f]);
assert_checkequal(P == UI32, [%f,%t;%f,%f]);
assert_checkequal(P == str, %f);
assert_checkequal(P == STR, %f);
assert_checkequal(P == b, %f);
assert_checkequal(P == B, %f);

assert_checkequal(PC == empty, %f);
assert_checkequal(PC == r, [%f,%t;%f,%f]);
assert_checkequal(PC == c, [%f,%f;%f,%f]);
assert_checkequal(PC == R, [%f,%t;%f,%f]);
assert_checkequal(PC == C, [%f,%f;%f,%f]);
assert_checkequal(PC == e, [%f,%f;%f,%f]);
assert_checkequal(PC == ec, [%f,%f;%f,%f]);
assert_checkequal(PC == p, [%f,%f;%f,%f]);
assert_checkequal(PC == pc, [%f,%f;%f,%f]);
assert_checkequal(PC == P, [%f,%t;%f,%f]);
assert_checkequal(PC == PC, [%t,%t;%t,%t]);
assert_checkequal(PC == i8, [%f,%f;%f,%f]);
assert_checkequal(PC == I8, [%f,%t;%f,%f]);
assert_checkequal(PC == ui8, [%f,%f;%f,%f]);
assert_checkequal(PC == UI8, [%f,%t;%f,%f]);
assert_checkequal(PC == i16, [%f,%f;%f,%f]);
assert_checkequal(PC == I16, [%f,%t;%f,%f]);
assert_checkequal(PC == ui16, [%f,%f;%f,%f]);
assert_checkequal(PC == UI16, [%f,%t;%f,%f]);
assert_checkequal(PC == i32, [%f,%f;%f,%f]);
assert_checkequal(PC == I32, [%f,%t;%f,%f]);
assert_checkequal(PC == ui32, [%f,%f;%f,%f]);
assert_checkequal(PC == UI32, [%f,%t;%f,%f]);
assert_checkequal(PC == str, %f);
assert_checkequal(PC == STR, %f);
assert_checkequal(PC == b, %f);
assert_checkequal(PC == B, %f);

assert_checkequal(SP == empty, %f);
assert_checkequal(SP == r, sparse([4,5],%t,[4,10]));
assert_checkequal(SP == c, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == R, %f);
assert_checkequal(SP == C, %f);
assert_checkequal(SP == e, %f);
assert_checkequal(SP == ec, %f);
assert_checkequal(SP == SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP == SPC, sparse([1,1;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;4,1;4,2;4,3;4,4;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP == SP1, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == SPC1, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == i8, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == I8, %f);
assert_checkequal(SP == ui8, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == UI8, %f);
assert_checkequal(SP == i16, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == I16, %f);
assert_checkequal(SP == ui16, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == UI16, %f);
assert_checkequal(SP == i32, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == I32, %f);
assert_checkequal(SP == ui32, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP == UI32, %f);
assert_checkequal(SP == str, %f);
assert_checkequal(SP == STR, %f);
assert_checkequal(SP == b, %f);
assert_checkequal(SP == B, %f);
assert_checkequal(SP == SPB, %f);

assert_checkequal(SPC == empty, %f);
assert_checkequal(SPC == r, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == c, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == R, %f);
assert_checkequal(SPC == C, %f);
assert_checkequal(SPC == e, %f);
assert_checkequal(SPC == ec, %f);
assert_checkequal(SPC == SP, sparse([1,1;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;4,1;4,2;4,3;4,4;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC == SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC == SP1, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == SPC1, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == i8, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == I8, %f);
assert_checkequal(SPC == ui8, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == UI8, %f);
assert_checkequal(SPC == i16, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == I16, %f);
assert_checkequal(SPC == ui16, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == UI16, %f);
assert_checkequal(SPC == i32, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == I32, %f);
assert_checkequal(SPC == ui32, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC == UI32, %f);
assert_checkequal(SPC == str, %f);
assert_checkequal(SPC == STR, %f);
assert_checkequal(SPC == b, %f);
assert_checkequal(SPC == B, %f);
assert_checkequal(SPC == SPB, %f);

assert_checkequal(SP1 == empty, %f);
assert_checkequal(SP1 == r, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == c, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == R, %f);
assert_checkequal(SP1 == C, %f);
assert_checkequal(SP1 == e, %f);
assert_checkequal(SP1 == ec, %f);
assert_checkequal(SP1 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP1 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP1 == SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == i8, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == I8, %f);
assert_checkequal(SP1 == ui8, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == UI8, %f);
assert_checkequal(SP1 == i16, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == I16, %f);
assert_checkequal(SP1 == ui16, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == UI16, %f);
assert_checkequal(SP1 == i32, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == I32, %f);
assert_checkequal(SP1 == ui32, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 == UI32, %f);
assert_checkequal(SP1 == str, %f);
assert_checkequal(SP1 == STR, %f);
assert_checkequal(SP1 == b, %f);
assert_checkequal(SP1 == B, %f);
assert_checkequal(SP1 == SPB, %f);

assert_checkequal(SPC1 == empty, %f);
assert_checkequal(SPC1 == r, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == c, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == R, %f);
assert_checkequal(SPC1 == C, %f);
assert_checkequal(SPC1 == e, %f);
assert_checkequal(SPC1 == ec, %f);
assert_checkequal(SPC1 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC1 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC1 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 == i8, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == I8, %f);
assert_checkequal(SPC1 == ui8, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == UI8, %f);
assert_checkequal(SPC1 == i16, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == I16, %f);
assert_checkequal(SPC1 == ui16, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == UI16, %f);
assert_checkequal(SPC1 == i32, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == I32, %f);
assert_checkequal(SPC1 == ui32, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 == UI32, %f);
assert_checkequal(SPC1 == str, %f);
assert_checkequal(SPC1 == STR, %f);
assert_checkequal(SPC1 == b, %f);
assert_checkequal(SPC1 == B, %f);
assert_checkequal(SPC1 == SPB, %f);

assert_checkequal(i8 == empty, %f);
assert_checkequal(i8 == r, %f);
assert_checkequal(i8 == c, %f);
assert_checkequal(i8 == R, [%f,%f;%f,%f]);
assert_checkequal(i8 == C, [%f,%f;%f,%f]);
assert_checkequal(i8 == e, %f);
assert_checkequal(i8 == ec, %f);
assert_checkequal(i8 == p, %f);
assert_checkequal(i8 == pc, %f);
assert_checkequal(i8 == P, [%f,%f;%f,%f]);
assert_checkequal(i8 == PC, [%f,%f;%f,%f]);
assert_checkequal(i8 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(i8 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(i8 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i8 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i8 == i8, %t);
assert_checkequal(i8 == I8, [%t,%f;%f,%f]);
assert_checkequal(i8 == ui8, %f);
assert_checkequal(i8 == UI8, [%f,%f;%f,%f]);
assert_checkequal(i8 == i16, %f);
assert_checkequal(i8 == I16, [%f,%f;%f,%f]);
assert_checkequal(i8 == ui16, %f);
assert_checkequal(i8 == UI16, [%f,%f;%f,%f]);
assert_checkequal(i8 == i32, %f);
assert_checkequal(i8 == I32, [%f,%f;%f,%f]);
assert_checkequal(i8 == ui32, %f);
assert_checkequal(i8 == UI32, [%f,%f;%f,%f]);
assert_checkequal(i8 == str, %f);
assert_checkequal(i8 == STR, %f);
assert_checkequal(i8 == b, %f);
assert_checkequal(i8 == B, [%f,%f;%f,%f]);
assert_checkequal(i8 == SPB, %f);

assert_checkequal(I8 == empty, %f);
assert_checkequal(I8 == r, [%f,%t;%f,%f]);
assert_checkequal(I8 == c, [%f,%f;%f,%f]);
assert_checkequal(I8 == R, [%f,%t;%f,%f]);
assert_checkequal(I8 == C, [%f,%f;%f,%f]);
assert_checkequal(I8 == e, [%f,%f;%f,%f]);
assert_checkequal(I8 == ec, [%f,%f;%f,%f]);
assert_checkequal(I8 == p, [%f,%f;%f,%f]);
assert_checkequal(I8 == pc, [%f,%f;%f,%f]);
assert_checkequal(I8 == P, [%f,%t;%f,%f]);
assert_checkequal(I8 == PC, [%f,%t;%f,%f]);
assert_checkequal(I8 == SP, %f);
assert_checkequal(I8 == SPC, %f);
assert_checkequal(I8 == SP1, %f);
assert_checkequal(I8 == SPC1, %f);
assert_checkequal(I8 == i8, [%t,%f;%f,%f]);
assert_checkequal(I8 == I8, [%t,%t;%t,%t]);
assert_checkequal(I8 == ui8, [%f,%f;%f,%f]);
assert_checkequal(I8 == UI8, [%f,%t;%f,%f]);
assert_checkequal(I8 == i16, [%f,%f;%f,%f]);
assert_checkequal(I8 == I16, [%f,%t;%f,%f]);
assert_checkequal(I8 == ui16, [%f,%f;%f,%f]);
assert_checkequal(I8 == UI16, [%f,%t;%f,%f]);
assert_checkequal(I8 == i32, [%f,%f;%f,%t]);
assert_checkequal(I8 == I32, [%f,%t;%f,%f]);
assert_checkequal(I8 == ui32, [%f,%f;%f,%f]);
assert_checkequal(I8 == UI32, [%f,%t;%f,%f]);
assert_checkequal(I8 == str, %f);
assert_checkequal(I8 == STR, %f);
assert_checkequal(I8 == b, [%f,%f;%f,%f]);
assert_checkequal(I8 == B, [%f,%f;%f,%f]);
assert_checkequal(I8 == SPB, %f);

assert_checkequal(ui8 == empty, %f);
assert_checkequal(ui8 == r, %f);
assert_checkequal(ui8 == c, %f);
assert_checkequal(ui8 == R, [%f,%f;%f,%f]);
assert_checkequal(ui8 == C, [%f,%f;%f,%f]);
assert_checkequal(ui8 == e, %f);
assert_checkequal(ui8 == ec, %f);
assert_checkequal(ui8 == p, %f);
assert_checkequal(ui8 == pc, %f);
assert_checkequal(ui8 == P, [%f,%f;%f,%f]);
assert_checkequal(ui8 == PC, [%f,%f;%f,%f]);
assert_checkequal(ui8 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui8 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui8 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui8 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui8 == i8, %f);
assert_checkequal(ui8 == I8, [%f,%f;%f,%f]);
assert_checkequal(ui8 == ui8, %t);
assert_checkequal(ui8 == UI8, [%t,%f;%f,%f]);
assert_checkequal(ui8 == i16, %f);
assert_checkequal(ui8 == I16, [%f,%f;%f,%f]);
assert_checkequal(ui8 == ui16, %f);
assert_checkequal(ui8 == UI16, [%f,%f;%f,%f]);
assert_checkequal(ui8 == i32, %f);
assert_checkequal(ui8 == I32, [%f,%f;%f,%f]);
assert_checkequal(ui8 == ui32, %f);
assert_checkequal(ui8 == UI32, [%f,%f;%f,%f]);
assert_checkequal(ui8 == str, %f);
assert_checkequal(ui8 == STR, %f);
assert_checkequal(ui8 == b, %f);
assert_checkequal(ui8 == B, [%f,%f;%f,%f]);
assert_checkequal(ui8 == SPB, %f);

assert_checkequal(UI8 == empty, %f);
assert_checkequal(UI8 == r, [%f,%t;%f,%f]);
assert_checkequal(UI8 == c, [%f,%f;%f,%f]);
assert_checkequal(UI8 == R, [%f,%t;%f,%f]);
assert_checkequal(UI8 == C, [%f,%f;%f,%f]);
assert_checkequal(UI8 == e, [%f,%f;%f,%f]);
assert_checkequal(UI8 == ec, [%f,%f;%f,%f]);
assert_checkequal(UI8 == p, [%f,%f;%f,%f]);
assert_checkequal(UI8 == pc, [%f,%f;%f,%f]);
assert_checkequal(UI8 == P, [%f,%t;%f,%f]);
assert_checkequal(UI8 == PC, [%f,%t;%f,%f]);
assert_checkequal(UI8 == SP, %f);
assert_checkequal(UI8 == SPC, %f);
assert_checkequal(UI8 == SP1, %f);
assert_checkequal(UI8 == SPC1, %f);
assert_checkequal(UI8 == i8, [%f,%f;%f,%f]);
assert_checkequal(UI8 == I8, [%f,%t;%f,%f]);
assert_checkequal(UI8 == ui8, [%t,%f;%f,%f]);
assert_checkequal(UI8 == UI8, [%t,%t;%t,%t]);
assert_checkequal(UI8 == i16, [%f,%f;%f,%f]);
assert_checkequal(UI8 == I16, [%f,%t;%f,%f]);
assert_checkequal(UI8 == ui16, [%f,%f;%f,%f]);
assert_checkequal(UI8 == UI16, [%f,%t;%f,%f]);
assert_checkequal(UI8 == i32, [%f,%f;%f,%f]);
assert_checkequal(UI8 == I32, [%f,%t;%f,%f]);
assert_checkequal(UI8 == ui32, [%f,%f;%f,%t]);
assert_checkequal(UI8 == UI32, [%f,%t;%f,%f]);
assert_checkequal(UI8 == str, %f);
assert_checkequal(UI8 == STR, %f);
assert_checkequal(UI8 == b, [%f,%f;%f,%f]);
assert_checkequal(UI8 == B, [%f,%f;%f,%f]);
assert_checkequal(UI8 == SPB, %f);

assert_checkequal(i16 == empty, %f);
assert_checkequal(i16 == r, %f);
assert_checkequal(i16 == c, %f);
assert_checkequal(i16 == R, [%f,%f;%f,%f]);
assert_checkequal(i16 == C, [%f,%f;%f,%f]);
assert_checkequal(i16 == e, %f);
assert_checkequal(i16 == ec, %f);
assert_checkequal(i16 == p, %f);
assert_checkequal(i16 == pc, %f);
assert_checkequal(i16 == P, [%f,%f;%f,%f]);
assert_checkequal(i16 == PC, [%f,%f;%f,%f]);
assert_checkequal(i16 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(i16 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(i16 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i16 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i16 == i8, %f);
assert_checkequal(i16 == I8, [%f,%f;%f,%f]);
assert_checkequal(i16 == ui8, %f);
assert_checkequal(i16 == UI8, [%f,%f;%f,%f]);
assert_checkequal(i16 == i16, %t);
assert_checkequal(i16 == I16, [%t,%f;%f,%f]);
assert_checkequal(i16 == ui16, %f);
assert_checkequal(i16 == UI16, [%f,%f;%f,%f]);
assert_checkequal(i16 == i32, %f);
assert_checkequal(i16 == I32, [%f,%f;%f,%f]);
assert_checkequal(i16 == ui32, %f);
assert_checkequal(i16 == UI32, [%f,%f;%f,%f]);
assert_checkequal(i16 == str, %f);
assert_checkequal(i16 == STR, %f);
assert_checkequal(i16 == b, %f);
assert_checkequal(i16 == B, [%f,%f;%f,%f]);
assert_checkequal(i16 == SPB, %f);

assert_checkequal(I16 == empty, %f);
assert_checkequal(I16 == r, [%f,%t;%f,%f]);
assert_checkequal(I16 == c, [%f,%f;%f,%f]);
assert_checkequal(I16 == R, [%f,%t;%f,%f]);
assert_checkequal(I16 == C, [%f,%f;%f,%f]);
assert_checkequal(I16 == e, [%f,%f;%f,%f]);
assert_checkequal(I16 == ec, [%f,%f;%f,%f]);
assert_checkequal(I16 == p, [%f,%f;%f,%f]);
assert_checkequal(I16 == pc, [%f,%f;%f,%f]);
assert_checkequal(I16 == P, [%f,%t;%f,%f]);
assert_checkequal(I16 == PC, [%f,%t;%f,%f]);
assert_checkequal(I16 == SP, %f);
assert_checkequal(I16 == SPC, %f);
assert_checkequal(I16 == SP1, %f);
assert_checkequal(I16 == SPC1, %f);
assert_checkequal(I16 == i8, [%f,%f;%f,%f]);
assert_checkequal(I16 == I8, [%f,%t;%f,%f]);
assert_checkequal(I16 == ui8, [%f,%f;%f,%f]);
assert_checkequal(I16 == UI8, [%f,%t;%f,%f]);
assert_checkequal(I16 == i16, [%t,%f;%f,%f]);
assert_checkequal(I16 == I16, [%t,%t;%t,%t]);
assert_checkequal(I16 == ui16, [%f,%f;%f,%f]);
assert_checkequal(I16 == UI16, [%f,%t;%f,%f]);
assert_checkequal(I16 == i32, [%f,%f;%f,%f]);
assert_checkequal(I16 == I32, [%f,%t;%f,%f]);
assert_checkequal(I16 == ui32, [%f,%f;%f,%f]);
assert_checkequal(I16 == UI32, [%f,%t;%f,%f]);
assert_checkequal(I16 == str, %f);
assert_checkequal(I16 == STR, %f);
assert_checkequal(I16 == b, [%f,%f;%f,%f]);
assert_checkequal(I16 == B, [%f,%f;%f,%f]);
assert_checkequal(I16 == SPB, %f);

assert_checkequal(ui16 == empty, %f);
assert_checkequal(ui16 == r, %f);
assert_checkequal(ui16 == c, %f);
assert_checkequal(ui16 == R, [%f,%f;%f,%f]);
assert_checkequal(ui16 == C, [%f,%f;%f,%f]);
assert_checkequal(ui16 == e, %f);
assert_checkequal(ui16 == ec, %f);
assert_checkequal(ui16 == p, %f);
assert_checkequal(ui16 == pc, %f);
assert_checkequal(ui16 == P, [%f,%f;%f,%f]);
assert_checkequal(ui16 == PC, [%f,%f;%f,%f]);
assert_checkequal(ui16 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui16 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui16 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui16 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui16 == i8, %f);
assert_checkequal(ui16 == I8, [%f,%f;%f,%f]);
assert_checkequal(ui16 == ui8, %f);
assert_checkequal(ui16 == UI8, [%f,%f;%f,%f]);
assert_checkequal(ui16 == i16, %f);
assert_checkequal(ui16 == I16, [%f,%f;%f,%f]);
assert_checkequal(ui16 == ui16, %t);
assert_checkequal(ui16 == UI16, [%t,%f;%f,%f]);
assert_checkequal(ui16 == i32, %f);
assert_checkequal(ui16 == I32, [%f,%f;%f,%f]);
assert_checkequal(ui16 == ui32, %f);
assert_checkequal(ui16 == UI32, [%f,%f;%f,%f]);
assert_checkequal(ui16 == str, %f);
assert_checkequal(ui16 == STR, %f);
assert_checkequal(ui16 == b, %f);
assert_checkequal(ui16 == B, [%f,%f;%f,%f]);
assert_checkequal(ui16 == SPB, %f);

assert_checkequal(UI16 == empty, %f);
assert_checkequal(UI16 == r, [%f,%t;%f,%f]);
assert_checkequal(UI16 == c, [%f,%f;%f,%f]);
assert_checkequal(UI16 == R, [%f,%t;%f,%f]);
assert_checkequal(UI16 == C, [%f,%f;%f,%f]);
assert_checkequal(UI16 == e, [%f,%f;%f,%f]);
assert_checkequal(UI16 == ec, [%f,%f;%f,%f]);
assert_checkequal(UI16 == p, [%f,%f;%f,%f]);
assert_checkequal(UI16 == pc, [%f,%f;%f,%f]);
assert_checkequal(UI16 == P, [%f,%t;%f,%f]);
assert_checkequal(UI16 == PC, [%f,%t;%f,%f]);
assert_checkequal(UI16 == SP, %f);
assert_checkequal(UI16 == SPC, %f);
assert_checkequal(UI16 == SP1, %f);
assert_checkequal(UI16 == SPC1, %f);
assert_checkequal(UI16 == i8, [%f,%f;%f,%f]);
assert_checkequal(UI16 == I8, [%f,%t;%f,%f]);
assert_checkequal(UI16 == ui8, [%f,%f;%f,%f]);
assert_checkequal(UI16 == UI8, [%f,%t;%f,%f]);
assert_checkequal(UI16 == i16, [%f,%f;%f,%f]);
assert_checkequal(UI16 == I16, [%f,%t;%f,%f]);
assert_checkequal(UI16 == ui16, [%t,%f;%f,%f]);
assert_checkequal(UI16 == UI16, [%t,%t;%t,%t]);
assert_checkequal(UI16 == i32, [%f,%f;%f,%f]);
assert_checkequal(UI16 == I32, [%f,%t;%f,%f]);
assert_checkequal(UI16 == ui32, [%f,%f;%f,%f]);
assert_checkequal(UI16 == UI32, [%f,%t;%f,%f]);
assert_checkequal(UI16 == str, %f);
assert_checkequal(UI16 == STR, %f);
assert_checkequal(UI16 == b, [%f,%f;%f,%f]);
assert_checkequal(UI16 == B, [%f,%f;%f,%f]);
assert_checkequal(UI16 == SPB, %f);

assert_checkequal(i32 == empty, %f);
assert_checkequal(i32 == r, %f);
assert_checkequal(i32 == c, %f);
assert_checkequal(i32 == R, [%f,%f;%f,%f]);
assert_checkequal(i32 == C, [%f,%f;%f,%f]);
assert_checkequal(i32 == e, %f);
assert_checkequal(i32 == ec, %f);
assert_checkequal(i32 == p, %f);
assert_checkequal(i32 == pc, %f);
assert_checkequal(i32 == P, [%f,%f;%f,%f]);
assert_checkequal(i32 == PC, [%f,%f;%f,%f]);
assert_checkequal(i32 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(i32 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(i32 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i32 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(i32 == i8, %f);
assert_checkequal(i32 == I8, [%f,%f;%f,%t]);
assert_checkequal(i32 == ui8, %f);
assert_checkequal(i32 == UI8, [%f,%f;%f,%f]);
assert_checkequal(i32 == i16, %f);
assert_checkequal(i32 == I16, [%f,%f;%f,%f]);
assert_checkequal(i32 == ui16, %f);
assert_checkequal(i32 == UI16, [%f,%f;%f,%f]);
assert_checkequal(i32 == i32, %t);
assert_checkequal(i32 == I32, [%t,%f;%f,%f]);
assert_checkequal(i32 == ui32, %f);
assert_checkequal(i32 == UI32, [%f,%f;%f,%f]);
assert_checkequal(i32 == str, %f);
assert_checkequal(i32 == STR, %f);
assert_checkequal(i32 == b, %f);
assert_checkequal(i32 == B, [%f,%f;%f,%f]);
assert_checkequal(i32 == SPB, %f);

assert_checkequal(I32 == empty, %f);
assert_checkequal(I32 == r, [%f,%t;%f,%f]);
assert_checkequal(I32 == c, [%f,%f;%f,%f]);
assert_checkequal(I32 == R, [%f,%t;%f,%f]);
assert_checkequal(I32 == C, [%f,%f;%f,%f]);
assert_checkequal(I32 == e, [%f,%f;%f,%f]);
assert_checkequal(I32 == ec, [%f,%f;%f,%f]);
assert_checkequal(I32 == p, [%f,%f;%f,%f]);
assert_checkequal(I32 == pc, [%f,%f;%f,%f]);
assert_checkequal(I32 == P, [%f,%t;%f,%f]);
assert_checkequal(I32 == PC, [%f,%t;%f,%f]);
assert_checkequal(I32 == SP, %f);
assert_checkequal(I32 == SPC, %f);
assert_checkequal(I32 == SP1, %f);
assert_checkequal(I32 == SPC1, %f);
assert_checkequal(I32 == i8, [%f,%f;%f,%f]);
assert_checkequal(I32 == I8, [%f,%t;%f,%f]);
assert_checkequal(I32 == ui8, [%f,%f;%f,%f]);
assert_checkequal(I32 == UI8, [%f,%t;%f,%f]);
assert_checkequal(I32 == i16, [%f,%f;%f,%f]);
assert_checkequal(I32 == I16, [%f,%t;%f,%f]);
assert_checkequal(I32 == ui16, [%f,%f;%f,%f]);
assert_checkequal(I32 == UI16, [%f,%t;%f,%f]);
assert_checkequal(I32 == i32, [%t,%f;%f,%f]);
assert_checkequal(I32 == I32, [%t,%t;%t,%t]);
assert_checkequal(I32 == ui32, [%f,%f;%f,%f]);
assert_checkequal(I32 == UI32, [%f,%t;%f,%f]);
assert_checkequal(I32 == str, %f);
assert_checkequal(I32 == STR, %f);
assert_checkequal(I32 == b, [%f,%f;%f,%f]);
assert_checkequal(I32 == B, [%f,%f;%f,%f]);
assert_checkequal(I32 == SPB, %f);

assert_checkequal(ui32 == empty, %f);
assert_checkequal(ui32 == r, %f);
assert_checkequal(ui32 == c, %f);
assert_checkequal(ui32 == R, [%f,%f;%f,%f]);
assert_checkequal(ui32 == C, [%f,%f;%f,%f]);
assert_checkequal(ui32 == e, %f);
assert_checkequal(ui32 == ec, %f);
assert_checkequal(ui32 == p, %f);
assert_checkequal(ui32 == pc, %f);
assert_checkequal(ui32 == P, [%f,%f;%f,%f]);
assert_checkequal(ui32 == PC, [%f,%f;%f,%f]);
assert_checkequal(ui32 == SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui32 == SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(ui32 == SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui32 == SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(ui32 == i8, %f);
assert_checkequal(ui32 == I8, [%f,%f;%f,%f]);
assert_checkequal(ui32 == ui8, %f);
assert_checkequal(ui32 == UI8, [%f,%f;%f,%t]);
assert_checkequal(ui32 == i16, %f);
assert_checkequal(ui32 == I16, [%f,%f;%f,%f]);
assert_checkequal(ui32 == ui16, %f);
assert_checkequal(ui32 == UI16, [%f,%f;%f,%f]);
assert_checkequal(ui32 == i32, %f);
assert_checkequal(ui32 == I32, [%f,%f;%f,%f]);
assert_checkequal(ui32 == ui32, %t);
assert_checkequal(ui32 == UI32, [%t,%f;%f,%f]);
assert_checkequal(ui32 == str, %f);
assert_checkequal(ui32 == STR, %f);
assert_checkequal(ui32 == b, %f);
assert_checkequal(ui32 == B, [%f,%f;%f,%f]);
assert_checkequal(ui32 == SPB, %f);

assert_checkequal(UI32 == empty, %f);
assert_checkequal(UI32 == r, [%f,%t;%f,%f]);
assert_checkequal(UI32 == c, [%f,%f;%f,%f]);
assert_checkequal(UI32 == R, [%f,%t;%f,%f]);
assert_checkequal(UI32 == C, [%f,%f;%f,%f]);
assert_checkequal(UI32 == e, [%f,%f;%f,%f]);
assert_checkequal(UI32 == ec, [%f,%f;%f,%f]);
assert_checkequal(UI32 == p, [%f,%f;%f,%f]);
assert_checkequal(UI32 == pc, [%f,%f;%f,%f]);
assert_checkequal(UI32 == P, [%f,%t;%f,%f]);
assert_checkequal(UI32 == PC, [%f,%t;%f,%f]);
assert_checkequal(UI32 == SP, %f);
assert_checkequal(UI32 == SPC, %f);
assert_checkequal(UI32 == SP1, %f);
assert_checkequal(UI32 == SPC1, %f);
assert_checkequal(UI32 == i8, [%f,%f;%f,%f]);
assert_checkequal(UI32 == I8, [%f,%t;%f,%f]);
assert_checkequal(UI32 == ui8, [%f,%f;%f,%f]);
assert_checkequal(UI32 == UI8, [%f,%t;%f,%f]);
assert_checkequal(UI32 == i16, [%f,%f;%f,%f]);
assert_checkequal(UI32 == I16, [%f,%t;%f,%f]);
assert_checkequal(UI32 == ui16, [%f,%f;%f,%f]);
assert_checkequal(UI32 == UI16, [%f,%t;%f,%f]);
assert_checkequal(UI32 == i32, [%f,%f;%f,%f]);
assert_checkequal(UI32 == I32, [%f,%t;%f,%f]);
assert_checkequal(UI32 == ui32, [%t,%f;%f,%f]);
assert_checkequal(UI32 == UI32, [%t,%t;%t,%t]);
assert_checkequal(UI32 == str, %f);
assert_checkequal(UI32 == STR, %f);
assert_checkequal(UI32 == b, [%f,%f;%f,%f]);
assert_checkequal(UI32 == B, [%f,%f;%f,%f]);
assert_checkequal(UI32 == SPB, %f);

assert_checkequal(str == empty, %f);
assert_checkequal(str == r, %f);
assert_checkequal(str == c, %f);
assert_checkequal(str == R, %f);
assert_checkequal(str == C, %f);
assert_checkequal(str == e, %f);
assert_checkequal(str == ec, %f);
assert_checkequal(str == p, %f);
assert_checkequal(str == pc, %f);
assert_checkequal(str == P, %f);
assert_checkequal(str == PC, %f);
assert_checkequal(str == SP, %f);
assert_checkequal(str == SPC, %f);
assert_checkequal(str == SP1, %f);
assert_checkequal(str == SPC1, %f);
assert_checkequal(str == i8, %f);
assert_checkequal(str == I8, %f);
assert_checkequal(str == ui8, %f);
assert_checkequal(str == UI8, %f);
assert_checkequal(str == i16, %f);
assert_checkequal(str == I16, %f);
assert_checkequal(str == ui16, %f);
assert_checkequal(str == UI16, %f);
assert_checkequal(str == i32, %f);
assert_checkequal(str == I32, %f);
assert_checkequal(str == ui32, %f);
assert_checkequal(str == UI32, %f);
assert_checkequal(str == str, %t);
assert_checkequal(str == STR, [%f,%f;%f,%f]);
assert_checkequal(str == b, %f);
assert_checkequal(str == B, %f);
assert_checkequal(str == SPB, %f);

assert_checkequal(STR == empty, %f);
assert_checkequal(STR == r, %f);
assert_checkequal(STR == c, %f);
assert_checkequal(STR == R, %f);
assert_checkequal(STR == C, %f);
assert_checkequal(STR == e, %f);
assert_checkequal(STR == ec, %f);
assert_checkequal(STR == p, %f);
assert_checkequal(STR == pc, %f);
assert_checkequal(STR == P, %f);
assert_checkequal(STR == PC, %f);
assert_checkequal(STR == SP, %f);
assert_checkequal(STR == SPC, %f);
assert_checkequal(STR == SP1, %f);
assert_checkequal(STR == SPC1, %f);
assert_checkequal(STR == i8, %f);
assert_checkequal(STR == I8, %f);
assert_checkequal(STR == ui8, %f);
assert_checkequal(STR == UI8, %f);
assert_checkequal(STR == i16, %f);
assert_checkequal(STR == I16, %f);
assert_checkequal(STR == ui16, %f);
assert_checkequal(STR == UI16, %f);
assert_checkequal(STR == i32, %f);
assert_checkequal(STR == I32, %f);
assert_checkequal(STR == ui32, %f);
assert_checkequal(STR == UI32, %f);
assert_checkequal(STR == str, [%f,%f;%f,%f]);
assert_checkequal(STR == STR, [%t,%t;%t,%t]);
assert_checkequal(STR == b, %f);
assert_checkequal(STR == B, %f);
assert_checkequal(STR == SPB, %f);

assert_checkequal(b == empty, %f);
assert_checkequal(b == r, %f);
assert_checkequal(b == c, %f);
assert_checkequal(b == R, %f);
assert_checkequal(b == C, %f);
assert_checkequal(b == e, %f);
assert_checkequal(b == ec, %f);
assert_checkequal(b == p, %f);
assert_checkequal(b == pc, %f);
assert_checkequal(b == P, %f);
assert_checkequal(b == PC, %f);
assert_checkequal(b == SP, %f);
assert_checkequal(b == SPC, %f);
assert_checkequal(b == SP1, %f);
assert_checkequal(b == SPC1, %f);
assert_checkequal(b == i8, %f);
assert_checkequal(b == I8, [%f,%f;%f,%f]);
assert_checkequal(b == ui8, %f);
assert_checkequal(b == UI8, [%f,%f;%f,%f]);
assert_checkequal(b == i16, %f);
assert_checkequal(b == I16, [%f,%f;%f,%f]);
assert_checkequal(b == ui16, %f);
assert_checkequal(b == UI16, [%f,%f;%f,%f]);
assert_checkequal(b == i32, %f);
assert_checkequal(b == I32, [%f,%f;%f,%f]);
assert_checkequal(b == ui32, %f);
assert_checkequal(b == UI32, [%f,%f;%f,%f]);
assert_checkequal(b == str, %f);
assert_checkequal(b == STR, %f);
assert_checkequal(b == b, %t);
assert_checkequal(b == B, [%f,%t;%t,%f]);
assert_checkequal(b == SPB, sparse([1,1;2,2],[%t;%t],[2,2]));

assert_checkequal(B == empty, %f);
assert_checkequal(B == r, %f);
assert_checkequal(B == c, %f);
assert_checkequal(B == R, %f);
assert_checkequal(B == C, %f);
assert_checkequal(B == e, %f);
assert_checkequal(B == ec, %f);
assert_checkequal(B == p, %f);
assert_checkequal(B == pc, %f);

assert_checkequal(B == P, %f);
assert_checkequal(B == PC, %f);
assert_checkequal(B == SP, %f);
assert_checkequal(B == SPC, %f);
assert_checkequal(B == SP1, %f);
assert_checkequal(B == SPC1, %f);
assert_checkequal(B == i8, [%f,%f;%f,%f]);
assert_checkequal(B == I8, [%f,%f;%f,%f]);
assert_checkequal(B == ui8, [%f,%f;%f,%f]);
assert_checkequal(B == UI8, [%f,%f;%f,%f]);
assert_checkequal(B == i16, [%f,%f;%f,%f]);
assert_checkequal(B == I16, [%f,%f;%f,%f]);
assert_checkequal(B == ui16, [%f,%f;%f,%f]);
assert_checkequal(B == UI16, [%f,%f;%f,%f]);
assert_checkequal(B == i32, [%f,%f;%f,%f]);
assert_checkequal(B == I32, [%f,%f;%f,%f]);
assert_checkequal(B == ui32, [%f,%f;%f,%f]);
assert_checkequal(B == UI32, [%f,%f;%f,%f]);
assert_checkequal(B == str, %f);
assert_checkequal(B == STR, %f);
assert_checkequal(B == b, [%f,%t;%t,%f]);
assert_checkequal(B == B, [%t,%t;%t,%t]);
assert_checkequal(B == SPB, sparse([1,1],[%f],[2,2]));

assert_checkequal(SPB == empty, %f);
assert_checkequal(SPB == r, %f);
assert_checkequal(SPB == c, %f);
assert_checkequal(SPB == R, %f);
assert_checkequal(SPB == C, %f);
assert_checkequal(SPB == e, %f);
assert_checkequal(SPB == ec, %f);
assert_checkequal(SPB == SP, %f);
assert_checkequal(SPB == SPC, %f);
assert_checkequal(SPB == SP1, %f);
assert_checkequal(SPB == SPC1, %f);
assert_checkequal(SPB == i8, %f);
assert_checkequal(SPB == I8, %f);
assert_checkequal(SPB == ui8, %f);
assert_checkequal(SPB == UI8, %f);
assert_checkequal(SPB == i16, %f);
assert_checkequal(SPB == I16, %f);
assert_checkequal(SPB == ui16, %f);
assert_checkequal(SPB == UI16, %f);
assert_checkequal(SPB == i32, %f);
assert_checkequal(SPB == I32, %f);
assert_checkequal(SPB == ui32, %f);
assert_checkequal(SPB == UI32, %f);
assert_checkequal(SPB == str, %f);
assert_checkequal(SPB == STR, %f);
assert_checkequal(SPB == b, sparse([1,1;2,2],[%t;%t],[2,2]));
assert_checkequal(SPB == B, sparse([1,1],[%f],[2,2]));
assert_checkequal(SPB == SPB, sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,2]));

assert_checkequal(["a" "b"] == ["a" "b" "c"],%f);
assert_checkequal(["a" "b"] == ["a" ; "b"],%f);
assert_checkequal(["a" "b" "c"] == ["a" "b"],%f);
assert_checkequal(["a" "b"; "a" "b"] == ["a" "b"],%f);

//struct
test_st=struct("double",1,"string","test","int8",int8(2),"struct",struct("valeur",0));
test_st2=struct("double",1,"string","test","int16",int8(2),"struct",1);
test_st4=struct("double",1,"string","test","int8",int8(4),"struct",struct("valeur",0));
test_st8=struct("double",8,"string","test","int8",int8(8),"struct",struct("valeur",0));

assert_checkequal(test_st == test_st, %t);
assert_checkequal(test_st == test_st2, %f);
assert_checkequal([test_st4 test_st8] == [test_st test_st], [%f %f]);
assert_checkequal([test_st, test_st4;test_st4,test_st8] == [test_st, test_st; test_st,test_st], [%t, %f; %f , %f]);
assert_checkequal(test_st == [], %f);

//polynom
res = horner(1/(1-%s),1/(1-%s));

assert_checkequal(res == (1-%s)/-%s, %t);
assert_checkequal(res == (1-%s)/1, %f);
assert_checkequal(res == 1/-%s, %f);

// Equality with a type==0 object (void or listdelete)
// ---------------------------------------------------
L = list(,2);
assert_checktrue(L(1) == L(1));
assert_checktrue(null() == null());
assert_checkfalse(L(1) == null());
assert_checkfalse(null() == L(1));
//
lss = syslin('c',[0,1;0,0],[1;1],[1,1]);
ptr = lufact(sparse(rand(5,5)));
x = 1:10; h5File = TMPDIR + filesep()+"x.sod"; save(h5File,"x"); h5 = h5open(h5File);
program = macr2tree(%0_o_0);
xml = xmlReadStr("<root><a rib=""bar""><b>Hello</b></a></root>");
L2 = list(1, [], %z, %f, sparse(5), sparse(%t), int8(2), "abc", sin, ..
    sind, list(3), list(), {1,%t}, {}, struct("a",3), 1/%z, 1:$, lss, ..
    ptr, h5, program, xml);
for object = L2
    assert_checkfalse(object == L(1));
    assert_checkfalse(object == null());
    assert_checkfalse(L(1) == object);
    assert_checkfalse(null() == object);
end
h5close(h5);
ludel(ptr);
xmlDelete(xml);
mdelete(h5File);

//macro
deff("[x]=myplus(y,z)","x=y+z");

deff("[x]=mymacro(y,z)",["a=3*y+1"; "x=a*z+y"]);

assert_checkequal(myplus == myplus,%t);
assert_checkequal(myplus == mymacro,%f);
assert_checkequal(myplus == [],%f);
assert_checkequal(myplus == 2,%f);

//function
assert_checkequal(acosd == acosd, %t);
assert_checkequal(acosd == [], %f);
assert_checkequal(acosd == 2, %f);

// libraries
assert_checkequal(iolib == iolib, %t);
