---
title: Object types
---

# Object types

Object types are the fundamentals of any GraphQL schema, they are used to define
the kind of objects that exist in a schema. Object types are created by defining
a name and a list of fields, here’s an example object type defined using the
GraphQL schema language:

```graphql
type Character {
  name: String!
  age: Int!
}
```

## A note on Query, Mutation and Subscription

While reading about GraphQL you might have encountered 3 special object types:
`Query`, `Mutation` and `Subscription`. They are defined as standard object
types, with the difference that they are also used as entry points for your
schema (also referred as root types).

- `Query` is the entry point for all the query operations
- `Mutation` is the entry point for all the mutations
- `Subscription` is the entry point for all the subscriptions.

For a walk-through on how to define schemas, read the
[schema basics](../general/schema-basics.md).

## Defining object types

In Strawberry, you can define object types by using the `@strawberry.type`
decorator, like this:

<CodeGrid>

```python
import strawberry


@strawberry.type
class Character:
    name: str
    age: int
```

```graphql
type Character {
  name: String!
  age: int!
}
```

</CodeGrid>

You can also refer to other types, like this:

<CodeGrid>

```python
import strawberry


@strawberry.type
class Character:
    name: str
    age: int


@strawberry.type
class Book:
    title: str
    main_character: Character
```

```graphql
type Character {
  name: String!
  age: Int!
}

type Book {
  title: String!
  mainCharacter: Character!
}
```

</CodeGrid>

## API

`@strawberry.type(name: str = None, description: str = None)`

Creates an object type from a class definition.

`name`: if set this will be the GraphQL name, otherwise the GraphQL will be
generated by camel-casing the name of the class.

`description`: this is the GraphQL description that will be returned when
introspecting the schema or when navigating the schema using GraphiQL.
